/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.regionserver.wal.AsyncFSWAL;
import org.apache.hadoop.hbase.regionserver.wal.CombinedAsyncWriter;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.apache.hbase.thirdparty.io.netty.channel.Channel;
import org.apache.hbase.thirdparty.io.netty.channel.EventLoopGroup;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class DualAsyncFSWAL
extends AsyncFSWAL {
    private static final Logger LOG = LoggerFactory.getLogger(DualAsyncFSWAL.class);
    private final FileSystem remoteFs;
    private final Path remoteWALDir;
    private volatile boolean skipRemoteWAL = false;
    private volatile boolean markerEditOnly = false;

    public DualAsyncFSWAL(FileSystem fs, FileSystem remoteFs, Path rootDir, Path remoteWALDir, String logDir, String archiveDir, Configuration conf, List<WALActionsListener> listeners, boolean failIfWALExists, String prefix, String suffix, EventLoopGroup eventLoopGroup, Class<? extends Channel> channelClass) throws FailedLogCloseException, IOException {
        super(fs, rootDir, logDir, archiveDir, conf, listeners, failIfWALExists, prefix, suffix, eventLoopGroup, channelClass);
        this.remoteFs = remoteFs;
        this.remoteWALDir = remoteWALDir;
    }

    protected WALProvider.AsyncWriter createCombinedAsyncWriter(WALProvider.AsyncWriter localWriter, WALProvider.AsyncWriter remoteWriter) {
        return CombinedAsyncWriter.create(remoteWriter, localWriter);
    }

    @Override
    protected WALProvider.AsyncWriter createWriterInstance(Path path) throws IOException {
        WALProvider.AsyncWriter localWriter = super.createWriterInstance(path);
        Path remoteWAL = new Path(this.remoteWALDir, path.getName());
        int retry = 0;
        while (true) {
            block6: {
                WALProvider.AsyncWriter remoteWriter;
                if (this.skipRemoteWAL) {
                    return localWriter;
                }
                try {
                    remoteWriter = this.createAsyncWriter(this.remoteFs, remoteWAL);
                }
                catch (IOException e) {
                    LOG.warn("create remote writer {} failed, retry = {}", new Object[]{remoteWAL, retry, e});
                    try {
                        Thread.sleep(ConnectionUtils.getPauseTime((long)100L, (int)retry));
                        break block6;
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        Closeables.close((Closeable)localWriter, (boolean)true);
                        throw (IOException)new InterruptedIOException().initCause(ie);
                    }
                }
                return this.createCombinedAsyncWriter(localWriter, remoteWriter);
            }
            ++retry;
        }
    }

    @Override
    protected boolean markerEditOnly() {
        return this.markerEditOnly;
    }

    public void skipRemoteWAL(boolean markerEditOnly) {
        if (markerEditOnly) {
            this.markerEditOnly = true;
        }
        this.skipRemoteWAL = true;
    }
}

