/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class CombinedAsyncWriter
implements WALProvider.AsyncWriter {
    private static final Logger LOG = LoggerFactory.getLogger(CombinedAsyncWriter.class);
    private final ImmutableList<WALProvider.AsyncWriter> writers;

    private CombinedAsyncWriter(ImmutableList<WALProvider.AsyncWriter> writers) {
        this.writers = writers;
    }

    @Override
    public long getLength() {
        return ((WALProvider.AsyncWriter)this.writers.get(0)).getLength();
    }

    @Override
    public long getSyncedLength() {
        return ((WALProvider.AsyncWriter)this.writers.get(0)).getSyncedLength();
    }

    @Override
    public void close() throws IOException {
        Exception error = null;
        for (WALProvider.AsyncWriter writer : this.writers) {
            try {
                writer.close();
            }
            catch (Exception e) {
                LOG.warn("close writer failed", (Throwable)e);
                if (error != null) continue;
                error = e;
            }
        }
        if (error != null) {
            throw new IOException("Failed to close at least one writer, please see the warn log above. The cause is the first exception occurred", error);
        }
    }

    @Override
    public void append(WAL.Entry entry) {
        this.writers.forEach(w -> w.append(entry));
    }

    @Override
    public CompletableFuture<Long> sync(boolean forceSync) {
        CompletableFuture<Long> future = new CompletableFuture<Long>();
        AtomicInteger remaining = new AtomicInteger(this.writers.size());
        this.writers.forEach(w -> FutureUtils.addListener(w.sync(forceSync), (length, error) -> {
            if (error != null) {
                future.completeExceptionally((Throwable)error);
                return;
            }
            if (remaining.decrementAndGet() == 0) {
                future.complete((Long)length);
            }
        }));
        return future;
    }

    public static CombinedAsyncWriter create(WALProvider.AsyncWriter writer, WALProvider.AsyncWriter ... writers) {
        return new CombinedAsyncWriter((ImmutableList<WALProvider.AsyncWriter>)ImmutableList.builder().add((Object)writer).add((Object[])writers).build());
    }
}

