/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.regionreplication;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.regionreplication.RegionReplicationSink;
import org.apache.hadoop.util.StringUtils;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RegionReplicationBufferManager {
    private static final Logger LOG = LoggerFactory.getLogger(RegionReplicationBufferManager.class);
    public static final String MAX_PENDING_SIZE = "hbase.region.read-replica.sink.max-pending-size";
    public static final long MAX_PENDING_SIZE_DEFAULT = 0x6400000L;
    public static final String SOFT_LIMIT_PERCENTAGE = "hbase.region.read-replica.sink.max-pending-size.soft-limit-percentage";
    public static final float SOFT_LIMIT_PERCENTAGE_DEFAULT = 0.8f;
    private final RegionServerServices rsServices;
    private final long maxPendingSize;
    private final long softMaxPendingSize;
    private final AtomicLong pendingSize = new AtomicLong();
    private final ThreadPoolExecutor executor;

    public RegionReplicationBufferManager(RegionServerServices rsServices) {
        this.rsServices = rsServices;
        Configuration conf = rsServices.getConfiguration();
        this.maxPendingSize = conf.getLong(MAX_PENDING_SIZE, 0x6400000L);
        this.softMaxPendingSize = (long)(conf.getFloat(SOFT_LIMIT_PERCENTAGE, 0.8f) * (float)this.maxPendingSize);
        this.executor = new ThreadPoolExecutor(1, 1, 1L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Region-Replication-Flusher-%d").build(), (r, e) -> LOG.debug("A flush task is ongoing, drop the new scheduled one"));
        this.executor.allowCoreThreadTimeOut(true);
    }

    private void flush() {
        long max = Long.MIN_VALUE;
        HRegion toFlush = null;
        for (HRegion region : this.rsServices.getRegions()) {
            RegionReplicationSink s;
            long p;
            Optional<RegionReplicationSink> sink = region.getRegionReplicationSink();
            if (!sink.isPresent() || (p = (s = sink.get()).pendingSize()) <= max) continue;
            max = p;
            toFlush = region;
        }
        if (toFlush != null) {
            try {
                LOG.info("Going to flush {} with {} pending entry size", (Object)toFlush.getRegionInfo(), (Object)StringUtils.TraditionalBinaryPrefix.long2String((long)max, (String)"", (int)1));
                HRegion.FlushResultImpl result = toFlush.flushcache(true, true, FlushLifeCycleTracker.DUMMY);
                if (!result.isFlushSucceeded()) {
                    LOG.warn("Failed to flush {}, the result is {}", (Object)toFlush.getRegionInfo(), (Object)result.getResult());
                }
            }
            catch (IOException e) {
                LOG.warn("Failed to flush {}", (Object)toFlush.getRegionInfo(), (Object)e);
            }
        } else {
            LOG.warn("Can not find a region to flush");
        }
    }

    public boolean increase(long size) {
        long sz = this.pendingSize.addAndGet(size);
        if (sz > this.softMaxPendingSize) {
            this.executor.execute(this::flush);
        }
        return sz <= this.maxPendingSize;
    }

    public void decrease(long size) {
        this.pendingSize.addAndGet(-size);
    }

    public void stop() {
        this.executor.shutdown();
    }
}

