/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.regionserver.OperationStatus;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor"})
public class MiniBatchOperationInProgress<T> {
    private final T[] operations;
    private Mutation[][] operationsFromCoprocessors;
    private final OperationStatus[] retCodeDetails;
    private final WALEdit[] walEditsFromCoprocessors;
    private final int firstIndex;
    private final int lastIndexExclusive;
    private int readyToWriteCount = 0;
    private int cellCount = 0;
    private int numOfPuts = 0;
    private int numOfDeletes = 0;
    private int numOfIncrements = 0;
    private int numOfAppends = 0;
    private WALEdit walEditForReplicateIfExistsSkipWAL = null;

    public MiniBatchOperationInProgress(T[] operations, OperationStatus[] retCodeDetails, WALEdit[] walEditsFromCoprocessors, int firstIndex, int lastIndexExclusive, int readyToWriteCount) {
        Preconditions.checkArgument((readyToWriteCount <= lastIndexExclusive - firstIndex ? 1 : 0) != 0);
        this.operations = operations;
        this.retCodeDetails = retCodeDetails;
        this.walEditsFromCoprocessors = walEditsFromCoprocessors;
        this.firstIndex = firstIndex;
        this.lastIndexExclusive = lastIndexExclusive;
        this.readyToWriteCount = readyToWriteCount;
    }

    public int size() {
        return this.lastIndexExclusive - this.firstIndex;
    }

    public T getOperation(int index) {
        return this.operations[this.getAbsoluteIndex(index)];
    }

    public void setOperationStatus(int index, OperationStatus opStatus) {
        this.retCodeDetails[this.getAbsoluteIndex((int)index)] = opStatus;
    }

    public OperationStatus getOperationStatus(int index) {
        return this.retCodeDetails[this.getAbsoluteIndex(index)];
    }

    public void setWalEdit(int index, WALEdit walEdit) {
        this.walEditsFromCoprocessors[this.getAbsoluteIndex((int)index)] = walEdit;
    }

    public WALEdit getWalEdit(int index) {
        return this.walEditsFromCoprocessors[this.getAbsoluteIndex(index)];
    }

    private int getAbsoluteIndex(int index) {
        if (index < 0 || this.firstIndex + index >= this.lastIndexExclusive) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.firstIndex + index;
    }

    public void addOperationsFromCP(int index, Mutation[] newOperations) {
        if (this.operationsFromCoprocessors == null) {
            this.operationsFromCoprocessors = new Mutation[this.operations.length][];
        }
        this.operationsFromCoprocessors[this.getAbsoluteIndex((int)index)] = newOperations;
    }

    public Mutation[] getOperationsFromCoprocessors(int index) {
        return this.operationsFromCoprocessors == null ? null : this.operationsFromCoprocessors[this.getAbsoluteIndex(index)];
    }

    public int getReadyToWriteCount() {
        return this.readyToWriteCount;
    }

    public int getLastIndexExclusive() {
        return this.lastIndexExclusive;
    }

    public int getCellCount() {
        return this.cellCount;
    }

    public void addCellCount(int cellCount) {
        this.cellCount += cellCount;
    }

    public int getNumOfPuts() {
        return this.numOfPuts;
    }

    public void incrementNumOfPuts() {
        ++this.numOfPuts;
    }

    public int getNumOfDeletes() {
        return this.numOfDeletes;
    }

    public void incrementNumOfDeletes() {
        ++this.numOfDeletes;
    }

    public int getNumOfIncrements() {
        return this.numOfIncrements;
    }

    public void incrementNumOfIncrements() {
        ++this.numOfIncrements;
    }

    public int getNumOfAppends() {
        return this.numOfAppends;
    }

    public void incrementNumOfAppends() {
        ++this.numOfAppends;
    }

    public WALEdit getWalEditForReplicateIfExistsSkipWAL() {
        return this.walEditForReplicateIfExistsSkipWAL;
    }

    public void setWalEditForReplicateIfExistsSkipWAL(WALEdit walEditForReplicateSkipWAL) {
        this.walEditForReplicateIfExistsSkipWAL = walEditForReplicateSkipWAL;
    }
}

