/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.zookeeper.ZKListener;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class ZKProcedureUtil
extends ZKListener
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ZKProcedureUtil.class);
    public static final String ACQUIRED_BARRIER_ZNODE_DEFAULT = "acquired";
    public static final String REACHED_BARRIER_ZNODE_DEFAULT = "reached";
    public static final String ABORT_ZNODE_DEFAULT = "abort";
    public final String baseZNode;
    protected final String acquiredZnode;
    protected final String reachedZnode;
    protected final String abortZnode;

    public ZKProcedureUtil(ZKWatcher watcher, String procDescription) throws KeeperException {
        super(watcher);
        watcher.registerListener((ZKListener)this);
        this.baseZNode = ZNodePaths.joinZNode((String)watcher.getZNodePaths().baseZNode, (String[])new String[]{procDescription});
        this.acquiredZnode = ZNodePaths.joinZNode((String)this.baseZNode, (String[])new String[]{ACQUIRED_BARRIER_ZNODE_DEFAULT});
        this.reachedZnode = ZNodePaths.joinZNode((String)this.baseZNode, (String[])new String[]{REACHED_BARRIER_ZNODE_DEFAULT});
        this.abortZnode = ZNodePaths.joinZNode((String)this.baseZNode, (String[])new String[]{ABORT_ZNODE_DEFAULT});
        ZKUtil.createWithParents((ZKWatcher)watcher, (String)this.acquiredZnode);
        ZKUtil.createAndFailSilent((ZKWatcher)watcher, (String)this.reachedZnode);
        ZKUtil.createAndFailSilent((ZKWatcher)watcher, (String)this.abortZnode);
    }

    @Override
    public void close() throws IOException {
    }

    public String getAcquiredBarrierNode(String opInstanceName) {
        return ZKProcedureUtil.getAcquireBarrierNode(this, opInstanceName);
    }

    public String getReachedBarrierNode(String opInstanceName) {
        return ZKProcedureUtil.getReachedBarrierNode(this, opInstanceName);
    }

    public String getAbortZNode(String opInstanceName) {
        return ZKProcedureUtil.getAbortNode(this, opInstanceName);
    }

    public String getAbortZnode() {
        return this.abortZnode;
    }

    public String getBaseZnode() {
        return this.baseZNode;
    }

    public String getAcquiredBarrier() {
        return this.acquiredZnode;
    }

    public static String getAcquireBarrierNode(ZKProcedureUtil controller, String opInstanceName) {
        return ZNodePaths.joinZNode((String)controller.acquiredZnode, (String[])new String[]{opInstanceName});
    }

    public static String getReachedBarrierNode(ZKProcedureUtil controller, String opInstanceName) {
        return ZNodePaths.joinZNode((String)controller.reachedZnode, (String[])new String[]{opInstanceName});
    }

    public static String getAbortNode(ZKProcedureUtil controller, String opInstanceName) {
        return ZNodePaths.joinZNode((String)controller.abortZnode, (String[])new String[]{opInstanceName});
    }

    public ZKWatcher getWatcher() {
        return this.watcher;
    }

    boolean isInProcedurePath(String path) {
        return path.startsWith(this.baseZNode);
    }

    boolean isAcquiredNode(String path) {
        return path.equals(this.acquiredZnode);
    }

    boolean isAcquiredPathNode(String path) {
        return path.startsWith(this.acquiredZnode) && !path.equals(this.acquiredZnode) && this.isMemberNode(path, this.acquiredZnode);
    }

    boolean isReachedNode(String path) {
        return path.equals(this.reachedZnode);
    }

    boolean isReachedPathNode(String path) {
        return path.startsWith(this.reachedZnode) && !path.equals(this.reachedZnode) && this.isMemberNode(path, this.reachedZnode);
    }

    private boolean isMemberNode(String path, String statePath) {
        int count = 0;
        for (int i = statePath.length(); i < path.length(); ++i) {
            count += path.charAt(i) == '/' ? 1 : 0;
        }
        return count == 2;
    }

    boolean isAbortNode(String path) {
        return path.equals(this.abortZnode);
    }

    public boolean isAbortPathNode(String path) {
        return path.startsWith(this.abortZnode) && !path.equals(this.abortZnode);
    }

    void logZKTree(String root) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug("Current zk system:");
        String prefix = "|-";
        LOG.debug(prefix + root);
        try {
            this.logZKTree(root, prefix);
        }
        catch (KeeperException e) {
            throw new RuntimeException(e);
        }
    }

    protected void logZKTree(String root, String prefix) throws KeeperException {
        List children = ZKUtil.listChildrenNoWatch((ZKWatcher)this.watcher, (String)root);
        if (children == null) {
            return;
        }
        for (String child : children) {
            LOG.debug(prefix + child);
            String node = ZNodePaths.joinZNode((String)(root.equals("/") ? "" : root), (String[])new String[]{child});
            this.logZKTree(node, prefix + "---");
        }
    }

    public void clearChildZNodes() throws KeeperException {
        LOG.debug("Clearing all znodes {}, {}, {}", new Object[]{this.acquiredZnode, this.reachedZnode, this.abortZnode});
        ZKUtil.deleteChildrenRecursivelyMultiOrSequential((ZKWatcher)this.watcher, (boolean)true, (String[])new String[]{this.acquiredZnode, this.reachedZnode, this.abortZnode});
        if (LOG.isTraceEnabled()) {
            this.logZKTree(this.baseZNode);
        }
    }

    public void clearZNodes(String procedureName) throws KeeperException {
        LOG.info("Clearing all znodes for procedure " + procedureName + " including nodes " + this.acquiredZnode + " " + this.reachedZnode + " " + this.abortZnode);
        String acquiredBarrierNode = this.getAcquiredBarrierNode(procedureName);
        String reachedBarrierNode = this.getReachedBarrierNode(procedureName);
        String abortZNode = this.getAbortZNode(procedureName);
        ZKUtil.createAndFailSilent((ZKWatcher)this.watcher, (String)acquiredBarrierNode);
        ZKUtil.createAndFailSilent((ZKWatcher)this.watcher, (String)abortZNode);
        ZKUtil.deleteNodeRecursivelyMultiOrSequential((ZKWatcher)this.watcher, (boolean)true, (String[])new String[]{acquiredBarrierNode, reachedBarrierNode, abortZNode});
        if (LOG.isTraceEnabled()) {
            this.logZKTree(this.baseZNode);
        }
    }
}

