/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.replication;

import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.replication.ReplicationPeerConfigUtil;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.PeerProcedureInterface;
import org.apache.hadoop.hbase.master.procedure.ReopenTableRegionsProcedure;
import org.apache.hadoop.hbase.master.replication.AbstractPeerProcedure;
import org.apache.hadoop.hbase.master.replication.MigrateReplicationQueueFromZkToTableProcedure;
import org.apache.hadoop.hbase.master.replication.RecoverStandbyProcedure;
import org.apache.hadoop.hbase.master.replication.RefreshPeerProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
import org.apache.hadoop.hbase.replication.ReplicationUtils;
import org.apache.hadoop.hbase.replication.SyncReplicationState;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ReplicationProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class TransitPeerSyncReplicationStateProcedure
extends AbstractPeerProcedure<MasterProcedureProtos.PeerSyncReplicationStateTransitionState> {
    private static final Logger LOG = LoggerFactory.getLogger(TransitPeerSyncReplicationStateProcedure.class);
    protected SyncReplicationState fromState;
    private SyncReplicationState toState;
    private boolean enabled;
    private boolean serial;

    public TransitPeerSyncReplicationStateProcedure() {
    }

    public TransitPeerSyncReplicationStateProcedure(String peerId, SyncReplicationState state) {
        super(peerId);
        this.toState = state;
    }

    @Override
    public PeerProcedureInterface.PeerOperationType getPeerOperationType() {
        return PeerProcedureInterface.PeerOperationType.TRANSIT_SYNC_REPLICATION_STATE;
    }

    @Override
    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.TransitPeerSyncReplicationStateStateData.Builder builder = MasterProcedureProtos.TransitPeerSyncReplicationStateStateData.newBuilder().setToState(ReplicationPeerConfigUtil.toSyncReplicationState((SyncReplicationState)this.toState));
        if (this.fromState != null) {
            builder.setFromState(ReplicationPeerConfigUtil.toSyncReplicationState((SyncReplicationState)this.fromState));
        }
        serializer.serialize((Message)builder.build());
    }

    @Override
    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.TransitPeerSyncReplicationStateStateData data = (MasterProcedureProtos.TransitPeerSyncReplicationStateStateData)serializer.deserialize(MasterProcedureProtos.TransitPeerSyncReplicationStateStateData.class);
        this.toState = ReplicationPeerConfigUtil.toSyncReplicationState((ReplicationProtos.SyncReplicationState)data.getToState());
        if (data.hasFromState()) {
            this.fromState = ReplicationPeerConfigUtil.toSyncReplicationState((ReplicationProtos.SyncReplicationState)data.getFromState());
        }
    }

    protected MasterProcedureProtos.PeerSyncReplicationStateTransitionState getState(int stateId) {
        return MasterProcedureProtos.PeerSyncReplicationStateTransitionState.forNumber((int)stateId);
    }

    protected int getStateId(MasterProcedureProtos.PeerSyncReplicationStateTransitionState state) {
        return state.getNumber();
    }

    protected MasterProcedureProtos.PeerSyncReplicationStateTransitionState getInitialState() {
        return MasterProcedureProtos.PeerSyncReplicationStateTransitionState.PRE_PEER_SYNC_REPLICATION_STATE_TRANSITION;
    }

    protected void preTransit(MasterProcedureEnv env) throws IOException {
        Path remoteWALDirForPeer;
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            cpHost.preTransitReplicationPeerSyncReplicationState(this.peerId, this.toState);
        }
        ReplicationPeerDescription desc = env.getReplicationPeerManager().preTransitPeerSyncReplicationState(this.peerId, this.toState);
        if (this.toState == SyncReplicationState.ACTIVE && !(remoteWALDirForPeer = ReplicationUtils.getPeerRemoteWALDir((String)desc.getPeerConfig().getRemoteWALDir(), (String)this.peerId)).getFileSystem(env.getMasterConfiguration()).exists(remoteWALDirForPeer)) {
            throw new DoNotRetryIOException("The remote WAL directory " + remoteWALDirForPeer + " does not exist");
        }
        this.fromState = desc.getSyncReplicationState();
        this.enabled = desc.isEnabled();
        this.serial = desc.getPeerConfig().isSerial();
    }

    private void postTransit(MasterProcedureEnv env) throws IOException {
        LOG.info("Successfully transit current cluster state from {} to {} for sync replication peer {}", new Object[]{this.fromState, this.toState, this.peerId});
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            env.getMasterCoprocessorHost().postTransitReplicationPeerSyncReplicationState(this.peerId, this.fromState, this.toState);
        }
    }

    protected void reopenRegions(MasterProcedureEnv env) {
        this.addChildProcedure((Procedure[])env.getReplicationPeerManager().getPeerConfig(this.peerId).get().getTableCFsMap().keySet().stream().map(ReopenTableRegionsProcedure::new).toArray(ReopenTableRegionsProcedure[]::new));
    }

    protected void createDirForRemoteWAL(MasterProcedureEnv env) throws IOException {
        MasterFileSystem mfs = env.getMasterFileSystem();
        Path remoteWALDir = new Path(mfs.getWALRootDir(), "remoteWALs");
        Path remoteWALDirForPeer = ReplicationUtils.getPeerRemoteWALDir((Path)remoteWALDir, (String)this.peerId);
        FileSystem walFs = mfs.getWALFileSystem();
        if (walFs.exists(remoteWALDirForPeer)) {
            LOG.warn("Wal dir {} already exists, usually this should not happen, continue anyway", (Object)remoteWALDirForPeer);
        } else if (!walFs.mkdirs(remoteWALDirForPeer)) {
            throw new IOException("Failed to create remote wal dir " + remoteWALDirForPeer);
        }
    }

    private void setNextStateAfterRefreshBegin() {
        if (this.fromState.equals((Object)SyncReplicationState.ACTIVE)) {
            this.setNextState(this.toState.equals((Object)SyncReplicationState.STANDBY) ? MasterProcedureProtos.PeerSyncReplicationStateTransitionState.REMOVE_ALL_REPLICATION_QUEUES_IN_PEER : MasterProcedureProtos.PeerSyncReplicationStateTransitionState.REOPEN_ALL_REGIONS_IN_PEER);
        } else if (this.fromState.equals((Object)SyncReplicationState.DOWNGRADE_ACTIVE)) {
            this.setNextState(this.toState.equals((Object)SyncReplicationState.STANDBY) ? MasterProcedureProtos.PeerSyncReplicationStateTransitionState.REMOVE_ALL_REPLICATION_QUEUES_IN_PEER : MasterProcedureProtos.PeerSyncReplicationStateTransitionState.REOPEN_ALL_REGIONS_IN_PEER);
        } else {
            assert (this.toState.equals((Object)SyncReplicationState.DOWNGRADE_ACTIVE));
            this.setNextState(this.serial ? MasterProcedureProtos.PeerSyncReplicationStateTransitionState.REOPEN_ALL_REGIONS_IN_PEER : MasterProcedureProtos.PeerSyncReplicationStateTransitionState.REPLAY_REMOTE_WAL_IN_PEER);
        }
    }

    private void setNextStateAfterRefreshEnd() {
        if (this.toState == SyncReplicationState.STANDBY) {
            this.setNextState(this.enabled ? MasterProcedureProtos.PeerSyncReplicationStateTransitionState.SYNC_REPLICATION_SET_PEER_ENABLED : MasterProcedureProtos.PeerSyncReplicationStateTransitionState.CREATE_DIR_FOR_REMOTE_WAL);
        } else if (this.fromState == SyncReplicationState.STANDBY) {
            assert (this.toState.equals((Object)SyncReplicationState.DOWNGRADE_ACTIVE));
            this.setNextState(this.serial && this.enabled ? MasterProcedureProtos.PeerSyncReplicationStateTransitionState.SYNC_REPLICATION_SET_PEER_ENABLED : MasterProcedureProtos.PeerSyncReplicationStateTransitionState.POST_PEER_SYNC_REPLICATION_STATE_TRANSITION);
        } else {
            this.setNextState(MasterProcedureProtos.PeerSyncReplicationStateTransitionState.POST_PEER_SYNC_REPLICATION_STATE_TRANSITION);
        }
    }

    private void replayRemoteWAL(boolean serial) {
        this.addChildProcedure((Procedure[])new RecoverStandbyProcedure[]{new RecoverStandbyProcedure(this.peerId, serial)});
    }

    protected void setPeerNewSyncReplicationState(MasterProcedureEnv env) throws ReplicationException {
        if (this.toState.equals((Object)SyncReplicationState.STANDBY) || this.fromState.equals((Object)SyncReplicationState.STANDBY) && this.serial && this.enabled) {
            env.getReplicationPeerManager().disablePeer(this.peerId);
        }
        env.getReplicationPeerManager().setPeerNewSyncReplicationState(this.peerId, this.toState);
    }

    protected void removeAllReplicationQueues(MasterProcedureEnv env) throws ReplicationException {
        env.getReplicationPeerManager().removeAllQueues(this.peerId);
    }

    protected void transitPeerSyncReplicationState(MasterProcedureEnv env) throws ReplicationException {
        env.getReplicationPeerManager().transitPeerSyncReplicationState(this.peerId, this.toState);
    }

    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.PeerSyncReplicationStateTransitionState state) throws ProcedureSuspendedException {
        switch (state) {
            case PRE_PEER_SYNC_REPLICATION_STATE_TRANSITION: {
                try {
                    if (env.getMasterServices().getProcedures().stream().filter(p -> p instanceof MigrateReplicationQueueFromZkToTableProcedure).anyMatch(p -> !p.isFinished())) {
                        LOG.info("There is a pending {}, give up execution of {}", (Object)MigrateReplicationQueueFromZkToTableProcedure.class.getSimpleName(), (Object)this.getClass().getSimpleName());
                        this.setFailure("master-transit-peer-sync-replication-state", (Throwable)new DoNotRetryIOException("There is a pending " + MigrateReplicationQueueFromZkToTableProcedure.class.getSimpleName()));
                        return StateMachineProcedure.Flow.NO_MORE_STATE;
                    }
                    this.checkPeerModificationEnabled(env);
                    this.preTransit(env);
                }
                catch (IOException e) {
                    LOG.warn("Failed to call pre CP hook or the pre check is failed for peer {} when transiting sync replication peer state to {}, mark the procedure as failure and give up", new Object[]{this.peerId, this.toState, e});
                    this.setFailure("master-transit-peer-sync-replication-state", e);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                this.setNextState(MasterProcedureProtos.PeerSyncReplicationStateTransitionState.SET_PEER_NEW_SYNC_REPLICATION_STATE);
                return StateMachineProcedure.Flow.HAS_MORE_STATE;
            }
            case SET_PEER_NEW_SYNC_REPLICATION_STATE: {
                try {
                    this.setPeerNewSyncReplicationState(env);
                }
                catch (ReplicationException e) {
                    throw this.suspend(env.getMasterConfiguration(), backoff -> LOG.warn("Failed to update peer storage for peer {} when starting transiting sync replication peer state from {} to {}, sleep {} secs and retry", new Object[]{this.peerId, this.fromState, this.toState, backoff / 1000L, e}));
                }
                this.resetRetry();
                this.setNextState(MasterProcedureProtos.PeerSyncReplicationStateTransitionState.REFRESH_PEER_SYNC_REPLICATION_STATE_ON_RS_BEGIN);
                return StateMachineProcedure.Flow.HAS_MORE_STATE;
            }
            case REFRESH_PEER_SYNC_REPLICATION_STATE_ON_RS_BEGIN: {
                this.addChildProcedure((Procedure[])env.getMasterServices().getServerManager().getOnlineServersList().stream().map(sn -> new RefreshPeerProcedure(this.peerId, this.getPeerOperationType(), (ServerName)sn, 0)).toArray(RefreshPeerProcedure[]::new));
                this.setNextStateAfterRefreshBegin();
                return StateMachineProcedure.Flow.HAS_MORE_STATE;
            }
            case REOPEN_ALL_REGIONS_IN_PEER: {
                this.reopenRegions(env);
                if (this.fromState.equals((Object)SyncReplicationState.STANDBY)) {
                    assert (this.serial);
                    this.setNextState(MasterProcedureProtos.PeerSyncReplicationStateTransitionState.SYNC_REPLICATION_UPDATE_LAST_PUSHED_SEQ_ID_FOR_SERIAL_PEER);
                } else {
                    this.setNextState(MasterProcedureProtos.PeerSyncReplicationStateTransitionState.TRANSIT_PEER_NEW_SYNC_REPLICATION_STATE);
                }
                return StateMachineProcedure.Flow.HAS_MORE_STATE;
            }
            case SYNC_REPLICATION_UPDATE_LAST_PUSHED_SEQ_ID_FOR_SERIAL_PEER: {
                try {
                    this.setLastPushedSequenceId(env, env.getReplicationPeerManager().getPeerConfig(this.peerId).get());
                }
                catch (Exception e) {
                    throw this.suspend(env.getMasterConfiguration(), backoff -> LOG.warn("Failed to update last pushed sequence id for peer {} when transiting sync replication peer state from {} to {}, sleep {} secs and retry", new Object[]{this.peerId, this.fromState, this.toState, backoff / 1000L, e}));
                }
                this.resetRetry();
                this.setNextState(MasterProcedureProtos.PeerSyncReplicationStateTransitionState.REPLAY_REMOTE_WAL_IN_PEER);
                return StateMachineProcedure.Flow.HAS_MORE_STATE;
            }
            case REPLAY_REMOTE_WAL_IN_PEER: {
                this.replayRemoteWAL(env.getReplicationPeerManager().getPeerConfig(this.peerId).get().isSerial());
                this.setNextState(MasterProcedureProtos.PeerSyncReplicationStateTransitionState.TRANSIT_PEER_NEW_SYNC_REPLICATION_STATE);
                return StateMachineProcedure.Flow.HAS_MORE_STATE;
            }
            case REMOVE_ALL_REPLICATION_QUEUES_IN_PEER: {
                try {
                    this.removeAllReplicationQueues(env);
                }
                catch (ReplicationException e) {
                    throw this.suspend(env.getMasterConfiguration(), backoff -> LOG.warn("Failed to remove all replication queues peer {} when starting transiting sync replication peer state from {} to {}, sleep {} secs and retry", new Object[]{this.peerId, this.fromState, this.toState, backoff / 1000L, e}));
                }
                this.resetRetry();
                this.setNextState(this.fromState.equals((Object)SyncReplicationState.ACTIVE) ? MasterProcedureProtos.PeerSyncReplicationStateTransitionState.REOPEN_ALL_REGIONS_IN_PEER : MasterProcedureProtos.PeerSyncReplicationStateTransitionState.TRANSIT_PEER_NEW_SYNC_REPLICATION_STATE);
                return StateMachineProcedure.Flow.HAS_MORE_STATE;
            }
            case TRANSIT_PEER_NEW_SYNC_REPLICATION_STATE: {
                try {
                    this.transitPeerSyncReplicationState(env);
                }
                catch (ReplicationException e) {
                    throw this.suspend(env.getMasterConfiguration(), backoff -> LOG.warn("Failed to update peer storage for peer {} when ending transiting sync replication peer state from {} to {}, sleep {} secs and retry", new Object[]{this.peerId, this.fromState, this.toState, backoff / 1000L, e}));
                }
                this.resetRetry();
                this.setNextState(MasterProcedureProtos.PeerSyncReplicationStateTransitionState.REFRESH_PEER_SYNC_REPLICATION_STATE_ON_RS_END);
                return StateMachineProcedure.Flow.HAS_MORE_STATE;
            }
            case REFRESH_PEER_SYNC_REPLICATION_STATE_ON_RS_END: {
                this.addChildProcedure((Procedure[])env.getMasterServices().getServerManager().getOnlineServersList().stream().map(sn -> new RefreshPeerProcedure(this.peerId, this.getPeerOperationType(), (ServerName)sn, 1)).toArray(RefreshPeerProcedure[]::new));
                this.setNextStateAfterRefreshEnd();
                return StateMachineProcedure.Flow.HAS_MORE_STATE;
            }
            case SYNC_REPLICATION_SET_PEER_ENABLED: {
                try {
                    this.enablePeer(env);
                }
                catch (ReplicationException e) {
                    throw this.suspend(env.getMasterConfiguration(), backoff -> LOG.warn("Failed to set peer enabled for peer {} when transiting sync replication peer state from {} to {}, sleep {} secs and retry", new Object[]{this.peerId, this.fromState, this.toState, backoff / 1000L, e}));
                }
                this.resetRetry();
                this.setNextState(MasterProcedureProtos.PeerSyncReplicationStateTransitionState.SYNC_REPLICATION_ENABLE_PEER_REFRESH_PEER_ON_RS);
                return StateMachineProcedure.Flow.HAS_MORE_STATE;
            }
            case SYNC_REPLICATION_ENABLE_PEER_REFRESH_PEER_ON_RS: {
                this.refreshPeer(env, PeerProcedureInterface.PeerOperationType.ENABLE);
                this.setNextState(MasterProcedureProtos.PeerSyncReplicationStateTransitionState.CREATE_DIR_FOR_REMOTE_WAL);
                return StateMachineProcedure.Flow.HAS_MORE_STATE;
            }
            case CREATE_DIR_FOR_REMOTE_WAL: {
                try {
                    this.createDirForRemoteWAL(env);
                }
                catch (IOException e) {
                    throw this.suspend(env.getMasterConfiguration(), backoff -> LOG.warn("Failed to create remote wal dir for peer {} when transiting sync replication peer state from {} to {}, sleep {} secs and retry", new Object[]{this.peerId, this.fromState, this.toState, backoff / 1000L, e}));
                }
                this.resetRetry();
                this.setNextState(MasterProcedureProtos.PeerSyncReplicationStateTransitionState.POST_PEER_SYNC_REPLICATION_STATE_TRANSITION);
                return StateMachineProcedure.Flow.HAS_MORE_STATE;
            }
            case POST_PEER_SYNC_REPLICATION_STATE_TRANSITION: {
                try {
                    this.postTransit(env);
                }
                catch (IOException e) {
                    LOG.warn("Failed to call post CP hook for peer {} when transiting sync replication peer state from {} to {}, ignore since the procedure has already done", new Object[]{this.peerId, this.fromState, this.toState, e});
                }
                return StateMachineProcedure.Flow.NO_MORE_STATE;
            }
        }
        throw new UnsupportedOperationException("unhandled state=" + state);
    }
}

