/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.replication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.PeerProcedureInterface;
import org.apache.hadoop.hbase.master.procedure.RSProcedureDispatcher;
import org.apache.hadoop.hbase.master.procedure.ServerRemoteProcedure;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureDispatcher;
import org.apache.hadoop.hbase.replication.regionserver.ReplaySyncReplicationWALCallable;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SyncReplicationReplayWALRemoteProcedure
extends ServerRemoteProcedure
implements PeerProcedureInterface {
    private static final Logger LOG = LoggerFactory.getLogger(SyncReplicationReplayWALRemoteProcedure.class);
    private String peerId;
    private List<String> wals;

    public SyncReplicationReplayWALRemoteProcedure() {
    }

    public SyncReplicationReplayWALRemoteProcedure(String peerId, List<String> wals, ServerName targetServer) {
        this.peerId = peerId;
        this.wals = wals;
        this.targetServer = targetServer;
    }

    public Optional<RemoteProcedureDispatcher.RemoteOperation> remoteCallBuild(MasterProcedureEnv env, ServerName remote) {
        MasterProcedureProtos.ReplaySyncReplicationWALParameter.Builder builder = MasterProcedureProtos.ReplaySyncReplicationWALParameter.newBuilder();
        builder.setPeerId(this.peerId);
        this.wals.stream().forEach(arg_0 -> ((MasterProcedureProtos.ReplaySyncReplicationWALParameter.Builder)builder).addWal(arg_0));
        return Optional.of(new RSProcedureDispatcher.ServerOperation(this, this.getProcId(), ReplaySyncReplicationWALCallable.class, builder.build().toByteArray()));
    }

    @Override
    protected void complete(MasterProcedureEnv env, Throwable error) {
        if (error != null) {
            LOG.warn("Replay wals {} on {} failed for peer id={}", new Object[]{this.wals, this.targetServer, this.peerId, error});
            this.succ = false;
        } else {
            this.truncateWALs(env);
            LOG.info("Replay wals {} on {} succeed for peer id={}", new Object[]{this.wals, this.targetServer, this.peerId});
            this.succ = true;
        }
    }

    private void truncateWALs(MasterProcedureEnv env) {
        String firstWal = this.wals.get(0);
        try {
            env.getMasterServices().getSyncReplicationReplayWALManager().finishReplayWAL(firstWal);
        }
        catch (IOException e) {
            LOG.warn("Failed to truncate wal {} for peer id={}", new Object[]{firstWal, this.peerId, e});
            return;
        }
        for (int i = 1; i < this.wals.size(); ++i) {
            String wal = this.wals.get(i);
            try {
                env.getMasterServices().getSyncReplicationReplayWALManager().finishReplayWAL(wal);
                continue;
            }
            catch (IOException e1) {
                try {
                    env.getMasterServices().getSyncReplicationReplayWALManager().finishReplayWAL(wal);
                    continue;
                }
                catch (IOException e2) {
                    LOG.warn("Failed to truncate wal {} for peer id={}", new Object[]{wal, this.peerId, e2});
                }
            }
        }
    }

    protected void rollback(MasterProcedureEnv env) throws IOException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    protected boolean abort(MasterProcedureEnv env) {
        return false;
    }

    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        MasterProcedureProtos.SyncReplicationReplayWALRemoteStateData.Builder builder = MasterProcedureProtos.SyncReplicationReplayWALRemoteStateData.newBuilder().setPeerId(this.peerId).setTargetServer(ProtobufUtil.toServerName((ServerName)this.targetServer));
        this.wals.stream().forEach(arg_0 -> ((MasterProcedureProtos.SyncReplicationReplayWALRemoteStateData.Builder)builder).addWal(arg_0));
        serializer.serialize((Message)builder.build());
    }

    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        MasterProcedureProtos.SyncReplicationReplayWALRemoteStateData data = (MasterProcedureProtos.SyncReplicationReplayWALRemoteStateData)serializer.deserialize(MasterProcedureProtos.SyncReplicationReplayWALRemoteStateData.class);
        this.peerId = data.getPeerId();
        this.wals = new ArrayList<String>();
        data.getWalList().forEach(this.wals::add);
        this.targetServer = ProtobufUtil.toServerName((HBaseProtos.ServerName)data.getTargetServer());
    }

    @Override
    public String getPeerId() {
        return this.peerId;
    }

    @Override
    public PeerProcedureInterface.PeerOperationType getPeerOperationType() {
        return PeerProcedureInterface.PeerOperationType.SYNC_REPLICATION_REPLAY_WAL_REMOTE;
    }
}

