/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.replication;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.PeerProcedureInterface;
import org.apache.hadoop.hbase.master.replication.AbstractPeerNoLockProcedure;
import org.apache.hadoop.hbase.master.replication.SyncReplicationReplayWALManager;
import org.apache.hadoop.hbase.master.replication.SyncReplicationReplayWALProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RecoverStandbyProcedure
extends AbstractPeerNoLockProcedure<MasterProcedureProtos.RecoverStandbyState> {
    private static final Logger LOG = LoggerFactory.getLogger(RecoverStandbyProcedure.class);
    private boolean serial;

    public RecoverStandbyProcedure() {
    }

    public RecoverStandbyProcedure(String peerId, boolean serial) {
        super(peerId);
        this.serial = serial;
    }

    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.RecoverStandbyState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        SyncReplicationReplayWALManager syncReplicationReplayWALManager = env.getMasterServices().getSyncReplicationReplayWALManager();
        switch (state) {
            case RENAME_SYNC_REPLICATION_WALS_DIR: {
                try {
                    syncReplicationReplayWALManager.renameToPeerReplayWALDir(this.peerId);
                }
                catch (IOException e) {
                    LOG.warn("Failed to rename remote wal dir for peer id={}", (Object)this.peerId, (Object)e);
                    this.setFailure("master-recover-standby", e);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                this.setNextState(MasterProcedureProtos.RecoverStandbyState.REGISTER_PEER_TO_WORKER_STORAGE);
                return StateMachineProcedure.Flow.HAS_MORE_STATE;
            }
            case REGISTER_PEER_TO_WORKER_STORAGE: {
                syncReplicationReplayWALManager.registerPeer(this.peerId);
                this.setNextState(MasterProcedureProtos.RecoverStandbyState.DISPATCH_WALS);
                return StateMachineProcedure.Flow.HAS_MORE_STATE;
            }
            case DISPATCH_WALS: {
                this.dispathWals(syncReplicationReplayWALManager);
                this.setNextState(MasterProcedureProtos.RecoverStandbyState.UNREGISTER_PEER_FROM_WORKER_STORAGE);
                return StateMachineProcedure.Flow.HAS_MORE_STATE;
            }
            case UNREGISTER_PEER_FROM_WORKER_STORAGE: {
                syncReplicationReplayWALManager.unregisterPeer(this.peerId);
                this.setNextState(MasterProcedureProtos.RecoverStandbyState.SNAPSHOT_SYNC_REPLICATION_WALS_DIR);
                return StateMachineProcedure.Flow.HAS_MORE_STATE;
            }
            case SNAPSHOT_SYNC_REPLICATION_WALS_DIR: {
                try {
                    syncReplicationReplayWALManager.renameToPeerSnapshotWALDir(this.peerId);
                }
                catch (IOException e) {
                    LOG.warn("Failed to cleanup replay wals dir for peer id={}, , retry", (Object)this.peerId, (Object)e);
                    throw new ProcedureYieldException();
                }
                return StateMachineProcedure.Flow.NO_MORE_STATE;
            }
        }
        throw new UnsupportedOperationException("unhandled state=" + state);
    }

    private void dispathWals(SyncReplicationReplayWALManager syncReplicationReplayWALManager) throws ProcedureYieldException {
        try {
            List<Path> wals = syncReplicationReplayWALManager.getReplayWALsAndCleanUpUnusedFiles(this.peerId);
            this.addChildProcedure((Procedure[])wals.stream().map(wal -> new SyncReplicationReplayWALProcedure(this.peerId, Arrays.asList(syncReplicationReplayWALManager.removeWALRootPath((Path)wal)))).toArray(SyncReplicationReplayWALProcedure[]::new));
        }
        catch (IOException e) {
            LOG.warn("Failed to get replay wals for peer id={}, , retry", (Object)this.peerId, (Object)e);
            throw new ProcedureYieldException();
        }
    }

    protected MasterProcedureProtos.RecoverStandbyState getState(int stateId) {
        return MasterProcedureProtos.RecoverStandbyState.forNumber((int)stateId);
    }

    protected int getStateId(MasterProcedureProtos.RecoverStandbyState state) {
        return state.getNumber();
    }

    protected MasterProcedureProtos.RecoverStandbyState getInitialState() {
        return MasterProcedureProtos.RecoverStandbyState.RENAME_SYNC_REPLICATION_WALS_DIR;
    }

    @Override
    public PeerProcedureInterface.PeerOperationType getPeerOperationType() {
        return PeerProcedureInterface.PeerOperationType.RECOVER_STANDBY;
    }

    @Override
    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        serializer.serialize((Message)MasterProcedureProtos.RecoverStandbyStateData.newBuilder().setSerial(this.serial).build());
    }

    @Override
    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.RecoverStandbyStateData data = (MasterProcedureProtos.RecoverStandbyStateData)serializer.deserialize(MasterProcedureProtos.RecoverStandbyStateData.class);
        this.serial = data.getSerial();
    }

    protected void afterReplay(MasterProcedureEnv env) {
        switch ((MasterProcedureProtos.RecoverStandbyState)this.getCurrentState()) {
            case DISPATCH_WALS: 
            case UNREGISTER_PEER_FROM_WORKER_STORAGE: {
                env.getMasterServices().getSyncReplicationReplayWALManager().registerPeer(this.peerId);
                break;
            }
        }
    }
}

