/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.replication;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.LongConsumer;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.master.procedure.GlobalProcedureInterface;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.PeerProcedureInterface;
import org.apache.hadoop.hbase.master.replication.DisablePeerProcedure;
import org.apache.hadoop.hbase.master.replication.EnablePeerProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureUtil;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
import org.apache.hadoop.hbase.replication.ZKReplicationQueueStorageForMigration;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hadoop.hbase.util.IdLock;
import org.apache.hadoop.hbase.util.RetryCounter;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MigrateReplicationQueueFromZkToTableProcedure
extends StateMachineProcedure<MasterProcedureEnv, MasterProcedureProtos.MigrateReplicationQueueFromZkToTableState>
implements GlobalProcedureInterface {
    private static final Logger LOG = LoggerFactory.getLogger(MigrateReplicationQueueFromZkToTableProcedure.class);
    private static final int MIN_MAJOR_VERSION = 3;
    private List<String> disabledPeerIds;
    private CompletableFuture<?> future;
    private ExecutorService executor;
    private RetryCounter retryCounter;

    @Override
    public String getGlobalId() {
        return this.getClass().getSimpleName();
    }

    private ProcedureSuspendedException suspend(Configuration conf, LongConsumer backoffConsumer) throws ProcedureSuspendedException {
        if (this.retryCounter == null) {
            this.retryCounter = ProcedureUtil.createRetryCounter((Configuration)conf);
        }
        long backoff = this.retryCounter.getBackoffTimeAndIncrementAttempts();
        backoffConsumer.accept(backoff);
        throw this.suspend(Math.toIntExact(backoff), true);
    }

    private void resetRetry() {
        this.retryCounter = null;
    }

    private ExecutorService getExecutorService() {
        if (this.executor == null) {
            this.executor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat(this.getClass().getSimpleName() + "-%d").setDaemon(true).build());
        }
        return this.executor;
    }

    private void shutdownExecutorService() {
        if (this.executor != null) {
            this.executor.shutdown();
            this.executor = null;
        }
    }

    private void disableReplicationLogCleaner(MasterProcedureEnv env) throws ProcedureSuspendedException {
        if (!env.getReplicationPeerManager().getReplicationLogCleanerBarrier().disable()) {
            throw this.suspend(env.getMasterConfiguration(), backoff -> LOG.info("Can not disable replication log cleaner, sleep {} secs and retry later", (Object)(backoff / 1000L)));
        }
        this.resetRetry();
    }

    private void enableReplicationLogCleaner(MasterProcedureEnv env) {
        env.getReplicationPeerManager().getReplicationLogCleanerBarrier().enable();
    }

    private void waitUntilNoPeerProcedure(MasterProcedureEnv env) throws ProcedureSuspendedException {
        long peerProcCount;
        try {
            peerProcCount = env.getMasterServices().getProcedures().stream().filter(p -> p instanceof PeerProcedureInterface).filter(p -> !p.isFinished()).count();
        }
        catch (IOException e) {
            throw this.suspend(env.getMasterConfiguration(), backoff -> LOG.warn("failed to check peer procedure status, sleep {} secs and retry later", (Object)(backoff / 1000L), (Object)e));
        }
        if (peerProcCount > 0L) {
            throw this.suspend(env.getMasterConfiguration(), backoff -> LOG.info("There are still {} pending peer procedures, sleep {} secs and retry later", (Object)peerProcCount, (Object)(backoff / 1000L)));
        }
        this.resetRetry();
        LOG.info("No pending peer procedures found, continue...");
    }

    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.MigrateReplicationQueueFromZkToTableState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        switch (state) {
            case MIGRATE_REPLICATION_QUEUE_FROM_ZK_TO_TABLE_DISABLE_CLEANER: {
                this.disableReplicationLogCleaner(env);
                this.setNextState(MasterProcedureProtos.MigrateReplicationQueueFromZkToTableState.MIGRATE_REPLICATION_QUEUE_FROM_ZK_TO_TABLE_PREPARE);
                return StateMachineProcedure.Flow.HAS_MORE_STATE;
            }
            case MIGRATE_REPLICATION_QUEUE_FROM_ZK_TO_TABLE_PREPARE: {
                this.waitUntilNoPeerProcedure(env);
                List<ReplicationPeerDescription> peers = env.getReplicationPeerManager().listPeers(null);
                if (peers.isEmpty()) {
                    LOG.info("No active replication peer found, delete old replication queue data and quit");
                    ZKReplicationQueueStorageForMigration oldStorage = new ZKReplicationQueueStorageForMigration(env.getMasterServices().getZooKeeper(), env.getMasterConfiguration());
                    try {
                        oldStorage.deleteAllData();
                    }
                    catch (KeeperException e2) {
                        throw this.suspend(env.getMasterConfiguration(), backoff -> LOG.warn("failed to delete old replication queue data, sleep {} secs and retry later", (Object)(backoff / 1000L), (Object)e2));
                    }
                    this.setNextState(MasterProcedureProtos.MigrateReplicationQueueFromZkToTableState.MIGRATE_REPLICATION_QUEUE_FROM_ZK_TO_TABLE_ENABLE_CLEANER);
                    return StateMachineProcedure.Flow.HAS_MORE_STATE;
                }
                this.disabledPeerIds = peers.stream().filter(ReplicationPeerDescription::isEnabled).map(ReplicationPeerDescription::getPeerId).collect(Collectors.toList());
                this.setNextState(MasterProcedureProtos.MigrateReplicationQueueFromZkToTableState.MIGRATE_REPLICATION_QUEUE_FROM_ZK_TO_TABLE_DISABLE_PEER);
                this.resetRetry();
                return StateMachineProcedure.Flow.HAS_MORE_STATE;
            }
            case MIGRATE_REPLICATION_QUEUE_FROM_ZK_TO_TABLE_DISABLE_PEER: {
                for (String peerId : this.disabledPeerIds) {
                    this.addChildProcedure((Procedure[])new DisablePeerProcedure[]{new DisablePeerProcedure(peerId)});
                }
                this.setNextState(MasterProcedureProtos.MigrateReplicationQueueFromZkToTableState.MIGRATE_REPLICATION_QUEUE_FROM_ZK_TO_TABLE_MIGRATE);
                return StateMachineProcedure.Flow.HAS_MORE_STATE;
            }
            case MIGRATE_REPLICATION_QUEUE_FROM_ZK_TO_TABLE_MIGRATE: {
                if (this.future != null) {
                    assert (this.future.isDone());
                    try {
                        this.future.get();
                    }
                    catch (Exception e3) {
                        this.future = null;
                        throw this.suspend(env.getMasterConfiguration(), backoff -> LOG.warn("failed to migrate queue data, sleep {} secs and retry later", (Object)(backoff / 1000L), (Object)e3));
                    }
                    this.shutdownExecutorService();
                    this.setNextState(MasterProcedureProtos.MigrateReplicationQueueFromZkToTableState.MIGRATE_REPLICATION_QUEUE_FROM_ZK_TO_TABLE_WAIT_UPGRADING);
                    this.resetRetry();
                    return StateMachineProcedure.Flow.HAS_MORE_STATE;
                }
                this.future = env.getReplicationPeerManager().migrateQueuesFromZk(env.getMasterServices().getZooKeeper(), this.getExecutorService());
                FutureUtils.addListener(this.future, (r, e) -> {
                    IdLock.Entry lockEntry;
                    IdLock procLock = env.getMasterServices().getMasterProcedureExecutor().getProcExecutionLock();
                    try {
                        lockEntry = procLock.getLockEntry(this.getProcId());
                    }
                    catch (IOException ioe) {
                        LOG.error("Error while acquiring execution lock for procedure {} when trying to wake it up, aborting...", (Throwable)ioe);
                        env.getMasterServices().abort("Can not acquire procedure execution lock", (Throwable)e);
                        return;
                    }
                    try {
                        this.setTimeoutFailure(env);
                    }
                    finally {
                        procLock.releaseLockEntry(lockEntry);
                    }
                });
                this.setTimeout(-1);
                this.setState(ProcedureProtos.ProcedureState.WAITING_TIMEOUT);
                this.skipPersistence();
                throw new ProcedureSuspendedException();
            }
            case MIGRATE_REPLICATION_QUEUE_FROM_ZK_TO_TABLE_WAIT_UPGRADING: {
                long rsWithLowerVersion = env.getMasterServices().getServerManager().getOnlineServers().values().stream().filter(sm -> VersionInfo.getMajorVersion((String)sm.getVersion()) < 3).count();
                if (rsWithLowerVersion == 0L) {
                    this.setNextState(MasterProcedureProtos.MigrateReplicationQueueFromZkToTableState.MIGRATE_REPLICATION_QUEUE_FROM_ZK_TO_TABLE_ENABLE_PEER);
                    return StateMachineProcedure.Flow.HAS_MORE_STATE;
                }
                throw this.suspend(env.getMasterConfiguration(), backoff -> LOG.warn("There are still {} region servers which have a major version less than {}, sleep {} secs and check later", new Object[]{rsWithLowerVersion, 3, backoff / 1000L}));
            }
            case MIGRATE_REPLICATION_QUEUE_FROM_ZK_TO_TABLE_ENABLE_PEER: {
                for (String peerId : this.disabledPeerIds) {
                    this.addChildProcedure((Procedure[])new EnablePeerProcedure[]{new EnablePeerProcedure(peerId)});
                }
                this.setNextState(MasterProcedureProtos.MigrateReplicationQueueFromZkToTableState.MIGRATE_REPLICATION_QUEUE_FROM_ZK_TO_TABLE_ENABLE_CLEANER);
                return StateMachineProcedure.Flow.HAS_MORE_STATE;
            }
            case MIGRATE_REPLICATION_QUEUE_FROM_ZK_TO_TABLE_ENABLE_CLEANER: {
                this.enableReplicationLogCleaner(env);
                return StateMachineProcedure.Flow.NO_MORE_STATE;
            }
        }
        throw new UnsupportedOperationException("unhandled state=" + state);
    }

    protected synchronized boolean setTimeoutFailure(MasterProcedureEnv env) {
        this.setState(ProcedureProtos.ProcedureState.RUNNABLE);
        env.getProcedureScheduler().addFront((Procedure)this);
        return false;
    }

    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.MigrateReplicationQueueFromZkToTableState state) throws IOException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    protected MasterProcedureProtos.MigrateReplicationQueueFromZkToTableState getState(int stateId) {
        return MasterProcedureProtos.MigrateReplicationQueueFromZkToTableState.forNumber((int)stateId);
    }

    protected int getStateId(MasterProcedureProtos.MigrateReplicationQueueFromZkToTableState state) {
        return state.getNumber();
    }

    protected MasterProcedureProtos.MigrateReplicationQueueFromZkToTableState getInitialState() {
        return MasterProcedureProtos.MigrateReplicationQueueFromZkToTableState.MIGRATE_REPLICATION_QUEUE_FROM_ZK_TO_TABLE_DISABLE_CLEANER;
    }

    protected void afterReplay(MasterProcedureEnv env) {
        if (this.getCurrentState() == this.getInitialState()) {
            return;
        }
        if (!env.getReplicationPeerManager().getReplicationLogCleanerBarrier().disable()) {
            throw new IllegalStateException("can not disable log cleaner, this should not happen");
        }
    }

    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.MigrateReplicationQueueFromZkToTableStateData.Builder builder = MasterProcedureProtos.MigrateReplicationQueueFromZkToTableStateData.newBuilder();
        if (this.disabledPeerIds != null) {
            builder.addAllDisabledPeerId(this.disabledPeerIds);
        }
        serializer.serialize((Message)builder.build());
    }

    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.MigrateReplicationQueueFromZkToTableStateData data = (MasterProcedureProtos.MigrateReplicationQueueFromZkToTableStateData)serializer.deserialize(MasterProcedureProtos.MigrateReplicationQueueFromZkToTableStateData.class);
        this.disabledPeerIds = data.getDisabledPeerIdList().stream().collect(Collectors.toList());
    }
}

