/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.replication;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.ServerProcedureInterface;
import org.apache.hadoop.hbase.master.replication.ClaimReplicationQueueRemoteProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureUtil;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationGroupOffset;
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
import org.apache.hadoop.hbase.replication.ReplicationQueueId;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.util.RetryCounter;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class AssignReplicationQueuesProcedure
extends StateMachineProcedure<MasterProcedureEnv, MasterProcedureProtos.AssignReplicationQueuesState>
implements ServerProcedureInterface {
    private static final Logger LOG = LoggerFactory.getLogger(AssignReplicationQueuesProcedure.class);
    private ServerName crashedServer;
    private RetryCounter retryCounter;

    public AssignReplicationQueuesProcedure() {
    }

    public AssignReplicationQueuesProcedure(ServerName crashedServer) {
        this.crashedServer = crashedServer;
    }

    @Override
    public ServerName getServerName() {
        return this.crashedServer;
    }

    @Override
    public boolean hasMetaTableRegion() {
        return false;
    }

    @Override
    public ServerProcedureInterface.ServerOperationType getServerOperationType() {
        return ServerProcedureInterface.ServerOperationType.CLAIM_REPLICATION_QUEUES;
    }

    private void addMissingQueues(MasterProcedureEnv env) throws ReplicationException {
        ReplicationQueueStorage storage = env.getReplicationPeerManager().getQueueStorage();
        HashSet<String> existingQueuePeerIds = new HashSet<String>();
        List queueIds = storage.listAllQueueIds(this.crashedServer);
        for (ReplicationQueueId queueId : queueIds) {
            if (queueId.isRecovered()) continue;
            existingQueuePeerIds.add(queueId.getPeerId());
        }
        List<ReplicationPeerDescription> peers = env.getReplicationPeerManager().listPeers(null);
        for (ReplicationPeerDescription peer : peers) {
            if (existingQueuePeerIds.contains(peer.getPeerId())) continue;
            ReplicationQueueId queueId = new ReplicationQueueId(this.crashedServer, peer.getPeerId());
            LOG.debug("Add replication queue {} for claiming", (Object)queueId);
            env.getReplicationPeerManager().getQueueStorage().setOffset(queueId, this.crashedServer.toString(), ReplicationGroupOffset.BEGIN, Collections.emptyMap());
        }
    }

    private StateMachineProcedure.Flow claimQueues(MasterProcedureEnv env) throws ReplicationException, IOException {
        Set existingPeerIds = env.getReplicationPeerManager().listPeers(null).stream().map(ReplicationPeerDescription::getPeerId).collect(Collectors.toSet());
        ReplicationQueueStorage storage = env.getReplicationPeerManager().getQueueStorage();
        List queueIds = storage.listAllQueueIds(this.crashedServer).stream().filter(q -> existingPeerIds.contains(q.getPeerId())).collect(Collectors.toList());
        if (queueIds.isEmpty()) {
            LOG.debug("Finish claiming replication queues for {}", (Object)this.crashedServer);
            return StateMachineProcedure.Flow.NO_MORE_STATE;
        }
        LOG.debug("There are {} replication queues need to be claimed for {}", (Object)queueIds.size(), (Object)this.crashedServer);
        List<ServerName> targetServers = env.getMasterServices().getServerManager().getOnlineServersList();
        if (targetServers.isEmpty()) {
            throw new ReplicationException("no region server available");
        }
        Collections.shuffle(targetServers);
        int n = Math.min(queueIds.size(), targetServers.size());
        for (int i = 0; i < n; ++i) {
            this.addChildProcedure(new ClaimReplicationQueueRemoteProcedure[]{new ClaimReplicationQueueRemoteProcedure((ReplicationQueueId)queueIds.get(i), targetServers.get(i))});
        }
        this.retryCounter = null;
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    private boolean shouldSkip(MasterProcedureEnv env) throws IOException {
        MasterFileSystem mfs = env.getMasterFileSystem();
        Path syncUpDir = new Path(mfs.getRootDir(), "ReplicationSyncUp");
        return mfs.getFileSystem().exists(new Path(syncUpDir, this.crashedServer.getServerName()));
    }

    private void removeQueues(MasterProcedureEnv env) throws ReplicationException, IOException {
        ReplicationQueueStorage storage = env.getReplicationPeerManager().getQueueStorage();
        for (ReplicationQueueId queueId : storage.listAllQueueIds(this.crashedServer)) {
            storage.removeQueue(queueId);
        }
        MasterFileSystem mfs = env.getMasterFileSystem();
        Path syncUpDir = new Path(mfs.getRootDir(), "ReplicationSyncUp");
        mfs.getFileSystem().delete(new Path(syncUpDir, this.crashedServer.getServerName()), false);
    }

    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.AssignReplicationQueuesState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        try {
            switch (state) {
                case ASSIGN_REPLICATION_QUEUES_ADD_MISSING_QUEUES: {
                    if (this.shouldSkip(env)) {
                        this.setNextState(MasterProcedureProtos.AssignReplicationQueuesState.ASSIGN_REPLICATION_QUEUES_REMOVE_QUEUES);
                        return StateMachineProcedure.Flow.HAS_MORE_STATE;
                    }
                    this.addMissingQueues(env);
                    this.retryCounter = null;
                    this.setNextState(MasterProcedureProtos.AssignReplicationQueuesState.ASSIGN_REPLICATION_QUEUES_CLAIM);
                    return StateMachineProcedure.Flow.HAS_MORE_STATE;
                }
                case ASSIGN_REPLICATION_QUEUES_CLAIM: {
                    if (this.shouldSkip(env)) {
                        this.retryCounter = null;
                        this.setNextState(MasterProcedureProtos.AssignReplicationQueuesState.ASSIGN_REPLICATION_QUEUES_REMOVE_QUEUES);
                        return StateMachineProcedure.Flow.HAS_MORE_STATE;
                    }
                    return this.claimQueues(env);
                }
                case ASSIGN_REPLICATION_QUEUES_REMOVE_QUEUES: {
                    this.removeQueues(env);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
            }
            throw new UnsupportedOperationException("unhandled state=" + state);
        }
        catch (Exception e) {
            if (this.retryCounter == null) {
                this.retryCounter = ProcedureUtil.createRetryCounter((Configuration)env.getMasterConfiguration());
            }
            long backoff = this.retryCounter.getBackoffTimeAndIncrementAttempts();
            LOG.warn("Failed to claim replication queues for {}, suspend {}secs {}; {};", new Object[]{this.crashedServer, backoff / 1000L, e});
            this.setTimeout(Math.toIntExact(backoff));
            this.setState(ProcedureProtos.ProcedureState.WAITING_TIMEOUT);
            this.skipPersistence();
            throw new ProcedureSuspendedException();
        }
    }

    protected synchronized boolean setTimeoutFailure(MasterProcedureEnv env) {
        this.setState(ProcedureProtos.ProcedureState.RUNNABLE);
        env.getProcedureScheduler().addFront((Procedure)this);
        return false;
    }

    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.AssignReplicationQueuesState state) throws IOException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    protected MasterProcedureProtos.AssignReplicationQueuesState getState(int stateId) {
        return MasterProcedureProtos.AssignReplicationQueuesState.forNumber((int)stateId);
    }

    protected int getStateId(MasterProcedureProtos.AssignReplicationQueuesState state) {
        return state.getNumber();
    }

    protected MasterProcedureProtos.AssignReplicationQueuesState getInitialState() {
        return MasterProcedureProtos.AssignReplicationQueuesState.ASSIGN_REPLICATION_QUEUES_ADD_MISSING_QUEUES;
    }

    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        serializer.serialize((Message)MasterProcedureProtos.AssignReplicationQueuesStateData.newBuilder().setCrashedServer(ProtobufUtil.toServerName((ServerName)this.crashedServer)).build());
    }

    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.AssignReplicationQueuesStateData proto = (MasterProcedureProtos.AssignReplicationQueuesStateData)serializer.deserialize(MasterProcedureProtos.AssignReplicationQueuesStateData.class);
        this.crashedServer = ProtobufUtil.toServerName((HBaseProtos.ServerName)proto.getCrashedServer());
    }
}

