/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NamespaceExistException;
import org.apache.hadoop.hbase.master.procedure.AbstractStateMachineNamespaceProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.ProcedurePrepareLatch;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class CreateNamespaceProcedure
extends AbstractStateMachineNamespaceProcedure<MasterProcedureProtos.CreateNamespaceState> {
    private static final Logger LOG = LoggerFactory.getLogger(CreateNamespaceProcedure.class);
    private NamespaceDescriptor nsDescriptor;

    public CreateNamespaceProcedure() {
    }

    public CreateNamespaceProcedure(MasterProcedureEnv env, NamespaceDescriptor nsDescriptor) {
        this(env, nsDescriptor, null);
    }

    public CreateNamespaceProcedure(MasterProcedureEnv env, NamespaceDescriptor nsDescriptor, ProcedurePrepareLatch latch) {
        super(env, latch);
        this.nsDescriptor = nsDescriptor;
    }

    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.CreateNamespaceState state) throws InterruptedException {
        LOG.trace("{} execute state={}", (Object)this, (Object)state);
        try {
            switch (state) {
                case CREATE_NAMESPACE_PREPARE: {
                    boolean success = this.prepareCreate(env);
                    this.releaseSyncLatch();
                    if (!success) {
                        assert (this.isFailed()) : "createNamespace should have an exception here";
                        return StateMachineProcedure.Flow.NO_MORE_STATE;
                    }
                    this.setNextState(MasterProcedureProtos.CreateNamespaceState.CREATE_NAMESPACE_CREATE_DIRECTORY);
                    break;
                }
                case CREATE_NAMESPACE_CREATE_DIRECTORY: {
                    CreateNamespaceProcedure.createDirectory(env, this.nsDescriptor);
                    this.setNextState(MasterProcedureProtos.CreateNamespaceState.CREATE_NAMESPACE_INSERT_INTO_NS_TABLE);
                    break;
                }
                case CREATE_NAMESPACE_INSERT_INTO_NS_TABLE: {
                    CreateNamespaceProcedure.addOrUpdateNamespace(env, this.nsDescriptor);
                    this.setNextState(MasterProcedureProtos.CreateNamespaceState.CREATE_NAMESPACE_SET_NAMESPACE_QUOTA);
                    break;
                }
                case CREATE_NAMESPACE_UPDATE_ZK: {
                    this.setNextState(MasterProcedureProtos.CreateNamespaceState.CREATE_NAMESPACE_SET_NAMESPACE_QUOTA);
                    break;
                }
                case CREATE_NAMESPACE_SET_NAMESPACE_QUOTA: {
                    CreateNamespaceProcedure.setNamespaceQuota(env, this.nsDescriptor);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException(this + " unhandled state=" + state);
                }
            }
        }
        catch (IOException e) {
            if (this.isRollbackSupported(state)) {
                this.setFailure("master-create-namespace", e);
            }
            LOG.warn("Retriable error trying to create namespace=" + this.nsDescriptor.getName() + " (in state=" + state + ")", (Throwable)e);
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.CreateNamespaceState state) throws IOException {
        if (state == MasterProcedureProtos.CreateNamespaceState.CREATE_NAMESPACE_PREPARE) {
            this.releaseSyncLatch();
            return;
        }
        throw new UnsupportedOperationException("unhandled state=" + state);
    }

    protected boolean isRollbackSupported(MasterProcedureProtos.CreateNamespaceState state) {
        switch (state) {
            case CREATE_NAMESPACE_PREPARE: {
                return true;
            }
        }
        return false;
    }

    protected MasterProcedureProtos.CreateNamespaceState getState(int stateId) {
        return MasterProcedureProtos.CreateNamespaceState.forNumber((int)stateId);
    }

    protected int getStateId(MasterProcedureProtos.CreateNamespaceState state) {
        return state.getNumber();
    }

    protected MasterProcedureProtos.CreateNamespaceState getInitialState() {
        return MasterProcedureProtos.CreateNamespaceState.CREATE_NAMESPACE_PREPARE;
    }

    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.CreateNamespaceStateData.Builder createNamespaceMsg = MasterProcedureProtos.CreateNamespaceStateData.newBuilder().setNamespaceDescriptor(ProtobufUtil.toProtoNamespaceDescriptor((NamespaceDescriptor)this.nsDescriptor));
        serializer.serialize((Message)createNamespaceMsg.build());
    }

    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.CreateNamespaceStateData createNamespaceMsg = (MasterProcedureProtos.CreateNamespaceStateData)serializer.deserialize(MasterProcedureProtos.CreateNamespaceStateData.class);
        this.nsDescriptor = ProtobufUtil.toNamespaceDescriptor((HBaseProtos.NamespaceDescriptor)createNamespaceMsg.getNamespaceDescriptor());
    }

    @Override
    protected boolean waitInitialized(MasterProcedureEnv env) {
        return env.waitInitialized((Procedure<?>)this);
    }

    @Override
    protected Procedure.LockState acquireLock(MasterProcedureEnv env) {
        if (env.getProcedureScheduler().waitNamespaceExclusiveLock((Procedure<?>)this, this.getNamespaceName())) {
            return Procedure.LockState.LOCK_EVENT_WAIT;
        }
        return Procedure.LockState.LOCK_ACQUIRED;
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.EDIT;
    }

    @Override
    protected String getNamespaceName() {
        return this.nsDescriptor.getName();
    }

    private boolean prepareCreate(MasterProcedureEnv env) throws IOException {
        if (CreateNamespaceProcedure.getTableNamespaceManager(env).doesNamespaceExist(this.nsDescriptor.getName())) {
            this.setFailure("master-create-namespace", (Throwable)new NamespaceExistException("Namespace " + this.nsDescriptor.getName() + " already exists"));
            return false;
        }
        CreateNamespaceProcedure.getTableNamespaceManager(env).validateTableAndRegionCount(this.nsDescriptor);
        this.checkNamespaceRSGroup(env, this.nsDescriptor);
        return true;
    }

    private static void setNamespaceQuota(MasterProcedureEnv env, NamespaceDescriptor nsDescriptor) throws IOException {
        if (env.getMasterServices().isInitialized()) {
            env.getMasterServices().getMasterQuotaManager().setNamespaceQuota(nsDescriptor);
        }
    }
}

