/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import com.google.errorprone.annotations.RestrictedApi;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.BalancerDecision;
import org.apache.hadoop.hbase.client.BalancerRejection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.balancer.ClusterInfoProvider;
import org.apache.hadoop.hbase.namequeues.BalancerDecisionDetails;
import org.apache.hadoop.hbase.namequeues.BalancerRejectionDetails;
import org.apache.hadoop.hbase.namequeues.NamedQueueRecorder;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.compactions.OffPeakHours;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MasterClusterInfoProvider
implements ClusterInfoProvider {
    private final MasterServices services;
    private boolean isBalancerDecisionRecording;
    private boolean isBalancerRejectionRecording;
    private NamedQueueRecorder namedQueueRecorder;
    private OffPeakHours offPeakHours;

    private void loadConf(Configuration conf) {
        this.offPeakHours = OffPeakHours.getInstance(conf);
        this.isBalancerDecisionRecording = conf.getBoolean("hbase.master.balancer.decision.buffer.enabled", false);
        this.isBalancerRejectionRecording = conf.getBoolean("hbase.master.balancer.rejection.buffer.enabled", false);
        this.namedQueueRecorder = this.isBalancerDecisionRecording || this.isBalancerRejectionRecording ? NamedQueueRecorder.getInstance(conf) : null;
    }

    public MasterClusterInfoProvider(MasterServices services) {
        this.services = services;
        this.loadConf(services.getConfiguration());
    }

    public Configuration getConfiguration() {
        return this.services.getConfiguration();
    }

    public Connection getConnection() {
        return this.services.getConnection();
    }

    public List<RegionInfo> getAssignedRegions() {
        AssignmentManager am = this.services.getAssignmentManager();
        return am != null ? am.getAssignedRegions() : Collections.emptyList();
    }

    public void unassign(RegionInfo regionInfo) throws IOException {
        AssignmentManager am = this.services.getAssignmentManager();
        if (am != null) {
            am.unassign(regionInfo);
        }
    }

    public TableDescriptor getTableDescriptor(TableName tableName) throws IOException {
        TableDescriptors tds = this.services.getTableDescriptors();
        return tds != null ? tds.get(tableName) : null;
    }

    public HDFSBlocksDistribution computeHDFSBlocksDistribution(Configuration conf, TableDescriptor tableDescriptor, RegionInfo regionInfo) throws IOException {
        return HRegion.computeHDFSBlocksDistribution(conf, tableDescriptor, regionInfo);
    }

    public boolean hasRegionReplica(Collection<RegionInfo> regions) throws IOException {
        TableDescriptors tds = this.services.getTableDescriptors();
        if (tds == null) {
            return false;
        }
        for (RegionInfo region : regions) {
            TableDescriptor td = tds.get(region.getTable());
            if (td == null || td.getRegionReplication() <= 1) continue;
            return true;
        }
        return false;
    }

    public List<ServerName> getOnlineServersList() {
        ServerManager sm = this.services.getServerManager();
        return sm != null ? sm.getOnlineServersList() : Collections.emptyList();
    }

    public List<ServerName> getOnlineServersListWithPredicator(List<ServerName> servers, Predicate<ServerMetrics> filter) {
        ServerManager sm = this.services.getServerManager();
        return sm != null ? sm.getOnlineServersListWithPredicator(servers, filter) : Collections.emptyList();
    }

    public Map<ServerName, List<RegionInfo>> getSnapShotOfAssignment(Collection<RegionInfo> regions) {
        AssignmentManager am = this.services.getAssignmentManager();
        return am != null ? am.getSnapShotOfAssignment(regions) : Collections.emptyMap();
    }

    public int getNumberOfTables() throws IOException {
        return this.services.getTableDescriptors().getAll().size();
    }

    public boolean isOffPeakHour() {
        return this.offPeakHours.isOffPeakHour();
    }

    public void onConfigurationChange(Configuration conf) {
        this.loadConf(conf);
    }

    public void recordBalancerDecision(Supplier<BalancerDecision> decision) {
        if (this.isBalancerDecisionRecording) {
            this.namedQueueRecorder.addRecord(new BalancerDecisionDetails(decision.get()));
        }
    }

    public void recordBalancerRejection(Supplier<BalancerRejection> rejection) {
        if (this.isBalancerRejectionRecording) {
            this.namedQueueRecorder.addRecord(new BalancerRejectionDetails(rejection.get()));
        }
    }

    public ServerMetrics getLoad(ServerName serverName) {
        ServerManager sm = this.services.getServerManager();
        return sm != null ? sm.getLoad(serverName) : null;
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*/src/test/.*")
    NamedQueueRecorder getNamedQueueRecorder() {
        return this.namedQueueRecorder;
    }
}

