/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ClockOutOfSyncException;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerMetricsBuilder;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.YouAreDeadException;
import org.apache.hadoop.hbase.client.AsyncClusterConnection;
import org.apache.hadoop.hbase.client.AsyncRegionServerAdmin;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.ipc.RemoteWithExtrasException;
import org.apache.hadoop.hbase.master.DeadServer;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionServerList;
import org.apache.hadoop.hbase.master.ServerListener;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.master.procedure.ServerCrashProcedure;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.ConcurrentMapUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ServerManager {
    public static final String WAIT_ON_REGIONSERVERS_MAXTOSTART = "hbase.master.wait.on.regionservers.maxtostart";
    public static final String WAIT_ON_REGIONSERVERS_MINTOSTART = "hbase.master.wait.on.regionservers.mintostart";
    public static final String WAIT_ON_REGIONSERVERS_TIMEOUT = "hbase.master.wait.on.regionservers.timeout";
    public static final String WAIT_ON_REGIONSERVERS_INTERVAL = "hbase.master.wait.on.regionservers.interval";
    public static final String PERSIST_FLUSHEDSEQUENCEID = "hbase.master.persist.flushedsequenceid.enabled";
    public static final boolean PERSIST_FLUSHEDSEQUENCEID_DEFAULT = true;
    public static final String FLUSHEDSEQUENCEID_FLUSHER_INTERVAL = "hbase.master.flushedsequenceid.flusher.interval";
    public static final int FLUSHEDSEQUENCEID_FLUSHER_INTERVAL_DEFAULT = 10800000;
    public static final String MAX_CLOCK_SKEW_MS = "hbase.master.maxclockskew";
    private static final Logger LOG = LoggerFactory.getLogger(ServerManager.class);
    private AtomicBoolean clusterShutdown = new AtomicBoolean(false);
    private final ConcurrentNavigableMap<byte[], Long> flushedSequenceIdByRegion = new ConcurrentSkipListMap<byte[], Long>(Bytes.BYTES_COMPARATOR);
    private boolean persistFlushedSequenceId = true;
    private volatile boolean isFlushSeqIdPersistInProgress = false;
    private static final String LAST_FLUSHED_SEQ_ID_FILE = ".lastflushedseqids";
    private FlushedSequenceIdFlusher flushedSeqIdFlusher;
    private final ConcurrentNavigableMap<byte[], ConcurrentNavigableMap<byte[], Long>> storeFlushedSequenceIdsByRegion = new ConcurrentSkipListMap<byte[], ConcurrentNavigableMap<byte[], Long>>(Bytes.BYTES_COMPARATOR);
    private final ConcurrentNavigableMap<ServerName, ServerMetrics> onlineServers = new ConcurrentSkipListMap<ServerName, ServerMetrics>();
    private final ArrayList<ServerName> drainingServers = new ArrayList();
    private final MasterServices master;
    private final RegionServerList storage;
    private final DeadServer deadservers = new DeadServer();
    private final long maxSkew;
    private final long warningSkew;
    private List<ServerListener> listeners = new CopyOnWriteArrayList<ServerListener>();

    public ServerManager(MasterServices master, RegionServerList storage) {
        this.master = master;
        this.storage = storage;
        Configuration c = master.getConfiguration();
        this.maxSkew = c.getLong(MAX_CLOCK_SKEW_MS, 30000L);
        this.warningSkew = c.getLong("hbase.master.warningclockskew", 10000L);
        this.persistFlushedSequenceId = c.getBoolean(PERSIST_FLUSHEDSEQUENCEID, true);
    }

    public void registerListener(ServerListener listener) {
        this.listeners.add(listener);
    }

    public boolean unregisterListener(ServerListener listener) {
        return this.listeners.remove(listener);
    }

    ServerName regionServerStartup(RegionServerStatusProtos.RegionServerStartupRequest request, int versionNumber, String version, InetAddress ia) throws IOException {
        boolean useIp = this.master.getConfiguration().getBoolean("hbase.server.useip.enabled", false);
        String isaHostName = useIp ? ia.getHostAddress() : ia.getHostName();
        String hostname = request.hasUseThisHostnameInstead() ? request.getUseThisHostnameInstead() : isaHostName;
        ServerName sn = ServerName.valueOf((String)hostname, (int)request.getPort(), (long)request.getServerStartCode());
        this.checkClockSkew(sn, request.getServerCurrentTime());
        this.checkIsDead(sn, "STARTUP");
        if (!this.checkAndRecordNewServer(sn, ServerMetricsBuilder.of((ServerName)sn, (int)versionNumber, (String)version))) {
            LOG.warn("THIS SHOULD NOT HAPPEN, RegionServerStartup could not record the server: " + sn);
        }
        this.storage.started(sn);
        return sn;
    }

    private void updateLastFlushedSequenceIds(ServerName sn, ServerMetrics hsl) {
        for (Map.Entry entry : hsl.getRegionMetrics().entrySet()) {
            byte[] encodedRegionName = Bytes.toBytes((String)RegionInfo.encodeRegionName((byte[])((byte[])entry.getKey())));
            Long existingValue = (Long)this.flushedSequenceIdByRegion.get(encodedRegionName);
            long l = ((RegionMetrics)entry.getValue()).getCompletedSequenceId();
            if (LOG.isTraceEnabled()) {
                LOG.trace(Bytes.toString((byte[])encodedRegionName) + ", existingValue=" + existingValue + ", completeSequenceId=" + l);
            }
            if (existingValue == null || l != -1L && l > existingValue) {
                this.flushedSequenceIdByRegion.put(encodedRegionName, l);
            } else if (l != -1L && l < existingValue) {
                LOG.warn("RegionServer " + sn + " indicates a last flushed sequence id (" + l + ") that is less than the previous last flushed sequence id (" + existingValue + ") for region " + Bytes.toString((byte[])((byte[])entry.getKey())) + " Ignoring.");
            }
            ConcurrentNavigableMap storeFlushedSequenceId = (ConcurrentNavigableMap)ConcurrentMapUtils.computeIfAbsent(this.storeFlushedSequenceIdsByRegion, (Object)encodedRegionName, () -> new ConcurrentSkipListMap(Bytes.BYTES_COMPARATOR));
            for (Map.Entry storeSeqId : ((RegionMetrics)entry.getValue()).getStoreSequenceId().entrySet()) {
                byte[] family = (byte[])storeSeqId.getKey();
                existingValue = (Long)storeFlushedSequenceId.get(family);
                l = (Long)storeSeqId.getValue();
                if (LOG.isTraceEnabled()) {
                    LOG.trace(Bytes.toString((byte[])encodedRegionName) + ", family=" + Bytes.toString((byte[])family) + ", existingValue=" + existingValue + ", completeSequenceId=" + l);
                }
                if (existingValue != null && (l == -1L || l <= existingValue)) continue;
                storeFlushedSequenceId.put(family, l);
            }
        }
    }

    public void regionServerReport(ServerName sn, ServerMetrics sl) throws YouAreDeadException {
        this.checkIsDead(sn, "REPORT");
        if (null == this.onlineServers.replace(sn, sl) && !this.checkAndRecordNewServer(sn, sl)) {
            LOG.info("RegionServerReport ignored, could not record the server: " + sn);
            return;
        }
        this.updateLastFlushedSequenceIds(sn, sl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkAndRecordNewServer(ServerName serverName, ServerMetrics sl) {
        ServerName existingServer = null;
        ConcurrentNavigableMap<ServerName, ServerMetrics> concurrentNavigableMap = this.onlineServers;
        synchronized (concurrentNavigableMap) {
            existingServer = this.findServerWithSameHostnamePortWithLock(serverName);
            if (existingServer != null && existingServer.getStartcode() > serverName.getStartcode()) {
                LOG.info("Server serverName=" + serverName + " rejected; we already have " + existingServer.toString() + " registered with same hostname and port");
                return false;
            }
            this.recordNewServerWithLock(serverName, sl);
        }
        if (!this.listeners.isEmpty()) {
            for (ServerListener listener : this.listeners) {
                listener.serverAdded(serverName);
            }
        }
        if (existingServer != null && existingServer.getStartcode() < serverName.getStartcode()) {
            LOG.info("Triggering server recovery; existingServer " + existingServer + " looks stale, new server:" + serverName);
            this.expireServer(existingServer);
        }
        return true;
    }

    void findDeadServersAndProcess(Set<ServerName> deadServersFromPE, Set<ServerName> liveServersFromWALDir) {
        deadServersFromPE.forEach(this.deadservers::putIfAbsent);
        liveServersFromWALDir.stream().filter(sn -> !this.onlineServers.containsKey(sn)).forEach(this::expireServer);
    }

    private void checkClockSkew(ServerName serverName, long serverCurrentTime) throws ClockOutOfSyncException {
        long skew = Math.abs(EnvironmentEdgeManager.currentTime() - serverCurrentTime);
        if (skew > this.maxSkew) {
            String message = "Server " + serverName + " has been rejected; Reported time is too far out of sync with master.  Time difference of " + skew + "ms > max allowed of " + this.maxSkew + "ms";
            LOG.warn(message);
            throw new ClockOutOfSyncException(message);
        }
        if (skew > this.warningSkew) {
            String message = "Reported time for server " + serverName + " is out of sync with master by " + skew + "ms. (Warning threshold is " + this.warningSkew + "ms; error threshold is " + this.maxSkew + "ms)";
            LOG.warn(message);
        }
    }

    private void checkIsDead(ServerName serverName, String what) throws YouAreDeadException {
        if (this.deadservers.isDeadServer(serverName)) {
            String message = "Server " + what + " rejected; currently processing " + serverName + " as dead server";
            LOG.debug(message);
            throw new YouAreDeadException(message);
        }
        if ((this.master == null || this.master.isInitialized()) && this.deadservers.cleanPreviousInstance(serverName)) {
            LOG.debug("{} {} came back up, removed it from the dead servers list", (Object)what, (Object)serverName);
        }
    }

    public ServerName findServerWithSameHostnamePortWithLock(ServerName serverName) {
        ServerName end = ServerName.valueOf((String)serverName.getHostname(), (int)serverName.getPort(), (long)Long.MAX_VALUE);
        ServerName r = this.onlineServers.lowerKey(end);
        if (r != null && ServerName.isSameAddress((ServerName)r, (ServerName)serverName)) {
            return r;
        }
        return null;
    }

    void recordNewServerWithLock(ServerName serverName, ServerMetrics sl) {
        LOG.info("Registering regionserver=" + serverName);
        this.onlineServers.put(serverName, sl);
    }

    public ConcurrentNavigableMap<byte[], Long> getFlushedSequenceIdByRegion() {
        return this.flushedSequenceIdByRegion;
    }

    public ClusterStatusProtos.RegionStoreSequenceIds getLastFlushedSequenceId(byte[] encodedRegionName) {
        ClusterStatusProtos.RegionStoreSequenceIds.Builder builder = ClusterStatusProtos.RegionStoreSequenceIds.newBuilder();
        Long seqId = (Long)this.flushedSequenceIdByRegion.get(encodedRegionName);
        builder.setLastFlushedSequenceId(seqId != null ? seqId : -1L);
        Map storeFlushedSequenceId = (Map)this.storeFlushedSequenceIdsByRegion.get(encodedRegionName);
        if (storeFlushedSequenceId != null) {
            for (Map.Entry entry : storeFlushedSequenceId.entrySet()) {
                builder.addStoreSequenceId(ClusterStatusProtos.StoreSequenceId.newBuilder().setFamilyName(UnsafeByteOperations.unsafeWrap((byte[])((byte[])entry.getKey()))).setSequenceId(((Long)entry.getValue()).longValue()).build());
            }
        }
        return builder.build();
    }

    public ServerMetrics getLoad(ServerName serverName) {
        return (ServerMetrics)this.onlineServers.get(serverName);
    }

    public double getAverageLoad() {
        int totalLoad = 0;
        int numServers = 0;
        for (ServerMetrics sl : this.onlineServers.values()) {
            ++numServers;
            totalLoad += sl.getRegionMetrics().size();
        }
        return numServers == 0 ? 0.0 : (double)totalLoad / (double)numServers;
    }

    public int countOfRegionServers() {
        return this.onlineServers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<ServerName, ServerMetrics> getOnlineServers() {
        ConcurrentNavigableMap<ServerName, ServerMetrics> concurrentNavigableMap = this.onlineServers;
        synchronized (concurrentNavigableMap) {
            return Collections.unmodifiableMap(this.onlineServers);
        }
    }

    public DeadServer getDeadServers() {
        return this.deadservers;
    }

    public boolean areDeadServersInProgress() throws IOException {
        return this.master.getProcedures().stream().anyMatch(p -> !p.isFinished() && p instanceof ServerCrashProcedure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void letRegionServersShutdown() {
        int onlineServersCt;
        long previousLogTime = 0L;
        ServerName sn = this.master.getServerName();
        ZKWatcher zkw = this.master.getZooKeeper();
        while ((onlineServersCt = this.onlineServers.size()) > 0) {
            block17: {
                if (EnvironmentEdgeManager.currentTime() > previousLogTime + 1000L) {
                    Set remainingServers = this.onlineServers.keySet();
                    ConcurrentNavigableMap<ServerName, ServerMetrics> concurrentNavigableMap = this.onlineServers;
                    synchronized (concurrentNavigableMap) {
                        if (remainingServers.size() == 1 && remainingServers.contains(sn)) {
                            return;
                        }
                    }
                    StringBuilder sb = new StringBuilder();
                    for (ServerName key : remainingServers) {
                        if (sb.length() > 0) {
                            sb.append(", ");
                        }
                        sb.append(key);
                    }
                    LOG.info("Waiting on regionserver(s) " + sb.toString());
                    previousLogTime = EnvironmentEdgeManager.currentTime();
                }
                try {
                    List<String> servers = this.getRegionServersInZK(zkw);
                    if (servers == null || servers.isEmpty() || servers.size() == 1 && servers.contains(sn.toString())) {
                        LOG.info("ZK shows there is only the master self online, exiting now");
                    }
                    break block17;
                }
                catch (KeeperException ke) {
                    LOG.warn("Failed to list regionservers", (Throwable)ke);
                }
                break;
            }
            ConcurrentNavigableMap<ServerName, ServerMetrics> concurrentNavigableMap = this.onlineServers;
            synchronized (concurrentNavigableMap) {
                try {
                    if (onlineServersCt == this.onlineServers.size()) {
                        this.onlineServers.wait(100L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private List<String> getRegionServersInZK(ZKWatcher zkw) throws KeeperException {
        return ZKUtil.listChildrenNoWatch((ZKWatcher)zkw, (String)zkw.getZNodePaths().rsZNode);
    }

    public synchronized long expireServer(ServerName serverName) {
        return this.expireServer(serverName, false);
    }

    synchronized long expireServer(ServerName serverName, boolean force) {
        if (serverName.equals((Object)this.master.getServerName())) {
            if (!this.master.isAborted() && !this.master.isStopped()) {
                this.master.stop("We lost our znode?");
            }
            return -1L;
        }
        if (this.deadservers.isDeadServer(serverName)) {
            LOG.warn("Expiration called on {} but already in DeadServer", (Object)serverName);
            return -1L;
        }
        this.moveFromOnlineToDeadServers(serverName);
        if (this.master.getZooKeeper() != null) {
            String drainingZnode = ZNodePaths.joinZNode((String)this.master.getZooKeeper().getZNodePaths().drainingZNode, (String[])new String[]{serverName.getServerName()});
            try {
                ZKUtil.deleteNodeFailSilent((ZKWatcher)this.master.getZooKeeper(), (String)drainingZnode);
            }
            catch (KeeperException e) {
                LOG.warn("Error deleting the draining znode for stopping server " + serverName.getServerName(), (Throwable)e);
            }
        }
        if (this.isClusterShutdown()) {
            LOG.info("Cluster shutdown set; " + serverName + " expired; onlineServers=" + this.onlineServers.size());
            if (this.onlineServers.isEmpty()) {
                this.master.stop("Cluster shutdown set; onlineServer=0");
            }
            return -1L;
        }
        LOG.info("Processing expiration of " + serverName + " on " + this.master.getServerName());
        long pid = this.master.getAssignmentManager().submitServerCrash(serverName, true, force);
        this.storage.expired(serverName);
        if (!this.listeners.isEmpty()) {
            this.listeners.stream().forEach(l -> l.serverRemoved(serverName));
        }
        if (this.flushedSeqIdFlusher != null) {
            this.flushedSeqIdFlusher.triggerNow();
        }
        return pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void moveFromOnlineToDeadServers(ServerName sn) {
        ConcurrentNavigableMap<ServerName, ServerMetrics> concurrentNavigableMap = this.onlineServers;
        synchronized (concurrentNavigableMap) {
            boolean online = this.onlineServers.containsKey(sn);
            if (online) {
                this.deadservers.putIfAbsent(sn);
                this.onlineServers.remove(sn);
                this.onlineServers.notifyAll();
            } else {
                LOG.trace("Expiration of {} but server not online", (Object)sn);
            }
        }
    }

    public synchronized boolean removeServerFromDrainList(ServerName sn) {
        if (!this.isServerOnline(sn)) {
            LOG.warn("Server " + sn + " is not currently online. Removing from draining list anyway, as requested.");
        }
        return this.drainingServers.remove(sn);
    }

    public synchronized boolean addServerToDrainList(ServerName sn) {
        if (!this.isServerOnline(sn)) {
            LOG.warn("Server " + sn + " is not currently online. Ignoring request to add it to draining list.");
            return false;
        }
        if (this.drainingServers.contains(sn)) {
            LOG.warn("Server " + sn + " is already in the draining server list.Ignoring request to add it again.");
            return true;
        }
        LOG.info("Server " + sn + " added to draining server list.");
        return this.drainingServers.add(sn);
    }

    public static void closeRegionSilentlyAndWait(AsyncClusterConnection connection, ServerName server, RegionInfo region, long timeout) throws IOException, InterruptedException {
        AsyncRegionServerAdmin admin = connection.getRegionServerAdmin(server);
        try {
            FutureUtils.get(admin.closeRegion(ProtobufUtil.buildCloseRegionRequest((ServerName)server, (byte[])region.getRegionName())));
        }
        catch (IOException e) {
            LOG.warn("Exception when closing region: " + region.getRegionNameAsString(), (Throwable)e);
        }
        if (timeout < 0L) {
            return;
        }
        long expiration = timeout + EnvironmentEdgeManager.currentTime();
        while (EnvironmentEdgeManager.currentTime() < expiration) {
            try {
                RegionInfo rsRegion = ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)((AdminProtos.GetRegionInfoResponse)FutureUtils.get(admin.getRegionInfo(RequestConverter.buildGetRegionInfoRequest((byte[])region.getRegionName())))).getRegionInfo());
                if (rsRegion == null) {
                    return;
                }
            }
            catch (IOException ioe) {
                if (ioe instanceof NotServingRegionException || ioe instanceof RemoteWithExtrasException && ((RemoteWithExtrasException)ioe).unwrapRemoteException() instanceof NotServingRegionException) {
                    return;
                }
                LOG.warn("Exception when retrieving regioninfo from: " + region.getRegionNameAsString(), (Throwable)ioe);
            }
            Thread.sleep(1000L);
        }
        throw new IOException("Region " + region + " failed to close within timeout " + timeout);
    }

    private int getMinToStart() {
        if (this.master.isInMaintenanceMode()) {
            return 1;
        }
        int minimumRequired = 1;
        int minToStart = this.master.getConfiguration().getInt(WAIT_ON_REGIONSERVERS_MINTOSTART, -1);
        return Math.max(minToStart, minimumRequired);
    }

    public void waitForRegionServers(MonitoredTask status) throws InterruptedException {
        long now;
        long interval = this.master.getConfiguration().getLong(WAIT_ON_REGIONSERVERS_INTERVAL, 1500L);
        long timeout = this.master.getConfiguration().getLong(WAIT_ON_REGIONSERVERS_TIMEOUT, 4500L);
        int minToStart = this.getMinToStart();
        int maxToStart = this.master.getConfiguration().getInt(WAIT_ON_REGIONSERVERS_MAXTOSTART, Integer.MAX_VALUE);
        if (maxToStart < minToStart) {
            LOG.warn(String.format("The value of '%s' (%d) is set less than '%s' (%d), ignoring.", WAIT_ON_REGIONSERVERS_MAXTOSTART, maxToStart, WAIT_ON_REGIONSERVERS_MINTOSTART, minToStart));
            maxToStart = Integer.MAX_VALUE;
        }
        long startTime = now = EnvironmentEdgeManager.currentTime();
        long slept = 0L;
        long lastLogTime = 0L;
        long lastCountChange = startTime;
        int count = this.countOfRegionServers();
        int oldCount = 0;
        for (ServerListener listener : this.listeners) {
            listener.waiting();
        }
        while (!(this.master.isStopped() || this.isClusterShutdown() || count >= maxToStart || lastCountChange + interval <= now && timeout <= slept && count >= minToStart)) {
            if (oldCount != count || lastLogTime + interval < now) {
                lastLogTime = now;
                String msg = "Waiting on regionserver count=" + count + "; waited=" + slept + "ms, expecting min=" + minToStart + " server(s), max=" + this.getStrForMax(maxToStart) + " server(s), timeout=" + timeout + "ms, lastChange=" + (now - lastCountChange) + "ms";
                LOG.info(msg);
                status.setStatus(msg);
            }
            long sleepTime = 50L;
            Thread.sleep(50L);
            now = EnvironmentEdgeManager.currentTime();
            slept = now - startTime;
            oldCount = count;
            count = this.countOfRegionServers();
            if (count == oldCount) continue;
            lastCountChange = now;
        }
        if (this.isClusterShutdown()) {
            this.master.stop("Cluster shutdown");
        }
        LOG.info("Finished waiting on RegionServer count=" + count + "; waited=" + slept + "ms, expected min=" + minToStart + " server(s), max=" + this.getStrForMax(maxToStart) + " server(s), master is " + (this.master.isStopped() ? "stopped." : "running"));
    }

    private String getStrForMax(int max) {
        return max == Integer.MAX_VALUE ? "NO_LIMIT" : Integer.toString(max);
    }

    public List<ServerName> getOnlineServersList() {
        return new ArrayList<ServerName>(this.onlineServers.keySet());
    }

    public List<ServerName> getOnlineServersListWithPredicator(List<ServerName> keys, Predicate<ServerMetrics> idleServerPredicator) {
        ArrayList<ServerName> names = new ArrayList<ServerName>();
        if (keys != null && idleServerPredicator != null) {
            keys.forEach(name -> {
                ServerMetrics load = (ServerMetrics)this.onlineServers.get(name);
                if (load != null && idleServerPredicator.test(load)) {
                    names.add((ServerName)name);
                }
            });
        }
        return names;
    }

    public List<ServerName> getDrainingServersList() {
        return new ArrayList<ServerName>(this.drainingServers);
    }

    public boolean isServerOnline(ServerName serverName) {
        return serverName != null && this.onlineServers.containsKey(serverName);
    }

    public synchronized ServerLiveState isServerKnownAndOnline(ServerName serverName) {
        return this.onlineServers.containsKey(serverName) ? ServerLiveState.LIVE : (this.deadservers.isDeadServer(serverName) ? ServerLiveState.DEAD : ServerLiveState.UNKNOWN);
    }

    public synchronized boolean isServerDead(ServerName serverName) {
        return serverName == null || this.deadservers.isDeadServer(serverName);
    }

    public boolean isServerUnknown(ServerName serverName) {
        return serverName == null || !this.onlineServers.containsKey(serverName) && !this.deadservers.isDeadServer(serverName);
    }

    public void shutdownCluster() {
        String statusStr = "Cluster shutdown requested of master=" + this.master.getServerName();
        LOG.info(statusStr);
        this.clusterShutdown.set(true);
        if (this.onlineServers.isEmpty()) {
            this.master.stop("OnlineServer=0 right after cluster shutdown set");
        }
    }

    public boolean isClusterShutdown() {
        return this.clusterShutdown.get();
    }

    public void startChore() {
        Configuration c = this.master.getConfiguration();
        if (this.persistFlushedSequenceId) {
            new Thread(() -> this.removeDeletedRegionFromLoadedFlushedSequenceIds(), "RemoveDeletedRegionSyncThread").start();
            int flushPeriod = c.getInt(FLUSHEDSEQUENCEID_FLUSHER_INTERVAL, 10800000);
            this.flushedSeqIdFlusher = new FlushedSequenceIdFlusher("FlushedSequenceIdFlusher", flushPeriod);
            this.master.getChoreService().scheduleChore((ScheduledChore)this.flushedSeqIdFlusher);
        }
    }

    public void stop() {
        if (this.flushedSeqIdFlusher != null) {
            this.flushedSeqIdFlusher.shutdown();
        }
        if (this.persistFlushedSequenceId) {
            try {
                this.persistRegionLastFlushedSequenceIds();
            }
            catch (IOException e) {
                LOG.warn("Failed to persist last flushed sequence id of regions to file system", (Throwable)e);
            }
        }
    }

    public List<ServerName> createDestinationServersList(List<ServerName> serversToExclude) {
        HashSet destServers = new HashSet();
        this.onlineServers.forEach((sn, sm) -> {
            if (sm.getLastReportTimestamp() > 0L) {
                destServers.add(sn);
            }
        });
        if (serversToExclude != null) {
            destServers.removeAll(serversToExclude);
        }
        List<ServerName> drainingServersCopy = this.getDrainingServersList();
        destServers.removeAll(drainingServersCopy);
        return new ArrayList<ServerName>(destServers);
    }

    public List<ServerName> createDestinationServersList() {
        return this.createDestinationServersList(null);
    }

    void clearDeadServersWithSameHostNameAndPortOfOnlineServer() {
        for (ServerName serverName : this.getOnlineServersList()) {
            this.deadservers.cleanAllPreviousInstances(serverName);
        }
    }

    public void removeRegion(RegionInfo regionInfo) {
        byte[] encodedName = regionInfo.getEncodedNameAsBytes();
        this.storeFlushedSequenceIdsByRegion.remove(encodedName);
        this.flushedSequenceIdByRegion.remove(encodedName);
    }

    public boolean isRegionInServerManagerStates(RegionInfo hri) {
        byte[] encodedName = hri.getEncodedNameAsBytes();
        return this.storeFlushedSequenceIdsByRegion.containsKey(encodedName) || this.flushedSequenceIdByRegion.containsKey(encodedName);
    }

    public void removeRegions(List<RegionInfo> regions) {
        for (RegionInfo hri : regions) {
            this.removeRegion(hri);
        }
    }

    public int getVersionNumber(ServerName serverName) {
        ServerMetrics serverMetrics = (ServerMetrics)this.onlineServers.get(serverName);
        return serverMetrics != null ? serverMetrics.getVersionNumber() : 0;
    }

    public String getVersion(ServerName serverName) {
        ServerMetrics serverMetrics = (ServerMetrics)this.onlineServers.get(serverName);
        return serverMetrics != null ? serverMetrics.getVersion() : "0.0.0";
    }

    public int getInfoPort(ServerName serverName) {
        ServerMetrics serverMetrics = (ServerMetrics)this.onlineServers.get(serverName);
        return serverMetrics != null ? serverMetrics.getInfoServerPort() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistRegionLastFlushedSequenceIds() throws IOException {
        if (this.isFlushSeqIdPersistInProgress) {
            return;
        }
        this.isFlushSeqIdPersistInProgress = true;
        try {
            Configuration conf = this.master.getConfiguration();
            Path rootDir = CommonFSUtils.getRootDir((Configuration)conf);
            Path lastFlushedSeqIdPath = new Path(rootDir, LAST_FLUSHED_SEQ_ID_FILE);
            FileSystem fs = FileSystem.get((Configuration)conf);
            if (fs.exists(lastFlushedSeqIdPath)) {
                LOG.info("Rewriting .lastflushedseqids file at: " + lastFlushedSeqIdPath);
                if (!fs.delete(lastFlushedSeqIdPath, false)) {
                    throw new IOException("Unable to remove existing " + lastFlushedSeqIdPath);
                }
            } else {
                LOG.info("Writing .lastflushedseqids file at: " + lastFlushedSeqIdPath);
            }
            HBaseProtos.FlushedSequenceId.Builder flushedSequenceIdBuilder = HBaseProtos.FlushedSequenceId.newBuilder();
            try (FSDataOutputStream out = fs.create(lastFlushedSeqIdPath);){
                for (Map.Entry entry : this.flushedSequenceIdByRegion.entrySet()) {
                    HBaseProtos.FlushedRegionSequenceId.Builder flushedRegionSequenceIdBuilder = HBaseProtos.FlushedRegionSequenceId.newBuilder();
                    flushedRegionSequenceIdBuilder.setRegionEncodedName(ByteString.copyFrom((byte[])((byte[])entry.getKey())));
                    flushedRegionSequenceIdBuilder.setSeqId(((Long)entry.getValue()).longValue());
                    ConcurrentNavigableMap storeSeqIds = (ConcurrentNavigableMap)this.storeFlushedSequenceIdsByRegion.get(entry.getKey());
                    if (storeSeqIds != null) {
                        for (Map.Entry store : storeSeqIds.entrySet()) {
                            HBaseProtos.FlushedStoreSequenceId.Builder flushedStoreSequenceIdBuilder = HBaseProtos.FlushedStoreSequenceId.newBuilder();
                            flushedStoreSequenceIdBuilder.setFamily(ByteString.copyFrom((byte[])((byte[])store.getKey())));
                            flushedStoreSequenceIdBuilder.setSeqId(((Long)store.getValue()).longValue());
                            flushedRegionSequenceIdBuilder.addStores(flushedStoreSequenceIdBuilder);
                        }
                    }
                    flushedSequenceIdBuilder.addRegionSequenceId(flushedRegionSequenceIdBuilder);
                }
                flushedSequenceIdBuilder.build().writeDelimitedTo((OutputStream)out);
            }
        }
        finally {
            this.isFlushSeqIdPersistInProgress = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadLastFlushedSequenceIds() throws IOException {
        if (!this.persistFlushedSequenceId) {
            return;
        }
        Configuration conf = this.master.getConfiguration();
        Path rootDir = CommonFSUtils.getRootDir((Configuration)conf);
        Path lastFlushedSeqIdPath = new Path(rootDir, LAST_FLUSHED_SEQ_ID_FILE);
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (!fs.exists(lastFlushedSeqIdPath)) {
            LOG.info("No .lastflushedseqids found at " + lastFlushedSeqIdPath + " will record last flushed sequence id for regions by regionserver report all over again");
            return;
        }
        LOG.info("begin to load .lastflushedseqids at " + lastFlushedSeqIdPath);
        try (FSDataInputStream in = fs.open(lastFlushedSeqIdPath);){
            HBaseProtos.FlushedSequenceId flushedSequenceId = HBaseProtos.FlushedSequenceId.parseDelimitedFrom((InputStream)in);
            if (flushedSequenceId == null) {
                LOG.info(".lastflushedseqids found at {} is empty", (Object)lastFlushedSeqIdPath);
                return;
            }
            for (HBaseProtos.FlushedRegionSequenceId flushedRegionSequenceId : flushedSequenceId.getRegionSequenceIdList()) {
                byte[] encodedRegionName = flushedRegionSequenceId.getRegionEncodedName().toByteArray();
                this.flushedSequenceIdByRegion.putIfAbsent(encodedRegionName, flushedRegionSequenceId.getSeqId());
                if (flushedRegionSequenceId.getStoresList() == null || flushedRegionSequenceId.getStoresList().size() == 0) continue;
                ConcurrentNavigableMap storeFlushedSequenceId = (ConcurrentNavigableMap)ConcurrentMapUtils.computeIfAbsent(this.storeFlushedSequenceIdsByRegion, (Object)encodedRegionName, () -> new ConcurrentSkipListMap(Bytes.BYTES_COMPARATOR));
                for (HBaseProtos.FlushedStoreSequenceId flushedStoreSequenceId : flushedRegionSequenceId.getStoresList()) {
                    storeFlushedSequenceId.put(flushedStoreSequenceId.getFamily().toByteArray(), flushedStoreSequenceId.getSeqId());
                }
            }
        }
    }

    public void removeDeletedRegionFromLoadedFlushedSequenceIds() {
        RegionStates regionStates = this.master.getAssignmentManager().getRegionStates();
        Iterator it = this.flushedSequenceIdByRegion.keySet().iterator();
        while (it.hasNext()) {
            byte[] regionEncodedName = (byte[])it.next();
            if (regionStates.getRegionState(Bytes.toStringBinary((byte[])regionEncodedName)) != null) continue;
            it.remove();
            this.storeFlushedSequenceIdsByRegion.remove(regionEncodedName);
        }
    }

    private class FlushedSequenceIdFlusher
    extends ScheduledChore {
        public FlushedSequenceIdFlusher(String name, int p) {
            super(name, (Stoppable)ServerManager.this.master, p, 60000L);
        }

        protected void chore() {
            try {
                ServerManager.this.persistRegionLastFlushedSequenceIds();
            }
            catch (IOException e) {
                LOG.debug("Failed to persist last flushed sequence id of regions to file system", (Throwable)e);
            }
        }
    }

    public static enum ServerLiveState {
        LIVE,
        DEAD,
        UNKNOWN;

    }
}

