/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.MetricsMasterFileSystem;
import org.apache.hadoop.hbase.master.SplitLogManager;
import org.apache.hadoop.hbase.regionserver.wal.AbstractFSWAL;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MasterWalManager {
    private static final Logger LOG = LoggerFactory.getLogger(MasterWalManager.class);
    static final PathFilter META_FILTER = new PathFilter(){

        public boolean accept(Path p) {
            return AbstractFSWALProvider.isMetaFile(p);
        }
    };
    public static final PathFilter NON_META_FILTER = new PathFilter(){

        public boolean accept(Path p) {
            return !AbstractFSWALProvider.isMetaFile(p);
        }
    };
    private final MetricsMasterFileSystem metricsMasterFilesystem = new MetricsMasterFileSystem();
    private final MasterServices services;
    private final Configuration conf;
    private final FileSystem fs;
    private final Path oldLogDir;
    private final Path rootDir;
    private final Lock splitLogLock = new ReentrantLock();
    @Deprecated
    private final SplitLogManager splitLogManager;
    private volatile boolean fsOk = true;

    public MasterWalManager(MasterServices services) throws IOException {
        this(services.getConfiguration(), services.getMasterFileSystem().getWALFileSystem(), services.getMasterFileSystem().getWALRootDir(), services);
    }

    public MasterWalManager(Configuration conf, FileSystem fs, Path rootDir, MasterServices services) throws IOException {
        this.fs = fs;
        this.conf = conf;
        this.rootDir = rootDir;
        this.services = services;
        this.splitLogManager = new SplitLogManager(services, conf);
        this.oldLogDir = new Path(rootDir, "oldWALs");
    }

    public void stop() {
        if (this.splitLogManager != null) {
            this.splitLogManager.stop();
        }
    }

    SplitLogManager getSplitLogManager() {
        return this.splitLogManager;
    }

    Path getOldLogDir() {
        return this.oldLogDir;
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    private boolean checkFileSystem() {
        if (this.fsOk) {
            try {
                FSUtils.checkFileSystemAvailable(this.fs);
                FSUtils.checkDfsSafeMode(this.conf);
            }
            catch (IOException e) {
                this.services.abort("Shutting down HBase cluster: file system not available", e);
                this.fsOk = false;
            }
        }
        return this.fsOk;
    }

    public Set<ServerName> getSplittingServersFromWALDir() throws IOException {
        return this.getServerNamesFromWALDirPath(p -> p.getName().endsWith("-splitting"));
    }

    public Set<ServerName> getLiveServersFromWALDir() throws IOException {
        return this.getServerNamesFromWALDirPath(p -> !p.getName().endsWith("-splitting"));
    }

    public Set<ServerName> getServerNamesFromWALDirPath(PathFilter filter) throws IOException {
        FileStatus[] walDirForServerNames = this.getWALDirPaths(filter);
        return Stream.of(walDirForServerNames).map(s -> {
            ServerName serverName = AbstractFSWALProvider.getServerNameFromWALDirectoryName(s.getPath());
            if (serverName == null) {
                LOG.warn("Log folder {} doesn't look like its name includes a region server name; leaving in place. If you see later errors about missing write ahead logs they may be saved in this location.", (Object)s.getPath());
                return null;
            }
            return serverName;
        }).filter(s -> s != null).collect(Collectors.toSet());
    }

    public FileStatus[] getWALDirPaths(PathFilter filter) throws IOException {
        Path walDirPath = new Path(CommonFSUtils.getWALRootDir((Configuration)this.conf), "WALs");
        FileStatus[] walDirForServerNames = CommonFSUtils.listStatus((FileSystem)this.fs, (Path)walDirPath, (PathFilter)filter);
        return walDirForServerNames == null ? new FileStatus[]{} : walDirForServerNames;
    }

    @Deprecated
    public Set<ServerName> getFailedServersFromLogFolders() throws IOException {
        boolean retrySplitting = !this.conf.getBoolean("hbase.hlog.split.skip.errors", false);
        HashSet<ServerName> serverNames = new HashSet<ServerName>();
        Path logsDirPath = new Path(CommonFSUtils.getWALRootDir((Configuration)this.conf), "WALs");
        do {
            if (this.services.isStopped()) {
                LOG.warn("Master stopped while trying to get failed servers.");
                break;
            }
            try {
                if (!this.fs.exists(logsDirPath)) {
                    return serverNames;
                }
                FileStatus[] logFolders = CommonFSUtils.listStatus((FileSystem)this.fs, (Path)logsDirPath, null);
                Set<ServerName> onlineServers = this.services.getServerManager().getOnlineServers().keySet();
                if (logFolders == null || logFolders.length == 0) {
                    LOG.debug("No log files to split, proceeding...");
                    return serverNames;
                }
                for (FileStatus status : logFolders) {
                    FileStatus[] curLogFiles = CommonFSUtils.listStatus((FileSystem)this.fs, (Path)status.getPath(), null);
                    if (curLogFiles == null || curLogFiles.length == 0) continue;
                    ServerName serverName = AbstractFSWALProvider.getServerNameFromWALDirectoryName(status.getPath());
                    if (null == serverName) {
                        LOG.warn("Log folder " + status.getPath() + " doesn't look like its name includes a region server name; leaving in place. If you see later errors about missing write ahead logs they may be saved in this location.");
                        continue;
                    }
                    if (!onlineServers.contains(serverName)) {
                        LOG.info("Log folder " + status.getPath() + " doesn't belong to a known region server, splitting");
                        serverNames.add(serverName);
                        continue;
                    }
                    LOG.info("Log folder " + status.getPath() + " belongs to an existing region server");
                }
                retrySplitting = false;
            }
            catch (IOException ioe) {
                LOG.warn("Failed getting failed servers to be recovered.", (Throwable)ioe);
                if (!this.checkFileSystem()) {
                    LOG.warn("Bad Filesystem, exiting");
                    Runtime.getRuntime().halt(1);
                }
                try {
                    if (!retrySplitting) continue;
                    Thread.sleep(this.conf.getInt("hbase.hlog.split.failure.retry.interval", 30000));
                }
                catch (InterruptedException e) {
                    LOG.warn("Interrupted, aborting since cannot return w/o splitting");
                    Thread.currentThread().interrupt();
                    retrySplitting = false;
                    Runtime.getRuntime().halt(1);
                }
            }
        } while (retrySplitting);
        return serverNames;
    }

    public void splitLog(ServerName serverName) throws IOException {
        this.splitLog(Collections.singleton(serverName));
    }

    public void splitMetaLog(ServerName serverName) throws IOException {
        this.splitMetaLog(Collections.singleton(serverName));
    }

    public void splitMetaLog(Set<ServerName> serverNames) throws IOException {
        this.splitLog(serverNames, META_FILTER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"UL_UNRELEASED_LOCK"}, justification="We only release this lock when we set it. Updates to code that uses it should verify use of the guard boolean.")
    List<Path> getLogDirs(Set<ServerName> serverNames) throws IOException {
        ArrayList<Path> logDirs = new ArrayList<Path>();
        boolean needReleaseLock = false;
        if (!this.services.isInitialized()) {
            this.splitLogLock.lock();
            needReleaseLock = true;
        }
        try {
            for (ServerName serverName : serverNames) {
                Path logDir = new Path(this.rootDir, AbstractFSWALProvider.getWALDirectoryName(serverName.toString()));
                Path splitDir = logDir.suffix("-splitting");
                if (this.fs.exists(logDir)) {
                    if (!this.fs.rename(logDir, splitDir)) {
                        throw new IOException("Failed fs.rename for log split: " + logDir);
                    }
                    logDir = splitDir;
                    LOG.debug("Renamed region directory: " + splitDir);
                } else if (!this.fs.exists(splitDir)) {
                    LOG.info("Log dir for server " + serverName + " does not exist");
                    continue;
                }
                logDirs.add(splitDir);
            }
        }
        catch (IOException ioe) {
            if (!this.checkFileSystem()) {
                this.services.abort("Aborting due to filesystem unavailable", ioe);
                throw ioe;
            }
        }
        finally {
            if (needReleaseLock) {
                this.splitLogLock.unlock();
            }
        }
        return logDirs;
    }

    public void splitLog(Set<ServerName> serverNames) throws IOException {
        this.splitLog(serverNames, NON_META_FILTER);
    }

    public void splitLog(Set<ServerName> serverNames, PathFilter filter) throws IOException {
        long splitTime = 0L;
        long splitLogSize = 0L;
        List<Path> logDirs = this.getLogDirs(serverNames);
        this.splitLogManager.handleDeadWorkers(serverNames);
        splitTime = EnvironmentEdgeManager.currentTime();
        splitLogSize = this.splitLogManager.splitLogDistributed(serverNames, logDirs, filter);
        splitTime = EnvironmentEdgeManager.currentTime() - splitTime;
        if (this.metricsMasterFilesystem != null) {
            if (filter == META_FILTER) {
                this.metricsMasterFilesystem.addMetaWALSplit(splitTime, splitLogSize);
            } else {
                this.metricsMasterFilesystem.addSplit(splitTime, splitLogSize);
            }
        }
    }

    public void archiveMetaLog(ServerName serverName) {
        try {
            Path logDir = new Path(this.rootDir, AbstractFSWALProvider.getWALDirectoryName(serverName.toString()));
            Path splitDir = logDir.suffix("-splitting");
            if (this.fs.exists(splitDir)) {
                FileStatus[] logfiles = CommonFSUtils.listStatus((FileSystem)this.fs, (Path)splitDir, (PathFilter)META_FILTER);
                if (logfiles != null) {
                    for (FileStatus status : logfiles) {
                        if (status.isDir()) continue;
                        Path newPath = AbstractFSWAL.getWALArchivePath(this.oldLogDir, status.getPath());
                        if (!CommonFSUtils.renameAndSetModifyTime((FileSystem)this.fs, (Path)status.getPath(), (Path)newPath)) {
                            LOG.warn("Unable to move  " + status.getPath() + " to " + newPath);
                            continue;
                        }
                        LOG.debug("Archived meta log " + status.getPath() + " to " + newPath);
                    }
                }
                if (!this.fs.delete(splitDir, false)) {
                    LOG.warn("Unable to delete log dir. Ignoring. " + splitDir);
                }
            }
        }
        catch (IOException ie) {
            LOG.warn("Failed archiving meta log for server " + serverName, (Throwable)ie);
        }
    }
}

