/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.ClusterMetricsBuilder;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseRpcServicesBase;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerMetricsBuilder;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.UnknownRegionException;
import org.apache.hadoop.hbase.client.BalanceRequest;
import org.apache.hadoop.hbase.client.BalanceResponse;
import org.apache.hadoop.hbase.client.MasterSwitchType;
import org.apache.hadoop.hbase.client.NormalizeTableFilterParams;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.client.VersionInfoUtil;
import org.apache.hadoop.hbase.client.replication.ReplicationPeerConfigUtil;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessor;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.exceptions.UnknownProtocolException;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hadoop.hbase.ipc.PriorityFunction;
import org.apache.hadoop.hbase.ipc.QosPriority;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.ServerNotRunningYetException;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.master.DeadServer;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterAnnotationReadingPriorityFunction;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.master.cleaner.HFileCleaner;
import org.apache.hadoop.hbase.master.hbck.HbckChore;
import org.apache.hadoop.hbase.master.janitor.MetaFixer;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureUtil;
import org.apache.hadoop.hbase.master.procedure.ServerCrashProcedure;
import org.apache.hadoop.hbase.master.replication.AbstractPeerNoLockProcedure;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.namequeues.NamedQueueRecorder;
import org.apache.hadoop.hbase.namequeues.request.NamedQueueGetRequest;
import org.apache.hadoop.hbase.namequeues.response.NamedQueueGetResponse;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.procedure.MasterProcedureManager;
import org.apache.hadoop.hbase.procedure2.LockType;
import org.apache.hadoop.hbase.procedure2.LockedResource;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureUtil;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureException;
import org.apache.hadoop.hbase.quotas.MasterQuotaManager;
import org.apache.hadoop.hbase.quotas.QuotaObserverChore;
import org.apache.hadoop.hbase.quotas.QuotaUtil;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;
import org.apache.hadoop.hbase.regionserver.SimpleRpcSchedulerFactory;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
import org.apache.hadoop.hbase.rsgroup.RSGroupBasedLoadBalancer;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.rsgroup.RSGroupUtil;
import org.apache.hadoop.hbase.security.Superusers;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessChecker;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.PermissionStorage;
import org.apache.hadoop.hbase.security.access.ShadedAccessControlUtil;
import org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hadoop.hbase.security.visibility.VisibilityController;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AccessControlProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ErrorHandlingProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.LockServiceProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RSGroupAdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegistryProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ReplicationProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.VisibilityLabelsProtos;
import org.apache.hadoop.hbase.snapshot.ClientSnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.DNS;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ForeignExceptionUtil;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.hbase.thirdparty.com.google.protobuf.Descriptors;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.Service;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MasterRpcServices
extends HBaseRpcServicesBase<HMaster>
implements MasterProtos.MasterService.BlockingInterface,
RegionServerStatusProtos.RegionServerStatusService.BlockingInterface,
LockServiceProtos.LockService.BlockingInterface,
MasterProtos.HbckService.BlockingInterface {
    private static final Logger LOG = LoggerFactory.getLogger((String)MasterRpcServices.class.getName());
    private static final Logger AUDITLOG = LoggerFactory.getLogger((String)("SecurityLogger." + MasterRpcServices.class.getName()));
    public static final String MASTER_RPC_SCHEDULER_FACTORY_CLASS = "hbase.master.rpc.scheduler.factory.class";

    private RegionServerStatusProtos.RegionServerStartupResponse.Builder createConfigurationSubset() {
        RegionServerStatusProtos.RegionServerStartupResponse.Builder resp = this.addConfig(RegionServerStatusProtos.RegionServerStartupResponse.newBuilder(), "hbase.rootdir");
        resp = this.addConfig(resp, "fs.defaultFS");
        return this.addConfig(resp, "hbase.master.info.port");
    }

    private RegionServerStatusProtos.RegionServerStartupResponse.Builder addConfig(RegionServerStatusProtos.RegionServerStartupResponse.Builder resp, String key) {
        HBaseProtos.NameStringPair.Builder entry = HBaseProtos.NameStringPair.newBuilder().setName(key).setValue(((HMaster)this.server).getConfiguration().get(key));
        resp.addMapEntries(entry.build());
        return resp;
    }

    public MasterRpcServices(HMaster m) throws IOException {
        super(m, m.getProcessName());
    }

    @Override
    protected boolean defaultReservoirEnabled() {
        return false;
    }

    @Override
    protected DNS.ServerType getDNSServerType() {
        return DNS.ServerType.MASTER;
    }

    @Override
    protected String getHostname(Configuration conf, String defaultHostname) {
        return conf.get("hbase.master.ipc.address", defaultHostname);
    }

    @Override
    protected String getPortConfigName() {
        return "hbase.master.port";
    }

    @Override
    protected int getDefaultPort() {
        return 16000;
    }

    @Override
    protected Class<?> getRpcSchedulerFactoryClass(Configuration conf) {
        return conf.getClass(MASTER_RPC_SCHEDULER_FACTORY_CLASS, SimpleRpcSchedulerFactory.class);
    }

    @Override
    protected PriorityFunction createPriority() {
        return new MasterAnnotationReadingPriorityFunction(this);
    }

    private void rpcPreCheck(String requestName) throws ServiceException {
        try {
            ((HMaster)this.server).checkInitialized();
            this.requirePermission(requestName, Permission.Action.ADMIN);
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean switchBalancer(boolean b, BalanceSwitchMode mode) throws IOException {
        boolean oldValue = ((HMaster)this.server).loadBalancerStateStore.get();
        boolean newValue = b;
        try {
            if (((HMaster)this.server).cpHost != null) {
                ((HMaster)this.server).cpHost.preBalanceSwitch(newValue);
            }
            if (mode == BalanceSwitchMode.SYNC) {
                RSGroupBasedLoadBalancer rSGroupBasedLoadBalancer = ((HMaster)this.server).getLoadBalancer();
                synchronized (rSGroupBasedLoadBalancer) {
                    ((HMaster)this.server).loadBalancerStateStore.set(newValue);
                }
            } else {
                ((HMaster)this.server).loadBalancerStateStore.set(newValue);
            }
            LOG.info(((HMaster)this.server).getClientIdAuditPrefix() + " set balanceSwitch=" + newValue);
            if (((HMaster)this.server).cpHost != null) {
                ((HMaster)this.server).cpHost.postBalanceSwitch(oldValue, newValue);
            }
            ((HMaster)this.server).getLoadBalancer().updateBalancerStatus(newValue);
        }
        catch (IOException ioe) {
            LOG.warn("Error flipping balance switch", (Throwable)ioe);
        }
        return oldValue;
    }

    boolean synchronousBalanceSwitch(boolean b) throws IOException {
        return this.switchBalancer(b, BalanceSwitchMode.SYNC);
    }

    @Override
    protected List<RpcServer.BlockingServiceAndInterface> getServices() {
        ArrayList<RpcServer.BlockingServiceAndInterface> bssi = new ArrayList<RpcServer.BlockingServiceAndInterface>(5);
        bssi.add(new RpcServer.BlockingServiceAndInterface(MasterProtos.MasterService.newReflectiveBlockingService((MasterProtos.MasterService.BlockingInterface)this), MasterProtos.MasterService.BlockingInterface.class));
        bssi.add(new RpcServer.BlockingServiceAndInterface(RegionServerStatusProtos.RegionServerStatusService.newReflectiveBlockingService((RegionServerStatusProtos.RegionServerStatusService.BlockingInterface)this), RegionServerStatusProtos.RegionServerStatusService.BlockingInterface.class));
        bssi.add(new RpcServer.BlockingServiceAndInterface(LockServiceProtos.LockService.newReflectiveBlockingService((LockServiceProtos.LockService.BlockingInterface)this), LockServiceProtos.LockService.BlockingInterface.class));
        bssi.add(new RpcServer.BlockingServiceAndInterface(MasterProtos.HbckService.newReflectiveBlockingService((MasterProtos.HbckService.BlockingInterface)this), MasterProtos.HbckService.BlockingInterface.class));
        bssi.add(new RpcServer.BlockingServiceAndInterface(RegistryProtos.ClientMetaService.newReflectiveBlockingService((RegistryProtos.ClientMetaService.BlockingInterface)this), RegistryProtos.ClientMetaService.BlockingInterface.class));
        bssi.add(new RpcServer.BlockingServiceAndInterface(AdminProtos.AdminService.newReflectiveBlockingService((AdminProtos.AdminService.BlockingInterface)this), AdminProtos.AdminService.BlockingInterface.class));
        return bssi;
    }

    void start(ZKWatcher zkWatcher) {
        this.internalStart(zkWatcher);
    }

    void stop() {
        this.internalStop();
    }

    @QosPriority(priority=100)
    public RegionServerStatusProtos.GetLastFlushedSequenceIdResponse getLastFlushedSequenceId(RpcController controller, RegionServerStatusProtos.GetLastFlushedSequenceIdRequest request) throws ServiceException {
        try {
            ((HMaster)this.server).checkServiceStarted();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
        byte[] encodedRegionName = request.getRegionName().toByteArray();
        ClusterStatusProtos.RegionStoreSequenceIds ids = ((HMaster)this.server).getServerManager().getLastFlushedSequenceId(encodedRegionName);
        return ResponseConverter.buildGetLastFlushedSequenceIdResponse((ClusterStatusProtos.RegionStoreSequenceIds)ids);
    }

    public RegionServerStatusProtos.RegionServerReportResponse regionServerReport(RpcController controller, RegionServerStatusProtos.RegionServerReportRequest request) throws ServiceException {
        try {
            ((HMaster)this.server).checkServiceStarted();
            int versionNumber = 0;
            String version = "0.0.0";
            HBaseProtos.VersionInfo versionInfo = VersionInfoUtil.getCurrentClientVersionInfo();
            if (versionInfo != null) {
                version = versionInfo.getVersion();
                versionNumber = VersionInfoUtil.getVersionNumber(versionInfo);
            }
            ClusterStatusProtos.ServerLoad sl = request.getLoad();
            ServerName serverName = ProtobufUtil.toServerName((HBaseProtos.ServerName)request.getServer());
            ServerMetrics oldLoad = ((HMaster)this.server).getServerManager().getLoad(serverName);
            ServerMetrics newLoad = ServerMetricsBuilder.toServerMetrics((ServerName)serverName, (int)versionNumber, (String)version, (ClusterStatusProtos.ServerLoad)sl);
            ((HMaster)this.server).getServerManager().regionServerReport(serverName, newLoad);
            ((HMaster)this.server).getAssignmentManager().reportOnlineRegions(serverName, newLoad.getRegionMetrics().keySet());
            if (sl != null && ((HMaster)this.server).metricsMaster != null) {
                ((HMaster)this.server).metricsMaster.incrementRequests(sl.getTotalNumberOfRequests() - (oldLoad != null ? oldLoad.getRequestCount() : 0L));
                ((HMaster)this.server).metricsMaster.incrementReadRequests(sl.getReadRequestsCount() - (oldLoad != null ? oldLoad.getReadRequestsCount() : 0L));
                ((HMaster)this.server).metricsMaster.incrementWriteRequests(sl.getWriteRequestsCount() - (oldLoad != null ? oldLoad.getWriteRequestsCount() : 0L));
            }
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
        return RegionServerStatusProtos.RegionServerReportResponse.newBuilder().build();
    }

    public RegionServerStatusProtos.RegionServerStartupResponse regionServerStartup(RpcController controller, RegionServerStatusProtos.RegionServerStartupRequest request) throws ServiceException {
        try {
            ((HMaster)this.server).checkServiceStarted();
            int versionNumber = 0;
            String version = "0.0.0";
            HBaseProtos.VersionInfo versionInfo = VersionInfoUtil.getCurrentClientVersionInfo();
            if (versionInfo != null) {
                version = versionInfo.getVersion();
                versionNumber = VersionInfoUtil.getVersionNumber(versionInfo);
            }
            InetAddress ia = ((HMaster)this.server).getRemoteInetAddress(request.getPort(), request.getServerStartCode());
            ServerName rs = ((HMaster)this.server).getServerManager().regionServerStartup(request, versionNumber, version, ia);
            RegionServerStatusProtos.RegionServerStartupResponse.Builder resp = this.createConfigurationSubset();
            HBaseProtos.NameStringPair.Builder entry = HBaseProtos.NameStringPair.newBuilder().setName("hbase.regionserver.hostname.seen.by.master").setValue(rs.getHostname());
            resp.addMapEntries(entry.build());
            return resp.build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public RegionServerStatusProtos.ReportRSFatalErrorResponse reportRSFatalError(RpcController controller, RegionServerStatusProtos.ReportRSFatalErrorRequest request) throws ServiceException {
        String errorText = request.getErrorMessage();
        ServerName sn = ProtobufUtil.toServerName((HBaseProtos.ServerName)request.getServer());
        String msg = sn + " reported a fatal error:\n" + errorText;
        LOG.warn(msg);
        ((HMaster)this.server).rsFatals.add(msg);
        return RegionServerStatusProtos.ReportRSFatalErrorResponse.newBuilder().build();
    }

    public MasterProtos.AddColumnResponse addColumn(RpcController controller, MasterProtos.AddColumnRequest req) throws ServiceException {
        try {
            long procId = ((HMaster)this.server).addColumn(ProtobufUtil.toTableName((HBaseProtos.TableName)req.getTableName()), ProtobufUtil.toColumnFamilyDescriptor((HBaseProtos.ColumnFamilySchema)req.getColumnFamilies()), req.getNonceGroup(), req.getNonce());
            if (procId == -1L) {
                return MasterProtos.AddColumnResponse.newBuilder().build();
            }
            return MasterProtos.AddColumnResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public MasterProtos.AssignRegionResponse assignRegion(RpcController controller, MasterProtos.AssignRegionRequest req) throws ServiceException {
        try {
            ((HMaster)this.server).checkInitialized();
            HBaseProtos.RegionSpecifier.RegionSpecifierType type = req.getRegion().getType();
            if (type != HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME) {
                LOG.warn("assignRegion specifier type: expected: " + HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME + " actual: " + type);
            }
            byte[] regionName = req.getRegion().getValue().toByteArray();
            RegionInfo regionInfo = ((HMaster)this.server).getAssignmentManager().getRegionInfo(regionName);
            if (regionInfo == null) {
                throw new UnknownRegionException(Bytes.toStringBinary((byte[])regionName));
            }
            MasterProtos.AssignRegionResponse arr = MasterProtos.AssignRegionResponse.newBuilder().build();
            if (((HMaster)this.server).cpHost != null) {
                ((HMaster)this.server).cpHost.preAssign(regionInfo);
            }
            LOG.info(((HMaster)this.server).getClientIdAuditPrefix() + " assign " + regionInfo.getRegionNameAsString());
            ((HMaster)this.server).getAssignmentManager().assign(regionInfo);
            if (((HMaster)this.server).cpHost != null) {
                ((HMaster)this.server).cpHost.postAssign(regionInfo);
            }
            return arr;
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public MasterProtos.BalanceResponse balance(RpcController controller, MasterProtos.BalanceRequest request) throws ServiceException {
        try {
            return ProtobufUtil.toBalanceResponse((BalanceResponse)((HMaster)this.server).balance(ProtobufUtil.toBalanceRequest((MasterProtos.BalanceRequest)request)));
        }
        catch (IOException ex) {
            throw new ServiceException((Throwable)ex);
        }
    }

    public MasterProtos.CreateNamespaceResponse createNamespace(RpcController controller, MasterProtos.CreateNamespaceRequest request) throws ServiceException {
        try {
            long procId = ((HMaster)this.server).createNamespace(ProtobufUtil.toNamespaceDescriptor((HBaseProtos.NamespaceDescriptor)request.getNamespaceDescriptor()), request.getNonceGroup(), request.getNonce());
            return MasterProtos.CreateNamespaceResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.CreateTableResponse createTable(RpcController controller, MasterProtos.CreateTableRequest req) throws ServiceException {
        TableDescriptor tableDescriptor = ProtobufUtil.toTableDescriptor((HBaseProtos.TableSchema)req.getTableSchema());
        byte[][] splitKeys = ProtobufUtil.getSplitKeysArray((MasterProtos.CreateTableRequest)req);
        try {
            long procId = ((HMaster)this.server).createTable(tableDescriptor, splitKeys, req.getNonceGroup(), req.getNonce());
            LOG.info(((HMaster)this.server).getClientIdAuditPrefix() + " procedure request for creating table: " + req.getTableSchema().getTableName() + " procId is: " + procId);
            return MasterProtos.CreateTableResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public MasterProtos.DeleteColumnResponse deleteColumn(RpcController controller, MasterProtos.DeleteColumnRequest req) throws ServiceException {
        try {
            long procId = ((HMaster)this.server).deleteColumn(ProtobufUtil.toTableName((HBaseProtos.TableName)req.getTableName()), req.getColumnName().toByteArray(), req.getNonceGroup(), req.getNonce());
            if (procId == -1L) {
                return MasterProtos.DeleteColumnResponse.newBuilder().build();
            }
            return MasterProtos.DeleteColumnResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public MasterProtos.DeleteNamespaceResponse deleteNamespace(RpcController controller, MasterProtos.DeleteNamespaceRequest request) throws ServiceException {
        try {
            long procId = ((HMaster)this.server).deleteNamespace(request.getNamespaceName(), request.getNonceGroup(), request.getNonce());
            return MasterProtos.DeleteNamespaceResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.DeleteSnapshotResponse deleteSnapshot(RpcController controller, MasterProtos.DeleteSnapshotRequest request) throws ServiceException {
        try {
            ((HMaster)this.server).checkInitialized();
            ((HMaster)this.server).snapshotManager.checkSnapshotSupport();
            LOG.info(((HMaster)this.server).getClientIdAuditPrefix() + " delete " + request.getSnapshot());
            ((HMaster)this.server).snapshotManager.deleteSnapshot(request.getSnapshot());
            return MasterProtos.DeleteSnapshotResponse.newBuilder().build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.DeleteTableResponse deleteTable(RpcController controller, MasterProtos.DeleteTableRequest request) throws ServiceException {
        try {
            long procId = ((HMaster)this.server).deleteTable(ProtobufUtil.toTableName((HBaseProtos.TableName)request.getTableName()), request.getNonceGroup(), request.getNonce());
            return MasterProtos.DeleteTableResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public MasterProtos.TruncateTableResponse truncateTable(RpcController controller, MasterProtos.TruncateTableRequest request) throws ServiceException {
        try {
            long procId = ((HMaster)this.server).truncateTable(ProtobufUtil.toTableName((HBaseProtos.TableName)request.getTableName()), request.getPreserveSplits(), request.getNonceGroup(), request.getNonce());
            return MasterProtos.TruncateTableResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public MasterProtos.DisableTableResponse disableTable(RpcController controller, MasterProtos.DisableTableRequest request) throws ServiceException {
        try {
            long procId = ((HMaster)this.server).disableTable(ProtobufUtil.toTableName((HBaseProtos.TableName)request.getTableName()), request.getNonceGroup(), request.getNonce());
            return MasterProtos.DisableTableResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public MasterProtos.EnableCatalogJanitorResponse enableCatalogJanitor(RpcController c, MasterProtos.EnableCatalogJanitorRequest req) throws ServiceException {
        this.rpcPreCheck("enableCatalogJanitor");
        return MasterProtos.EnableCatalogJanitorResponse.newBuilder().setPrevValue(((HMaster)this.server).catalogJanitorChore.setEnabled(req.getEnable())).build();
    }

    public MasterProtos.SetCleanerChoreRunningResponse setCleanerChoreRunning(RpcController c, MasterProtos.SetCleanerChoreRunningRequest req) throws ServiceException {
        this.rpcPreCheck("setCleanerChoreRunning");
        boolean prevValue = ((HMaster)this.server).getLogCleaner().getEnabled() && ((HMaster)this.server).getHFileCleaner().getEnabled();
        ((HMaster)this.server).getLogCleaner().setEnabled(req.getOn());
        for (HFileCleaner hFileCleaner : ((HMaster)this.server).getHFileCleaners()) {
            hFileCleaner.setEnabled(req.getOn());
        }
        return MasterProtos.SetCleanerChoreRunningResponse.newBuilder().setPrevValue(prevValue).build();
    }

    public MasterProtos.EnableTableResponse enableTable(RpcController controller, MasterProtos.EnableTableRequest request) throws ServiceException {
        try {
            long procId = ((HMaster)this.server).enableTable(ProtobufUtil.toTableName((HBaseProtos.TableName)request.getTableName()), request.getNonceGroup(), request.getNonce());
            return MasterProtos.EnableTableResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public MasterProtos.MergeTableRegionsResponse mergeTableRegions(RpcController c, MasterProtos.MergeTableRegionsRequest request) throws ServiceException {
        try {
            ((HMaster)this.server).checkInitialized();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
        RegionStates regionStates = ((HMaster)this.server).getAssignmentManager().getRegionStates();
        RegionInfo[] regionsToMerge = new RegionInfo[request.getRegionCount()];
        for (int i = 0; i < request.getRegionCount(); ++i) {
            RegionState regionState;
            byte[] encodedNameOfRegion = request.getRegion(i).getValue().toByteArray();
            if (request.getRegion(i).getType() != HBaseProtos.RegionSpecifier.RegionSpecifierType.ENCODED_REGION_NAME) {
                LOG.warn("MergeRegions specifier type: expected: " + HBaseProtos.RegionSpecifier.RegionSpecifierType.ENCODED_REGION_NAME + " actual: region " + i + " =" + request.getRegion(i).getType());
            }
            if ((regionState = regionStates.getRegionState(Bytes.toString((byte[])encodedNameOfRegion))) == null) {
                throw new ServiceException((Throwable)new UnknownRegionException(Bytes.toStringBinary((byte[])encodedNameOfRegion)));
            }
            regionsToMerge[i] = regionState.getRegion();
        }
        try {
            long procId = ((HMaster)this.server).mergeRegions(regionsToMerge, request.getForcible(), request.getNonceGroup(), request.getNonce());
            return MasterProtos.MergeTableRegionsResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public MasterProtos.SplitTableRegionResponse splitRegion(RpcController controller, MasterProtos.SplitTableRegionRequest request) throws ServiceException {
        try {
            long procId = ((HMaster)this.server).splitRegion(ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)request.getRegionInfo()), request.hasSplitRow() ? request.getSplitRow().toByteArray() : null, request.getNonceGroup(), request.getNonce());
            return MasterProtos.SplitTableRegionResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    public ClientProtos.CoprocessorServiceResponse execMasterService(RpcController controller, ClientProtos.CoprocessorServiceRequest request) throws ServiceException {
        this.rpcPreCheck("execMasterService");
        try {
            ServerRpcController execController = new ServerRpcController();
            ClientProtos.CoprocessorServiceCall call = request.getCall();
            String serviceName = call.getServiceName();
            String methodName = call.getMethodName();
            if (!((HMaster)this.server).coprocessorServiceHandlers.containsKey(serviceName)) {
                throw new UnknownProtocolException(null, "No registered Master Coprocessor Endpoint found for " + serviceName + ". Has it been enabled?");
            }
            Service service = ((HMaster)this.server).coprocessorServiceHandlers.get(serviceName);
            Descriptors.ServiceDescriptor serviceDesc = service.getDescriptorForType();
            Descriptors.MethodDescriptor methodDesc = CoprocessorRpcUtils.getMethodDescriptor((String)methodName, (Descriptors.ServiceDescriptor)serviceDesc);
            Message execRequest = CoprocessorRpcUtils.getRequest((Service)service, (Descriptors.MethodDescriptor)methodDesc, (ByteString)call.getRequest());
            Message.Builder responseBuilder = service.getResponsePrototype(methodDesc).newBuilderForType();
            service.callMethod(methodDesc, (RpcController)execController, execRequest, message -> {
                if (message != null) {
                    responseBuilder.mergeFrom(message);
                }
            });
            Message execResult = responseBuilder.build();
            if (execController.getFailedOn() != null) {
                throw execController.getFailedOn();
            }
            String remoteAddress = RpcServer.getRemoteAddress().map(InetAddress::toString).orElse("");
            User caller = RpcServer.getRequestUser().orElse(null);
            AUDITLOG.info("User {} (remote address: {}) master service request for {}.{}", new Object[]{caller, remoteAddress, serviceName, methodName});
            return CoprocessorRpcUtils.getResponse((Message)execResult, (byte[])HConstants.EMPTY_BYTE_ARRAY);
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
    }

    public MasterProtos.ExecProcedureResponse execProcedure(RpcController controller, MasterProtos.ExecProcedureRequest request) throws ServiceException {
        try {
            ((HMaster)this.server).checkInitialized();
            HBaseProtos.ProcedureDescription desc = request.getProcedure();
            MasterProcedureManager mpm = ((HMaster)this.server).getMasterProcedureManagerHost().getProcedureManager(desc.getSignature());
            if (mpm == null) {
                throw new ServiceException((Throwable)new DoNotRetryIOException("The procedure is not registered: " + desc.getSignature()));
            }
            LOG.info(((HMaster)this.server).getClientIdAuditPrefix() + " procedure request for: " + desc.getSignature());
            mpm.checkPermissions(desc, this.getAccessChecker(), RpcServer.getRequestUser().orElse(null));
            mpm.execProcedure(desc);
            long waitTime = 300000L;
            return MasterProtos.ExecProcedureResponse.newBuilder().setExpectedTimeout(waitTime).build();
        }
        catch (ForeignException e) {
            throw new ServiceException(e.getCause());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.ExecProcedureResponse execProcedureWithRet(RpcController controller, MasterProtos.ExecProcedureRequest request) throws ServiceException {
        this.rpcPreCheck("execProcedureWithRet");
        try {
            HBaseProtos.ProcedureDescription desc = request.getProcedure();
            MasterProcedureManager mpm = ((HMaster)this.server).getMasterProcedureManagerHost().getProcedureManager(desc.getSignature());
            if (mpm == null) {
                throw new ServiceException("The procedure is not registered: " + desc.getSignature());
            }
            LOG.info(((HMaster)this.server).getClientIdAuditPrefix() + " procedure request for: " + desc.getSignature());
            byte[] data = mpm.execProcedureWithRet(desc);
            MasterProtos.ExecProcedureResponse.Builder builder = MasterProtos.ExecProcedureResponse.newBuilder();
            if (data != null) {
                builder.setReturnData(UnsafeByteOperations.unsafeWrap((byte[])data));
            }
            return builder.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.GetClusterStatusResponse getClusterStatus(RpcController controller, MasterProtos.GetClusterStatusRequest req) throws ServiceException {
        MasterProtos.GetClusterStatusResponse.Builder response = MasterProtos.GetClusterStatusResponse.newBuilder();
        try {
            response.setClusterStatus(ClusterMetricsBuilder.toClusterStatus((ClusterMetrics)((HMaster)this.server).getClusterMetrics(ClusterMetricsBuilder.toOptions((List)req.getOptionsList()))));
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return response.build();
    }

    public MasterProtos.GetCompletedSnapshotsResponse getCompletedSnapshots(RpcController controller, MasterProtos.GetCompletedSnapshotsRequest request) throws ServiceException {
        try {
            ((HMaster)this.server).checkInitialized();
            MasterProtos.GetCompletedSnapshotsResponse.Builder builder = MasterProtos.GetCompletedSnapshotsResponse.newBuilder();
            List<SnapshotProtos.SnapshotDescription> snapshots = ((HMaster)this.server).snapshotManager.getCompletedSnapshots();
            for (SnapshotProtos.SnapshotDescription snapshot : snapshots) {
                builder.addSnapshots(snapshot);
            }
            return builder.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.ListNamespacesResponse listNamespaces(RpcController controller, MasterProtos.ListNamespacesRequest request) throws ServiceException {
        try {
            return MasterProtos.ListNamespacesResponse.newBuilder().addAllNamespaceName(((HMaster)this.server).listNamespaces()).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.GetNamespaceDescriptorResponse getNamespaceDescriptor(RpcController controller, MasterProtos.GetNamespaceDescriptorRequest request) throws ServiceException {
        try {
            return MasterProtos.GetNamespaceDescriptorResponse.newBuilder().setNamespaceDescriptor(ProtobufUtil.toProtoNamespaceDescriptor((NamespaceDescriptor)((HMaster)this.server).getNamespace(request.getNamespaceName()))).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.GetSchemaAlterStatusResponse getSchemaAlterStatus(RpcController controller, MasterProtos.GetSchemaAlterStatusRequest req) throws ServiceException {
        TableName tableName = ProtobufUtil.toTableName((HBaseProtos.TableName)req.getTableName());
        try {
            ((HMaster)this.server).checkInitialized();
            Pair<Integer, Integer> pair = ((HMaster)this.server).getAssignmentManager().getReopenStatus(tableName);
            MasterProtos.GetSchemaAlterStatusResponse.Builder ret = MasterProtos.GetSchemaAlterStatusResponse.newBuilder();
            ret.setYetToUpdateRegions(((Integer)pair.getFirst()).intValue());
            ret.setTotalRegions(((Integer)pair.getSecond()).intValue());
            return ret.build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public MasterProtos.GetTableDescriptorsResponse getTableDescriptors(RpcController c, MasterProtos.GetTableDescriptorsRequest req) throws ServiceException {
        try {
            ((HMaster)this.server).checkInitialized();
            String regex = req.hasRegex() ? req.getRegex() : null;
            String namespace = req.hasNamespace() ? req.getNamespace() : null;
            ArrayList<TableName> tableNameList = null;
            if (req.getTableNamesCount() > 0) {
                tableNameList = new ArrayList<TableName>(req.getTableNamesCount());
                for (HBaseProtos.TableName tableNamePB : req.getTableNamesList()) {
                    tableNameList.add(ProtobufUtil.toTableName((HBaseProtos.TableName)tableNamePB));
                }
            }
            List<TableDescriptor> descriptors = ((HMaster)this.server).listTableDescriptors(namespace, regex, tableNameList, req.getIncludeSysTables());
            MasterProtos.GetTableDescriptorsResponse.Builder builder = MasterProtos.GetTableDescriptorsResponse.newBuilder();
            if (descriptors != null && descriptors.size() > 0) {
                for (TableDescriptor htd : descriptors) {
                    builder.addTableSchema(ProtobufUtil.toTableSchema((TableDescriptor)htd));
                }
            }
            return builder.build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public MasterProtos.ListTableDescriptorsByStateResponse listTableDescriptorsByState(RpcController controller, MasterProtos.ListTableDescriptorsByStateRequest request) throws ServiceException {
        try {
            ((HMaster)this.server).checkInitialized();
            List<TableDescriptor> descriptors = ((HMaster)this.server).listTableDescriptors(null, null, null, false);
            MasterProtos.ListTableDescriptorsByStateResponse.Builder builder = MasterProtos.ListTableDescriptorsByStateResponse.newBuilder();
            if (descriptors != null && descriptors.size() > 0) {
                TableState.State state = request.getIsEnabled() ? TableState.State.ENABLED : TableState.State.DISABLED;
                for (TableDescriptor htd : descriptors) {
                    if (!((HMaster)this.server).getTableStateManager().isTableState(htd.getTableName(), state)) continue;
                    builder.addTableSchema(ProtobufUtil.toTableSchema((TableDescriptor)htd));
                }
            }
            return builder.build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public MasterProtos.GetTableNamesResponse getTableNames(RpcController controller, MasterProtos.GetTableNamesRequest req) throws ServiceException {
        try {
            ((HMaster)this.server).checkServiceStarted();
            String regex = req.hasRegex() ? req.getRegex() : null;
            String namespace = req.hasNamespace() ? req.getNamespace() : null;
            List<TableName> tableNames = ((HMaster)this.server).listTableNames(namespace, regex, req.getIncludeSysTables());
            MasterProtos.GetTableNamesResponse.Builder builder = MasterProtos.GetTableNamesResponse.newBuilder();
            if (tableNames != null && tableNames.size() > 0) {
                for (TableName table : tableNames) {
                    builder.addTableNames(ProtobufUtil.toProtoTableName((TableName)table));
                }
            }
            return builder.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.ListTableNamesByStateResponse listTableNamesByState(RpcController controller, MasterProtos.ListTableNamesByStateRequest request) throws ServiceException {
        try {
            ((HMaster)this.server).checkServiceStarted();
            List<TableName> tableNames = ((HMaster)this.server).listTableNames(null, null, false);
            MasterProtos.ListTableNamesByStateResponse.Builder builder = MasterProtos.ListTableNamesByStateResponse.newBuilder();
            if (tableNames != null && tableNames.size() > 0) {
                TableState.State state = request.getIsEnabled() ? TableState.State.ENABLED : TableState.State.DISABLED;
                for (TableName table : tableNames) {
                    if (!((HMaster)this.server).getTableStateManager().isTableState(table, state)) continue;
                    builder.addTableNames(ProtobufUtil.toProtoTableName((TableName)table));
                }
            }
            return builder.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.GetTableStateResponse getTableState(RpcController controller, MasterProtos.GetTableStateRequest request) throws ServiceException {
        try {
            ((HMaster)this.server).checkServiceStarted();
            TableName tableName = ProtobufUtil.toTableName((HBaseProtos.TableName)request.getTableName());
            TableState ts = ((HMaster)this.server).getTableStateManager().getTableState(tableName);
            MasterProtos.GetTableStateResponse.Builder builder = MasterProtos.GetTableStateResponse.newBuilder();
            builder.setTableState(ts.convert());
            return builder.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.IsCatalogJanitorEnabledResponse isCatalogJanitorEnabled(RpcController c, MasterProtos.IsCatalogJanitorEnabledRequest req) throws ServiceException {
        return MasterProtos.IsCatalogJanitorEnabledResponse.newBuilder().setValue(((HMaster)this.server).isCatalogJanitorEnabled()).build();
    }

    public MasterProtos.IsCleanerChoreEnabledResponse isCleanerChoreEnabled(RpcController c, MasterProtos.IsCleanerChoreEnabledRequest req) throws ServiceException {
        return MasterProtos.IsCleanerChoreEnabledResponse.newBuilder().setValue(((HMaster)this.server).isCleanerChoreEnabled()).build();
    }

    public MasterProtos.IsMasterRunningResponse isMasterRunning(RpcController c, MasterProtos.IsMasterRunningRequest req) throws ServiceException {
        try {
            ((HMaster)this.server).checkServiceStarted();
            return MasterProtos.IsMasterRunningResponse.newBuilder().setIsMasterRunning(!((HMaster)this.server).isStopped()).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.IsProcedureDoneResponse isProcedureDone(RpcController controller, MasterProtos.IsProcedureDoneRequest request) throws ServiceException {
        try {
            ((HMaster)this.server).checkInitialized();
            HBaseProtos.ProcedureDescription desc = request.getProcedure();
            MasterProcedureManager mpm = ((HMaster)this.server).getMasterProcedureManagerHost().getProcedureManager(desc.getSignature());
            if (mpm == null) {
                throw new ServiceException("The procedure is not registered: " + desc.getSignature());
            }
            LOG.debug("Checking to see if procedure from request:" + desc.getSignature() + " is done");
            MasterProtos.IsProcedureDoneResponse.Builder builder = MasterProtos.IsProcedureDoneResponse.newBuilder();
            boolean done = mpm.isProcedureDone(desc);
            builder.setDone(done);
            return builder.build();
        }
        catch (ForeignException e) {
            throw new ServiceException(e.getCause());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.IsSnapshotDoneResponse isSnapshotDone(RpcController controller, MasterProtos.IsSnapshotDoneRequest request) throws ServiceException {
        LOG.debug("Checking to see if snapshot from request:" + ClientSnapshotDescriptionUtils.toString((SnapshotProtos.SnapshotDescription)request.getSnapshot()) + " is done");
        try {
            ((HMaster)this.server).checkInitialized();
            MasterProtos.IsSnapshotDoneResponse.Builder builder = MasterProtos.IsSnapshotDoneResponse.newBuilder();
            boolean done = ((HMaster)this.server).snapshotManager.isSnapshotDone(request.getSnapshot());
            builder.setDone(done);
            return builder.build();
        }
        catch (ForeignException e) {
            throw new ServiceException(e.getCause());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.GetProcedureResultResponse getProcedureResult(RpcController controller, MasterProtos.GetProcedureResultRequest request) throws ServiceException {
        LOG.debug("Checking to see if procedure is done pid=" + request.getProcId());
        try {
            ((HMaster)this.server).checkInitialized();
            MasterProtos.GetProcedureResultResponse.Builder builder = MasterProtos.GetProcedureResultResponse.newBuilder();
            long procId = request.getProcId();
            ProcedureExecutor<MasterProcedureEnv> executor = ((HMaster)this.server).getMasterProcedureExecutor();
            Procedure result = executor.getResultOrProcedure(procId);
            if (result != null) {
                builder.setSubmittedTime(result.getSubmittedTime());
                builder.setLastUpdate(result.getLastUpdate());
                if (executor.isFinished(procId)) {
                    byte[] resultData;
                    builder.setState(MasterProtos.GetProcedureResultResponse.State.FINISHED);
                    if (result.isFailed()) {
                        IOException exception = MasterProcedureUtil.unwrapRemoteIOException(result);
                        builder.setException(ForeignExceptionUtil.toProtoForeignException((Throwable)exception));
                    }
                    if ((resultData = result.getResult()) != null) {
                        builder.setResult(UnsafeByteOperations.unsafeWrap((byte[])resultData));
                    }
                    ((HMaster)this.server).getMasterProcedureExecutor().removeResult(request.getProcId());
                } else {
                    builder.setState(MasterProtos.GetProcedureResultResponse.State.RUNNING);
                }
            } else {
                builder.setState(MasterProtos.GetProcedureResultResponse.State.NOT_FOUND);
            }
            return builder.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.AbortProcedureResponse abortProcedure(RpcController rpcController, MasterProtos.AbortProcedureRequest request) throws ServiceException {
        try {
            MasterProtos.AbortProcedureResponse.Builder response = MasterProtos.AbortProcedureResponse.newBuilder();
            boolean abortResult = ((HMaster)this.server).abortProcedure(request.getProcId(), request.getMayInterruptIfRunning());
            response.setIsProcedureAborted(abortResult);
            return response.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.ListNamespaceDescriptorsResponse listNamespaceDescriptors(RpcController c, MasterProtos.ListNamespaceDescriptorsRequest request) throws ServiceException {
        try {
            MasterProtos.ListNamespaceDescriptorsResponse.Builder response = MasterProtos.ListNamespaceDescriptorsResponse.newBuilder();
            for (NamespaceDescriptor ns : ((HMaster)this.server).getNamespaces()) {
                response.addNamespaceDescriptor(ProtobufUtil.toProtoNamespaceDescriptor((NamespaceDescriptor)ns));
            }
            return response.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.GetProceduresResponse getProcedures(RpcController rpcController, MasterProtos.GetProceduresRequest request) throws ServiceException {
        try {
            MasterProtos.GetProceduresResponse.Builder response = MasterProtos.GetProceduresResponse.newBuilder();
            for (Procedure<?> p : ((HMaster)this.server).getProcedures()) {
                response.addProcedure(ProcedureUtil.convertToProtoProcedure(p));
            }
            return response.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.GetLocksResponse getLocks(RpcController controller, MasterProtos.GetLocksRequest request) throws ServiceException {
        try {
            MasterProtos.GetLocksResponse.Builder builder = MasterProtos.GetLocksResponse.newBuilder();
            for (LockedResource lockedResource : ((HMaster)this.server).getLocks()) {
                builder.addLock(ProcedureUtil.convertToProtoLockedResource((LockedResource)lockedResource));
            }
            return builder.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.ListTableDescriptorsByNamespaceResponse listTableDescriptorsByNamespace(RpcController c, MasterProtos.ListTableDescriptorsByNamespaceRequest request) throws ServiceException {
        try {
            MasterProtos.ListTableDescriptorsByNamespaceResponse.Builder b = MasterProtos.ListTableDescriptorsByNamespaceResponse.newBuilder();
            for (TableDescriptor htd : ((HMaster)this.server).listTableDescriptorsByNamespace(request.getNamespaceName())) {
                b.addTableSchema(ProtobufUtil.toTableSchema((TableDescriptor)htd));
            }
            return b.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.ListTableNamesByNamespaceResponse listTableNamesByNamespace(RpcController c, MasterProtos.ListTableNamesByNamespaceRequest request) throws ServiceException {
        try {
            MasterProtos.ListTableNamesByNamespaceResponse.Builder b = MasterProtos.ListTableNamesByNamespaceResponse.newBuilder();
            for (TableName tableName : ((HMaster)this.server).listTableNamesByNamespace(request.getNamespaceName())) {
                b.addTableName(ProtobufUtil.toProtoTableName((TableName)tableName));
            }
            return b.build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.ModifyColumnResponse modifyColumn(RpcController controller, MasterProtos.ModifyColumnRequest req) throws ServiceException {
        try {
            long procId = ((HMaster)this.server).modifyColumn(ProtobufUtil.toTableName((HBaseProtos.TableName)req.getTableName()), ProtobufUtil.toColumnFamilyDescriptor((HBaseProtos.ColumnFamilySchema)req.getColumnFamilies()), req.getNonceGroup(), req.getNonce());
            if (procId == -1L) {
                return MasterProtos.ModifyColumnResponse.newBuilder().build();
            }
            return MasterProtos.ModifyColumnResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public MasterProtos.ModifyColumnStoreFileTrackerResponse modifyColumnStoreFileTracker(RpcController controller, MasterProtos.ModifyColumnStoreFileTrackerRequest req) throws ServiceException {
        try {
            long procId = ((HMaster)this.server).modifyColumnStoreFileTracker(ProtobufUtil.toTableName((HBaseProtos.TableName)req.getTableName()), req.getFamily().toByteArray(), req.getDstSft(), req.getNonceGroup(), req.getNonce());
            return MasterProtos.ModifyColumnStoreFileTrackerResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public MasterProtos.ModifyNamespaceResponse modifyNamespace(RpcController controller, MasterProtos.ModifyNamespaceRequest request) throws ServiceException {
        try {
            long procId = ((HMaster)this.server).modifyNamespace(ProtobufUtil.toNamespaceDescriptor((HBaseProtos.NamespaceDescriptor)request.getNamespaceDescriptor()), request.getNonceGroup(), request.getNonce());
            return MasterProtos.ModifyNamespaceResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.ModifyTableResponse modifyTable(RpcController controller, MasterProtos.ModifyTableRequest req) throws ServiceException {
        try {
            long procId = ((HMaster)this.server).modifyTable(ProtobufUtil.toTableName((HBaseProtos.TableName)req.getTableName()), ProtobufUtil.toTableDescriptor((HBaseProtos.TableSchema)req.getTableSchema()), req.getNonceGroup(), req.getNonce());
            return MasterProtos.ModifyTableResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public MasterProtos.ModifyTableStoreFileTrackerResponse modifyTableStoreFileTracker(RpcController controller, MasterProtos.ModifyTableStoreFileTrackerRequest req) throws ServiceException {
        try {
            long procId = ((HMaster)this.server).modifyTableStoreFileTracker(ProtobufUtil.toTableName((HBaseProtos.TableName)req.getTableName()), req.getDstSft(), req.getNonceGroup(), req.getNonce());
            return MasterProtos.ModifyTableStoreFileTrackerResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public MasterProtos.MoveRegionResponse moveRegion(RpcController controller, MasterProtos.MoveRegionRequest req) throws ServiceException {
        byte[] encodedRegionName = req.getRegion().getValue().toByteArray();
        HBaseProtos.RegionSpecifier.RegionSpecifierType type = req.getRegion().getType();
        byte[] destServerName = req.hasDestServerName() ? Bytes.toBytes((String)ProtobufUtil.toServerName((HBaseProtos.ServerName)req.getDestServerName()).getServerName()) : null;
        MasterProtos.MoveRegionResponse mrr = MasterProtos.MoveRegionResponse.newBuilder().build();
        if (type != HBaseProtos.RegionSpecifier.RegionSpecifierType.ENCODED_REGION_NAME) {
            LOG.warn("moveRegion specifier type: expected: " + HBaseProtos.RegionSpecifier.RegionSpecifierType.ENCODED_REGION_NAME + " actual: " + type);
        }
        try {
            ((HMaster)this.server).checkInitialized();
            ((HMaster)this.server).move(encodedRegionName, destServerName);
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
        return mrr;
    }

    public MasterProtos.OfflineRegionResponse offlineRegion(RpcController controller, MasterProtos.OfflineRegionRequest request) throws ServiceException {
        try {
            ((HMaster)this.server).checkInitialized();
            HBaseProtos.RegionSpecifier.RegionSpecifierType type = request.getRegion().getType();
            if (type != HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME) {
                LOG.warn("moveRegion specifier type: expected: " + HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME + " actual: " + type);
            }
            byte[] regionName = request.getRegion().getValue().toByteArray();
            RegionInfo hri = ((HMaster)this.server).getAssignmentManager().getRegionInfo(regionName);
            if (hri == null) {
                throw new UnknownRegionException(Bytes.toStringBinary((byte[])regionName));
            }
            if (((HMaster)this.server).cpHost != null) {
                ((HMaster)this.server).cpHost.preRegionOffline(hri);
            }
            LOG.info(((HMaster)this.server).getClientIdAuditPrefix() + " offline " + hri.getRegionNameAsString());
            ((HMaster)this.server).getAssignmentManager().offlineRegion(hri);
            if (((HMaster)this.server).cpHost != null) {
                ((HMaster)this.server).cpHost.postRegionOffline(hri);
            }
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
        return MasterProtos.OfflineRegionResponse.newBuilder().build();
    }

    public MasterProtos.RestoreSnapshotResponse restoreSnapshot(RpcController controller, MasterProtos.RestoreSnapshotRequest request) throws ServiceException {
        try {
            long procId = ((HMaster)this.server).restoreSnapshot(request.getSnapshot(), request.getNonceGroup(), request.getNonce(), request.getRestoreACL(), request.getCustomSFT());
            return MasterProtos.RestoreSnapshotResponse.newBuilder().setProcId(procId).build();
        }
        catch (ForeignException e) {
            throw new ServiceException(e.getCause());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.SetSnapshotCleanupResponse switchSnapshotCleanup(RpcController controller, MasterProtos.SetSnapshotCleanupRequest request) throws ServiceException {
        try {
            ((HMaster)this.server).checkInitialized();
            boolean enabled = request.getEnabled();
            boolean isSynchronous = request.hasSynchronous() && request.getSynchronous();
            boolean prevSnapshotCleanupRunning = this.switchSnapshotCleanup(enabled, isSynchronous);
            return MasterProtos.SetSnapshotCleanupResponse.newBuilder().setPrevSnapshotCleanup(prevSnapshotCleanupRunning).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.IsSnapshotCleanupEnabledResponse isSnapshotCleanupEnabled(RpcController controller, MasterProtos.IsSnapshotCleanupEnabledRequest request) throws ServiceException {
        try {
            ((HMaster)this.server).checkInitialized();
            boolean isSnapshotCleanupEnabled = ((HMaster)this.server).snapshotCleanupStateStore.get();
            return MasterProtos.IsSnapshotCleanupEnabledResponse.newBuilder().setEnabled(isSnapshotCleanupEnabled).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    private synchronized boolean switchSnapshotCleanup(boolean enabledNewVal, boolean synchronous) throws IOException {
        boolean oldValue = ((HMaster)this.server).snapshotCleanupStateStore.get();
        ((HMaster)this.server).switchSnapshotCleanup(enabledNewVal, synchronous);
        LOG.info("{} Successfully set snapshot cleanup to {}", (Object)((HMaster)this.server).getClientIdAuditPrefix(), (Object)enabledNewVal);
        return oldValue;
    }

    public MasterProtos.RunCatalogScanResponse runCatalogScan(RpcController c, MasterProtos.RunCatalogScanRequest req) throws ServiceException {
        this.rpcPreCheck("runCatalogScan");
        try {
            return ResponseConverter.buildRunCatalogScanResponse((int)((HMaster)this.server).catalogJanitorChore.scan());
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public MasterProtos.RunCleanerChoreResponse runCleanerChore(RpcController c, MasterProtos.RunCleanerChoreRequest req) throws ServiceException {
        this.rpcPreCheck("runCleanerChore");
        try {
            CompletableFuture<Boolean> fileCleanerFuture = ((HMaster)this.server).getHFileCleaner().triggerCleanerNow();
            CompletableFuture<Boolean> logCleanerFuture = ((HMaster)this.server).getLogCleaner().triggerCleanerNow();
            boolean result = fileCleanerFuture.get() != false && logCleanerFuture.get() != false;
            return ResponseConverter.buildRunCleanerChoreResponse((boolean)result);
        }
        catch (InterruptedException e) {
            throw new ServiceException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new ServiceException(e.getCause());
        }
    }

    public MasterProtos.SetBalancerRunningResponse setBalancerRunning(RpcController c, MasterProtos.SetBalancerRunningRequest req) throws ServiceException {
        try {
            ((HMaster)this.server).checkInitialized();
            boolean prevValue = req.getSynchronous() ? this.synchronousBalanceSwitch(req.getOn()) : ((HMaster)this.server).balanceSwitch(req.getOn());
            return MasterProtos.SetBalancerRunningResponse.newBuilder().setPrevBalanceValue(prevValue).build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public MasterProtos.ShutdownResponse shutdown(RpcController controller, MasterProtos.ShutdownRequest request) throws ServiceException {
        LOG.info(((HMaster)this.server).getClientIdAuditPrefix() + " shutdown");
        try {
            ((HMaster)this.server).shutdown();
        }
        catch (IOException e) {
            LOG.error("Exception occurred in HMaster.shutdown()", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        return MasterProtos.ShutdownResponse.newBuilder().build();
    }

    public MasterProtos.SnapshotResponse snapshot(RpcController controller, MasterProtos.SnapshotRequest request) throws ServiceException {
        try {
            ((HMaster)this.server).checkInitialized();
            ((HMaster)this.server).snapshotManager.checkSnapshotSupport();
            LOG.info(((HMaster)this.server).getClientIdAuditPrefix() + " snapshot request for:" + ClientSnapshotDescriptionUtils.toString((SnapshotProtos.SnapshotDescription)request.getSnapshot()));
            SnapshotProtos.SnapshotDescription snapshot = SnapshotDescriptionUtils.validate(request.getSnapshot(), ((HMaster)this.server).getConfiguration());
            long waitTime = SnapshotDescriptionUtils.getMaxMasterTimeout(((HMaster)this.server).getConfiguration(), snapshot.getType(), 300000L);
            MasterProtos.SnapshotResponse.Builder builder = MasterProtos.SnapshotResponse.newBuilder().setExpectedTimeout(waitTime);
            if (request.hasNonceGroup() && request.hasNonce() && ((HMaster)this.server).snapshotManager.snapshotProcedureEnabled()) {
                long nonceGroup = request.getNonceGroup();
                long nonce = request.getNonce();
                long procId = ((HMaster)this.server).snapshotManager.takeSnapshot(snapshot, nonceGroup, nonce);
                return builder.setProcId(procId).build();
            }
            ((HMaster)this.server).snapshotManager.takeSnapshot(snapshot);
            return builder.build();
        }
        catch (ForeignException e) {
            throw new ServiceException(e.getCause());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.StopMasterResponse stopMaster(RpcController controller, MasterProtos.StopMasterRequest request) throws ServiceException {
        LOG.info(((HMaster)this.server).getClientIdAuditPrefix() + " stop");
        try {
            ((HMaster)this.server).stopMaster();
        }
        catch (IOException e) {
            LOG.error("Exception occurred while stopping master", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        return MasterProtos.StopMasterResponse.newBuilder().build();
    }

    public MasterProtos.IsInMaintenanceModeResponse isMasterInMaintenanceMode(RpcController controller, MasterProtos.IsInMaintenanceModeRequest request) throws ServiceException {
        MasterProtos.IsInMaintenanceModeResponse.Builder response = MasterProtos.IsInMaintenanceModeResponse.newBuilder();
        response.setInMaintenanceMode(((HMaster)this.server).isInMaintenanceMode());
        return response.build();
    }

    public MasterProtos.UnassignRegionResponse unassignRegion(RpcController controller, MasterProtos.UnassignRegionRequest req) throws ServiceException {
        try {
            RegionStateNode rsn;
            byte[] regionName = req.getRegion().getValue().toByteArray();
            HBaseProtos.RegionSpecifier.RegionSpecifierType type = req.getRegion().getType();
            MasterProtos.UnassignRegionResponse urr = MasterProtos.UnassignRegionResponse.newBuilder().build();
            ((HMaster)this.server).checkInitialized();
            if (type != HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME) {
                LOG.warn("unassignRegion specifier type: expected: " + HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME + " actual: " + type);
            }
            if ((rsn = ((HMaster)this.server).getAssignmentManager().getRegionStates().getRegionStateNodeFromName(regionName)) == null) {
                throw new UnknownRegionException(Bytes.toString((byte[])regionName));
            }
            RegionInfo hri = rsn.getRegionInfo();
            if (((HMaster)this.server).cpHost != null) {
                ((HMaster)this.server).cpHost.preUnassign(hri);
            }
            LOG.debug(((HMaster)this.server).getClientIdAuditPrefix() + " unassign " + hri.getRegionNameAsString() + " in current location if it is online");
            ((HMaster)this.server).getAssignmentManager().unassign(hri);
            if (((HMaster)this.server).cpHost != null) {
                ((HMaster)this.server).cpHost.postUnassign(hri);
            }
            return urr;
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public RegionServerStatusProtos.ReportRegionStateTransitionResponse reportRegionStateTransition(RpcController c, RegionServerStatusProtos.ReportRegionStateTransitionRequest req) throws ServiceException {
        try {
            ((HMaster)this.server).checkServiceStarted();
            return ((HMaster)this.server).getAssignmentManager().reportRegionStateTransition(req);
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public MasterProtos.SetQuotaResponse setQuota(RpcController c, MasterProtos.SetQuotaRequest req) throws ServiceException {
        try {
            ((HMaster)this.server).checkInitialized();
            return ((HMaster)this.server).getMasterQuotaManager().setQuota(req);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.MajorCompactionTimestampResponse getLastMajorCompactionTimestamp(RpcController controller, MasterProtos.MajorCompactionTimestampRequest request) throws ServiceException {
        MasterProtos.MajorCompactionTimestampResponse.Builder response = MasterProtos.MajorCompactionTimestampResponse.newBuilder();
        try {
            ((HMaster)this.server).checkInitialized();
            response.setCompactionTimestamp(((HMaster)this.server).getLastMajorCompactionTimestamp(ProtobufUtil.toTableName((HBaseProtos.TableName)request.getTableName())));
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return response.build();
    }

    public MasterProtos.MajorCompactionTimestampResponse getLastMajorCompactionTimestampForRegion(RpcController controller, MasterProtos.MajorCompactionTimestampForRegionRequest request) throws ServiceException {
        MasterProtos.MajorCompactionTimestampResponse.Builder response = MasterProtos.MajorCompactionTimestampResponse.newBuilder();
        try {
            ((HMaster)this.server).checkInitialized();
            response.setCompactionTimestamp(((HMaster)this.server).getLastMajorCompactionTimestampForRegion(request.getRegion().getValue().toByteArray()));
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return response.build();
    }

    public MasterProtos.IsBalancerEnabledResponse isBalancerEnabled(RpcController controller, MasterProtos.IsBalancerEnabledRequest request) throws ServiceException {
        MasterProtos.IsBalancerEnabledResponse.Builder response = MasterProtos.IsBalancerEnabledResponse.newBuilder();
        response.setEnabled(((HMaster)this.server).isBalancerOn());
        return response.build();
    }

    public MasterProtos.SetSplitOrMergeEnabledResponse setSplitOrMergeEnabled(RpcController controller, MasterProtos.SetSplitOrMergeEnabledRequest request) throws ServiceException {
        MasterProtos.SetSplitOrMergeEnabledResponse.Builder response = MasterProtos.SetSplitOrMergeEnabledResponse.newBuilder();
        try {
            ((HMaster)this.server).checkInitialized();
            boolean newValue = request.getEnabled();
            for (MasterProtos.MasterSwitchType masterSwitchType : request.getSwitchTypesList()) {
                MasterSwitchType switchType = this.convert(masterSwitchType);
                boolean oldValue = ((HMaster)this.server).isSplitOrMergeEnabled(switchType);
                response.addPrevValue(oldValue);
                if (((HMaster)this.server).cpHost != null) {
                    ((HMaster)this.server).cpHost.preSetSplitOrMergeEnabled(newValue, switchType);
                }
                ((HMaster)this.server).getSplitOrMergeStateStore().setSplitOrMergeEnabled(newValue, switchType);
                if (((HMaster)this.server).cpHost == null) continue;
                ((HMaster)this.server).cpHost.postSetSplitOrMergeEnabled(newValue, switchType);
            }
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return response.build();
    }

    public MasterProtos.IsSplitOrMergeEnabledResponse isSplitOrMergeEnabled(RpcController controller, MasterProtos.IsSplitOrMergeEnabledRequest request) throws ServiceException {
        MasterProtos.IsSplitOrMergeEnabledResponse.Builder response = MasterProtos.IsSplitOrMergeEnabledResponse.newBuilder();
        response.setEnabled(((HMaster)this.server).isSplitOrMergeEnabled(this.convert(request.getSwitchType())));
        return response.build();
    }

    public MasterProtos.NormalizeResponse normalize(RpcController controller, MasterProtos.NormalizeRequest request) throws ServiceException {
        this.rpcPreCheck("normalize");
        try {
            NormalizeTableFilterParams ntfp = new NormalizeTableFilterParams.Builder().tableNames(ProtobufUtil.toTableNameList((List)request.getTableNamesList())).regex(request.hasRegex() ? request.getRegex() : null).namespace(request.hasNamespace() ? request.getNamespace() : null).build();
            return MasterProtos.NormalizeResponse.newBuilder().setNormalizerRan(((HMaster)this.server).normalizeRegions(ntfp, true)).build();
        }
        catch (IOException ex) {
            throw new ServiceException((Throwable)ex);
        }
    }

    public MasterProtos.SetNormalizerRunningResponse setNormalizerRunning(RpcController controller, MasterProtos.SetNormalizerRunningRequest request) throws ServiceException {
        this.rpcPreCheck("setNormalizerRunning");
        boolean prevValue = ((HMaster)this.server).getRegionNormalizerManager().isNormalizerOn();
        boolean newValue = request.getOn();
        try {
            ((HMaster)this.server).getRegionNormalizerManager().setNormalizerOn(newValue);
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        LOG.info("{} set normalizerSwitch={}", (Object)((HMaster)this.server).getClientIdAuditPrefix(), (Object)newValue);
        return MasterProtos.SetNormalizerRunningResponse.newBuilder().setPrevNormalizerValue(prevValue).build();
    }

    public MasterProtos.IsNormalizerEnabledResponse isNormalizerEnabled(RpcController controller, MasterProtos.IsNormalizerEnabledRequest request) {
        MasterProtos.IsNormalizerEnabledResponse.Builder response = MasterProtos.IsNormalizerEnabledResponse.newBuilder();
        response.setEnabled(((HMaster)this.server).isNormalizerOn());
        return response.build();
    }

    public MasterProtos.SecurityCapabilitiesResponse getSecurityCapabilities(RpcController controller, MasterProtos.SecurityCapabilitiesRequest request) throws ServiceException {
        MasterProtos.SecurityCapabilitiesResponse.Builder response = MasterProtos.SecurityCapabilitiesResponse.newBuilder();
        try {
            ((HMaster)this.server).checkInitialized();
            HashSet<MasterProtos.SecurityCapabilitiesResponse.Capability> capabilities = new HashSet<MasterProtos.SecurityCapabilitiesResponse.Capability>();
            if (User.isHBaseSecurityEnabled((Configuration)((HMaster)this.server).getConfiguration())) {
                capabilities.add(MasterProtos.SecurityCapabilitiesResponse.Capability.SECURE_AUTHENTICATION);
            } else {
                capabilities.add(MasterProtos.SecurityCapabilitiesResponse.Capability.SIMPLE_AUTHENTICATION);
            }
            if (((HMaster)this.server).cpHost != null && this.hasAccessControlServiceCoprocessor(((HMaster)this.server).cpHost)) {
                if (AccessChecker.isAuthorizationSupported(((HMaster)this.server).getConfiguration())) {
                    capabilities.add(MasterProtos.SecurityCapabilitiesResponse.Capability.AUTHORIZATION);
                }
                if (AccessController.isCellAuthorizationSupported(((HMaster)this.server).getConfiguration())) {
                    capabilities.add(MasterProtos.SecurityCapabilitiesResponse.Capability.CELL_AUTHORIZATION);
                }
            }
            if (((HMaster)this.server).cpHost != null && this.hasVisibilityLabelsServiceCoprocessor(((HMaster)this.server).cpHost) && VisibilityController.isCellAuthorizationSupported(((HMaster)this.server).getConfiguration())) {
                capabilities.add(MasterProtos.SecurityCapabilitiesResponse.Capability.CELL_VISIBILITY);
            }
            response.addAllCapabilities(capabilities);
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return response.build();
    }

    boolean hasAccessControlServiceCoprocessor(MasterCoprocessorHost cpHost) {
        return this.checkCoprocessorWithService(cpHost.findCoprocessors(MasterCoprocessor.class), AccessControlProtos.AccessControlService.Interface.class);
    }

    boolean hasVisibilityLabelsServiceCoprocessor(MasterCoprocessorHost cpHost) {
        return this.checkCoprocessorWithService(cpHost.findCoprocessors(MasterCoprocessor.class), VisibilityLabelsProtos.VisibilityLabelsService.Interface.class);
    }

    boolean checkCoprocessorWithService(List<MasterCoprocessor> coprocessorsToCheck, Class<?> service) {
        if (coprocessorsToCheck == null || coprocessorsToCheck.isEmpty()) {
            return false;
        }
        for (MasterCoprocessor cp : coprocessorsToCheck) {
            if (!service.isAssignableFrom(cp.getClass())) continue;
            return true;
        }
        return false;
    }

    private MasterSwitchType convert(MasterProtos.MasterSwitchType switchType) {
        switch (switchType) {
            case SPLIT: {
                return MasterSwitchType.SPLIT;
            }
            case MERGE: {
                return MasterSwitchType.MERGE;
            }
        }
        return null;
    }

    public ReplicationProtos.AddReplicationPeerResponse addReplicationPeer(RpcController controller, ReplicationProtos.AddReplicationPeerRequest request) throws ServiceException {
        try {
            long procId = ((HMaster)this.server).addReplicationPeer(request.getPeerId(), ReplicationPeerConfigUtil.convert((ReplicationProtos.ReplicationPeer)request.getPeerConfig()), request.getPeerState().getState().equals((Object)ReplicationProtos.ReplicationState.State.ENABLED));
            return ReplicationProtos.AddReplicationPeerResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException | ReplicationException e) {
            throw new ServiceException(e);
        }
    }

    public ReplicationProtos.RemoveReplicationPeerResponse removeReplicationPeer(RpcController controller, ReplicationProtos.RemoveReplicationPeerRequest request) throws ServiceException {
        try {
            long procId = ((HMaster)this.server).removeReplicationPeer(request.getPeerId());
            return ReplicationProtos.RemoveReplicationPeerResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException | ReplicationException e) {
            throw new ServiceException(e);
        }
    }

    public ReplicationProtos.EnableReplicationPeerResponse enableReplicationPeer(RpcController controller, ReplicationProtos.EnableReplicationPeerRequest request) throws ServiceException {
        try {
            long procId = ((HMaster)this.server).enableReplicationPeer(request.getPeerId());
            return ReplicationProtos.EnableReplicationPeerResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException | ReplicationException e) {
            throw new ServiceException(e);
        }
    }

    public ReplicationProtos.DisableReplicationPeerResponse disableReplicationPeer(RpcController controller, ReplicationProtos.DisableReplicationPeerRequest request) throws ServiceException {
        try {
            long procId = ((HMaster)this.server).disableReplicationPeer(request.getPeerId());
            return ReplicationProtos.DisableReplicationPeerResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException | ReplicationException e) {
            throw new ServiceException(e);
        }
    }

    public ReplicationProtos.GetReplicationPeerConfigResponse getReplicationPeerConfig(RpcController controller, ReplicationProtos.GetReplicationPeerConfigRequest request) throws ServiceException {
        ReplicationProtos.GetReplicationPeerConfigResponse.Builder response = ReplicationProtos.GetReplicationPeerConfigResponse.newBuilder();
        try {
            String peerId = request.getPeerId();
            ReplicationPeerConfig peerConfig = ((HMaster)this.server).getReplicationPeerConfig(peerId);
            response.setPeerId(peerId);
            response.setPeerConfig(ReplicationPeerConfigUtil.convert((ReplicationPeerConfig)peerConfig));
        }
        catch (IOException | ReplicationException e) {
            throw new ServiceException(e);
        }
        return response.build();
    }

    public ReplicationProtos.UpdateReplicationPeerConfigResponse updateReplicationPeerConfig(RpcController controller, ReplicationProtos.UpdateReplicationPeerConfigRequest request) throws ServiceException {
        try {
            long procId = ((HMaster)this.server).updateReplicationPeerConfig(request.getPeerId(), ReplicationPeerConfigUtil.convert((ReplicationProtos.ReplicationPeer)request.getPeerConfig()));
            return ReplicationProtos.UpdateReplicationPeerConfigResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException | ReplicationException e) {
            throw new ServiceException(e);
        }
    }

    public ReplicationProtos.TransitReplicationPeerSyncReplicationStateResponse transitReplicationPeerSyncReplicationState(RpcController controller, ReplicationProtos.TransitReplicationPeerSyncReplicationStateRequest request) throws ServiceException {
        try {
            long procId = ((HMaster)this.server).transitReplicationPeerSyncReplicationState(request.getPeerId(), ReplicationPeerConfigUtil.toSyncReplicationState((ReplicationProtos.SyncReplicationState)request.getSyncReplicationState()));
            return ReplicationProtos.TransitReplicationPeerSyncReplicationStateResponse.newBuilder().setProcId(procId).build();
        }
        catch (IOException | ReplicationException e) {
            throw new ServiceException(e);
        }
    }

    public ReplicationProtos.ListReplicationPeersResponse listReplicationPeers(RpcController controller, ReplicationProtos.ListReplicationPeersRequest request) throws ServiceException {
        ReplicationProtos.ListReplicationPeersResponse.Builder response = ReplicationProtos.ListReplicationPeersResponse.newBuilder();
        try {
            List<ReplicationPeerDescription> peers = ((HMaster)this.server).listReplicationPeers(request.hasRegex() ? request.getRegex() : null);
            for (ReplicationPeerDescription peer : peers) {
                response.addPeerDesc(ReplicationPeerConfigUtil.toProtoReplicationPeerDescription((ReplicationPeerDescription)peer));
            }
        }
        catch (IOException | ReplicationException e) {
            throw new ServiceException(e);
        }
        return response.build();
    }

    public ReplicationProtos.GetReplicationPeerStateResponse isReplicationPeerEnabled(RpcController controller, ReplicationProtos.GetReplicationPeerStateRequest request) throws ServiceException {
        boolean isEnabled;
        try {
            isEnabled = ((HMaster)this.server).getReplicationPeerManager().getPeerState(request.getPeerId());
        }
        catch (ReplicationException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
        return ReplicationProtos.GetReplicationPeerStateResponse.newBuilder().setIsEnabled(isEnabled).build();
    }

    public ReplicationProtos.ReplicationPeerModificationSwitchResponse replicationPeerModificationSwitch(RpcController controller, ReplicationProtos.ReplicationPeerModificationSwitchRequest request) throws ServiceException {
        try {
            ((HMaster)this.server).checkInitialized();
            boolean prevValue = ((HMaster)this.server).replicationPeerModificationSwitch(request.getOn());
            return ReplicationProtos.ReplicationPeerModificationSwitchResponse.newBuilder().setPreviousValue(prevValue).build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public ReplicationProtos.GetReplicationPeerModificationProceduresResponse getReplicationPeerModificationProcedures(RpcController controller, ReplicationProtos.GetReplicationPeerModificationProceduresRequest request) throws ServiceException {
        try {
            ((HMaster)this.server).checkInitialized();
            ReplicationProtos.GetReplicationPeerModificationProceduresResponse.Builder builder = ReplicationProtos.GetReplicationPeerModificationProceduresResponse.newBuilder();
            for (Procedure<?> proc : ((HMaster)this.server).getProcedures()) {
                if (proc.isFinished() || !(proc instanceof AbstractPeerNoLockProcedure)) continue;
                builder.addProcedure(ProcedureUtil.convertToProtoProcedure(proc));
            }
            return builder.build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public ReplicationProtos.IsReplicationPeerModificationEnabledResponse isReplicationPeerModificationEnabled(RpcController controller, ReplicationProtos.IsReplicationPeerModificationEnabledRequest request) throws ServiceException {
        try {
            ((HMaster)this.server).checkInitialized();
            return ReplicationProtos.IsReplicationPeerModificationEnabledResponse.newBuilder().setEnabled(((HMaster)this.server).isReplicationPeerModificationEnabled()).build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public MasterProtos.ListDecommissionedRegionServersResponse listDecommissionedRegionServers(RpcController controller, MasterProtos.ListDecommissionedRegionServersRequest request) throws ServiceException {
        MasterProtos.ListDecommissionedRegionServersResponse.Builder response = MasterProtos.ListDecommissionedRegionServersResponse.newBuilder();
        try {
            ((HMaster)this.server).checkInitialized();
            if (((HMaster)this.server).cpHost != null) {
                ((HMaster)this.server).cpHost.preListDecommissionedRegionServers();
            }
            List<ServerName> servers = ((HMaster)this.server).listDecommissionedRegionServers();
            response.addAllServerName((Iterable)servers.stream().map(server -> ProtobufUtil.toServerName((ServerName)server)).collect(Collectors.toList()));
            if (((HMaster)this.server).cpHost != null) {
                ((HMaster)this.server).cpHost.postListDecommissionedRegionServers();
            }
        }
        catch (IOException io) {
            throw new ServiceException((Throwable)io);
        }
        return response.build();
    }

    public MasterProtos.DecommissionRegionServersResponse decommissionRegionServers(RpcController controller, MasterProtos.DecommissionRegionServersRequest request) throws ServiceException {
        try {
            ((HMaster)this.server).checkInitialized();
            List<ServerName> servers = request.getServerNameList().stream().map(pbServer -> ProtobufUtil.toServerName((HBaseProtos.ServerName)pbServer)).collect(Collectors.toList());
            boolean offload = request.getOffload();
            if (((HMaster)this.server).cpHost != null) {
                ((HMaster)this.server).cpHost.preDecommissionRegionServers(servers, offload);
            }
            ((HMaster)this.server).decommissionRegionServers(servers, offload);
            if (((HMaster)this.server).cpHost != null) {
                ((HMaster)this.server).cpHost.postDecommissionRegionServers(servers, offload);
            }
        }
        catch (IOException io) {
            throw new ServiceException((Throwable)io);
        }
        return MasterProtos.DecommissionRegionServersResponse.newBuilder().build();
    }

    public MasterProtos.RecommissionRegionServerResponse recommissionRegionServer(RpcController controller, MasterProtos.RecommissionRegionServerRequest request) throws ServiceException {
        try {
            ((HMaster)this.server).checkInitialized();
            ServerName sn = ProtobufUtil.toServerName((HBaseProtos.ServerName)request.getServerName());
            List<byte[]> encodedRegionNames = request.getRegionList().stream().map(regionSpecifier -> regionSpecifier.getValue().toByteArray()).collect(Collectors.toList());
            if (((HMaster)this.server).cpHost != null) {
                ((HMaster)this.server).cpHost.preRecommissionRegionServer(sn, encodedRegionNames);
            }
            ((HMaster)this.server).recommissionRegionServer(sn, encodedRegionNames);
            if (((HMaster)this.server).cpHost != null) {
                ((HMaster)this.server).cpHost.postRecommissionRegionServer(sn, encodedRegionNames);
            }
        }
        catch (IOException io) {
            throw new ServiceException((Throwable)io);
        }
        return MasterProtos.RecommissionRegionServerResponse.newBuilder().build();
    }

    public LockServiceProtos.LockResponse requestLock(RpcController controller, final LockServiceProtos.LockRequest request) throws ServiceException {
        try {
            MasterProcedureUtil.NonceProcedureRunnable npr;
            if (request.getDescription().isEmpty()) {
                throw new IllegalArgumentException("Empty description");
            }
            final LockType type = LockType.valueOf((String)request.getLockType().name());
            if (request.getRegionInfoCount() > 0) {
                final RegionInfo[] regionInfos = new RegionInfo[request.getRegionInfoCount()];
                for (int i = 0; i < request.getRegionInfoCount(); ++i) {
                    regionInfos[i] = ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)request.getRegionInfo(i));
                }
                npr = new MasterProcedureUtil.NonceProcedureRunnable((MasterServices)((Object)this.server), request.getNonceGroup(), request.getNonce()){

                    @Override
                    protected void run() throws IOException {
                        this.setProcId(((HMaster)MasterRpcServices.this.server).getLockManager().remoteLocks().requestRegionsLock(regionInfos, request.getDescription(), this.getNonceKey()));
                    }

                    @Override
                    protected String getDescription() {
                        return "RequestLock";
                    }
                };
            } else if (request.hasTableName()) {
                final TableName tableName = ProtobufUtil.toTableName((HBaseProtos.TableName)request.getTableName());
                npr = new MasterProcedureUtil.NonceProcedureRunnable((MasterServices)((Object)this.server), request.getNonceGroup(), request.getNonce()){

                    @Override
                    protected void run() throws IOException {
                        this.setProcId(((HMaster)MasterRpcServices.this.server).getLockManager().remoteLocks().requestTableLock(tableName, type, request.getDescription(), this.getNonceKey()));
                    }

                    @Override
                    protected String getDescription() {
                        return "RequestLock";
                    }
                };
            } else if (request.hasNamespace()) {
                npr = new MasterProcedureUtil.NonceProcedureRunnable((MasterServices)((Object)this.server), request.getNonceGroup(), request.getNonce()){

                    @Override
                    protected void run() throws IOException {
                        this.setProcId(((HMaster)MasterRpcServices.this.server).getLockManager().remoteLocks().requestNamespaceLock(request.getNamespace(), type, request.getDescription(), this.getNonceKey()));
                    }

                    @Override
                    protected String getDescription() {
                        return "RequestLock";
                    }
                };
            } else {
                throw new IllegalArgumentException("one of table/namespace/region should be specified");
            }
            long procId = MasterProcedureUtil.submitProcedure(npr);
            return LockServiceProtos.LockResponse.newBuilder().setProcId(procId).build();
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Exception when queuing lock", (Throwable)e);
            throw new ServiceException((Throwable)new DoNotRetryIOException((Throwable)e));
        }
        catch (IOException e) {
            LOG.warn("Exception when queuing lock", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public LockServiceProtos.LockHeartbeatResponse lockHeartbeat(RpcController controller, LockServiceProtos.LockHeartbeatRequest request) throws ServiceException {
        try {
            if (((HMaster)this.server).getLockManager().remoteLocks().lockHeartbeat(request.getProcId(), request.getKeepAlive())) {
                return LockServiceProtos.LockHeartbeatResponse.newBuilder().setTimeoutMs(((HMaster)this.server).getConfiguration().getInt("hbase.master.procedure.remote.locks.timeout.ms", 30000)).setLockStatus(LockServiceProtos.LockHeartbeatResponse.LockStatus.LOCKED).build();
            }
            return LockServiceProtos.LockHeartbeatResponse.newBuilder().setLockStatus(LockServiceProtos.LockHeartbeatResponse.LockStatus.UNLOCKED).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public RegionServerStatusProtos.RegionSpaceUseReportResponse reportRegionSpaceUse(RpcController controller, RegionServerStatusProtos.RegionSpaceUseReportRequest request) throws ServiceException {
        try {
            ((HMaster)this.server).checkInitialized();
            if (!QuotaUtil.isQuotaEnabled(((HMaster)this.server).getConfiguration())) {
                return RegionServerStatusProtos.RegionSpaceUseReportResponse.newBuilder().build();
            }
            MasterQuotaManager quotaManager = ((HMaster)this.server).getMasterQuotaManager();
            if (quotaManager != null) {
                long now = EnvironmentEdgeManager.currentTime();
                for (RegionServerStatusProtos.RegionSpaceUse report : request.getSpaceUseList()) {
                    quotaManager.addRegionSize(ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)report.getRegionInfo()), report.getRegionSize(), now);
                }
            } else {
                LOG.debug("Received region space usage report but HMaster is not ready to process it, skipping");
            }
            return RegionServerStatusProtos.RegionSpaceUseReportResponse.newBuilder().build();
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public QuotaProtos.GetSpaceQuotaRegionSizesResponse getSpaceQuotaRegionSizes(RpcController controller, QuotaProtos.GetSpaceQuotaRegionSizesRequest request) throws ServiceException {
        try {
            ((HMaster)this.server).checkInitialized();
            MasterQuotaManager quotaManager = ((HMaster)this.server).getMasterQuotaManager();
            QuotaProtos.GetSpaceQuotaRegionSizesResponse.Builder builder = QuotaProtos.GetSpaceQuotaRegionSizesResponse.newBuilder();
            if (quotaManager != null) {
                Map<RegionInfo, Long> regionSizes = quotaManager.snapshotRegionSizes();
                HashMap<TableName, Long> regionSizesByTable = new HashMap<TableName, Long>();
                for (Map.Entry<RegionInfo, Long> entry : regionSizes.entrySet()) {
                    TableName tableName = entry.getKey().getTable();
                    Long prevSize = (Long)regionSizesByTable.get(tableName);
                    if (prevSize == null) {
                        prevSize = 0L;
                    }
                    regionSizesByTable.put(tableName, prevSize + entry.getValue());
                }
                for (Map.Entry<Object, Long> entry : regionSizesByTable.entrySet()) {
                    builder.addSizes(QuotaProtos.GetSpaceQuotaRegionSizesResponse.RegionSizes.newBuilder().setTableName(ProtobufUtil.toProtoTableName((TableName)((TableName)entry.getKey()))).setSize(entry.getValue().longValue()).build());
                }
                return builder.build();
            }
            LOG.debug("Received space quota region size report but HMaster is not ready to process it,skipping");
            return builder.build();
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public QuotaProtos.GetQuotaStatesResponse getQuotaStates(RpcController controller, QuotaProtos.GetQuotaStatesRequest request) throws ServiceException {
        try {
            ((HMaster)this.server).checkInitialized();
            QuotaObserverChore quotaChore = ((HMaster)this.server).getQuotaObserverChore();
            QuotaProtos.GetQuotaStatesResponse.Builder builder = QuotaProtos.GetQuotaStatesResponse.newBuilder();
            if (quotaChore != null) {
                Map<TableName, SpaceQuotaSnapshot> tableSnapshots = quotaChore.getTableQuotaSnapshots();
                for (Map.Entry<TableName, SpaceQuotaSnapshot> entry : tableSnapshots.entrySet()) {
                    builder.addTableSnapshots(QuotaProtos.GetQuotaStatesResponse.TableQuotaSnapshot.newBuilder().setTableName(ProtobufUtil.toProtoTableName((TableName)entry.getKey())).setSnapshot(SpaceQuotaSnapshot.toProtoSnapshot((SpaceQuotaSnapshot)entry.getValue())).build());
                }
                Map<String, SpaceQuotaSnapshot> nsSnapshots = quotaChore.getNamespaceQuotaSnapshots();
                for (Map.Entry<String, SpaceQuotaSnapshot> entry : nsSnapshots.entrySet()) {
                    builder.addNsSnapshots(QuotaProtos.GetQuotaStatesResponse.NamespaceQuotaSnapshot.newBuilder().setNamespace(entry.getKey()).setSnapshot(SpaceQuotaSnapshot.toProtoSnapshot((SpaceQuotaSnapshot)entry.getValue())).build());
                }
                return builder.build();
            }
            return builder.build();
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.ClearDeadServersResponse clearDeadServers(RpcController controller, MasterProtos.ClearDeadServersRequest request) throws ServiceException {
        LOG.debug(((HMaster)this.server).getClientIdAuditPrefix() + " clear dead region servers.");
        MasterProtos.ClearDeadServersResponse.Builder response = MasterProtos.ClearDeadServersResponse.newBuilder();
        try {
            ((HMaster)this.server).checkInitialized();
            if (((HMaster)this.server).cpHost != null) {
                ((HMaster)this.server).cpHost.preClearDeadServers();
            }
            if (((HMaster)this.server).getServerManager().areDeadServersInProgress()) {
                LOG.debug("Some dead server is still under processing, won't clear the dead server list");
                response.addAllServerName((Iterable)request.getServerNameList());
            } else {
                DeadServer deadServer = ((HMaster)this.server).getServerManager().getDeadServers();
                HashSet<Address> clearedServers = new HashSet<Address>();
                for (HBaseProtos.ServerName pbServer : request.getServerNameList()) {
                    ServerName serverName = ProtobufUtil.toServerName((HBaseProtos.ServerName)pbServer);
                    boolean deadInProcess = ((HMaster)this.server).getProcedures().stream().anyMatch(p -> p instanceof ServerCrashProcedure && ((ServerCrashProcedure)p).getServerName().equals((Object)serverName));
                    if (deadInProcess) {
                        throw new ServiceException(String.format("Dead server '%s' is not 'dead' in fact...", serverName));
                    }
                    if (!deadServer.removeDeadServer(serverName)) {
                        response.addServerName(pbServer);
                        continue;
                    }
                    clearedServers.add(serverName.getAddress());
                }
                ((HMaster)this.server).getRSGroupInfoManager().removeServers(clearedServers);
                LOG.info("Remove decommissioned servers {} from RSGroup done", clearedServers);
            }
            if (((HMaster)this.server).cpHost != null) {
                ((HMaster)this.server).cpHost.postClearDeadServers(ProtobufUtil.toServerNameList((List)request.getServerNameList()), ProtobufUtil.toServerNameList((List)response.getServerNameList()));
            }
        }
        catch (IOException io) {
            throw new ServiceException((Throwable)io);
        }
        return response.build();
    }

    public RegionServerStatusProtos.ReportProcedureDoneResponse reportProcedureDone(RpcController controller, RegionServerStatusProtos.ReportProcedureDoneRequest request) throws ServiceException {
        try {
            ((HMaster)this.server).checkServiceStarted();
        }
        catch (ServerNotRunningYetException snrye) {
            throw new ServiceException((Throwable)snrye);
        }
        request.getResultList().forEach(result -> {
            if (result.getStatus() == RegionServerStatusProtos.RemoteProcedureResult.Status.SUCCESS) {
                ((HMaster)this.server).remoteProcedureCompleted(result.getProcId());
            } else {
                ((HMaster)this.server).remoteProcedureFailed(result.getProcId(), RemoteProcedureException.fromProto((ErrorHandlingProtos.ForeignExceptionMessage)result.getError()));
            }
        });
        return RegionServerStatusProtos.ReportProcedureDoneResponse.getDefaultInstance();
    }

    public RegionServerStatusProtos.FileArchiveNotificationResponse reportFileArchival(RpcController controller, RegionServerStatusProtos.FileArchiveNotificationRequest request) throws ServiceException {
        try {
            ((HMaster)this.server).checkInitialized();
            if (!QuotaUtil.isQuotaEnabled(((HMaster)this.server).getConfiguration())) {
                return RegionServerStatusProtos.FileArchiveNotificationResponse.newBuilder().build();
            }
            ((HMaster)this.server).getMasterQuotaManager().processFileArchivals(request, ((HMaster)this.server).getConnection(), ((HMaster)this.server).getConfiguration(), ((HMaster)this.server).getFileSystem());
            return RegionServerStatusProtos.FileArchiveNotificationResponse.newBuilder().build();
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.RunHbckChoreResponse runHbckChore(RpcController c, MasterProtos.RunHbckChoreRequest req) throws ServiceException {
        this.rpcPreCheck("runHbckChore");
        LOG.info("{} request HBCK chore to run", (Object)((HMaster)this.server).getClientIdAuditPrefix());
        HbckChore hbckChore = ((HMaster)this.server).getHbckChore();
        boolean ran = hbckChore.runChore();
        return MasterProtos.RunHbckChoreResponse.newBuilder().setRan(ran).build();
    }

    public MasterProtos.GetTableStateResponse setTableStateInMeta(RpcController controller, MasterProtos.SetTableStateInMetaRequest request) throws ServiceException {
        this.rpcPreCheck("setTableStateInMeta");
        TableName tn = ProtobufUtil.toTableName((HBaseProtos.TableName)request.getTableName());
        try {
            TableState prevState = ((HMaster)this.server).getTableStateManager().getTableState(tn);
            TableState newState = TableState.convert((TableName)tn, (HBaseProtos.TableState)request.getTableState());
            LOG.info("{} set table={} state from {} to {}", new Object[]{((HMaster)this.server).getClientIdAuditPrefix(), tn, prevState.getState(), newState.getState()});
            ((HMaster)this.server).getTableStateManager().setTableState(tn, newState.getState());
            return MasterProtos.GetTableStateResponse.newBuilder().setTableState(prevState.convert()).build();
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.SetRegionStateInMetaResponse setRegionStateInMeta(RpcController controller, MasterProtos.SetRegionStateInMetaRequest request) throws ServiceException {
        this.rpcPreCheck("setRegionStateInMeta");
        MasterProtos.SetRegionStateInMetaResponse.Builder builder = MasterProtos.SetRegionStateInMetaResponse.newBuilder();
        AssignmentManager am = ((HMaster)this.server).getAssignmentManager();
        try {
            for (MasterProtos.RegionSpecifierAndState s : request.getStatesList()) {
                HBaseProtos.RegionSpecifier spec = s.getRegionSpecifier();
                RegionInfo targetRegionInfo = this.getRegionInfo(spec);
                RegionState.State targetState = RegionState.State.convert((ClusterStatusProtos.RegionState.State)s.getState());
                RegionState.State currentState = Optional.ofNullable(targetRegionInfo).map(info -> am.getRegionStates().getRegionState((RegionInfo)info)).map(RegionState::getState).orElseThrow(() -> new ServiceException("No existing state known for region '" + spec + "'."));
                LOG.info("{} set region={} state from {} to {}", new Object[]{((HMaster)this.server).getClientIdAuditPrefix(), targetRegionInfo, currentState, targetState});
                if (currentState == targetState) {
                    LOG.debug("Proposed state matches current state. {}, {}", (Object)targetRegionInfo, (Object)currentState);
                    continue;
                }
                MetaTableAccessor.updateRegionState(((HMaster)this.server).getConnection(), targetRegionInfo, targetState);
                am.populateRegionStatesFromMeta(targetRegionInfo);
                builder.addStates(MasterProtos.RegionSpecifierAndState.newBuilder().setRegionSpecifier(spec).setState(currentState.convert()));
            }
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return builder.build();
    }

    private RegionInfo getRegionInfo(HBaseProtos.RegionSpecifier rs) throws ServiceException {
        RegionInfo info;
        String encodedRegionName;
        AssignmentManager am = ((HMaster)this.server).getAssignmentManager();
        switch (rs.getType()) {
            case REGION_NAME: {
                byte[] regionName = rs.getValue().toByteArray();
                encodedRegionName = RegionInfo.encodeRegionName((byte[])regionName);
                info = am.getRegionInfo(regionName);
                break;
            }
            case ENCODED_REGION_NAME: {
                encodedRegionName = rs.getValue().toStringUtf8();
                info = am.getRegionInfo(encodedRegionName);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized RegionSpecifierType " + rs.getType());
            }
        }
        if (info != null) {
            return info;
        }
        try {
            am.populateRegionStatesFromMeta(encodedRegionName);
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return am.getRegionInfo(encodedRegionName);
    }

    private void checkMasterProcedureExecutor() throws ServiceException {
        if (((HMaster)this.server).getMasterProcedureExecutor() == null) {
            throw new ServiceException("Master's ProcedureExecutor not initialized; retry later");
        }
    }

    public MasterProtos.AssignsResponse assigns(RpcController controller, MasterProtos.AssignsRequest request) throws ServiceException {
        this.checkMasterProcedureExecutor();
        ProcedureExecutor<MasterProcedureEnv> pe = ((HMaster)this.server).getMasterProcedureExecutor();
        AssignmentManager am = ((HMaster)this.server).getAssignmentManager();
        MasterProtos.AssignsResponse.Builder responseBuilder = MasterProtos.AssignsResponse.newBuilder();
        boolean override = request.getOverride();
        LOG.info("{} assigns, override={}", (Object)((HMaster)this.server).getClientIdAuditPrefix(), (Object)override);
        for (HBaseProtos.RegionSpecifier rs : request.getRegionList()) {
            RegionInfo info = this.getRegionInfo(rs);
            if (info == null) {
                LOG.info("Unknown region {}", (Object)rs);
                continue;
            }
            responseBuilder.addPid(Optional.ofNullable(am.createOneAssignProcedure(info, override)).map(arg_0 -> pe.submitProcedure(arg_0)).orElse(-1L).longValue());
        }
        return responseBuilder.build();
    }

    public MasterProtos.UnassignsResponse unassigns(RpcController controller, MasterProtos.UnassignsRequest request) throws ServiceException {
        this.checkMasterProcedureExecutor();
        ProcedureExecutor<MasterProcedureEnv> pe = ((HMaster)this.server).getMasterProcedureExecutor();
        AssignmentManager am = ((HMaster)this.server).getAssignmentManager();
        MasterProtos.UnassignsResponse.Builder responseBuilder = MasterProtos.UnassignsResponse.newBuilder();
        boolean override = request.getOverride();
        LOG.info("{} unassigns, override={}", (Object)((HMaster)this.server).getClientIdAuditPrefix(), (Object)override);
        for (HBaseProtos.RegionSpecifier rs : request.getRegionList()) {
            RegionInfo info = this.getRegionInfo(rs);
            if (info == null) {
                LOG.info("Unknown region {}", (Object)rs);
                continue;
            }
            responseBuilder.addPid(Optional.ofNullable(am.createOneUnassignProcedure(info, override)).map(arg_0 -> pe.submitProcedure(arg_0)).orElse(-1L).longValue());
        }
        return responseBuilder.build();
    }

    public MasterProtos.BypassProcedureResponse bypassProcedure(RpcController controller, MasterProtos.BypassProcedureRequest request) throws ServiceException {
        try {
            LOG.info("{} bypass procedures={}, waitTime={}, override={}, recursive={}", new Object[]{((HMaster)this.server).getClientIdAuditPrefix(), request.getProcIdList(), request.getWaitTime(), request.getOverride(), request.getRecursive()});
            List ret = ((HMaster)this.server).getMasterProcedureExecutor().bypassProcedure(request.getProcIdList(), request.getWaitTime(), request.getOverride(), request.getRecursive());
            return MasterProtos.BypassProcedureResponse.newBuilder().addAllBypassed((Iterable)ret).build();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.ScheduleServerCrashProcedureResponse scheduleServerCrashProcedure(RpcController controller, MasterProtos.ScheduleServerCrashProcedureRequest request) throws ServiceException {
        ArrayList<Long> pids = new ArrayList<Long>();
        for (HBaseProtos.ServerName sn : request.getServerNameList()) {
            ServerName serverName = ProtobufUtil.toServerName((HBaseProtos.ServerName)sn);
            LOG.info("{} schedule ServerCrashProcedure for {}", (Object)((HMaster)this.server).getClientIdAuditPrefix(), (Object)serverName);
            if (this.shouldSubmitSCP(serverName)) {
                pids.add(((HMaster)this.server).getServerManager().expireServer(serverName, true));
                continue;
            }
            pids.add(-1L);
        }
        return MasterProtos.ScheduleServerCrashProcedureResponse.newBuilder().addAllPid(pids).build();
    }

    public MasterProtos.ScheduleSCPsForUnknownServersResponse scheduleSCPsForUnknownServers(RpcController controller, MasterProtos.ScheduleSCPsForUnknownServersRequest request) throws ServiceException {
        ArrayList<Long> pids = new ArrayList<Long>();
        Set serverNames = ((HMaster)this.server).getAssignmentManager().getRegionStates().getRegionStates().stream().map(RegionState::getServerName).collect(Collectors.toSet());
        Set unknownServerNames = serverNames.stream().filter(sn -> ((HMaster)this.server).getServerManager().isServerUnknown((ServerName)sn)).collect(Collectors.toSet());
        for (ServerName sn2 : unknownServerNames) {
            LOG.info("{} schedule ServerCrashProcedure for unknown {}", (Object)((HMaster)this.server).getClientIdAuditPrefix(), (Object)sn2);
            if (this.shouldSubmitSCP(sn2)) {
                pids.add(((HMaster)this.server).getServerManager().expireServer(sn2, true));
                continue;
            }
            pids.add(-1L);
        }
        return MasterProtos.ScheduleSCPsForUnknownServersResponse.newBuilder().addAllPid(pids).build();
    }

    public MasterProtos.FixMetaResponse fixMeta(RpcController controller, MasterProtos.FixMetaRequest request) throws ServiceException {
        this.rpcPreCheck("fixMeta");
        try {
            MetaFixer mf = new MetaFixer((MasterServices)((Object)this.server));
            mf.fix();
            return MasterProtos.FixMetaResponse.newBuilder().build();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public MasterProtos.SwitchRpcThrottleResponse switchRpcThrottle(RpcController controller, MasterProtos.SwitchRpcThrottleRequest request) throws ServiceException {
        try {
            ((HMaster)this.server).checkInitialized();
            return ((HMaster)this.server).getMasterQuotaManager().switchRpcThrottle(request);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.IsRpcThrottleEnabledResponse isRpcThrottleEnabled(RpcController controller, MasterProtos.IsRpcThrottleEnabledRequest request) throws ServiceException {
        try {
            ((HMaster)this.server).checkInitialized();
            return ((HMaster)this.server).getMasterQuotaManager().isRpcThrottleEnabled(request);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public MasterProtos.SwitchExceedThrottleQuotaResponse switchExceedThrottleQuota(RpcController controller, MasterProtos.SwitchExceedThrottleQuotaRequest request) throws ServiceException {
        try {
            ((HMaster)this.server).checkInitialized();
            return ((HMaster)this.server).getMasterQuotaManager().switchExceedThrottleQuota(request);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public AccessControlProtos.GrantResponse grant(RpcController controller, AccessControlProtos.GrantRequest request) throws ServiceException {
        try {
            ((HMaster)this.server).checkInitialized();
            if (((HMaster)this.server).cpHost != null && this.hasAccessControlServiceCoprocessor(((HMaster)this.server).cpHost)) {
                UserPermission perm = ShadedAccessControlUtil.toUserPermission((AccessControlProtos.UserPermission)request.getUserPermission());
                boolean mergeExistingPermissions = request.getMergeExistingPermissions();
                ((HMaster)this.server).cpHost.preGrant(perm, mergeExistingPermissions);
                try (Table table = ((HMaster)this.server).getConnection().getTable(PermissionStorage.ACL_TABLE_NAME);){
                    PermissionStorage.addUserPermission(this.getConfiguration(), perm, table, mergeExistingPermissions);
                }
                ((HMaster)this.server).cpHost.postGrant(perm, mergeExistingPermissions);
                return AccessControlProtos.GrantResponse.getDefaultInstance();
            }
            throw new DoNotRetryIOException((Throwable)new UnsupportedOperationException(AccessController.class.getName() + " is not loaded"));
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public AccessControlProtos.RevokeResponse revoke(RpcController controller, AccessControlProtos.RevokeRequest request) throws ServiceException {
        try {
            ((HMaster)this.server).checkInitialized();
            if (((HMaster)this.server).cpHost != null && this.hasAccessControlServiceCoprocessor(((HMaster)this.server).cpHost)) {
                UserPermission userPermission = ShadedAccessControlUtil.toUserPermission((AccessControlProtos.UserPermission)request.getUserPermission());
                ((HMaster)this.server).cpHost.preRevoke(userPermission);
                try (Table table = ((HMaster)this.server).getConnection().getTable(PermissionStorage.ACL_TABLE_NAME);){
                    PermissionStorage.removeUserPermission(((HMaster)this.server).getConfiguration(), userPermission, table);
                }
                ((HMaster)this.server).cpHost.postRevoke(userPermission);
                return AccessControlProtos.RevokeResponse.getDefaultInstance();
            }
            throw new DoNotRetryIOException((Throwable)new UnsupportedOperationException(AccessController.class.getName() + " is not loaded"));
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public AccessControlProtos.GetUserPermissionsResponse getUserPermissions(RpcController controller, AccessControlProtos.GetUserPermissionsRequest request) throws ServiceException {
        try {
            ((HMaster)this.server).checkInitialized();
            if (((HMaster)this.server).cpHost != null && this.hasAccessControlServiceCoprocessor(((HMaster)this.server).cpHost)) {
                String userName = request.hasUserName() ? request.getUserName().toStringUtf8() : null;
                String namespace = request.hasNamespaceName() ? request.getNamespaceName().toStringUtf8() : null;
                TableName table = request.hasTableName() ? ProtobufUtil.toTableName((HBaseProtos.TableName)request.getTableName()) : null;
                byte[] cf = request.hasColumnFamily() ? request.getColumnFamily().toByteArray() : null;
                byte[] cq = request.hasColumnQualifier() ? request.getColumnQualifier().toByteArray() : null;
                AccessControlProtos.Permission.Type permissionType = request.hasType() ? request.getType() : null;
                ((HMaster)this.server).getMasterCoprocessorHost().preGetUserPermissions(userName, namespace, table, cf, cq);
                List<UserPermission> perms = null;
                if (permissionType == AccessControlProtos.Permission.Type.Table) {
                    boolean filter = cf != null || userName != null;
                    perms = PermissionStorage.getUserTablePermissions(((HMaster)this.server).getConfiguration(), table, cf, cq, userName, filter);
                } else if (permissionType == AccessControlProtos.Permission.Type.Namespace) {
                    perms = PermissionStorage.getUserNamespacePermissions(((HMaster)this.server).getConfiguration(), namespace, userName, userName != null);
                } else {
                    perms = PermissionStorage.getUserPermissions(((HMaster)this.server).getConfiguration(), null, null, null, userName, userName != null);
                    if (userName == null) {
                        for (String user : Superusers.getSuperUsers()) {
                            perms.add(new UserPermission(user, Permission.newBuilder().withActions(Permission.Action.values()).build()));
                        }
                    }
                }
                ((HMaster)this.server).getMasterCoprocessorHost().postGetUserPermissions(userName, namespace, table, cf, cq);
                AccessControlProtos.GetUserPermissionsResponse response = ShadedAccessControlUtil.buildGetUserPermissionsResponse(perms);
                return response;
            }
            throw new DoNotRetryIOException((Throwable)new UnsupportedOperationException(AccessController.class.getName() + " is not loaded"));
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    public AccessControlProtos.HasUserPermissionsResponse hasUserPermissions(RpcController controller, AccessControlProtos.HasUserPermissionsRequest request) throws ServiceException {
        try {
            ((HMaster)this.server).checkInitialized();
            if (((HMaster)this.server).cpHost != null && this.hasAccessControlServiceCoprocessor(((HMaster)this.server).cpHost)) {
                User caller = RpcServer.getRequestUser().orElse(null);
                String userName = request.hasUserName() ? request.getUserName().toStringUtf8() : caller.getShortName();
                ArrayList<Permission> permissions = new ArrayList<Permission>();
                for (int i = 0; i < request.getPermissionCount(); ++i) {
                    permissions.add(ShadedAccessControlUtil.toPermission((AccessControlProtos.Permission)request.getPermission(i)));
                }
                ((HMaster)this.server).getMasterCoprocessorHost().preHasUserPermissions(userName, permissions);
                if (!caller.getShortName().equals(userName)) {
                    List<String> groups = AccessChecker.getUserGroups(userName);
                    caller = new AccessChecker.InputUser(userName, groups.toArray(new String[groups.size()]));
                }
                ArrayList<Boolean> hasUserPermissions = new ArrayList<Boolean>();
                if (this.getAccessChecker() != null) {
                    for (Permission permission : permissions) {
                        boolean hasUserPermission = this.getAccessChecker().hasUserPermission(caller, "hasUserPermissions", permission);
                        hasUserPermissions.add(hasUserPermission);
                    }
                } else {
                    for (int i = 0; i < permissions.size(); ++i) {
                        hasUserPermissions.add(true);
                    }
                }
                ((HMaster)this.server).getMasterCoprocessorHost().postHasUserPermissions(userName, permissions);
                AccessControlProtos.HasUserPermissionsResponse.Builder builder = AccessControlProtos.HasUserPermissionsResponse.newBuilder().addAllHasUserPermission(hasUserPermissions);
                return builder.build();
            }
            throw new DoNotRetryIOException((Throwable)new UnsupportedOperationException(AccessController.class.getName() + " is not loaded"));
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
    }

    private boolean shouldSubmitSCP(ServerName serverName) {
        List procedures = ((HMaster)this.server).getMasterProcedureExecutor().getProcedures();
        for (Procedure procedure : procedures) {
            if (!(procedure instanceof ServerCrashProcedure) || serverName.compareTo(((ServerCrashProcedure)procedure).getServerName()) != 0 || procedure.isFinished()) continue;
            LOG.info("there is already a SCP of this server {} running, pid {}", (Object)serverName, (Object)procedure.getProcId());
            return false;
        }
        return true;
    }

    public RSGroupAdminProtos.GetRSGroupInfoResponse getRSGroupInfo(RpcController controller, RSGroupAdminProtos.GetRSGroupInfoRequest request) throws ServiceException {
        String groupName = request.getRSGroupName();
        LOG.info(((HMaster)this.server).getClientIdAuditPrefix() + " initiates rsgroup info retrieval, group=" + groupName);
        try {
            RSGroupInfo rsGroupInfo;
            if (((HMaster)this.server).getMasterCoprocessorHost() != null) {
                ((HMaster)this.server).getMasterCoprocessorHost().preGetRSGroupInfo(groupName);
            }
            RSGroupAdminProtos.GetRSGroupInfoResponse resp = (rsGroupInfo = ((HMaster)this.server).getRSGroupInfoManager().getRSGroup(groupName)) != null ? RSGroupAdminProtos.GetRSGroupInfoResponse.newBuilder().setRSGroupInfo(ProtobufUtil.toProtoGroupInfo((RSGroupInfo)rsGroupInfo)).build() : RSGroupAdminProtos.GetRSGroupInfoResponse.getDefaultInstance();
            if (((HMaster)this.server).getMasterCoprocessorHost() != null) {
                ((HMaster)this.server).getMasterCoprocessorHost().postGetRSGroupInfo(groupName);
            }
            return resp;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public RSGroupAdminProtos.GetRSGroupInfoOfTableResponse getRSGroupInfoOfTable(RpcController controller, RSGroupAdminProtos.GetRSGroupInfoOfTableRequest request) throws ServiceException {
        TableName tableName = ProtobufUtil.toTableName((HBaseProtos.TableName)request.getTableName());
        LOG.info(((HMaster)this.server).getClientIdAuditPrefix() + " initiates rsgroup info retrieval, table=" + tableName);
        try {
            RSGroupAdminProtos.GetRSGroupInfoOfTableResponse resp;
            TableDescriptor td;
            if (((HMaster)this.server).getMasterCoprocessorHost() != null) {
                ((HMaster)this.server).getMasterCoprocessorHost().preGetRSGroupInfoOfTable(tableName);
            }
            if ((td = ((HMaster)this.server).getTableDescriptors().get(tableName)) == null) {
                resp = RSGroupAdminProtos.GetRSGroupInfoOfTableResponse.getDefaultInstance();
            } else {
                RSGroupInfo rsGroupInfo = RSGroupUtil.getRSGroupInfo((MasterServices)((Object)this.server), ((HMaster)this.server).getRSGroupInfoManager(), tableName).orElse(((HMaster)this.server).getRSGroupInfoManager().getRSGroup("default"));
                resp = RSGroupAdminProtos.GetRSGroupInfoOfTableResponse.newBuilder().setRSGroupInfo(ProtobufUtil.toProtoGroupInfo((RSGroupInfo)rsGroupInfo)).build();
            }
            if (((HMaster)this.server).getMasterCoprocessorHost() != null) {
                ((HMaster)this.server).getMasterCoprocessorHost().postGetRSGroupInfoOfTable(tableName);
            }
            return resp;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public RSGroupAdminProtos.GetRSGroupInfoOfServerResponse getRSGroupInfoOfServer(RpcController controller, RSGroupAdminProtos.GetRSGroupInfoOfServerRequest request) throws ServiceException {
        Address hp = Address.fromParts((String)request.getServer().getHostName(), (int)request.getServer().getPort());
        LOG.info(((HMaster)this.server).getClientIdAuditPrefix() + " initiates rsgroup info retrieval, server=" + hp);
        try {
            RSGroupInfo rsGroupInfo;
            if (((HMaster)this.server).getMasterCoprocessorHost() != null) {
                ((HMaster)this.server).getMasterCoprocessorHost().preGetRSGroupInfoOfServer(hp);
            }
            RSGroupAdminProtos.GetRSGroupInfoOfServerResponse resp = (rsGroupInfo = ((HMaster)this.server).getRSGroupInfoManager().getRSGroupOfServer(hp)) != null ? RSGroupAdminProtos.GetRSGroupInfoOfServerResponse.newBuilder().setRSGroupInfo(ProtobufUtil.toProtoGroupInfo((RSGroupInfo)rsGroupInfo)).build() : RSGroupAdminProtos.GetRSGroupInfoOfServerResponse.getDefaultInstance();
            if (((HMaster)this.server).getMasterCoprocessorHost() != null) {
                ((HMaster)this.server).getMasterCoprocessorHost().postGetRSGroupInfoOfServer(hp);
            }
            return resp;
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public RSGroupAdminProtos.MoveServersResponse moveServers(RpcController controller, RSGroupAdminProtos.MoveServersRequest request) throws ServiceException {
        HashSet hostPorts = Sets.newHashSet();
        RSGroupAdminProtos.MoveServersResponse.Builder builder = RSGroupAdminProtos.MoveServersResponse.newBuilder();
        for (HBaseProtos.ServerName el : request.getServersList()) {
            hostPorts.add(Address.fromParts((String)el.getHostName(), (int)el.getPort()));
        }
        LOG.info(((HMaster)this.server).getClientIdAuditPrefix() + " move servers " + hostPorts + " to rsgroup " + request.getTargetGroup());
        try {
            if (((HMaster)this.server).getMasterCoprocessorHost() != null) {
                ((HMaster)this.server).getMasterCoprocessorHost().preMoveServers(hostPorts, request.getTargetGroup());
            }
            ((HMaster)this.server).getRSGroupInfoManager().moveServers(hostPorts, request.getTargetGroup());
            if (((HMaster)this.server).getMasterCoprocessorHost() != null) {
                ((HMaster)this.server).getMasterCoprocessorHost().postMoveServers(hostPorts, request.getTargetGroup());
            }
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return builder.build();
    }

    public RSGroupAdminProtos.AddRSGroupResponse addRSGroup(RpcController controller, RSGroupAdminProtos.AddRSGroupRequest request) throws ServiceException {
        RSGroupAdminProtos.AddRSGroupResponse.Builder builder = RSGroupAdminProtos.AddRSGroupResponse.newBuilder();
        LOG.info(((HMaster)this.server).getClientIdAuditPrefix() + " add rsgroup " + request.getRSGroupName());
        try {
            if (((HMaster)this.server).getMasterCoprocessorHost() != null) {
                ((HMaster)this.server).getMasterCoprocessorHost().preAddRSGroup(request.getRSGroupName());
            }
            ((HMaster)this.server).getRSGroupInfoManager().addRSGroup(new RSGroupInfo(request.getRSGroupName()));
            if (((HMaster)this.server).getMasterCoprocessorHost() != null) {
                ((HMaster)this.server).getMasterCoprocessorHost().postAddRSGroup(request.getRSGroupName());
            }
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return builder.build();
    }

    public RSGroupAdminProtos.RemoveRSGroupResponse removeRSGroup(RpcController controller, RSGroupAdminProtos.RemoveRSGroupRequest request) throws ServiceException {
        RSGroupAdminProtos.RemoveRSGroupResponse.Builder builder = RSGroupAdminProtos.RemoveRSGroupResponse.newBuilder();
        LOG.info(((HMaster)this.server).getClientIdAuditPrefix() + " remove rsgroup " + request.getRSGroupName());
        try {
            if (((HMaster)this.server).getMasterCoprocessorHost() != null) {
                ((HMaster)this.server).getMasterCoprocessorHost().preRemoveRSGroup(request.getRSGroupName());
            }
            ((HMaster)this.server).getRSGroupInfoManager().removeRSGroup(request.getRSGroupName());
            if (((HMaster)this.server).getMasterCoprocessorHost() != null) {
                ((HMaster)this.server).getMasterCoprocessorHost().postRemoveRSGroup(request.getRSGroupName());
            }
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return builder.build();
    }

    public RSGroupAdminProtos.BalanceRSGroupResponse balanceRSGroup(RpcController controller, RSGroupAdminProtos.BalanceRSGroupRequest request) throws ServiceException {
        BalanceRequest balanceRequest = ProtobufUtil.toBalanceRequest((RSGroupAdminProtos.BalanceRSGroupRequest)request);
        RSGroupAdminProtos.BalanceRSGroupResponse.Builder builder = RSGroupAdminProtos.BalanceRSGroupResponse.newBuilder().setBalanceRan(false);
        LOG.info(((HMaster)this.server).getClientIdAuditPrefix() + " balance rsgroup, group=" + request.getRSGroupName());
        try {
            if (((HMaster)this.server).getMasterCoprocessorHost() != null) {
                ((HMaster)this.server).getMasterCoprocessorHost().preBalanceRSGroup(request.getRSGroupName(), balanceRequest);
            }
            BalanceResponse response = ((HMaster)this.server).getRSGroupInfoManager().balanceRSGroup(request.getRSGroupName(), balanceRequest);
            ProtobufUtil.populateBalanceRSGroupResponse((RSGroupAdminProtos.BalanceRSGroupResponse.Builder)builder, (BalanceResponse)response);
            if (((HMaster)this.server).getMasterCoprocessorHost() != null) {
                ((HMaster)this.server).getMasterCoprocessorHost().postBalanceRSGroup(request.getRSGroupName(), balanceRequest, response);
            }
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return builder.build();
    }

    public RSGroupAdminProtos.ListRSGroupInfosResponse listRSGroupInfos(RpcController controller, RSGroupAdminProtos.ListRSGroupInfosRequest request) throws ServiceException {
        RSGroupAdminProtos.ListRSGroupInfosResponse.Builder builder = RSGroupAdminProtos.ListRSGroupInfosResponse.newBuilder();
        LOG.info(((HMaster)this.server).getClientIdAuditPrefix() + " list rsgroup");
        try {
            if (((HMaster)this.server).getMasterCoprocessorHost() != null) {
                ((HMaster)this.server).getMasterCoprocessorHost().preListRSGroups();
            }
            List rsGroupInfos = ((HMaster)this.server).getRSGroupInfoManager().listRSGroups().stream().map(RSGroupInfo::new).collect(Collectors.toList());
            HashMap<String, RSGroupInfo> name2Info = new HashMap<String, RSGroupInfo>();
            ArrayList<TableDescriptor> needToFill = new ArrayList<TableDescriptor>(((HMaster)this.server).getTableDescriptors().getAll().values());
            for (RSGroupInfo rsGroupInfo : rsGroupInfos) {
                name2Info.put(rsGroupInfo.getName(), rsGroupInfo);
                for (TableDescriptor td : ((HMaster)this.server).getTableDescriptors().getAll().values()) {
                    if (!rsGroupInfo.containsTable(td.getTableName())) continue;
                    needToFill.remove(td);
                }
            }
            for (TableDescriptor td : needToFill) {
                String groupName = td.getRegionServerGroup().orElse("default");
                RSGroupInfo rsGroupInfo = (RSGroupInfo)name2Info.get(groupName);
                if (rsGroupInfo == null) continue;
                rsGroupInfo.addTable(td.getTableName());
            }
            for (RSGroupInfo rsGroupInfo : rsGroupInfos) {
                builder.addRSGroupInfo(ProtobufUtil.toProtoGroupInfo((RSGroupInfo)rsGroupInfo));
            }
            if (((HMaster)this.server).getMasterCoprocessorHost() != null) {
                ((HMaster)this.server).getMasterCoprocessorHost().postListRSGroups();
            }
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return builder.build();
    }

    public RSGroupAdminProtos.RemoveServersResponse removeServers(RpcController controller, RSGroupAdminProtos.RemoveServersRequest request) throws ServiceException {
        RSGroupAdminProtos.RemoveServersResponse.Builder builder = RSGroupAdminProtos.RemoveServersResponse.newBuilder();
        HashSet servers = Sets.newHashSet();
        for (HBaseProtos.ServerName el : request.getServersList()) {
            servers.add(Address.fromParts((String)el.getHostName(), (int)el.getPort()));
        }
        LOG.info(((HMaster)this.server).getClientIdAuditPrefix() + " remove decommissioned servers from rsgroup: " + servers);
        try {
            if (((HMaster)this.server).getMasterCoprocessorHost() != null) {
                ((HMaster)this.server).getMasterCoprocessorHost().preRemoveServers(servers);
            }
            ((HMaster)this.server).getRSGroupInfoManager().removeServers(servers);
            if (((HMaster)this.server).getMasterCoprocessorHost() != null) {
                ((HMaster)this.server).getMasterCoprocessorHost().postRemoveServers(servers);
            }
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return builder.build();
    }

    public RSGroupAdminProtos.ListTablesInRSGroupResponse listTablesInRSGroup(RpcController controller, RSGroupAdminProtos.ListTablesInRSGroupRequest request) throws ServiceException {
        RSGroupAdminProtos.ListTablesInRSGroupResponse.Builder builder = RSGroupAdminProtos.ListTablesInRSGroupResponse.newBuilder();
        String groupName = request.getGroupName();
        LOG.info(((HMaster)this.server).getClientIdAuditPrefix() + " list tables in rsgroup " + groupName);
        try {
            if (((HMaster)this.server).getMasterCoprocessorHost() != null) {
                ((HMaster)this.server).getMasterCoprocessorHost().preListTablesInRSGroup(groupName);
            }
            RSGroupUtil.listTablesInRSGroup((MasterServices)((Object)this.server), groupName).stream().map(ProtobufUtil::toProtoTableName).forEach(arg_0 -> ((RSGroupAdminProtos.ListTablesInRSGroupResponse.Builder)builder).addTableName(arg_0));
            if (((HMaster)this.server).getMasterCoprocessorHost() != null) {
                ((HMaster)this.server).getMasterCoprocessorHost().postListTablesInRSGroup(groupName);
            }
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return builder.build();
    }

    public RSGroupAdminProtos.GetConfiguredNamespacesAndTablesInRSGroupResponse getConfiguredNamespacesAndTablesInRSGroup(RpcController controller, RSGroupAdminProtos.GetConfiguredNamespacesAndTablesInRSGroupRequest request) throws ServiceException {
        RSGroupAdminProtos.GetConfiguredNamespacesAndTablesInRSGroupResponse.Builder builder = RSGroupAdminProtos.GetConfiguredNamespacesAndTablesInRSGroupResponse.newBuilder();
        String groupName = request.getGroupName();
        LOG.info(((HMaster)this.server).getClientIdAuditPrefix() + " get configured namespaces and tables in rsgroup " + groupName);
        try {
            if (((HMaster)this.server).getMasterCoprocessorHost() != null) {
                ((HMaster)this.server).getMasterCoprocessorHost().preGetConfiguredNamespacesAndTablesInRSGroup(groupName);
            }
            for (NamespaceDescriptor nd : ((HMaster)this.server).getClusterSchema().getNamespaces()) {
                if (!groupName.equals(nd.getConfigurationValue("hbase.rsgroup.name"))) continue;
                builder.addNamespace(nd.getName());
            }
            for (TableDescriptor td : ((HMaster)this.server).getTableDescriptors().getAll().values()) {
                if (!td.getRegionServerGroup().map(g -> g.equals(groupName)).orElse(false).booleanValue()) continue;
                builder.addTableName(ProtobufUtil.toProtoTableName((TableName)td.getTableName()));
            }
            if (((HMaster)this.server).getMasterCoprocessorHost() != null) {
                ((HMaster)this.server).getMasterCoprocessorHost().postGetConfiguredNamespacesAndTablesInRSGroup(groupName);
            }
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return builder.build();
    }

    public RSGroupAdminProtos.RenameRSGroupResponse renameRSGroup(RpcController controller, RSGroupAdminProtos.RenameRSGroupRequest request) throws ServiceException {
        RSGroupAdminProtos.RenameRSGroupResponse.Builder builder = RSGroupAdminProtos.RenameRSGroupResponse.newBuilder();
        String oldRSGroup = request.getOldRsgroupName();
        String newRSGroup = request.getNewRsgroupName();
        LOG.info("{} rename rsgroup from {} to {} ", new Object[]{((HMaster)this.server).getClientIdAuditPrefix(), oldRSGroup, newRSGroup});
        try {
            if (((HMaster)this.server).getMasterCoprocessorHost() != null) {
                ((HMaster)this.server).getMasterCoprocessorHost().preRenameRSGroup(oldRSGroup, newRSGroup);
            }
            ((HMaster)this.server).getRSGroupInfoManager().renameRSGroup(oldRSGroup, newRSGroup);
            if (((HMaster)this.server).getMasterCoprocessorHost() != null) {
                ((HMaster)this.server).getMasterCoprocessorHost().postRenameRSGroup(oldRSGroup, newRSGroup);
            }
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return builder.build();
    }

    public RSGroupAdminProtos.UpdateRSGroupConfigResponse updateRSGroupConfig(RpcController controller, RSGroupAdminProtos.UpdateRSGroupConfigRequest request) throws ServiceException {
        RSGroupAdminProtos.UpdateRSGroupConfigResponse.Builder builder = RSGroupAdminProtos.UpdateRSGroupConfigResponse.newBuilder();
        String groupName = request.getGroupName();
        HashMap<String, String> configuration = new HashMap<String, String>();
        request.getConfigurationList().forEach(p -> configuration.put(p.getName(), p.getValue()));
        LOG.info("{} update rsgroup {} configuration {}", new Object[]{((HMaster)this.server).getClientIdAuditPrefix(), groupName, configuration});
        try {
            if (((HMaster)this.server).getMasterCoprocessorHost() != null) {
                ((HMaster)this.server).getMasterCoprocessorHost().preUpdateRSGroupConfig(groupName, configuration);
            }
            ((HMaster)this.server).getRSGroupInfoManager().updateRSGroupConfig(groupName, configuration);
            if (((HMaster)this.server).getMasterCoprocessorHost() != null) {
                ((HMaster)this.server).getMasterCoprocessorHost().postUpdateRSGroupConfig(groupName, configuration);
            }
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return builder.build();
    }

    @Override
    public HBaseProtos.LogEntry getLogEntries(RpcController controller, HBaseProtos.LogRequest request) throws ServiceException {
        try {
            String logClassName = request.getLogClassName();
            Class<Message> logClass = Class.forName(logClassName).asSubclass(Message.class);
            Method method = logClass.getMethod("parseFrom", ByteString.class);
            if (logClassName.contains("BalancerDecisionsRequest")) {
                MasterProtos.BalancerDecisionsRequest balancerDecisionsRequest = (MasterProtos.BalancerDecisionsRequest)method.invoke(null, request.getLogMessage());
                MasterProtos.BalancerDecisionsResponse balancerDecisionsResponse = this.getBalancerDecisions(balancerDecisionsRequest);
                return HBaseProtos.LogEntry.newBuilder().setLogClassName(balancerDecisionsResponse.getClass().getName()).setLogMessage(balancerDecisionsResponse.toByteString()).build();
            }
            if (logClassName.contains("BalancerRejectionsRequest")) {
                MasterProtos.BalancerRejectionsRequest balancerRejectionsRequest = (MasterProtos.BalancerRejectionsRequest)method.invoke(null, request.getLogMessage());
                MasterProtos.BalancerRejectionsResponse balancerRejectionsResponse = this.getBalancerRejections(balancerRejectionsRequest);
                return HBaseProtos.LogEntry.newBuilder().setLogClassName(balancerRejectionsResponse.getClass().getName()).setLogMessage(balancerRejectionsResponse.toByteString()).build();
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LOG.error("Error while retrieving log entries.", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
        throw new ServiceException("Invalid request params");
    }

    private MasterProtos.BalancerDecisionsResponse getBalancerDecisions(MasterProtos.BalancerDecisionsRequest request) {
        NamedQueueRecorder namedQueueRecorder = ((HMaster)this.server).getNamedQueueRecorder();
        if (namedQueueRecorder == null) {
            return MasterProtos.BalancerDecisionsResponse.newBuilder().addAllBalancerDecision(Collections.emptyList()).build();
        }
        NamedQueueGetRequest namedQueueGetRequest = new NamedQueueGetRequest();
        namedQueueGetRequest.setNamedQueueEvent(1);
        namedQueueGetRequest.setBalancerDecisionsRequest(request);
        NamedQueueGetResponse namedQueueGetResponse = namedQueueRecorder.getNamedQueueRecords(namedQueueGetRequest);
        List<Object> balancerDecisions = namedQueueGetResponse != null ? namedQueueGetResponse.getBalancerDecisions() : Collections.emptyList();
        return MasterProtos.BalancerDecisionsResponse.newBuilder().addAllBalancerDecision(balancerDecisions).build();
    }

    private MasterProtos.BalancerRejectionsResponse getBalancerRejections(MasterProtos.BalancerRejectionsRequest request) {
        NamedQueueRecorder namedQueueRecorder = ((HMaster)this.server).getNamedQueueRecorder();
        if (namedQueueRecorder == null) {
            return MasterProtos.BalancerRejectionsResponse.newBuilder().addAllBalancerRejection(Collections.emptyList()).build();
        }
        NamedQueueGetRequest namedQueueGetRequest = new NamedQueueGetRequest();
        namedQueueGetRequest.setNamedQueueEvent(2);
        namedQueueGetRequest.setBalancerRejectionsRequest(request);
        NamedQueueGetResponse namedQueueGetResponse = namedQueueRecorder.getNamedQueueRecords(namedQueueGetRequest);
        List<Object> balancerRejections = namedQueueGetResponse != null ? namedQueueGetResponse.getBalancerRejections() : Collections.emptyList();
        return MasterProtos.BalancerRejectionsResponse.newBuilder().addAllBalancerRejection(balancerRejections).build();
    }

    @QosPriority(priority=100)
    public AdminProtos.GetRegionInfoResponse getRegionInfo(RpcController controller, AdminProtos.GetRegionInfoRequest request) throws ServiceException {
        AdminProtos.GetRegionInfoResponse.Builder builder = AdminProtos.GetRegionInfoResponse.newBuilder();
        RegionInfo info = this.getRegionInfo(request.getRegion());
        if (info != null) {
            builder.setRegionInfo(ProtobufUtil.toRegionInfo((RegionInfo)info));
        } else {
            byte[] regionName = request.getRegion().getValue().toByteArray();
            TableName tableName = RegionInfo.getTable((byte[])regionName);
            if (MobUtils.isMobRegionName(tableName, regionName)) {
                RegionInfo mobRegionInfo = MobUtils.getMobRegionInfo(tableName);
                builder.setRegionInfo(ProtobufUtil.toRegionInfo((RegionInfo)mobRegionInfo));
                if (request.hasCompactionState() && request.getCompactionState()) {
                    builder.setCompactionState(((HMaster)this.server).getMobCompactionState(tableName));
                }
            } else {
                throw new ServiceException((Throwable)new UnknownRegionException(Bytes.toString((byte[])regionName)));
            }
        }
        return builder.build();
    }

    public AdminProtos.GetStoreFileResponse getStoreFile(RpcController controller, AdminProtos.GetStoreFileRequest request) throws ServiceException {
        throw new ServiceException((Throwable)new DoNotRetryIOException("Unsupported method on master"));
    }

    public AdminProtos.GetOnlineRegionResponse getOnlineRegion(RpcController controller, AdminProtos.GetOnlineRegionRequest request) throws ServiceException {
        throw new ServiceException((Throwable)new DoNotRetryIOException("Unsupported method on master"));
    }

    public AdminProtos.OpenRegionResponse openRegion(RpcController controller, AdminProtos.OpenRegionRequest request) throws ServiceException {
        throw new ServiceException((Throwable)new DoNotRetryIOException("Unsupported method on master"));
    }

    public AdminProtos.WarmupRegionResponse warmupRegion(RpcController controller, AdminProtos.WarmupRegionRequest request) throws ServiceException {
        throw new ServiceException((Throwable)new DoNotRetryIOException("Unsupported method on master"));
    }

    public AdminProtos.CloseRegionResponse closeRegion(RpcController controller, AdminProtos.CloseRegionRequest request) throws ServiceException {
        throw new ServiceException((Throwable)new DoNotRetryIOException("Unsupported method on master"));
    }

    public AdminProtos.FlushRegionResponse flushRegion(RpcController controller, AdminProtos.FlushRegionRequest request) throws ServiceException {
        throw new ServiceException((Throwable)new DoNotRetryIOException("Unsupported method on master"));
    }

    public AdminProtos.CompactionSwitchResponse compactionSwitch(RpcController controller, AdminProtos.CompactionSwitchRequest request) throws ServiceException {
        throw new ServiceException((Throwable)new DoNotRetryIOException("Unsupported method on master"));
    }

    public AdminProtos.CompactRegionResponse compactRegion(RpcController controller, AdminProtos.CompactRegionRequest request) throws ServiceException {
        throw new ServiceException((Throwable)new DoNotRetryIOException("Unsupported method on master"));
    }

    public AdminProtos.ReplicateWALEntryResponse replicateWALEntry(RpcController controller, AdminProtos.ReplicateWALEntryRequest request) throws ServiceException {
        throw new ServiceException((Throwable)new DoNotRetryIOException("Unsupported method on master"));
    }

    public AdminProtos.ReplicateWALEntryResponse replay(RpcController controller, AdminProtos.ReplicateWALEntryRequest request) throws ServiceException {
        throw new ServiceException((Throwable)new DoNotRetryIOException("Unsupported method on master"));
    }

    public AdminProtos.RollWALWriterResponse rollWALWriter(RpcController controller, AdminProtos.RollWALWriterRequest request) throws ServiceException {
        throw new ServiceException((Throwable)new DoNotRetryIOException("Unsupported method on master"));
    }

    public AdminProtos.GetServerInfoResponse getServerInfo(RpcController controller, AdminProtos.GetServerInfoRequest request) throws ServiceException {
        throw new ServiceException((Throwable)new DoNotRetryIOException("Unsupported method on master"));
    }

    public AdminProtos.StopServerResponse stopServer(RpcController controller, AdminProtos.StopServerRequest request) throws ServiceException {
        throw new ServiceException((Throwable)new DoNotRetryIOException("Unsupported method on master"));
    }

    public AdminProtos.UpdateFavoredNodesResponse updateFavoredNodes(RpcController controller, AdminProtos.UpdateFavoredNodesRequest request) throws ServiceException {
        throw new ServiceException((Throwable)new DoNotRetryIOException("Unsupported method on master"));
    }

    public AdminProtos.GetRegionLoadResponse getRegionLoad(RpcController controller, AdminProtos.GetRegionLoadRequest request) throws ServiceException {
        throw new ServiceException((Throwable)new DoNotRetryIOException("Unsupported method on master"));
    }

    public AdminProtos.ClearCompactionQueuesResponse clearCompactionQueues(RpcController controller, AdminProtos.ClearCompactionQueuesRequest request) throws ServiceException {
        throw new ServiceException((Throwable)new DoNotRetryIOException("Unsupported method on master"));
    }

    public AdminProtos.ClearRegionBlockCacheResponse clearRegionBlockCache(RpcController controller, AdminProtos.ClearRegionBlockCacheRequest request) throws ServiceException {
        throw new ServiceException((Throwable)new DoNotRetryIOException("Unsupported method on master"));
    }

    public QuotaProtos.GetSpaceQuotaSnapshotsResponse getSpaceQuotaSnapshots(RpcController controller, QuotaProtos.GetSpaceQuotaSnapshotsRequest request) throws ServiceException {
        throw new ServiceException((Throwable)new DoNotRetryIOException("Unsupported method on master"));
    }

    public AdminProtos.ExecuteProceduresResponse executeProcedures(RpcController controller, AdminProtos.ExecuteProceduresRequest request) throws ServiceException {
        throw new ServiceException((Throwable)new DoNotRetryIOException("Unsupported method on master"));
    }

    public RegionServerStatusProtos.GetLiveRegionServersResponse getLiveRegionServers(RpcController controller, RegionServerStatusProtos.GetLiveRegionServersRequest request) throws ServiceException {
        ArrayList<ServerName> regionServers = new ArrayList<ServerName>(((HMaster)this.server).getLiveRegionServers());
        Collections.shuffle(regionServers, ThreadLocalRandom.current());
        RegionServerStatusProtos.GetLiveRegionServersResponse.Builder builder = RegionServerStatusProtos.GetLiveRegionServersResponse.newBuilder().setTotal(regionServers.size());
        regionServers.stream().limit(request.getCount()).map(ProtobufUtil::toServerName).forEach(arg_0 -> ((RegionServerStatusProtos.GetLiveRegionServersResponse.Builder)builder).addServer(arg_0));
        return builder.build();
    }

    public AdminProtos.ReplicateWALEntryResponse replicateToReplica(RpcController controller, AdminProtos.ReplicateWALEntryRequest request) throws ServiceException {
        throw new ServiceException((Throwable)new DoNotRetryIOException("Unsupported method on master"));
    }

    public MasterProtos.FlushMasterStoreResponse flushMasterStore(RpcController controller, MasterProtos.FlushMasterStoreRequest request) throws ServiceException {
        this.rpcPreCheck("flushMasterStore");
        try {
            ((HMaster)this.server).flushMasterStore();
        }
        catch (IOException ioe) {
            throw new ServiceException((Throwable)ioe);
        }
        return MasterProtos.FlushMasterStoreResponse.newBuilder().build();
    }

    static enum BalanceSwitchMode {
        SYNC,
        ASYNC;

    }
}

