/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseServerBase;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.exceptions.X509Exception;
import org.apache.hadoop.hbase.io.FileChangeWatcher;
import org.apache.hadoop.hbase.io.crypto.tls.X509Util;
import org.apache.hadoop.hbase.ipc.HeapByteBufAllocator;
import org.apache.hadoop.hbase.ipc.NettyRpcServerPreambleHandler;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcSchedulerContext;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.security.HBasePolicyProvider;
import org.apache.hadoop.hbase.security.token.AuthenticationTokenSecretManager;
import org.apache.hadoop.hbase.util.NettyEventLoopGroupConfig;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.hadoop.security.authorize.ServiceAuthorizationManager;
import org.apache.hbase.thirdparty.io.netty.bootstrap.ServerBootstrap;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBufAllocator;
import org.apache.hbase.thirdparty.io.netty.buffer.PooledByteBufAllocator;
import org.apache.hbase.thirdparty.io.netty.buffer.UnpooledByteBufAllocator;
import org.apache.hbase.thirdparty.io.netty.channel.Channel;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandler;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelInitializer;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelOption;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelPipeline;
import org.apache.hbase.thirdparty.io.netty.channel.EventLoopGroup;
import org.apache.hbase.thirdparty.io.netty.channel.ServerChannel;
import org.apache.hbase.thirdparty.io.netty.channel.group.ChannelGroup;
import org.apache.hbase.thirdparty.io.netty.channel.group.DefaultChannelGroup;
import org.apache.hbase.thirdparty.io.netty.handler.codec.FixedLengthFrameDecoder;
import org.apache.hbase.thirdparty.io.netty.handler.ssl.OptionalSslHandler;
import org.apache.hbase.thirdparty.io.netty.handler.ssl.SslContext;
import org.apache.hbase.thirdparty.io.netty.handler.ssl.SslHandler;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.EventExecutor;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.GlobalEventExecutor;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class NettyRpcServer
extends RpcServer {
    public static final Logger LOG = LoggerFactory.getLogger(NettyRpcServer.class);
    public static final String HBASE_NETTY_ALLOCATOR_KEY = "hbase.netty.rpcserver.allocator";
    static final String POOLED_ALLOCATOR_TYPE = "pooled";
    static final String UNPOOLED_ALLOCATOR_TYPE = "unpooled";
    static final String HEAP_ALLOCATOR_TYPE = "heap";
    private final InetSocketAddress bindAddress;
    private final CountDownLatch closed = new CountDownLatch(1);
    private final Channel serverChannel;
    final ChannelGroup allChannels = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE, true);
    private final ByteBufAllocator channelAllocator;
    private final AtomicReference<SslContext> sslContextForServer = new AtomicReference();
    private final AtomicReference<FileChangeWatcher> keyStoreWatcher = new AtomicReference();
    private final AtomicReference<FileChangeWatcher> trustStoreWatcher = new AtomicReference();

    public NettyRpcServer(Server server, String name, List<RpcServer.BlockingServiceAndInterface> services, InetSocketAddress bindAddress, final Configuration conf, RpcScheduler scheduler, boolean reservoirEnabled) throws IOException {
        super(server, name, services, bindAddress, conf, scheduler, reservoirEnabled);
        this.bindAddress = bindAddress;
        this.channelAllocator = this.getChannelAllocator(conf);
        NettyEventLoopGroupConfig config = null;
        if (server instanceof HBaseServerBase) {
            config = ((HBaseServerBase)server).getEventLoopGroupConfig();
        }
        if (config == null) {
            config = new NettyEventLoopGroupConfig(conf, "NettyRpcServer");
        }
        EventLoopGroup eventLoopGroup = config.group();
        Class<? extends ServerChannel> channelClass = config.serverChannelClass();
        ServerBootstrap bootstrap = ((ServerBootstrap)new ServerBootstrap().group(eventLoopGroup).channel(channelClass)).childOption(ChannelOption.TCP_NODELAY, (Object)this.tcpNoDelay).childOption(ChannelOption.SO_KEEPALIVE, (Object)this.tcpKeepAlive).childOption(ChannelOption.SO_REUSEADDR, (Object)true).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ch.config().setAllocator(NettyRpcServer.this.channelAllocator);
                ChannelPipeline pipeline = ch.pipeline();
                FixedLengthFrameDecoder preambleDecoder = new FixedLengthFrameDecoder(6);
                preambleDecoder.setSingleDecode(true);
                if (conf.getBoolean("hbase.server.netty.tls.enabled", false)) {
                    NettyRpcServer.this.initSSL(pipeline, conf.getBoolean("hbase.server.netty.tls.supportplaintext", true));
                }
                pipeline.addLast("preambleDecoder", (ChannelHandler)preambleDecoder).addLast(new ChannelHandler[]{NettyRpcServer.this.createNettyRpcServerPreambleHandler()});
            }
        });
        try {
            this.serverChannel = bootstrap.bind((SocketAddress)this.bindAddress).sync().channel();
            LOG.info("Bind to {}", (Object)this.serverChannel.localAddress());
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(e.getMessage());
        }
        this.initReconfigurable(conf);
        this.scheduler.init(new RpcSchedulerContext(this));
    }

    private ByteBufAllocator getChannelAllocator(Configuration conf) throws IOException {
        String value = conf.get(HBASE_NETTY_ALLOCATOR_KEY);
        if (value != null) {
            if (POOLED_ALLOCATOR_TYPE.equalsIgnoreCase(value)) {
                LOG.info("Using {} for buffer allocation", (Object)PooledByteBufAllocator.class.getName());
                return PooledByteBufAllocator.DEFAULT;
            }
            if (UNPOOLED_ALLOCATOR_TYPE.equalsIgnoreCase(value)) {
                LOG.info("Using {} for buffer allocation", (Object)UnpooledByteBufAllocator.class.getName());
                return UnpooledByteBufAllocator.DEFAULT;
            }
            if (HEAP_ALLOCATOR_TYPE.equalsIgnoreCase(value)) {
                LOG.info("Using {} for buffer allocation", (Object)HeapByteBufAllocator.class.getName());
                return HeapByteBufAllocator.DEFAULT;
            }
            try {
                ByteBufAllocator alloc = (ByteBufAllocator)ReflectionUtils.newInstance((String)value, (Object[])new Object[0]);
                LOG.info("Using {} for buffer allocation", (Object)value);
                return alloc;
            }
            catch (ClassCastException | UnsupportedOperationException e) {
                throw new IOException(e);
            }
        }
        LOG.info("Using {} for buffer allocation", (Object)PooledByteBufAllocator.class.getName());
        return PooledByteBufAllocator.DEFAULT;
    }

    @InterfaceAudience.Private
    protected NettyRpcServerPreambleHandler createNettyRpcServerPreambleHandler() {
        return new NettyRpcServerPreambleHandler(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void start() {
        if (this.started) {
            return;
        }
        this.authTokenSecretMgr = this.createSecretManager();
        if (this.authTokenSecretMgr != null) {
            AuthenticationTokenSecretManager authenticationTokenSecretManager = this.authTokenSecretMgr;
            synchronized (authenticationTokenSecretManager) {
                this.setSecretManager(this.authTokenSecretMgr);
                this.authTokenSecretMgr.start();
            }
        }
        this.authManager = new ServiceAuthorizationManager();
        HBasePolicyProvider.init(this.conf, this.authManager);
        this.scheduler.start();
        this.started = true;
    }

    @Override
    public synchronized void stop() {
        FileChangeWatcher ts;
        if (!this.running) {
            return;
        }
        LOG.info("Stopping server on " + this.serverChannel.localAddress());
        FileChangeWatcher ks = this.keyStoreWatcher.getAndSet(null);
        if (ks != null) {
            ks.stop();
        }
        if ((ts = (FileChangeWatcher)this.trustStoreWatcher.getAndSet(null)) != null) {
            ts.stop();
        }
        if (this.authTokenSecretMgr != null) {
            this.authTokenSecretMgr.stop();
            this.authTokenSecretMgr = null;
        }
        this.allChannels.close().awaitUninterruptibly();
        this.serverChannel.close();
        this.scheduler.stop();
        this.closed.countDown();
        this.running = false;
    }

    @Override
    public synchronized void join() throws InterruptedException {
        this.closed.await();
    }

    @Override
    public synchronized InetSocketAddress getListenerAddress() {
        return (InetSocketAddress)this.serverChannel.localAddress();
    }

    @Override
    public void setSocketSendBufSize(int size) {
    }

    @Override
    public int getNumOpenConnections() {
        return this.allChannels.size();
    }

    private void initSSL(ChannelPipeline p, boolean supportPlaintext) throws X509Exception, IOException {
        SslContext nettySslContext = this.getSslContext();
        if (supportPlaintext) {
            p.addLast("ssl", (ChannelHandler)new OptionalSslHandler(nettySslContext));
            LOG.debug("Dual mode SSL handler added for channel: {}", (Object)p.channel());
        } else {
            SslHandler sslHandler;
            SocketAddress remoteAddress = p.channel().remoteAddress();
            if (remoteAddress instanceof InetSocketAddress) {
                InetSocketAddress remoteInetAddress = (InetSocketAddress)remoteAddress;
                String host = this.conf.getBoolean("hbase.rpc.tls.host-verification.reverse-dns.enabled", true) ? remoteInetAddress.getHostName() : remoteInetAddress.getHostString();
                int port = remoteInetAddress.getPort();
                sslHandler = nettySslContext.newHandler(p.channel().alloc(), host, port);
            } else {
                sslHandler = nettySslContext.newHandler(p.channel().alloc());
            }
            p.addLast("ssl", (ChannelHandler)sslHandler);
            LOG.debug("SSL handler added for channel: {}", (Object)p.channel());
        }
    }

    SslContext getSslContext() throws X509Exception, IOException {
        SslContext result = this.sslContextForServer.get();
        if (result == null) {
            result = X509Util.createSslContextForServer((Configuration)this.conf);
            if (!this.sslContextForServer.compareAndSet(null, result)) {
                result = this.sslContextForServer.get();
            } else if (this.keyStoreWatcher.get() == null && this.trustStoreWatcher.get() == null && this.conf.getBoolean("hbase.rpc.tls.certReload", false)) {
                X509Util.enableCertFileReloading((Configuration)this.conf, this.keyStoreWatcher, this.trustStoreWatcher, () -> this.sslContextForServer.set(null));
            }
        }
        return result;
    }
}

