/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.client.VersionInfoUtil;
import org.apache.hadoop.hbase.exceptions.RequestTooBigException;
import org.apache.hadoop.hbase.ipc.NettyRpcServer;
import org.apache.hadoop.hbase.ipc.NettyServerCall;
import org.apache.hadoop.hbase.ipc.NettyServerRpcConnection;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelFutureListener;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandlerContext;
import org.apache.hbase.thirdparty.io.netty.handler.codec.ByteToMessageDecoder;
import org.apache.hbase.thirdparty.io.netty.handler.codec.CorruptedFrameException;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.GenericFutureListener;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class NettyRpcFrameDecoder
extends ByteToMessageDecoder {
    private static int FRAME_LENGTH_FIELD_LENGTH = 4;
    private final int maxFrameLength;
    final NettyServerRpcConnection connection;
    private boolean requestTooBig;
    private boolean requestTooBigSent;
    private String requestTooBigMessage;

    public NettyRpcFrameDecoder(int maxFrameLength, NettyServerRpcConnection connection) {
        this.maxFrameLength = maxFrameLength;
        this.connection = connection;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (this.requestTooBigSent) {
            in.skipBytes(in.readableBytes());
            return;
        }
        if (this.requestTooBig) {
            this.handleTooBigRequest(ctx, in);
            return;
        }
        if (in.readableBytes() < FRAME_LENGTH_FIELD_LENGTH) {
            return;
        }
        long frameLength = in.getUnsignedInt(in.readerIndex());
        if (frameLength < 0L) {
            throw new IOException("negative frame length field: " + frameLength);
        }
        if (frameLength > (long)this.maxFrameLength) {
            this.requestTooBig = true;
            this.requestTooBigMessage = "RPC data length of " + frameLength + " received from " + this.connection.getHostAddress() + " is greater than max allowed " + this.connection.rpcServer.maxRequestSize + ". Set \"" + "hbase.ipc.max.request.size" + "\" on server to override this limit (not recommended)";
            NettyRpcServer.LOG.warn(this.requestTooBigMessage);
            if (this.connection.connectionHeaderRead) {
                this.handleTooBigRequest(ctx, in);
                return;
            }
            ctx.channel().close();
            return;
        }
        int frameLengthInt = (int)frameLength;
        if (in.readableBytes() < frameLengthInt + FRAME_LENGTH_FIELD_LENGTH) {
            return;
        }
        in.skipBytes(FRAME_LENGTH_FIELD_LENGTH);
        out.add(in.readRetainedSlice(frameLengthInt));
    }

    private void handleTooBigRequest(ChannelHandlerContext ctx, ByteBuf in) throws IOException {
        in.skipBytes(FRAME_LENGTH_FIELD_LENGTH);
        in.markReaderIndex();
        int preIndex = in.readerIndex();
        int headerSize = NettyRpcFrameDecoder.readRawVarint32(in);
        if (preIndex == in.readerIndex()) {
            return;
        }
        if (headerSize < 0) {
            throw new IOException("negative headerSize: " + headerSize);
        }
        if (in.readableBytes() < headerSize) {
            NettyRpcServer.LOG.debug("headerSize is larger than readableBytes");
            in.resetReaderIndex();
            return;
        }
        RPCProtos.RequestHeader header = this.getHeader(in, headerSize);
        NettyRpcServer.LOG.info("BigRequest header is = " + header);
        NettyServerCall reqTooBig = this.connection.createCall(header.getCallId(), this.connection.service, null, null, null, null, 0L, this.connection.addr, 0, null);
        RequestTooBigException reqTooBigEx = new RequestTooBigException(this.requestTooBigMessage);
        this.connection.rpcServer.metrics.exception((Throwable)reqTooBigEx);
        if (VersionInfoUtil.hasMinimumVersion(this.connection.getVersionInfo(), 1, 3)) {
            reqTooBig.setResponse(null, null, (Throwable)reqTooBigEx, this.requestTooBigMessage);
        } else {
            reqTooBig.setResponse(null, null, (Throwable)new DoNotRetryIOException(this.requestTooBigMessage), this.requestTooBigMessage);
        }
        reqTooBig.param = null;
        this.connection.channel.writeAndFlush((Object)reqTooBig).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        in.skipBytes(in.readableBytes());
        this.requestTooBigSent = true;
        ctx.channel().config().setAutoRead(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RPCProtos.RequestHeader getHeader(ByteBuf in, int headerSize) throws IOException {
        ByteBuf msg = in.readRetainedSlice(headerSize);
        try {
            int offset;
            byte[] array;
            int length = msg.readableBytes();
            if (msg.hasArray()) {
                array = msg.array();
                offset = msg.arrayOffset() + msg.readerIndex();
            } else {
                array = new byte[length];
                msg.getBytes(msg.readerIndex(), array, 0, length);
                offset = 0;
            }
            RPCProtos.RequestHeader.Builder builder = RPCProtos.RequestHeader.newBuilder();
            ProtobufUtil.mergeFrom((Message.Builder)builder, (byte[])array, (int)offset, (int)length);
            RPCProtos.RequestHeader requestHeader = builder.build();
            return requestHeader;
        }
        finally {
            msg.release();
        }
    }

    private static int readRawVarint32(ByteBuf buffer) {
        if (!buffer.isReadable()) {
            return 0;
        }
        buffer.markReaderIndex();
        byte tmp = buffer.readByte();
        if (tmp >= 0) {
            return tmp;
        }
        int result = tmp & 0x7F;
        if (!buffer.isReadable()) {
            buffer.resetReaderIndex();
            return 0;
        }
        tmp = buffer.readByte();
        if (tmp >= 0) {
            result |= tmp << 7;
        } else {
            result |= (tmp & 0x7F) << 7;
            if (!buffer.isReadable()) {
                buffer.resetReaderIndex();
                return 0;
            }
            tmp = buffer.readByte();
            if (tmp >= 0) {
                result |= tmp << 14;
            } else {
                result |= (tmp & 0x7F) << 14;
                if (!buffer.isReadable()) {
                    buffer.resetReaderIndex();
                    return 0;
                }
                tmp = buffer.readByte();
                if (tmp >= 0) {
                    result |= tmp << 21;
                } else {
                    result |= (tmp & 0x7F) << 21;
                    if (!buffer.isReadable()) {
                        buffer.resetReaderIndex();
                        return 0;
                    }
                    tmp = buffer.readByte();
                    result |= tmp << 28;
                    if (tmp < 0) {
                        throw new CorruptedFrameException("malformed varint.");
                    }
                }
            }
        }
        return result;
    }
}

