/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class BufferChain {
    private final ByteBuffer[] buffers;
    private int remaining = 0;
    private int size;

    BufferChain(ByteBuffer ... buffers) {
        for (ByteBuffer b : buffers) {
            this.remaining += b.remaining();
        }
        this.size = this.remaining;
        this.buffers = buffers;
    }

    byte[] getBytes() {
        if (!this.hasRemaining()) {
            throw new IllegalAccessError();
        }
        byte[] bytes = new byte[this.remaining];
        int offset = 0;
        for (ByteBuffer bb : this.buffers) {
            int length = bb.remaining();
            bb.get(bytes, offset, length);
            offset += length;
        }
        return bytes;
    }

    boolean hasRemaining() {
        return this.remaining > 0;
    }

    long write(GatheringByteChannel channel) throws IOException {
        if (!this.hasRemaining()) {
            return 0L;
        }
        long written = 0L;
        for (ByteBuffer bb : this.buffers) {
            if (!bb.hasRemaining()) continue;
            int pos = bb.position();
            int result = channel.write(bb);
            if (result <= 0) {
                return written;
            }
            bb.position(pos + result);
            this.remaining -= result;
            written += (long)result;
        }
        return written;
    }

    int size() {
        return this.size;
    }

    ByteBuffer[] getBuffers() {
        return this.buffers;
    }
}

