/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile.bucket;

import java.io.IOException;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketCache;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class BucketCachePersister
extends Thread {
    private final BucketCache cache;
    private final long intervalMillis;
    private static final Logger LOG = LoggerFactory.getLogger(BucketCachePersister.class);

    public BucketCachePersister(BucketCache cache, long intervalMillis) {
        super("bucket-cache-persister");
        this.cache = cache;
        this.intervalMillis = intervalMillis;
        LOG.info("BucketCachePersister started with interval: " + intervalMillis);
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    Thread.sleep(this.intervalMillis);
                    if (!this.cache.isCacheInconsistent()) continue;
                    LOG.debug("Cache is inconsistent, persisting to disk");
                    this.cache.persistToFile();
                    this.cache.setCacheInconsistent(false);
                }
            }
            catch (IOException e) {
                LOG.warn("IOException in BucketCachePersister {} ", (Object)e.getMessage());
                continue;
            }
            catch (InterruptedException iex) {
                LOG.warn("InterruptedException in BucketCachePersister {} ", (Object)iex.getMessage());
                return;
            }
            break;
        }
    }
}

