/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.ConnectionRegistry;
import org.apache.hadoop.hbase.client.ConnectionRegistryEndpoint;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class ShortCircuitConnectionRegistry
implements ConnectionRegistry {
    private final ConnectionRegistryEndpoint endpoint;

    public ShortCircuitConnectionRegistry(ConnectionRegistryEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public CompletableFuture<RegionLocations> getMetaRegionLocations() {
        CompletableFuture<RegionLocations> future = new CompletableFuture<RegionLocations>();
        List<HRegionLocation> locs = this.endpoint.getMetaLocations();
        if (locs.isEmpty()) {
            future.completeExceptionally(new IOException("no meta location available"));
        } else {
            future.complete(new RegionLocations(locs));
        }
        return future;
    }

    public CompletableFuture<String> getClusterId() {
        return CompletableFuture.completedFuture(this.endpoint.getClusterId());
    }

    public CompletableFuture<ServerName> getActiveMaster() {
        CompletableFuture<ServerName> future = new CompletableFuture<ServerName>();
        Optional<ServerName> activeMaster = this.endpoint.getActiveMaster();
        if (activeMaster.isPresent()) {
            future.complete(activeMaster.get());
        } else {
            future.completeExceptionally(new IOException("no active master available"));
        }
        return future;
    }

    public String getConnectionString() {
        return "short-circuit";
    }

    public void close() {
    }
}

