/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcCallback;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class AsyncRegionServerAdmin {
    private final ServerName server;
    private final AsyncConnectionImpl conn;

    AsyncRegionServerAdmin(ServerName server, AsyncConnectionImpl conn) {
        this.server = server;
        this.conn = conn;
    }

    private <RESP> CompletableFuture<RESP> call(RpcCall<RESP> rpcCall, CellScanner cellScanner) {
        final CompletableFuture future = new CompletableFuture();
        final HBaseRpcController controller = this.conn.rpcControllerFactory.newController(null, cellScanner);
        try {
            rpcCall.call(this.conn.getAdminStub(this.server), controller, new RpcCallback<RESP>(){

                public void run(RESP resp) {
                    if (controller.failed()) {
                        future.completeExceptionally(controller.getFailed());
                    } else {
                        future.complete(resp);
                    }
                }
            });
        }
        catch (IOException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    private <RESP> CompletableFuture<RESP> call(RpcCall<RESP> rpcCall) {
        return this.call(rpcCall, null);
    }

    public CompletableFuture<AdminProtos.GetRegionInfoResponse> getRegionInfo(AdminProtos.GetRegionInfoRequest request) {
        return this.call((stub, controller, done) -> stub.getRegionInfo((RpcController)controller, request, done));
    }

    public CompletableFuture<AdminProtos.GetStoreFileResponse> getStoreFile(AdminProtos.GetStoreFileRequest request) {
        return this.call((stub, controller, done) -> stub.getStoreFile((RpcController)controller, request, done));
    }

    public CompletableFuture<AdminProtos.GetOnlineRegionResponse> getOnlineRegion(AdminProtos.GetOnlineRegionRequest request) {
        return this.call((stub, controller, done) -> stub.getOnlineRegion((RpcController)controller, request, done));
    }

    public CompletableFuture<AdminProtos.OpenRegionResponse> openRegion(AdminProtos.OpenRegionRequest request) {
        return this.call((stub, controller, done) -> stub.openRegion((RpcController)controller, request, done));
    }

    public CompletableFuture<AdminProtos.WarmupRegionResponse> warmupRegion(AdminProtos.WarmupRegionRequest request) {
        return this.call((stub, controller, done) -> stub.warmupRegion((RpcController)controller, request, done));
    }

    public CompletableFuture<AdminProtos.CloseRegionResponse> closeRegion(AdminProtos.CloseRegionRequest request) {
        return this.call((stub, controller, done) -> stub.closeRegion((RpcController)controller, request, done));
    }

    public CompletableFuture<AdminProtos.FlushRegionResponse> flushRegion(AdminProtos.FlushRegionRequest request) {
        return this.call((stub, controller, done) -> stub.flushRegion((RpcController)controller, request, done));
    }

    public CompletableFuture<AdminProtos.CompactionSwitchResponse> compactionSwitch(AdminProtos.CompactionSwitchRequest request) {
        return this.call((stub, controller, done) -> stub.compactionSwitch((RpcController)controller, request, done));
    }

    public CompletableFuture<AdminProtos.CompactRegionResponse> compactRegion(AdminProtos.CompactRegionRequest request) {
        return this.call((stub, controller, done) -> stub.compactRegion((RpcController)controller, request, done));
    }

    public CompletableFuture<AdminProtos.ReplicateWALEntryResponse> replicateWALEntry(AdminProtos.ReplicateWALEntryRequest request, CellScanner cellScanner, int timeout) {
        return this.call((stub, controller, done) -> {
            controller.setCallTimeout(timeout);
            stub.replicateWALEntry((RpcController)controller, request, done);
        }, cellScanner);
    }

    public CompletableFuture<AdminProtos.ReplicateWALEntryResponse> replay(AdminProtos.ReplicateWALEntryRequest request, CellScanner cellScanner) {
        return this.call((stub, controller, done) -> stub.replay((RpcController)controller, request, done), cellScanner);
    }

    public CompletableFuture<AdminProtos.RollWALWriterResponse> rollWALWriter(AdminProtos.RollWALWriterRequest request) {
        return this.call((stub, controller, done) -> stub.rollWALWriter((RpcController)controller, request, done));
    }

    public CompletableFuture<AdminProtos.GetServerInfoResponse> getServerInfo(AdminProtos.GetServerInfoRequest request) {
        return this.call((stub, controller, done) -> stub.getServerInfo((RpcController)controller, request, done));
    }

    public CompletableFuture<AdminProtos.StopServerResponse> stopServer(AdminProtos.StopServerRequest request) {
        return this.call((stub, controller, done) -> stub.stopServer((RpcController)controller, request, done));
    }

    public CompletableFuture<AdminProtos.UpdateFavoredNodesResponse> updateFavoredNodes(AdminProtos.UpdateFavoredNodesRequest request) {
        return this.call((stub, controller, done) -> stub.updateFavoredNodes((RpcController)controller, request, done));
    }

    public CompletableFuture<AdminProtos.UpdateConfigurationResponse> updateConfiguration(AdminProtos.UpdateConfigurationRequest request) {
        return this.call((stub, controller, done) -> stub.updateConfiguration((RpcController)controller, request, done));
    }

    public CompletableFuture<AdminProtos.GetRegionLoadResponse> getRegionLoad(AdminProtos.GetRegionLoadRequest request) {
        return this.call((stub, controller, done) -> stub.getRegionLoad((RpcController)controller, request, done));
    }

    public CompletableFuture<AdminProtos.ClearCompactionQueuesResponse> clearCompactionQueues(AdminProtos.ClearCompactionQueuesRequest request) {
        return this.call((stub, controller, done) -> stub.clearCompactionQueues((RpcController)controller, request, done));
    }

    public CompletableFuture<AdminProtos.ClearRegionBlockCacheResponse> clearRegionBlockCache(AdminProtos.ClearRegionBlockCacheRequest request) {
        return this.call((stub, controller, done) -> stub.clearRegionBlockCache((RpcController)controller, request, done));
    }

    public CompletableFuture<QuotaProtos.GetSpaceQuotaSnapshotsResponse> getSpaceQuotaSnapshots(QuotaProtos.GetSpaceQuotaSnapshotsRequest request) {
        return this.call((stub, controller, done) -> stub.getSpaceQuotaSnapshots((RpcController)controller, request, done));
    }

    public CompletableFuture<AdminProtos.ExecuteProceduresResponse> executeProcedures(AdminProtos.ExecuteProceduresRequest request) {
        return this.call((stub, controller, done) -> stub.executeProcedures((RpcController)controller, request, done));
    }

    @FunctionalInterface
    private static interface RpcCall<RESP> {
        public void call(AdminProtos.AdminService.Interface var1, HBaseRpcController var2, RpcCallback<RESP> var3);
    }
}

