/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class LocalHBaseCluster {
    private static final Logger LOG = LoggerFactory.getLogger(LocalHBaseCluster.class);
    private final List<JVMClusterUtil.MasterThread> masterThreads = new CopyOnWriteArrayList<JVMClusterUtil.MasterThread>();
    private final List<JVMClusterUtil.RegionServerThread> regionThreads = new CopyOnWriteArrayList<JVMClusterUtil.RegionServerThread>();
    private static final int DEFAULT_NO = 1;
    public static final String LOCAL = "local";
    public static final String LOCAL_COLON = "local:";
    public static final String ASSIGN_RANDOM_PORTS = "hbase.localcluster.assign.random.ports";
    private final Configuration conf;
    private final Class<? extends HMaster> masterClass;
    private final Class<? extends HRegionServer> regionServerClass;

    public LocalHBaseCluster(Configuration conf) throws IOException {
        this(conf, 1);
    }

    public LocalHBaseCluster(Configuration conf, int noRegionServers) throws IOException {
        this(conf, 1, 0, noRegionServers, LocalHBaseCluster.getMasterImplementation(conf), LocalHBaseCluster.getRegionServerImplementation(conf));
    }

    public LocalHBaseCluster(Configuration conf, int noMasters, int noRegionServers) throws IOException {
        this(conf, noMasters, 0, noRegionServers, LocalHBaseCluster.getMasterImplementation(conf), LocalHBaseCluster.getRegionServerImplementation(conf));
    }

    private static Class<? extends HRegionServer> getRegionServerImplementation(Configuration conf) {
        return conf.getClass("hbase.regionserver.impl", HRegionServer.class);
    }

    private static Class<? extends HMaster> getMasterImplementation(Configuration conf) {
        return conf.getClass("hbase.master.impl", HMaster.class);
    }

    public LocalHBaseCluster(Configuration conf, int noMasters, int noRegionServers, Class<? extends HMaster> masterClass, Class<? extends HRegionServer> regionServerClass) throws IOException {
        this(conf, noMasters, 0, noRegionServers, masterClass, regionServerClass);
    }

    public LocalHBaseCluster(Configuration conf, int noMasters, int noAlwaysStandByMasters, int noRegionServers, Class<? extends HMaster> masterClass, Class<? extends HRegionServer> regionServerClass) throws IOException {
        int j;
        int i;
        this.conf = conf;
        if (conf.getBoolean(ASSIGN_RANDOM_PORTS, false)) {
            if (conf.getInt("hbase.master.port", 16000) == 16000) {
                LOG.debug("Setting Master Port to random.");
                conf.set("hbase.master.port", "0");
            }
            if (conf.getInt("hbase.regionserver.port", 16020) == 16020) {
                LOG.debug("Setting RegionServer Port to random.");
                conf.set("hbase.regionserver.port", "0");
            }
            if (conf.getInt("hbase.regionserver.info.port", 0) != -1 && conf.getInt("hbase.regionserver.info.port", 16030) == 16030) {
                LOG.debug("Setting RS InfoServer Port to random.");
                conf.set("hbase.regionserver.info.port", "0");
            }
            if (conf.getInt("hbase.master.info.port", 0) != -1 && conf.getInt("hbase.master.info.port", 16010) == 16010) {
                LOG.debug("Setting Master InfoServer Port to random.");
                conf.set("hbase.master.info.port", "0");
            }
        }
        this.masterClass = conf.getClass("hbase.master.impl", masterClass);
        for (i = 0; i < noMasters; ++i) {
            this.addMaster(new Configuration(conf), i);
        }
        for (j = 0; j < noAlwaysStandByMasters; ++j) {
            Configuration c = new Configuration(conf);
            c.set("hbase.master.impl", "org.apache.hadoop.hbase.master.AlwaysStandByHMaster");
            this.addMaster(c, i + j);
        }
        this.regionServerClass = conf.getClass("hbase.regionserver.impl", regionServerClass);
        for (j = 0; j < noRegionServers; ++j) {
            this.addRegionServer(new Configuration(conf), j);
        }
    }

    public JVMClusterUtil.RegionServerThread addRegionServer() throws IOException {
        return this.addRegionServer(new Configuration(this.conf), this.regionThreads.size());
    }

    public JVMClusterUtil.RegionServerThread addRegionServer(Configuration config, int index) throws IOException {
        JVMClusterUtil.RegionServerThread rst = JVMClusterUtil.createRegionServerThread(config, this.conf.getClass("hbase.regionserver.impl", this.regionServerClass), index);
        this.regionThreads.add(rst);
        return rst;
    }

    public JVMClusterUtil.RegionServerThread addRegionServer(final Configuration config, final int index, User user) throws IOException, InterruptedException {
        return (JVMClusterUtil.RegionServerThread)user.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<JVMClusterUtil.RegionServerThread>(){

            @Override
            public JVMClusterUtil.RegionServerThread run() throws Exception {
                return LocalHBaseCluster.this.addRegionServer(config, index);
            }
        });
    }

    public JVMClusterUtil.MasterThread addMaster() throws IOException {
        return this.addMaster(new Configuration(this.conf), this.masterThreads.size());
    }

    public JVMClusterUtil.MasterThread addMaster(Configuration c, int index) throws IOException {
        JVMClusterUtil.MasterThread mt = JVMClusterUtil.createMasterThread(c, c.getClass("hbase.master.impl", this.masterClass), index);
        this.masterThreads.add(mt);
        ArrayList masterHostPorts = new ArrayList();
        this.getMasters().forEach(masterThread -> masterHostPorts.add(masterThread.getMaster().getServerName().getAddress().toString()));
        this.conf.set("hbase.masters", String.join((CharSequence)",", masterHostPorts));
        return mt;
    }

    public JVMClusterUtil.MasterThread addMaster(final Configuration c, final int index, User user) throws IOException, InterruptedException {
        return (JVMClusterUtil.MasterThread)user.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<JVMClusterUtil.MasterThread>(){

            @Override
            public JVMClusterUtil.MasterThread run() throws Exception {
                return LocalHBaseCluster.this.addMaster(c, index);
            }
        });
    }

    public HRegionServer getRegionServer(int serverNumber) {
        return this.regionThreads.get(serverNumber).getRegionServer();
    }

    public List<JVMClusterUtil.RegionServerThread> getRegionServers() {
        return Collections.unmodifiableList(this.regionThreads);
    }

    public List<JVMClusterUtil.RegionServerThread> getLiveRegionServers() {
        ArrayList<JVMClusterUtil.RegionServerThread> liveServers = new ArrayList<JVMClusterUtil.RegionServerThread>();
        List<JVMClusterUtil.RegionServerThread> list = this.getRegionServers();
        for (JVMClusterUtil.RegionServerThread rst : list) {
            if (rst.isAlive()) {
                liveServers.add(rst);
                continue;
            }
            LOG.info("Not alive " + rst.getName());
        }
        return liveServers;
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public String waitOnRegionServer(int serverNumber) {
        JVMClusterUtil.RegionServerThread regionServerThread = this.regionThreads.get(serverNumber);
        return this.waitOnRegionServer(regionServerThread);
    }

    public String waitOnRegionServer(JVMClusterUtil.RegionServerThread rst) {
        boolean interrupted = false;
        while (rst.isAlive()) {
            try {
                LOG.info("Waiting on " + rst.getRegionServer().toString());
                rst.join();
            }
            catch (InterruptedException e) {
                LOG.error("Interrupted while waiting for {} to finish. Retrying join", (Object)rst.getName(), (Object)e);
                interrupted = true;
            }
        }
        this.regionThreads.remove(rst);
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        return rst.getName();
    }

    public HMaster getMaster(int serverNumber) {
        return this.masterThreads.get(serverNumber).getMaster();
    }

    public HMaster getActiveMaster() {
        for (JVMClusterUtil.MasterThread mt : this.masterThreads) {
            if (!mt.getMaster().isActiveMaster() || mt.getMaster().isStopped()) continue;
            return mt.getMaster();
        }
        return null;
    }

    public List<JVMClusterUtil.MasterThread> getMasters() {
        return Collections.unmodifiableList(this.masterThreads);
    }

    public List<JVMClusterUtil.MasterThread> getLiveMasters() {
        ArrayList<JVMClusterUtil.MasterThread> liveServers = new ArrayList<JVMClusterUtil.MasterThread>();
        List<JVMClusterUtil.MasterThread> list = this.getMasters();
        for (JVMClusterUtil.MasterThread mt : list) {
            if (!mt.isAlive()) continue;
            liveServers.add(mt);
        }
        return liveServers;
    }

    public String waitOnMaster(int serverNumber) {
        JVMClusterUtil.MasterThread masterThread = this.masterThreads.get(serverNumber);
        return this.waitOnMaster(masterThread);
    }

    public String waitOnMaster(JVMClusterUtil.MasterThread masterThread) {
        boolean interrupted = false;
        while (masterThread.isAlive()) {
            try {
                LOG.info("Waiting on " + masterThread.getMaster().getServerName().toString());
                masterThread.join();
            }
            catch (InterruptedException e) {
                LOG.error("Interrupted while waiting for {} to finish. Retrying join", (Object)masterThread.getName(), (Object)e);
                interrupted = true;
            }
        }
        this.masterThreads.remove(masterThread);
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        return masterThread.getName();
    }

    public void join() {
        if (this.regionThreads != null) {
            for (Thread thread : this.regionThreads) {
                if (!thread.isAlive()) continue;
                try {
                    Threads.threadDumpingIsAlive((Thread)thread);
                }
                catch (InterruptedException e) {
                    LOG.debug("Interrupted", (Throwable)e);
                }
            }
        }
        if (this.masterThreads != null) {
            for (Thread thread : this.masterThreads) {
                if (!thread.isAlive()) continue;
                try {
                    Threads.threadDumpingIsAlive((Thread)thread);
                }
                catch (InterruptedException e) {
                    LOG.debug("Interrupted", (Throwable)e);
                }
            }
        }
    }

    public void startup() throws IOException {
        JVMClusterUtil.startup(this.masterThreads, this.regionThreads);
    }

    public void shutdown() {
        JVMClusterUtil.shutdown(this.masterThreads, this.regionThreads);
    }

    public static boolean isLocal(Configuration c) {
        boolean mode = c.getBoolean("hbase.cluster.distributed", false);
        return !mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        Configuration conf = HBaseConfiguration.create();
        LocalHBaseCluster cluster = new LocalHBaseCluster(conf);
        cluster.startup();
        try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
             Admin admin = connection.getAdmin();){
            TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)cluster.getClass().getName())).build();
            admin.createTable(htd);
        }
        finally {
            cluster.shutdown();
        }
    }
}

