/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.security.AccessRequest;
import org.apache.hadoop.yarn.security.YarnAuthorizationProvider;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueACLsManager {
    private static final Logger LOG = LoggerFactory.getLogger(QueueACLsManager.class);
    private ResourceScheduler scheduler;
    private boolean isACLsEnable;
    private YarnAuthorizationProvider authorizer;

    @VisibleForTesting
    public QueueACLsManager() {
        this(null, new Configuration());
    }

    public QueueACLsManager(ResourceScheduler scheduler, Configuration conf) {
        this.scheduler = scheduler;
        this.isACLsEnable = conf.getBoolean("yarn.acl.enable", false);
        this.authorizer = YarnAuthorizationProvider.getInstance((Configuration)conf);
    }

    public boolean checkAccess(UserGroupInformation callerUGI, QueueACL acl, RMApp app, String remoteAddress, List<String> forwardedAddresses) {
        if (!this.isACLsEnable) {
            return true;
        }
        if (this.scheduler instanceof CapacityScheduler) {
            CSQueue queue = ((CapacityScheduler)this.scheduler).getQueue(app.getQueue());
            if (queue == null) {
                LOG.error("Queue " + app.getQueue() + " does not exist for " + app.getApplicationId());
                return true;
            }
            return this.authorizer.checkPermission(new AccessRequest(queue.getPrivilegedEntity(), callerUGI, SchedulerUtils.toAccessType(acl), app.getApplicationId().toString(), app.getName(), remoteAddress, forwardedAddresses));
        }
        return this.scheduler.checkAccess(callerUGI, acl, app.getQueue());
    }

    public boolean checkAccess(UserGroupInformation callerUGI, QueueACL acl, RMApp app, String remoteAddress, List<String> forwardedAddresses, String targetQueue) {
        if (!this.isACLsEnable) {
            return true;
        }
        if (this.scheduler instanceof CapacityScheduler) {
            CSQueue queue = ((CapacityScheduler)this.scheduler).getQueue(targetQueue);
            if (queue == null) {
                LOG.warn("Target queue " + targetQueue + " does not exist while trying to move " + app.getApplicationId());
                return false;
            }
            return this.authorizer.checkPermission(new AccessRequest(queue.getPrivilegedEntity(), callerUGI, SchedulerUtils.toAccessType(acl), app.getApplicationId().toString(), app.getName(), remoteAddress, forwardedAddresses));
        }
        if (this.scheduler instanceof FairScheduler) {
            FSQueue queue = ((FairScheduler)this.scheduler).getQueueManager().getQueue(targetQueue);
            if (queue == null) {
                LOG.warn("Target queue " + targetQueue + " does not exist while trying to move " + app.getApplicationId());
                return false;
            }
            return this.scheduler.checkAccess(callerUGI, acl, targetQueue);
        }
        return this.scheduler.checkAccess(callerUGI, acl, targetQueue);
    }
}

