/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.client;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLContext;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.rest.client.Cluster;
import org.apache.hadoop.hbase.rest.client.Response;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.client.KerberosAuthenticator;
import org.apache.hbase.thirdparty.com.google.common.io.ByteStreams;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class Client {
    public static final Header[] EMPTY_HEADER_ARRAY = new Header[0];
    private static final Logger LOG = LoggerFactory.getLogger(Client.class);
    private HttpClient httpClient;
    private Cluster cluster;
    private Configuration conf;
    private boolean sslEnabled;
    private HttpResponse resp;
    private HttpGet httpGet = null;
    private Map<String, String> extraHeaders;
    private static final String AUTH_COOKIE = "hadoop.auth";
    private static final String AUTH_COOKIE_EQ = "hadoop.auth=";
    private static final String COOKIE = "Cookie";

    public Client() {
        this(null);
    }

    private void initialize(Cluster cluster, Configuration conf, boolean sslEnabled, Optional<KeyStore> trustStore) {
        this.cluster = cluster;
        this.conf = conf;
        this.sslEnabled = sslEnabled;
        this.extraHeaders = new ConcurrentHashMap<String, String>();
        String clspath = System.getProperty("java.class.path");
        LOG.debug("classpath " + clspath);
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        int connTimeout = this.conf.getInt("hbase.rest.client.conn.timeout", 2000);
        int socketTimeout = this.conf.getInt("hbase.rest.client.socket.timeout", 30000);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connTimeout).setSocketTimeout(socketTimeout).setNormalizeUri(false).build();
        httpClientBuilder.setDefaultRequestConfig(requestConfig);
        httpClientBuilder.disableContentCompression();
        if (sslEnabled && trustStore.isPresent()) {
            try {
                SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(trustStore.get(), null).build();
                httpClientBuilder.setSSLContext(sslcontext);
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                throw new ClientTrustStoreInitializationException("Error while processing truststore", e);
            }
        }
        this.httpClient = httpClientBuilder.build();
    }

    public Client(Cluster cluster) {
        this(cluster, false);
    }

    public Client(Cluster cluster, boolean sslEnabled) {
        this.initialize(cluster, HBaseConfiguration.create(), sslEnabled, Optional.empty());
    }

    public Client(Cluster cluster, Configuration conf, boolean sslEnabled) {
        this.initialize(cluster, conf, sslEnabled, Optional.empty());
    }

    public Client(Cluster cluster, String trustStorePath, Optional<String> trustStorePassword, Optional<String> trustStoreType) {
        this(cluster, HBaseConfiguration.create(), trustStorePath, trustStorePassword, trustStoreType);
    }

    public Client(Cluster cluster, Configuration conf, String trustStorePath, Optional<String> trustStorePassword, Optional<String> trustStoreType) {
        KeyStore trustStore;
        char[] password = trustStorePassword.map(String::toCharArray).orElse(null);
        String type = trustStoreType.orElse(KeyStore.getDefaultType());
        try {
            trustStore = KeyStore.getInstance(type);
        }
        catch (KeyStoreException e) {
            throw new ClientTrustStoreInitializationException("Invalid trust store type: " + type, e);
        }
        try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(new File(trustStorePath).toPath(), new OpenOption[0]));){
            trustStore.load(inputStream, password);
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException e) {
            throw new ClientTrustStoreInitializationException("Trust store load error: " + trustStorePath, e);
        }
        this.initialize(cluster, conf, true, Optional.of(trustStore));
    }

    public void shutdown() {
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void addExtraHeader(String name, String value) {
        this.extraHeaders.put(name, value);
    }

    public String getExtraHeader(String name) {
        return this.extraHeaders.get(name);
    }

    public Map<String, String> getExtraHeaders() {
        return Collections.unmodifiableMap(this.extraHeaders);
    }

    public void removeExtraHeader(String name) {
        this.extraHeaders.remove(name);
    }

    public HttpResponse executePathOnly(Cluster cluster, HttpUriRequest method, Header[] headers, String path) throws IOException {
        IOException lastException;
        int start;
        if (cluster.nodes.size() < 1) {
            throw new IOException("Cluster is empty");
        }
        int i = start = (int)Math.round((double)(cluster.nodes.size() - 1) * Math.random());
        do {
            cluster.lastHost = cluster.nodes.get(i);
            try {
                StringBuilder sb = new StringBuilder();
                if (this.sslEnabled) {
                    sb.append("https://");
                } else {
                    sb.append("http://");
                }
                sb.append(cluster.lastHost);
                sb.append(path);
                URI uri = new URI(sb.toString());
                if (method instanceof HttpPut) {
                    HttpPut put = new HttpPut(uri);
                    put.setEntity(((HttpPut)method).getEntity());
                    put.setHeaders(method.getAllHeaders());
                    method = put;
                } else if (method instanceof HttpGet) {
                    method = new HttpGet(uri);
                } else if (method instanceof HttpHead) {
                    method = new HttpHead(uri);
                } else if (method instanceof HttpDelete) {
                    method = new HttpDelete(uri);
                } else if (method instanceof HttpPost) {
                    HttpPost post = new HttpPost(uri);
                    post.setEntity(((HttpPost)method).getEntity());
                    post.setHeaders(method.getAllHeaders());
                    method = post;
                }
                return this.executeURI(method, headers, uri.toString());
            }
            catch (IOException e) {
                lastException = e;
            }
            catch (URISyntaxException use) {
                lastException = new IOException(use);
            }
        } while (++i != start && i < cluster.nodes.size());
        throw lastException;
    }

    public HttpResponse executeURI(HttpUriRequest method, Header[] headers, String uri) throws IOException {
        for (Map.Entry<String, String> e : this.extraHeaders.entrySet()) {
            method.addHeader(e.getKey(), e.getValue());
        }
        if (headers != null) {
            for (Header header : headers) {
                method.addHeader(header);
            }
        }
        long startTime = EnvironmentEdgeManager.currentTime();
        if (this.resp != null) {
            EntityUtils.consumeQuietly((HttpEntity)this.resp.getEntity());
        }
        this.resp = this.httpClient.execute(method);
        if (this.resp.getStatusLine().getStatusCode() == 401) {
            LOG.debug("Performing negotiation with the server.");
            this.negotiate(method, uri);
            this.resp = this.httpClient.execute(method);
        }
        long endTime = EnvironmentEdgeManager.currentTime();
        if (LOG.isTraceEnabled()) {
            LOG.trace(method.getMethod() + " " + uri + " " + this.resp.getStatusLine().getStatusCode() + " " + this.resp.getStatusLine().getReasonPhrase() + " in " + (endTime - startTime) + " ms");
        }
        return this.resp;
    }

    public HttpResponse execute(Cluster cluster, HttpUriRequest method, Header[] headers, String path) throws IOException {
        if (path.startsWith("/")) {
            return this.executePathOnly(cluster, method, headers, path);
        }
        return this.executeURI(method, headers, path);
    }

    private void negotiate(HttpUriRequest method, String uri) throws IOException {
        try {
            AuthenticatedURL.Token token = new AuthenticatedURL.Token();
            KerberosAuthenticator authenticator = new KerberosAuthenticator();
            authenticator.authenticate(new URL(uri), token);
            this.injectToken(method, token);
        }
        catch (AuthenticationException e) {
            LOG.error("Failed to negotiate with the server.", (Throwable)e);
            throw new IOException(e);
        }
    }

    private void injectToken(HttpUriRequest method, AuthenticatedURL.Token token) {
        String t = token.toString();
        if (t != null) {
            if (!t.startsWith("\"")) {
                t = "\"" + t + "\"";
            }
            method.addHeader(COOKIE, AUTH_COOKIE_EQ + t);
        }
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }

    public Response head(String path) throws IOException {
        return this.head(this.cluster, path, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response head(Cluster cluster, String path, Header[] headers) throws IOException {
        HttpHead method = new HttpHead(path);
        try {
            HttpResponse resp = this.execute(cluster, (HttpUriRequest)method, null, path);
            Response response = new Response(resp.getStatusLine().getStatusCode(), resp.getAllHeaders(), null);
            return response;
        }
        finally {
            method.releaseConnection();
        }
    }

    public Response get(String path) throws IOException {
        return this.get(this.cluster, path);
    }

    public Response get(Cluster cluster, String path) throws IOException {
        return this.get(cluster, path, EMPTY_HEADER_ARRAY);
    }

    public Response get(String path, String accept) throws IOException {
        return this.get(this.cluster, path, accept);
    }

    public Response get(Cluster cluster, String path, String accept) throws IOException {
        Header[] headers = new Header[]{new BasicHeader("Accept", accept)};
        return this.get(cluster, path, headers);
    }

    public Response get(String path, Header[] headers) throws IOException {
        return this.get(this.cluster, path, headers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getResponseBody(HttpResponse resp) throws IOException {
        if (resp.getEntity() == null) {
            return null;
        }
        InputStream instream = resp.getEntity().getContent();
        if (instream == null) {
            return null;
        }
        try {
            long contentLength = resp.getEntity().getContentLength();
            if (contentLength > Integer.MAX_VALUE) {
                throw new IOException("Content too large to be buffered: " + contentLength + " bytes");
            }
            if (contentLength > 0L) {
                byte[] content = new byte[(int)contentLength];
                ByteStreams.readFully((InputStream)instream, (byte[])content);
                byte[] byArray = content;
                return byArray;
            }
            byte[] byArray = ByteStreams.toByteArray((InputStream)instream);
            return byArray;
        }
        finally {
            Closeables.closeQuietly((InputStream)instream);
        }
    }

    public Response get(Cluster c, String path, Header[] headers) throws IOException {
        if (this.httpGet != null) {
            this.httpGet.releaseConnection();
        }
        this.httpGet = new HttpGet(path);
        HttpResponse resp = this.execute(c, (HttpUriRequest)this.httpGet, headers, path);
        return new Response(resp.getStatusLine().getStatusCode(), resp.getAllHeaders(), resp, resp.getEntity() == null ? null : resp.getEntity().getContent());
    }

    public Response put(String path, String contentType, byte[] content) throws IOException {
        return this.put(this.cluster, path, contentType, content);
    }

    public Response put(String path, String contentType, byte[] content, Header extraHdr) throws IOException {
        return this.put(this.cluster, path, contentType, content, extraHdr);
    }

    public Response put(Cluster cluster, String path, String contentType, byte[] content) throws IOException {
        Header[] headers = new Header[]{new BasicHeader("Content-Type", contentType)};
        return this.put(cluster, path, headers, content);
    }

    public Response put(Cluster cluster, String path, String contentType, byte[] content, Header extraHdr) throws IOException {
        int cnt = extraHdr == null ? 1 : 2;
        Header[] headers = new Header[cnt];
        headers[0] = new BasicHeader("Content-Type", contentType);
        if (extraHdr != null) {
            headers[1] = extraHdr;
        }
        return this.put(cluster, path, headers, content);
    }

    public Response put(String path, Header[] headers, byte[] content) throws IOException {
        return this.put(this.cluster, path, headers, content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response put(Cluster cluster, String path, Header[] headers, byte[] content) throws IOException {
        HttpPut method = new HttpPut(path);
        try {
            method.setEntity((HttpEntity)new InputStreamEntity((InputStream)new ByteArrayInputStream(content), (long)content.length));
            HttpResponse resp = this.execute(cluster, (HttpUriRequest)method, headers, path);
            headers = resp.getAllHeaders();
            content = Client.getResponseBody(resp);
            Response response = new Response(resp.getStatusLine().getStatusCode(), headers, content);
            return response;
        }
        finally {
            method.releaseConnection();
        }
    }

    public Response post(String path, String contentType, byte[] content) throws IOException {
        return this.post(this.cluster, path, contentType, content);
    }

    public Response post(String path, String contentType, byte[] content, Header extraHdr) throws IOException {
        return this.post(this.cluster, path, contentType, content, extraHdr);
    }

    public Response post(Cluster cluster, String path, String contentType, byte[] content) throws IOException {
        Header[] headers = new Header[]{new BasicHeader("Content-Type", contentType)};
        return this.post(cluster, path, headers, content);
    }

    public Response post(Cluster cluster, String path, String contentType, byte[] content, Header extraHdr) throws IOException {
        int cnt = extraHdr == null ? 1 : 2;
        Header[] headers = new Header[cnt];
        headers[0] = new BasicHeader("Content-Type", contentType);
        if (extraHdr != null) {
            headers[1] = extraHdr;
        }
        return this.post(cluster, path, headers, content);
    }

    public Response post(String path, Header[] headers, byte[] content) throws IOException {
        return this.post(this.cluster, path, headers, content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response post(Cluster cluster, String path, Header[] headers, byte[] content) throws IOException {
        HttpPost method = new HttpPost(path);
        try {
            method.setEntity((HttpEntity)new InputStreamEntity((InputStream)new ByteArrayInputStream(content), (long)content.length));
            HttpResponse resp = this.execute(cluster, (HttpUriRequest)method, headers, path);
            headers = resp.getAllHeaders();
            content = Client.getResponseBody(resp);
            Response response = new Response(resp.getStatusLine().getStatusCode(), headers, content);
            return response;
        }
        finally {
            method.releaseConnection();
        }
    }

    public Response delete(String path) throws IOException {
        return this.delete(this.cluster, path);
    }

    public Response delete(String path, Header extraHdr) throws IOException {
        return this.delete(this.cluster, path, extraHdr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response delete(Cluster cluster, String path) throws IOException {
        HttpDelete method = new HttpDelete(path);
        try {
            HttpResponse resp = this.execute(cluster, (HttpUriRequest)method, null, path);
            Header[] headers = resp.getAllHeaders();
            byte[] content = Client.getResponseBody(resp);
            Response response = new Response(resp.getStatusLine().getStatusCode(), headers, content);
            return response;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response delete(Cluster cluster, String path, Header extraHdr) throws IOException {
        HttpDelete method = new HttpDelete(path);
        try {
            Header[] headers = new Header[]{extraHdr};
            HttpResponse resp = this.execute(cluster, (HttpUriRequest)method, headers, path);
            headers = resp.getAllHeaders();
            byte[] content = Client.getResponseBody(resp);
            Response response = new Response(resp.getStatusLine().getStatusCode(), headers, content);
            return response;
        }
        finally {
            method.releaseConnection();
        }
    }

    public static class ClientTrustStoreInitializationException
    extends RuntimeException {
        public ClientTrustStoreInitializationException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

