/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.coprocessor;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.ColumnInterpreter;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AggregateProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class AggregationHelper {
    private AggregationHelper() {
    }

    private static void validateParameters(Scan scan, boolean canFamilyBeAbsent) throws IOException {
        if (scan == null || Bytes.equals((byte[])scan.getStartRow(), (byte[])scan.getStopRow()) && !Bytes.equals((byte[])scan.getStartRow(), (byte[])HConstants.EMPTY_START_ROW) || Bytes.compareTo((byte[])scan.getStartRow(), (byte[])scan.getStopRow()) > 0 && !Bytes.equals((byte[])scan.getStopRow(), (byte[])HConstants.EMPTY_END_ROW)) {
            throw new IOException("Agg client Exception: Startrow should be smaller than Stoprow");
        }
        if (!canFamilyBeAbsent && scan.getFamilyMap().size() != 1) {
            throw new IOException("There must be only one family.");
        }
    }

    static <R, S, P extends Message, Q extends Message, T extends Message> AggregateProtos.AggregateRequest validateArgAndGetPB(Scan scan, ColumnInterpreter<R, S, P, Q, T> ci, boolean canFamilyBeAbsent) throws IOException {
        AggregationHelper.validateParameters(scan, canFamilyBeAbsent);
        AggregateProtos.AggregateRequest.Builder requestBuilder = AggregateProtos.AggregateRequest.newBuilder();
        requestBuilder.setInterpreterClassName(ci.getClass().getCanonicalName());
        Message columnInterpreterSpecificData = ci.getRequestData();
        if (columnInterpreterSpecificData != null) {
            requestBuilder.setInterpreterSpecificBytes(columnInterpreterSpecificData.toByteString());
        }
        requestBuilder.setScan(ProtobufUtil.toScan((Scan)scan));
        return requestBuilder.build();
    }

    public static <T extends Message> T getParsedGenericInstance(Class<?> runtimeClass, int position, ByteString b) throws IOException {
        Type type = runtimeClass.getGenericSuperclass();
        Type argType = ((ParameterizedType)type).getActualTypeArguments()[position];
        Class classType = (Class)argType;
        try {
            Method m = classType.getMethod("parseFrom", ByteString.class);
            Message inst = (Message)m.invoke(null, b);
            return (T)inst;
        }
        catch (SecurityException e) {
            throw new IOException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IOException(e);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
        catch (InvocationTargetException e) {
            throw new IOException(e);
        }
        catch (IllegalAccessException e) {
            throw new IOException(e);
        }
    }
}

