/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtil;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.SequentialProcedure;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, SmallTests.class})
public class TestProcedureMetrics {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestProcedureMetrics.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestProcedureMetrics.class);
    private static final int PROCEDURE_EXECUTOR_SLOTS = 1;
    private TestProcEnv procEnv;
    private static ProcedureExecutor<TestProcEnv> procExecutor;
    private ProcedureStore procStore;
    private HBaseCommonTestingUtil htu;
    private FileSystem fs;
    private Path testDir;
    private Path logDir;
    private static int beginCount;
    private static int successCount;
    private static int failedCount;

    @Before
    public void setUp() throws IOException {
        this.htu = new HBaseCommonTestingUtil();
        this.testDir = this.htu.getDataTestDir();
        this.fs = this.testDir.getFileSystem(this.htu.getConfiguration());
        Assert.assertTrue((this.testDir.depth() > 1 ? 1 : 0) != 0);
        this.logDir = new Path(this.testDir, "proc-logs");
        this.procEnv = new TestProcEnv();
        this.procStore = ProcedureTestingUtility.createStore(this.htu.getConfiguration(), this.logDir);
        procExecutor = new ProcedureExecutor(this.htu.getConfiguration(), (Object)this.procEnv, this.procStore);
        TestProcedureMetrics.procExecutor.testing = new ProcedureExecutor.Testing();
        this.procStore.start(1);
        ProcedureTestingUtility.initAndStartWorkers(procExecutor, 1, true);
    }

    @After
    public void tearDown() throws IOException {
        procExecutor.stop();
        this.procStore.stop(false);
        this.fs.delete(this.logDir, true);
    }

    @Test
    public void testMetricForSimpleProcedure() throws Exception {
        ProcedureMetrics proc = new ProcedureMetrics(true);
        long id = ProcedureTestingUtility.submitAndWait(procExecutor, (Procedure)proc);
        Assert.assertNotEquals((String)"ProcId zero!", (long)0L, (long)id);
        ProcedureTestingUtility.waitProcedure(procExecutor, (Procedure)proc);
        Assert.assertEquals((String)"beginCount doesn't match!", (long)(++beginCount), (long)ProcedureMetrics.beginCount);
        Assert.assertEquals((String)"successCount doesn't match!", (long)(++successCount), (long)ProcedureMetrics.successCount);
        Assert.assertEquals((String)"failedCont doesn't match!", (long)failedCount, (long)ProcedureMetrics.failedCount);
    }

    @Test
    public void testMetricsForFailedProcedure() throws Exception {
        ProcedureMetrics proc = new ProcedureMetrics(false);
        long id = ProcedureTestingUtility.submitAndWait(procExecutor, (Procedure)proc);
        Assert.assertNotEquals((String)"ProcId zero!", (long)0L, (long)id);
        ++failedCount;
        ProcedureTestingUtility.waitProcedure(procExecutor, (Procedure)proc);
        Assert.assertEquals((String)"beginCount doesn't match!", (long)(++beginCount), (long)ProcedureMetrics.beginCount);
        Assert.assertEquals((String)"successCount doesn't match!", (long)successCount, (long)ProcedureMetrics.successCount);
        Assert.assertEquals((String)"failedCont doesn't match!", (long)failedCount, (long)ProcedureMetrics.failedCount);
    }

    @Test
    public void testMetricForYieldProcedure() throws Exception {
        ProcedureMetrics proc = new ProcedureMetrics(true, true);
        long id = ProcedureTestingUtility.submitAndWait(procExecutor, (Procedure)proc);
        Assert.assertNotEquals((String)"ProcId zero!", (long)0L, (long)id);
        ProcedureTestingUtility.waitProcedure(procExecutor, (Procedure)proc);
        Assert.assertEquals((String)"beginCount doesn't match!", (long)(++beginCount), (long)ProcedureMetrics.beginCount);
        Assert.assertEquals((String)"successCount doesn't match!", (long)(++successCount), (long)ProcedureMetrics.successCount);
        Assert.assertEquals((String)"failedCont doesn't match!", (long)failedCount, (long)ProcedureMetrics.failedCount);
    }

    @Test
    public void testMetricForFailedYiledProcedure() {
        ProcedureMetrics proc = new ProcedureMetrics(false, true);
        long id = ProcedureTestingUtility.submitAndWait(procExecutor, (Procedure)proc);
        Assert.assertNotEquals((String)"ProcId zero!", (long)0L, (long)id);
        ++failedCount;
        ProcedureTestingUtility.waitProcedure(procExecutor, (Procedure)proc);
        Assert.assertEquals((String)"beginCount doesn't match!", (long)(++beginCount), (long)ProcedureMetrics.beginCount);
        Assert.assertEquals((String)"successCount doesn't match!", (long)successCount, (long)ProcedureMetrics.successCount);
        Assert.assertEquals((String)"failedCont doesn't match!", (long)failedCount, (long)ProcedureMetrics.failedCount);
    }

    @Test
    public void testMetricForProcedureWithChildren() throws Exception {
        int subProcCount = 10;
        int failChildIndex = 2;
        int yiledChildIndex = -1;
        ProcedureMetrics[] subprocs = new ProcedureMetrics[subProcCount];
        for (int i = 0; i < subProcCount; ++i) {
            subprocs[i] = new ProcedureMetrics(failChildIndex != i, yiledChildIndex == i, 3);
        }
        ProcedureMetrics proc = new ProcedureMetrics(true, true, 3, subprocs);
        long id = ProcedureTestingUtility.submitAndWait(procExecutor, (Procedure)proc);
        Assert.assertNotEquals((String)"ProcId zero!", (long)0L, (long)id);
        beginCount += subProcCount + 1;
        successCount += subProcCount - (failChildIndex + 1);
        if (failChildIndex >= 0) {
            failedCount += subProcCount + 1;
        } else {
            ++successCount;
        }
        ProcedureTestingUtility.waitProcedure(procExecutor, (Procedure)proc);
        Assert.assertEquals((String)"beginCount doesn't match!", (long)beginCount, (long)ProcedureMetrics.beginCount);
        Assert.assertEquals((String)"successCount doesn't match!", (long)successCount, (long)ProcedureMetrics.successCount);
        Assert.assertEquals((String)"failedCont doesn't match!", (long)failedCount, (long)ProcedureMetrics.failedCount);
    }

    static {
        beginCount = 0;
        successCount = 0;
        failedCount = 0;
    }

    public static class ProcedureMetrics
    extends SequentialProcedure<TestProcEnv> {
        public static long beginCount = 0L;
        public static long successCount = 0L;
        public static long failedCount = 0L;
        private boolean success;
        private boolean yield;
        private int yieldCount;
        private int yieldNum;
        private ProcedureMetrics[] subprocs = null;

        public ProcedureMetrics() {
            this(true);
        }

        public ProcedureMetrics(boolean success) {
            this(success, true);
        }

        public ProcedureMetrics(boolean success, boolean yield) {
            this(success, yield, 1);
        }

        public ProcedureMetrics(boolean success, boolean yield, int yieldCount) {
            this(success, yield, yieldCount, null);
        }

        public ProcedureMetrics(boolean success, ProcedureMetrics[] subprocs) {
            this(success, false, 1, subprocs);
        }

        public ProcedureMetrics(boolean success, boolean yield, int yieldCount, ProcedureMetrics[] subprocs) {
            this.success = success;
            this.yield = yield;
            this.yieldCount = yieldCount;
            this.subprocs = subprocs;
            this.yieldNum = 0;
        }

        protected void updateMetricsOnSubmit(TestProcEnv env) {
            ++beginCount;
        }

        protected Procedure[] execute(TestProcEnv env) throws ProcedureYieldException, ProcedureSuspendedException, InterruptedException {
            if (this.yield && this.yieldNum < this.yieldCount) {
                ++this.yieldNum;
                throw new ProcedureYieldException();
            }
            if (!this.success) {
                this.setFailure("Failed", new InterruptedException("Failed"));
                return null;
            }
            return this.subprocs;
        }

        protected void rollback(TestProcEnv env) throws IOException, InterruptedException {
        }

        protected boolean abort(TestProcEnv env) {
            return false;
        }

        protected void updateMetricsOnFinish(TestProcEnv env, long time, boolean success) {
            if (success) {
                ++successCount;
            } else {
                ++failedCount;
            }
        }
    }

    private static class TestProcEnv {
        public boolean toggleKillBeforeStoreUpdate = false;
        public boolean triggerRollbackOnChild = false;

        private TestProcEnv() {
        }
    }
}

