/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import org.apache.hadoop.util.AutoCloseableLock;
import org.junit.Assert;
import org.junit.Test;

public class TestAutoCloseableLock {
    @Test
    public void testLockAcquireRelease() {
        AutoCloseableLock lock = new AutoCloseableLock();
        AutoCloseableLock newlock = lock.acquire();
        Assert.assertEquals((Object)newlock, (Object)lock);
        Assert.assertTrue((boolean)lock.isLocked());
        lock.release();
        Assert.assertFalse((boolean)lock.isLocked());
    }

    @Test
    public void testMultipleThread() throws Exception {
        final AutoCloseableLock lock = new AutoCloseableLock();
        lock.acquire();
        Assert.assertTrue((boolean)lock.isLocked());
        Thread competingThread = new Thread(){

            @Override
            public void run() {
                Assert.assertTrue((boolean)lock.isLocked());
                Assert.assertFalse((boolean)lock.tryLock());
            }
        };
        competingThread.start();
        competingThread.join();
        Assert.assertTrue((boolean)lock.isLocked());
        lock.release();
        Assert.assertFalse((boolean)lock.isLocked());
    }

    @Test
    public void testTryWithResourceSyntax() throws Exception {
        final AutoCloseableLock lock = new AutoCloseableLock();
        try (AutoCloseableLock localLock = lock.acquire();){
            Assert.assertEquals((Object)localLock, (Object)lock);
            Assert.assertTrue((boolean)lock.isLocked());
            Thread competingThread = new Thread(){

                @Override
                public void run() {
                    Assert.assertTrue((boolean)lock.isLocked());
                    Assert.assertFalse((boolean)lock.tryLock());
                }
            };
            competingThread.start();
            competingThread.join();
            Assert.assertTrue((boolean)localLock.isLocked());
        }
        Assert.assertFalse((boolean)lock.isLocked());
    }
}

