/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.IOException;
import java.security.PrivilegedAction;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class TestUGIWithSecurityOn {
    public static boolean isKdcRunning() {
        String startKdc = System.getProperty("startKdc");
        return startKdc != null && startKdc.equals("true");
    }

    @Before
    public void testKdcRunning() {
        Assume.assumeTrue((boolean)TestUGIWithSecurityOn.isKdcRunning());
    }

    @Test
    public void testLogin() throws IOException {
        String nn1keyTabFilepath = System.getProperty("kdc.resource.dir") + "/keytabs/nn1.keytab";
        String user1keyTabFilepath = System.getProperty("kdc.resource.dir") + "/keytabs/user1.keytab";
        Configuration conf = new Configuration();
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.KERBEROS, (Configuration)conf);
        UserGroupInformation.setConfiguration((Configuration)conf);
        UserGroupInformation ugiNn = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)"nn1/localhost@EXAMPLE.COM", (String)nn1keyTabFilepath);
        UserGroupInformation ugiDn = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)"user1@EXAMPLE.COM", (String)user1keyTabFilepath);
        Assert.assertEquals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS, (Object)ugiNn.getAuthenticationMethod());
        Assert.assertEquals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS, (Object)ugiDn.getAuthenticationMethod());
        try {
            UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)"bogus@EXAMPLE.COM", (String)nn1keyTabFilepath);
            Assert.fail((String)"Login should have failed");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Test
    public void testGetUGIFromKerberosSubject() throws IOException {
        String user1keyTabFilepath = System.getProperty("kdc.resource.dir") + "/keytabs/user1.keytab";
        UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)"user1@EXAMPLE.COM", (String)user1keyTabFilepath);
        Set<KerberosPrincipal> principals = ugi.getSubject().getPrincipals(KerberosPrincipal.class);
        if (principals.isEmpty()) {
            Assert.fail((String)"There should be a kerberos principal in the subject.");
        } else {
            UserGroupInformation ugi2 = UserGroupInformation.getUGIFromSubject((Subject)ugi.getSubject());
            if (ugi2 != null) {
                ugi2.doAs((PrivilegedAction)new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        try {
                            UserGroupInformation ugi3 = UserGroupInformation.getCurrentUser();
                            String doAsUserName = ugi3.getUserName();
                            Assert.assertEquals((Object)doAsUserName, (Object)"user1@EXAMPLE.COM");
                            System.out.println("DO AS USERNAME: " + doAsUserName);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        return null;
                    }
                });
            }
        }
    }
}

