/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc.metrics;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.metrics.RpcDetailedMetrics;
import org.apache.hadoop.ipc.metrics.RpcMetrics;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.junit.Assert;
import org.junit.Test;

public class TestRpcMetrics {
    @Test
    public void metricsAreUnregistered() throws Exception {
        Configuration conf = new Configuration();
        Server server = new Server("0.0.0.0", 0, LongWritable.class, 1, conf){

            public Writable call(RPC.RpcKind rpcKind, String protocol, Writable param, long receiveTime) throws Exception {
                return null;
            }
        };
        MetricsSystem metricsSystem = DefaultMetricsSystem.instance();
        RpcMetrics rpcMetrics = server.getRpcMetrics();
        RpcDetailedMetrics rpcDetailedMetrics = server.getRpcDetailedMetrics();
        Assert.assertNotNull((Object)metricsSystem.getSource(rpcMetrics.name()));
        Assert.assertNotNull((Object)metricsSystem.getSource(rpcDetailedMetrics.name()));
        server.stop();
        Assert.assertNull((Object)metricsSystem.getSource(rpcMetrics.name()));
        Assert.assertNull((Object)metricsSystem.getSource(rpcDetailedMetrics.name()));
    }
}

