/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.CostProvider;
import org.apache.hadoop.ipc.DecayRpcScheduler;
import org.apache.hadoop.ipc.ProcessingDetails;
import org.apache.hadoop.ipc.Schedulable;
import org.apache.hadoop.ipc.WeightedTimeCostProvider;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestDecayRpcScheduler {
    private DecayRpcScheduler scheduler;

    private Schedulable mockCall(String id) {
        Schedulable mockCall = (Schedulable)Mockito.mock(Schedulable.class);
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)id);
        Mockito.when((Object)mockCall.getUserGroupInformation()).thenReturn((Object)ugi);
        return mockCall;
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNegativeScheduler() {
        this.scheduler = new DecayRpcScheduler(-1, "", new Configuration());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testZeroScheduler() {
        this.scheduler = new DecayRpcScheduler(0, "", new Configuration());
    }

    @Test
    public void testParsePeriod() {
        this.scheduler = new DecayRpcScheduler(1, "", new Configuration());
        Assert.assertEquals((long)5000L, (long)this.scheduler.getDecayPeriodMillis());
        Configuration conf = new Configuration();
        conf.setLong("ns.faircallqueue.decay-scheduler.period-ms", 1058L);
        this.scheduler = new DecayRpcScheduler(1, "ns", conf);
        Assert.assertEquals((long)1058L, (long)this.scheduler.getDecayPeriodMillis());
    }

    @Test
    public void testParseFactor() {
        this.scheduler = new DecayRpcScheduler(1, "", new Configuration());
        Assert.assertEquals((double)0.5, (double)this.scheduler.getDecayFactor(), (double)1.0E-5);
        Configuration conf = new Configuration();
        conf.set("prefix.faircallqueue.decay-scheduler.decay-factor", "0.125");
        this.scheduler = new DecayRpcScheduler(1, "prefix", conf);
        Assert.assertEquals((double)0.125, (double)this.scheduler.getDecayFactor(), (double)1.0E-5);
    }

    public void assertEqualDecimalArrays(double[] a, double[] b) {
        Assert.assertEquals((long)a.length, (long)b.length);
        for (int i = 0; i < a.length; ++i) {
            Assert.assertEquals((double)a[i], (double)b[i], (double)1.0E-5);
        }
    }

    @Test
    public void testParseThresholds() {
        Configuration conf = new Configuration();
        this.scheduler = new DecayRpcScheduler(1, "", conf);
        this.assertEqualDecimalArrays(new double[0], this.scheduler.getThresholds());
        this.scheduler = new DecayRpcScheduler(2, "", conf);
        this.assertEqualDecimalArrays(new double[]{0.5}, this.scheduler.getThresholds());
        this.scheduler = new DecayRpcScheduler(3, "", conf);
        this.assertEqualDecimalArrays(new double[]{0.25, 0.5}, this.scheduler.getThresholds());
        this.scheduler = new DecayRpcScheduler(4, "", conf);
        this.assertEqualDecimalArrays(new double[]{0.125, 0.25, 0.5}, this.scheduler.getThresholds());
        conf = new Configuration();
        conf.set("ns.faircallqueue.decay-scheduler.thresholds", "1, 10, 20, 50, 85");
        this.scheduler = new DecayRpcScheduler(6, "ns", conf);
        this.assertEqualDecimalArrays(new double[]{0.01, 0.1, 0.2, 0.5, 0.85}, this.scheduler.getThresholds());
    }

    @Test
    public void testAccumulate() {
        Configuration conf = new Configuration();
        conf.set("ns.faircallqueue.decay-scheduler.period-ms", "99999999");
        this.scheduler = new DecayRpcScheduler(1, "ns", conf);
        Assert.assertEquals((long)0L, (long)this.scheduler.getCallCostSnapshot().size());
        this.getPriorityIncrementCallCount("A");
        Assert.assertEquals((long)1L, (long)((Long)this.scheduler.getCallCostSnapshot().get("A")));
        Assert.assertEquals((long)1L, (long)((Long)this.scheduler.getCallCostSnapshot().get("A")));
        this.getPriorityIncrementCallCount("A");
        this.getPriorityIncrementCallCount("B");
        this.getPriorityIncrementCallCount("A");
        Assert.assertEquals((long)3L, (long)((Long)this.scheduler.getCallCostSnapshot().get("A")));
        Assert.assertEquals((long)1L, (long)((Long)this.scheduler.getCallCostSnapshot().get("B")));
    }

    @Test
    public void testDecay() throws Exception {
        int i;
        Configuration conf = new Configuration();
        conf.setLong("ns.decay-scheduler.period-ms", 999999999L);
        conf.setDouble("ns.decay-scheduler.decay-factor", 0.5);
        this.scheduler = new DecayRpcScheduler(1, "ns", conf);
        Assert.assertEquals((long)0L, (long)this.scheduler.getTotalCallSnapshot());
        for (i = 0; i < 4; ++i) {
            this.getPriorityIncrementCallCount("A");
        }
        Thread.sleep(1000L);
        for (i = 0; i < 8; ++i) {
            this.getPriorityIncrementCallCount("B");
        }
        Assert.assertEquals((long)12L, (long)this.scheduler.getTotalCallSnapshot());
        Assert.assertEquals((long)4L, (long)((Long)this.scheduler.getCallCostSnapshot().get("A")));
        Assert.assertEquals((long)8L, (long)((Long)this.scheduler.getCallCostSnapshot().get("B")));
        this.scheduler.forceDecay();
        Assert.assertEquals((long)6L, (long)this.scheduler.getTotalCallSnapshot());
        Assert.assertEquals((long)2L, (long)((Long)this.scheduler.getCallCostSnapshot().get("A")));
        Assert.assertEquals((long)4L, (long)((Long)this.scheduler.getCallCostSnapshot().get("B")));
        this.scheduler.forceDecay();
        Assert.assertEquals((long)3L, (long)this.scheduler.getTotalCallSnapshot());
        Assert.assertEquals((long)1L, (long)((Long)this.scheduler.getCallCostSnapshot().get("A")));
        Assert.assertEquals((long)2L, (long)((Long)this.scheduler.getCallCostSnapshot().get("B")));
        this.scheduler.forceDecay();
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalCallSnapshot());
        Assert.assertEquals(null, this.scheduler.getCallCostSnapshot().get("A"));
        Assert.assertEquals((long)1L, (long)((Long)this.scheduler.getCallCostSnapshot().get("B")));
        this.scheduler.forceDecay();
        Assert.assertEquals((long)0L, (long)this.scheduler.getTotalCallSnapshot());
        Assert.assertEquals(null, this.scheduler.getCallCostSnapshot().get("A"));
        Assert.assertEquals(null, this.scheduler.getCallCostSnapshot().get("B"));
    }

    @Test
    public void testPriority() throws Exception {
        Configuration conf = new Configuration();
        String namespace = "ns";
        conf.set("ns.faircallqueue.decay-scheduler.period-ms", "99999999");
        conf.set("ns.faircallqueue.decay-scheduler.thresholds", "25, 50, 75");
        this.scheduler = new DecayRpcScheduler(4, "ns", conf);
        Assert.assertEquals((long)0L, (long)this.getPriorityIncrementCallCount("A"));
        Assert.assertEquals((long)3L, (long)this.getPriorityIncrementCallCount("A"));
        Assert.assertEquals((long)0L, (long)this.getPriorityIncrementCallCount("B"));
        Assert.assertEquals((long)1L, (long)this.getPriorityIncrementCallCount("B"));
        Assert.assertEquals((long)0L, (long)this.getPriorityIncrementCallCount("C"));
        Assert.assertEquals((long)0L, (long)this.getPriorityIncrementCallCount("C"));
        Assert.assertEquals((long)1L, (long)this.getPriorityIncrementCallCount("A"));
        Assert.assertEquals((long)1L, (long)this.getPriorityIncrementCallCount("A"));
        Assert.assertEquals((long)2L, (long)this.getPriorityIncrementCallCount("A"));
        Assert.assertEquals((long)2L, (long)this.getPriorityIncrementCallCount("A"));
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName mxbeanName = new ObjectName("Hadoop:service=ns,name=DecayRpcScheduler");
        String cvs1 = (String)mbs.getAttribute(mxbeanName, "CallVolumeSummary");
        Assert.assertTrue((String)"Get expected JMX of CallVolumeSummary before decay", (boolean)cvs1.equals("{\"A\":6,\"B\":2,\"C\":2}"));
        this.scheduler.forceDecay();
        String cvs2 = (String)mbs.getAttribute(mxbeanName, "CallVolumeSummary");
        Assert.assertTrue((String)"Get expected JMX for CallVolumeSummary after decay", (boolean)cvs2.equals("{\"A\":3,\"B\":1,\"C\":1}"));
    }

    @Test(timeout=2000L)
    public void testPeriodic() throws InterruptedException {
        Configuration conf = new Configuration();
        conf.set("ns.faircallqueue.decay-scheduler.period-ms", "10");
        conf.set("ns.faircallqueue.decay-scheduler.decay-factor", "0.5");
        this.scheduler = new DecayRpcScheduler(1, "ns", conf);
        Assert.assertEquals((long)10L, (long)this.scheduler.getDecayPeriodMillis());
        Assert.assertEquals((long)0L, (long)this.scheduler.getTotalCallSnapshot());
        for (int i = 0; i < 64; ++i) {
            this.getPriorityIncrementCallCount("A");
        }
        while (this.scheduler.getTotalCallSnapshot() > 0L) {
            Thread.sleep(10L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testNPEatInitialization() throws InterruptedException {
        PrintStream output = System.out;
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            System.setOut(new PrintStream(bytes));
            DefaultMetricsSystem.initialize((String)"NameNode");
            Configuration conf = new Configuration();
            this.scheduler = new DecayRpcScheduler(1, "ns", conf);
            Assert.assertFalse((boolean)bytes.toString().contains("NullPointerException"));
        }
        finally {
            System.setOut(output);
        }
    }

    @Test
    public void testUsingWeightedTimeCostProvider() {
        this.scheduler = TestDecayRpcScheduler.getSchedulerWithWeightedTimeCostProvider(3);
        ProcessingDetails callDetailsLow = new ProcessingDetails(TimeUnit.MILLISECONDS);
        callDetailsLow.set(ProcessingDetails.Timing.LOCKFREE, 1L);
        ProcessingDetails callDetailsMedium = new ProcessingDetails(TimeUnit.MILLISECONDS);
        callDetailsMedium.set(ProcessingDetails.Timing.LOCKSHARED, 500L);
        ProcessingDetails callDetailsHigh = new ProcessingDetails(TimeUnit.MILLISECONDS);
        callDetailsHigh.set(ProcessingDetails.Timing.LOCKEXCLUSIVE, 100L);
        for (int i = 0; i < 10; ++i) {
            this.scheduler.addResponseTime("ignored", this.mockCall("LOW"), callDetailsLow);
        }
        this.scheduler.addResponseTime("ignored", this.mockCall("MED"), callDetailsMedium);
        this.scheduler.addResponseTime("ignored", this.mockCall("HIGH"), callDetailsHigh);
        Assert.assertEquals((long)0L, (long)this.scheduler.getPriorityLevel(this.mockCall("LOW")));
        Assert.assertEquals((long)1L, (long)this.scheduler.getPriorityLevel(this.mockCall("MED")));
        Assert.assertEquals((long)2L, (long)this.scheduler.getPriorityLevel(this.mockCall("HIGH")));
        Assert.assertEquals((long)3L, (long)this.scheduler.getUniqueIdentityCount());
        long totalCallInitial = this.scheduler.getTotalRawCallVolume();
        Assert.assertEquals((long)totalCallInitial, (long)this.scheduler.getTotalCallVolume());
        this.scheduler.forceDecay();
        Assert.assertEquals((long)0L, (long)this.scheduler.getPriorityLevel(this.mockCall("LOW")));
        Assert.assertEquals((long)1L, (long)this.scheduler.getPriorityLevel(this.mockCall("MED")));
        Assert.assertEquals((long)2L, (long)this.scheduler.getPriorityLevel(this.mockCall("HIGH")));
        Assert.assertEquals((long)3L, (long)this.scheduler.getUniqueIdentityCount());
        Assert.assertEquals((long)totalCallInitial, (long)this.scheduler.getTotalRawCallVolume());
        Assert.assertTrue((this.scheduler.getTotalCallVolume() < totalCallInitial ? 1 : 0) != 0);
        for (int i = 0; i < 100; ++i) {
            this.scheduler.forceDecay();
        }
        Assert.assertEquals((long)0L, (long)this.scheduler.getPriorityLevel(this.mockCall("LOW")));
        Assert.assertEquals((long)0L, (long)this.scheduler.getPriorityLevel(this.mockCall("MED")));
        Assert.assertEquals((long)0L, (long)this.scheduler.getPriorityLevel(this.mockCall("HIGH")));
    }

    @Test
    public void testUsingWeightedTimeCostProviderWithZeroCostCalls() {
        this.scheduler = TestDecayRpcScheduler.getSchedulerWithWeightedTimeCostProvider(2);
        ProcessingDetails emptyDetails = new ProcessingDetails(TimeUnit.MILLISECONDS);
        for (int i = 0; i < 1000; ++i) {
            this.scheduler.addResponseTime("ignored", this.mockCall("MANY"), emptyDetails);
        }
        this.scheduler.addResponseTime("ignored", this.mockCall("FEW"), emptyDetails);
        Assert.assertEquals((long)0L, (long)this.scheduler.getPriorityLevel(this.mockCall("MANY")));
        Assert.assertEquals((long)0L, (long)this.scheduler.getPriorityLevel(this.mockCall("FEW")));
    }

    @Test
    public void testUsingWeightedTimeCostProviderNoRequests() {
        this.scheduler = TestDecayRpcScheduler.getSchedulerWithWeightedTimeCostProvider(2);
        Assert.assertEquals((long)0L, (long)this.scheduler.getPriorityLevel(this.mockCall("A")));
    }

    private static DecayRpcScheduler getSchedulerWithWeightedTimeCostProvider(int priorityLevels) {
        Configuration conf = new Configuration();
        conf.setClass("ns.cost-provider.impl", WeightedTimeCostProvider.class, CostProvider.class);
        conf.setLong("ns.decay-scheduler.period-ms", 999999L);
        return new DecayRpcScheduler(priorityLevels, "ns", conf);
    }

    private int getPriorityIncrementCallCount(String callId) {
        Schedulable mockCall = this.mockCall(callId);
        int priority = this.scheduler.getPriorityLevel(mockCall);
        ProcessingDetails emptyProcessingDetails = new ProcessingDetails(TimeUnit.MILLISECONDS);
        this.scheduler.addResponseTime("ignored", mockCall, emptyProcessingDetails);
        return priority;
    }
}

