/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.CallQueueManager;
import org.apache.hadoop.ipc.DefaultRpcScheduler;
import org.apache.hadoop.ipc.RpcScheduler;
import org.apache.hadoop.ipc.Schedulable;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestCallQueueManager {
    private CallQueueManager<FakeCall> manager;
    private Configuration conf = new Configuration();
    private static final Class<? extends BlockingQueue<FakeCall>> queueClass = CallQueueManager.convertQueueClass(LinkedBlockingQueue.class, FakeCall.class);
    private static final Class<? extends RpcScheduler> schedulerClass = CallQueueManager.convertSchedulerClass(DefaultRpcScheduler.class);
    private static final Class<? extends RpcScheduler> exceptionSchedulerClass = CallQueueManager.convertSchedulerClass(ExceptionFakeScheduler.class);
    private static final Class<? extends BlockingQueue<ExceptionFakeCall>> exceptionQueueClass = CallQueueManager.convertQueueClass(ExceptionFakeCall.class, ExceptionFakeCall.class);

    public void assertCanTake(CallQueueManager<FakeCall> cq, int numberOfTakes, int takeAttempts) throws InterruptedException {
        Taker taker = new Taker(cq, takeAttempts, -1);
        Thread t = new Thread(taker);
        t.start();
        t.join(100L);
        Assert.assertEquals((long)taker.callsTaken, (long)numberOfTakes);
        t.interrupt();
    }

    public void assertCanPut(CallQueueManager<FakeCall> cq, int numberOfPuts, int putAttempts) throws InterruptedException {
        Putter putter = new Putter(cq, putAttempts, -1);
        Thread t = new Thread(putter);
        t.start();
        t.join(100L);
        Assert.assertEquals((long)numberOfPuts, (long)putter.callsAdded);
        t.interrupt();
    }

    @Test
    public void testCallQueueCapacity() throws InterruptedException {
        this.manager = new CallQueueManager(queueClass, schedulerClass, false, 10, "", this.conf);
        this.assertCanPut(this.manager, 10, 20);
    }

    @Test
    public void testEmptyConsume() throws InterruptedException {
        this.manager = new CallQueueManager(queueClass, schedulerClass, false, 10, "", this.conf);
        this.assertCanTake(this.manager, 0, 1);
    }

    static Class<? extends BlockingQueue<FakeCall>> getQueueClass(String prefix, Configuration conf) {
        String name = prefix + "." + "callqueue.impl";
        Class queueClass = conf.getClass(name, LinkedBlockingQueue.class);
        return CallQueueManager.convertQueueClass((Class)queueClass, FakeCall.class);
    }

    @Test
    public void testFcqBackwardCompatibility() throws InterruptedException {
        Configuration conf = new Configuration();
        String ns = "ipc.0";
        String queueClassName = "org.apache.hadoop.ipc.FairCallQueue";
        conf.setStrings("ipc.0.callqueue.impl", new String[]{"org.apache.hadoop.ipc.FairCallQueue"});
        Class scheduler = Server.getSchedulerClass((String)"ipc.0", (Configuration)conf);
        Assert.assertTrue((boolean)scheduler.getCanonicalName().equals("org.apache.hadoop.ipc.DecayRpcScheduler"));
        Class<? extends BlockingQueue<FakeCall>> queue = TestCallQueueManager.getQueueClass("ipc.0", conf);
        Assert.assertTrue((boolean)queue.getCanonicalName().equals("org.apache.hadoop.ipc.FairCallQueue"));
        this.manager = new CallQueueManager(queue, scheduler, false, 8, "", conf);
        this.assertCanPut(this.manager, 3, 3);
    }

    @Test
    public void testSchedulerWithoutFCQ() throws InterruptedException {
        Configuration conf = new Configuration();
        String ns = "ipc.0";
        String schedulerClassName = "org.apache.hadoop.ipc.DecayRpcScheduler";
        conf.setStrings("ipc.0.scheduler.impl", new String[]{"org.apache.hadoop.ipc.DecayRpcScheduler"});
        Class<? extends BlockingQueue<FakeCall>> queue = TestCallQueueManager.getQueueClass("ipc.0", conf);
        Assert.assertTrue((boolean)queue.getCanonicalName().equals("java.util.concurrent.LinkedBlockingQueue"));
        this.manager = new CallQueueManager(queue, Server.getSchedulerClass((String)"ipc.0", (Configuration)conf), false, 3, "", conf);
        this.assertCanPut(this.manager, 3, 3);
        this.assertCanPut(this.manager, 0, 1);
    }

    @Test(timeout=60000L)
    public void testSwapUnderContention() throws InterruptedException {
        int i;
        this.manager = new CallQueueManager(queueClass, schedulerClass, false, 5000, "", this.conf);
        ArrayList<Putter> producers = new ArrayList<Putter>();
        ArrayList<Taker> consumers = new ArrayList<Taker>();
        HashMap<Runnable, Thread> threads = new HashMap<Runnable, Thread>();
        for (i = 0; i < 1000; ++i) {
            Putter p = new Putter(this.manager, -1, -1);
            Thread pt = new Thread(p);
            producers.add(p);
            threads.put(p, pt);
            pt.start();
        }
        for (i = 0; i < 100; ++i) {
            Taker t = new Taker(this.manager, -1, -1);
            Iterator tt = new Thread(t);
            consumers.add(t);
            threads.put(t, (Thread)((Object)tt));
            ((Thread)((Object)tt)).start();
        }
        Thread.sleep(500L);
        for (i = 0; i < 5; ++i) {
            this.manager.swapQueue(schedulerClass, queueClass, 5000, "", this.conf);
        }
        for (Putter p : producers) {
            p.stop();
        }
        Thread.sleep(2000L);
        Assert.assertEquals((long)0L, (long)this.manager.size());
        long totalCallsCreated = 0L;
        for (Putter p : producers) {
            ((Thread)threads.get(p)).interrupt();
        }
        for (Putter p : producers) {
            ((Thread)threads.get(p)).join();
            totalCallsCreated += (long)p.callsAdded;
        }
        long totalCallsConsumed = 0L;
        for (Taker t : consumers) {
            ((Thread)threads.get(t)).interrupt();
        }
        for (Taker t : consumers) {
            ((Thread)threads.get(t)).join();
            totalCallsConsumed += (long)t.callsTaken;
        }
        Assert.assertEquals((long)totalCallsConsumed, (long)totalCallsCreated);
    }

    @Test
    public void testCallQueueConstructorException() throws InterruptedException {
        try {
            new CallQueueManager(exceptionQueueClass, schedulerClass, false, 10, "", new Configuration());
            Assert.fail();
        }
        catch (RuntimeException re) {
            Assert.assertTrue((boolean)(re.getCause() instanceof IllegalArgumentException));
            Assert.assertEquals((Object)"Exception caused by call queue constructor.!!", (Object)re.getCause().getMessage());
        }
    }

    @Test
    public void testSchedulerConstructorException() throws InterruptedException {
        try {
            new CallQueueManager(queueClass, exceptionSchedulerClass, false, 10, "", new Configuration());
            Assert.fail();
        }
        catch (RuntimeException re) {
            Assert.assertTrue((boolean)(re.getCause() instanceof IllegalArgumentException));
            Assert.assertEquals((Object)"Exception caused by scheduler constructor.!!", (Object)re.getCause().getMessage());
        }
    }

    @Test
    public void testCallQueueOverflowExceptions() throws Exception {
        RpcScheduler scheduler = (RpcScheduler)Mockito.mock(RpcScheduler.class);
        BlockingQueue queue = (BlockingQueue)Mockito.mock(BlockingQueue.class);
        CallQueueManager cqm = (CallQueueManager)Mockito.spy((Object)new CallQueueManager(queue, scheduler, false));
        FakeCall call = new FakeCall(0);
        ((BlockingQueue)Mockito.doThrow((Throwable)CallQueueManager.CallQueueOverflowException.KEEPALIVE).when((Object)queue)).add(call);
        try {
            cqm.add((Schedulable)call);
            Assert.fail((String)"didn't throw");
        }
        catch (CallQueueManager.CallQueueOverflowException cqe) {
            Assert.assertSame((Object)((Object)CallQueueManager.CallQueueOverflowException.KEEPALIVE), (Object)((Object)cqe));
        }
        ((BlockingQueue)Mockito.doThrow((Throwable)new IllegalStateException()).when((Object)queue)).add(call);
        try {
            cqm.add((Schedulable)call);
            Assert.fail((String)"didn't throw");
        }
        catch (Exception ex) {
            Assert.assertTrue((String)ex.toString(), (boolean)(ex instanceof CallQueueManager.CallQueueOverflowException));
        }
        Mockito.reset((Object[])new BlockingQueue[]{queue});
        cqm.setClientBackoffEnabled(false);
        cqm.put((Schedulable)call);
        ((BlockingQueue)Mockito.verify((Object)queue, (VerificationMode)Mockito.times((int)1))).put(call);
        ((BlockingQueue)Mockito.verify((Object)queue, (VerificationMode)Mockito.times((int)0))).add(call);
        Mockito.reset((Object[])new BlockingQueue[]{queue});
        cqm.setClientBackoffEnabled(true);
        ((CallQueueManager)Mockito.doReturn((Object)Boolean.FALSE).when((Object)cqm)).shouldBackOff((Schedulable)call);
        cqm.put((Schedulable)call);
        ((BlockingQueue)Mockito.verify((Object)queue, (VerificationMode)Mockito.times((int)0))).put(call);
        ((BlockingQueue)Mockito.verify((Object)queue, (VerificationMode)Mockito.times((int)1))).add(call);
        Mockito.reset((Object[])new BlockingQueue[]{queue});
        Mockito.reset((Object[])new BlockingQueue[]{queue});
        cqm.setClientBackoffEnabled(true);
        ((CallQueueManager)Mockito.doReturn((Object)Boolean.TRUE).when((Object)cqm)).shouldBackOff((Schedulable)call);
        try {
            cqm.put((Schedulable)call);
            Assert.fail((String)"didn't fail");
        }
        catch (Exception ex) {
            Assert.assertTrue((String)ex.toString(), (boolean)(ex instanceof CallQueueManager.CallQueueOverflowException));
        }
        ((BlockingQueue)Mockito.verify((Object)queue, (VerificationMode)Mockito.times((int)0))).put(call);
        ((BlockingQueue)Mockito.verify((Object)queue, (VerificationMode)Mockito.times((int)0))).add(call);
        Mockito.reset((Object[])new BlockingQueue[]{queue});
        cqm.setClientBackoffEnabled(true);
        ((CallQueueManager)Mockito.doReturn((Object)Boolean.TRUE).when((Object)cqm)).shouldBackOff((Schedulable)call);
        try {
            cqm.add((Schedulable)call);
            Assert.fail((String)"didn't fail");
        }
        catch (Exception ex) {
            Assert.assertTrue((String)ex.toString(), (boolean)(ex instanceof CallQueueManager.CallQueueOverflowException));
        }
        ((BlockingQueue)Mockito.verify((Object)queue, (VerificationMode)Mockito.times((int)0))).put(call);
        ((BlockingQueue)Mockito.verify((Object)queue, (VerificationMode)Mockito.times((int)0))).add(call);
    }

    public static class ExceptionFakeScheduler {
        public ExceptionFakeScheduler() {
            throw new IllegalArgumentException("Exception caused by scheduler constructor.!!");
        }
    }

    public static class ExceptionFakeCall
    implements Schedulable {
        public ExceptionFakeCall() {
            throw new IllegalArgumentException("Exception caused by call queue constructor.!!");
        }

        public UserGroupInformation getUserGroupInformation() {
            return null;
        }

        public int getPriorityLevel() {
            return 0;
        }
    }

    public class Taker
    implements Runnable {
        private final CallQueueManager<FakeCall> cq;
        public final int tag;
        public volatile int callsTaken = 0;
        public volatile FakeCall lastResult = null;
        private final int maxCalls;

        public Taker(CallQueueManager<FakeCall> aCq, int maxCalls, int tag) {
            this.maxCalls = maxCalls;
            this.cq = aCq;
            this.tag = tag;
        }

        @Override
        public void run() {
            try {
                while (this.callsTaken < this.maxCalls || this.maxCalls < 0) {
                    FakeCall res = (FakeCall)this.cq.take();
                    if (this.tag >= 0 && res.tag != this.tag) {
                        this.cq.put((Schedulable)res);
                        continue;
                    }
                    ++this.callsTaken;
                    this.lastResult = res;
                }
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    public class Putter
    implements Runnable {
        private final CallQueueManager<FakeCall> cq;
        public final int tag;
        public volatile int callsAdded = 0;
        private final int maxCalls;
        private volatile boolean isRunning = true;

        public Putter(CallQueueManager<FakeCall> aCq, int maxCalls, int tag) {
            this.maxCalls = maxCalls;
            this.cq = aCq;
            this.tag = tag;
        }

        @Override
        public void run() {
            try {
                while (this.isRunning && (this.callsAdded < this.maxCalls || this.maxCalls < 0)) {
                    FakeCall call = new FakeCall(this.tag);
                    call.setPriorityLevel(this.cq.getPriorityLevel((Schedulable)call));
                    this.cq.put((Schedulable)call);
                    ++this.callsAdded;
                }
            }
            catch (InterruptedException e) {
                return;
            }
        }

        public void stop() {
            this.isRunning = false;
        }
    }

    public class FakeCall
    implements Schedulable {
        public final int tag;
        private int priorityLevel;
        UserGroupInformation fakeUgi = UserGroupInformation.createRemoteUser((String)"fakeUser");

        public FakeCall(int tag) {
            this.tag = tag;
        }

        public UserGroupInformation getUserGroupInformation() {
            return this.fakeUgi;
        }

        public int getPriorityLevel() {
            return this.priorityLevel;
        }

        public void setPriorityLevel(int level) {
            this.priorityLevel = level;
        }
    }
}

