/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.erasurecode;

import java.util.HashMap;
import java.util.TreeMap;
import org.apache.hadoop.io.erasurecode.ECSchema;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class TestECSchema {
    @Rule
    public Timeout globalTimeout = new Timeout(300000);

    @Test
    public void testGoodSchema() {
        int numDataUnits = 6;
        int numParityUnits = 3;
        String codec = "rs";
        String extraOption = "extraOption";
        String extraOptionValue = "extraOptionValue";
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("numDataUnits", String.valueOf(numDataUnits));
        options.put("numParityUnits", String.valueOf(numParityUnits));
        options.put("codec", codec);
        options.put(extraOption, extraOptionValue);
        ECSchema schema = new ECSchema(options);
        System.out.println(schema.toString());
        Assert.assertEquals((long)numDataUnits, (long)schema.getNumDataUnits());
        Assert.assertEquals((long)numParityUnits, (long)schema.getNumParityUnits());
        Assert.assertEquals((Object)codec, (Object)schema.getCodecName());
        Assert.assertEquals((Object)extraOptionValue, schema.getExtraOptions().get(extraOption));
        TreeMap<String, String> extraMap = new TreeMap<String, String>();
        extraMap.put(extraOption, extraOptionValue);
        ECSchema sameSchema = new ECSchema(codec, numDataUnits, numParityUnits, extraMap);
        Assert.assertEquals((String)"Different constructors not equal", (Object)sameSchema, (Object)schema);
    }

    @Test
    public void testEqualsAndHashCode() {
        TreeMap<String, String> extraMap = new TreeMap<String, String>();
        extraMap.put("key", "value");
        ECSchema[] schemas = new ECSchema[]{new ECSchema("one", 1, 2, null), new ECSchema("two", 1, 2, null), new ECSchema("one", 2, 2, null), new ECSchema("one", 1, 1, null), new ECSchema("one", 1, 2, extraMap)};
        for (int i = 0; i < schemas.length; ++i) {
            ECSchema ei = schemas[i];
            ECSchema temp = new ECSchema(ei.getCodecName(), ei.getNumDataUnits(), ei.getNumParityUnits(), ei.getExtraOptions());
            Assert.assertEquals((Object)ei, (Object)temp);
            Assert.assertEquals((long)ei.hashCode(), (long)temp.hashCode());
            for (int j = 0; j < schemas.length; ++j) {
                ECSchema ej = schemas[j];
                if (i == j) {
                    Assert.assertEquals((Object)ei, (Object)ej);
                    Assert.assertEquals((long)ei.hashCode(), (long)ej.hashCode());
                    continue;
                }
                Assert.assertNotEquals((Object)ei, (Object)ej);
                Assert.assertNotEquals((Object)ei, (Object)ej.hashCode());
            }
        }
    }
}

