/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.util.Map;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.SortedMapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.junit.Assert;
import org.junit.Test;

public class TestSortedMapWritable {
    @Test
    public void testSortedMapWritable() {
        Text[] keys = new Text[]{new Text("key1"), new Text("key2"), new Text("key3")};
        BytesWritable[] values = new BytesWritable[]{new BytesWritable("value1".getBytes()), new BytesWritable("value2".getBytes()), new BytesWritable("value3".getBytes())};
        SortedMapWritable inMap = new SortedMapWritable();
        for (int i = 0; i < keys.length; ++i) {
            inMap.put((WritableComparable)keys[i], (Writable)values[i]);
        }
        Assert.assertEquals((long)0L, (long)((Text)inMap.firstKey()).compareTo((BinaryComparable)keys[0]));
        Assert.assertEquals((long)0L, (long)((Text)inMap.lastKey()).compareTo((BinaryComparable)keys[2]));
        SortedMapWritable outMap = new SortedMapWritable(inMap);
        Assert.assertEquals((long)inMap.size(), (long)outMap.size());
        for (Map.Entry e : inMap.entrySet()) {
            Assert.assertTrue((boolean)outMap.containsKey(e.getKey()));
            WritableComparable aValue = (WritableComparable)outMap.get(e.getKey());
            WritableComparable bValue = (WritableComparable)e.getValue();
            Assert.assertEquals((long)0L, (long)aValue.compareTo((Object)bValue));
        }
        Text[] maps = new Text[]{new Text("map1"), new Text("map2")};
        SortedMapWritable mapOfMaps = new SortedMapWritable();
        mapOfMaps.put((WritableComparable)maps[0], (Writable)inMap);
        mapOfMaps.put((WritableComparable)maps[1], (Writable)outMap);
        SortedMapWritable copyOfMapOfMaps = new SortedMapWritable(mapOfMaps);
        for (int i = 0; i < maps.length; ++i) {
            Assert.assertTrue((boolean)copyOfMapOfMaps.containsKey((Object)maps[i]));
            SortedMapWritable a = (SortedMapWritable)mapOfMaps.get((Object)maps[i]);
            SortedMapWritable b = (SortedMapWritable)copyOfMapOfMaps.get((Object)maps[i]);
            Assert.assertEquals((long)a.size(), (long)b.size());
            for (Writable key : a.keySet()) {
                Assert.assertTrue((boolean)b.containsKey((Object)key));
                WritableComparable aValue = (WritableComparable)a.get((Object)key);
                WritableComparable bValue = (WritableComparable)b.get((Object)key);
                Assert.assertEquals((long)0L, (long)aValue.compareTo((Object)bValue));
            }
        }
    }

    @Test
    public void testForeignClass() {
        SortedMapWritable inMap = new SortedMapWritable();
        inMap.put((WritableComparable)new Text("key"), (Writable)new UTF8("value"));
        inMap.put((WritableComparable)new Text("key2"), (Writable)new UTF8("value2"));
        SortedMapWritable outMap = new SortedMapWritable(inMap);
        SortedMapWritable copyOfCopy = new SortedMapWritable(outMap);
        Assert.assertEquals((long)1L, (long)copyOfCopy.getNewClasses());
    }

    @Test
    public void testEqualsAndHashCode() {
        SortedMapWritable mapA = new SortedMapWritable();
        SortedMapWritable mapB = new SortedMapWritable();
        String failureReason = "SortedMapWritable couldn't be initialized. Got null reference";
        Assert.assertNotNull((String)failureReason, (Object)mapA);
        Assert.assertNotNull((String)failureReason, (Object)mapB);
        Assert.assertFalse((String)"equals method returns true when passed null", (boolean)mapA.equals(null));
        Assert.assertTrue((String)"Two empty SortedMapWritables are no longer equal", (boolean)mapA.equals((Object)mapB));
        Text[] keys = new Text[]{new Text("key1"), new Text("key2")};
        BytesWritable[] values = new BytesWritable[]{new BytesWritable("value1".getBytes()), new BytesWritable("value2".getBytes())};
        mapA.put((WritableComparable)keys[0], (Writable)values[0]);
        mapB.put((WritableComparable)keys[1], (Writable)values[1]);
        failureReason = "Two SortedMapWritables with different data are now equal";
        Assert.assertTrue((String)failureReason, (mapA.hashCode() != mapB.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)failureReason, (!mapA.equals((Object)mapB) ? 1 : 0) != 0);
        Assert.assertTrue((String)failureReason, (!mapB.equals((Object)mapA) ? 1 : 0) != 0);
        mapA.put((WritableComparable)keys[1], (Writable)values[1]);
        mapB.put((WritableComparable)keys[0], (Writable)values[0]);
        failureReason = "Two SortedMapWritables with same entry sets formed in different order are now different";
        Assert.assertEquals((String)failureReason, (long)mapA.hashCode(), (long)mapB.hashCode());
        Assert.assertTrue((String)failureReason, (boolean)mapA.equals((Object)mapB));
        Assert.assertTrue((String)failureReason, (boolean)mapB.equals((Object)mapA));
        mapA.put((WritableComparable)keys[0], (Writable)values[1]);
        mapA.put((WritableComparable)keys[1], (Writable)values[0]);
        failureReason = "Two SortedMapWritables with different content are now equal";
        Assert.assertTrue((String)failureReason, (mapA.hashCode() != mapB.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)failureReason, (!mapA.equals((Object)mapB) ? 1 : 0) != 0);
        Assert.assertTrue((String)failureReason, (!mapB.equals((Object)mapA) ? 1 : 0) != 0);
    }

    @Test(timeout=10000L)
    public void testPutAll() {
        SortedMapWritable map1 = new SortedMapWritable();
        SortedMapWritable map2 = new SortedMapWritable();
        map1.put((WritableComparable)new Text("key"), (Writable)new Text("value"));
        map2.putAll((Map)map1);
        Assert.assertEquals((String)"map1 entries don't match map2 entries", (Object)map1, (Object)map2);
        Assert.assertTrue((String)"map2 doesn't have class information from map1", (map2.classToIdMap.containsKey(Text.class) && map2.idToClassMap.containsValue(Text.class) ? 1 : 0) != 0);
    }
}

