/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.TestTrash;
import org.apache.hadoop.fs.viewfs.ViewFileSystemTestSetup;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestViewFsTrash {
    FileSystem fsTarget;
    FileSystem fsView;
    Configuration conf;
    private FileSystemTestHelper fileSystemTestHelper;

    @Before
    public void setUp() throws Exception {
        Configuration targetFSConf = new Configuration();
        targetFSConf.setClass("fs.file.impl", TestTrash.TestLFS.class, FileSystem.class);
        this.fsTarget = FileSystem.getLocal((Configuration)targetFSConf);
        this.fileSystemTestHelper = new FileSystemTestHelper(this.fsTarget.getHomeDirectory().toUri().getPath());
        this.conf = ViewFileSystemTestSetup.createConfig();
        this.fsView = ViewFileSystemTestSetup.setupForViewFileSystem(this.conf, this.fileSystemTestHelper, this.fsTarget);
        this.conf.set("fs.defaultFS", FsConstants.VIEWFS_URI.toString());
        this.conf.setClass("fs.file.impl", TestTrash.TestLFS.class, FileSystem.class);
    }

    @After
    public void tearDown() throws Exception {
        ViewFileSystemTestSetup.tearDown(this.fileSystemTestHelper, this.fsTarget);
        this.fsTarget.delete(new Path(this.fsTarget.getHomeDirectory(), ".Trash/Current"), true);
    }

    @Test
    public void testTrash() throws Exception {
        TestTrash.trashShell(this.conf, this.fileSystemTestHelper.getTestRootPath(this.fsView), this.fsView, new Path(this.fileSystemTestHelper.getTestRootPath(this.fsView), ".Trash/Current"));
    }
}

