/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.contract.rawlocal;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.fs.contract.AbstractContractRenameTest;
import org.apache.hadoop.fs.contract.AbstractFSContract;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.contract.rawlocal.RawlocalFSContract;
import org.junit.Test;

public class TestRawlocalContractRename
extends AbstractContractRenameTest {
    @Override
    protected AbstractFSContract createContract(Configuration conf) {
        return new RawlocalFSContract(conf);
    }

    @Test
    public void testRenameWithNonEmptySubDirPOSIX() throws Throwable {
        Path renameTestDir = this.path("testRenameWithNonEmptySubDir");
        Path srcDir = new Path(renameTestDir, "src1");
        Path srcSubDir = new Path(srcDir, "sub");
        Path finalDir = new Path(renameTestDir, "dest");
        FileSystem fs = this.getFileSystem();
        ContractTestUtils.rm(fs, renameTestDir, true, false);
        fs.mkdirs(srcDir);
        fs.mkdirs(finalDir);
        ContractTestUtils.writeTextFile(fs, new Path(srcDir, "source.txt"), "this is the file in src dir", false);
        ContractTestUtils.writeTextFile(fs, new Path(srcSubDir, "subfile.txt"), "this is the file in src/sub dir", false);
        ContractTestUtils.assertPathExists(fs, "not created in src dir", new Path(srcDir, "source.txt"));
        ContractTestUtils.assertPathExists(fs, "not created in src/sub dir", new Path(srcSubDir, "subfile.txt"));
        RawLocalFileSystem rlfs = (RawLocalFileSystem)fs;
        rlfs.handleEmptyDstDirectoryOnWindows(srcDir, rlfs.pathToFile(srcDir), finalDir, rlfs.pathToFile(finalDir));
        ContractTestUtils.assertPathExists(fs, "not renamed into dest dir", new Path(finalDir, "source.txt"));
        ContractTestUtils.assertPathExists(fs, "not renamed into dest/sub dir", new Path(finalDir, "sub/subfile.txt"));
        ContractTestUtils.assertPathDoesNotExist(fs, "not deleted", new Path(srcDir, "source.txt"));
    }
}

