/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.terminal.impl;

import java.io.PrintWriter;
import org.apache.hadoop.hbase.hbtop.terminal.Attributes;
import org.apache.hadoop.hbase.hbtop.terminal.CursorPosition;
import org.apache.hadoop.hbase.hbtop.terminal.impl.Cell;
import org.apache.hadoop.hbase.hbtop.terminal.impl.EscapeSequences;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ScreenBuffer {
    private int columns;
    private int rows;
    private Cell[][] buffer;
    private Cell[][] physical;
    private boolean cursorVisible;
    private int cursorColumn;
    private int cursorRow;

    public void reallocate(int columns, int rows) {
        this.buffer = new Cell[columns][rows];
        this.physical = new Cell[columns][rows];
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                this.buffer[column][row] = new Cell();
                this.physical[column][row] = new Cell();
                this.physical[column][row].unset();
            }
        }
        this.columns = columns;
        this.rows = rows;
    }

    public void clear() {
        for (int row = 0; row < this.rows; ++row) {
            for (int col = 0; col < this.columns; ++col) {
                this.buffer[col][row].reset();
            }
        }
    }

    public void flush(PrintWriter output) {
        StringBuilder sb = new StringBuilder();
        sb.append(EscapeSequences.normal());
        Attributes attributes = new Attributes();
        for (int row = 0; row < this.rows; ++row) {
            this.flushRow(row, sb, attributes);
        }
        if (this.cursorVisible && this.cursorRow >= 0 && this.cursorColumn >= 0 && this.cursorRow < this.rows && this.cursorColumn < this.columns) {
            sb.append(EscapeSequences.cursor(true));
            sb.append(EscapeSequences.moveCursor(this.cursorColumn, this.cursorRow));
        } else {
            sb.append(EscapeSequences.cursor(false));
        }
        output.write(sb.toString());
        output.flush();
    }

    private void flushRow(int row, StringBuilder sb, Attributes lastAttributes) {
        int lastColumn = -1;
        for (int column = 0; column < this.columns; ++column) {
            Cell cell = this.buffer[column][row];
            Cell pCell = this.physical[column][row];
            if (cell.equals(pCell)) continue;
            if (lastColumn != column - 1 || lastColumn == -1) {
                sb.append(EscapeSequences.moveCursor(column, row));
            }
            if (cell.isEndOfLine()) {
                for (int i = column; i < this.columns; ++i) {
                    this.physical[i][row].set(this.buffer[i][row]);
                }
                sb.append(EscapeSequences.clearRemainingLine());
                lastAttributes.reset();
                return;
            }
            if (!cell.getAttributes().equals(lastAttributes)) {
                sb.append(EscapeSequences.color(cell.getForegroundColor(), cell.getBackgroundColor(), cell.isBold(), cell.isReverse(), cell.isBlink(), cell.isUnderline()));
            }
            sb.append(cell.getChar());
            lastColumn = column;
            lastAttributes.set(cell.getAttributes());
            this.physical[column][row].set(cell);
        }
    }

    public CursorPosition getCursorPosition() {
        return new CursorPosition(this.cursorColumn, this.cursorRow);
    }

    public void setCursorPosition(int column, int row) {
        this.cursorVisible = true;
        this.cursorColumn = column;
        this.cursorRow = row;
    }

    public void hideCursor() {
        this.cursorVisible = false;
    }

    public void putString(int column, int row, String string, Attributes attributes) {
        int i = column;
        for (int j = 0; j < string.length(); ++j) {
            char ch = string.charAt(j);
            this.putChar(i, row, ch, attributes);
            if (++i == this.columns) break;
        }
    }

    public void putChar(int column, int row, char ch, Attributes attributes) {
        if (column >= 0 && column < this.columns && row >= 0 && row < this.rows) {
            this.buffer[column][row].setAttributes(attributes);
            this.buffer[column][row].setChar(ch);
        }
    }

    public void endOfLine(int column, int row) {
        if (column >= 0 && column < this.columns && row >= 0 && row < this.rows) {
            this.buffer[column][row].endOfLine();
            for (int i = column + 1; i < this.columns; ++i) {
                this.buffer[i][row].reset();
            }
        }
    }
}

