/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.regionserver.CompactionTool;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, RegionServerTests.class})
public class TestCompactionTool {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCompactionTool.class);
    private final HBaseTestingUtil testUtil = new HBaseTestingUtil();
    private HRegion region;
    private static final byte[] qualifier = Bytes.toBytes((String)"qf");
    private Path rootDir;
    private final TableName tableName = TableName.valueOf((String)this.getClass().getSimpleName());

    @Before
    public void setUp() throws Exception {
        this.testUtil.startMiniCluster();
        this.testUtil.createTable(this.tableName, HBaseTestingUtil.fam1);
        this.rootDir = this.testUtil.getDefaultRootDirPath();
        this.region = (HRegion)this.testUtil.getMiniHBaseCluster().getRegions(this.tableName).get(0);
    }

    @After
    public void tearDown() throws Exception {
        this.testUtil.shutdownMiniCluster();
        this.testUtil.cleanupTestDir();
    }

    @Test
    public void testCompactedFilesArchived() throws Exception {
        for (int i = 0; i < 10; ++i) {
            this.putAndFlush(i);
        }
        HStore store = this.region.getStore(HBaseTestingUtil.fam1);
        Assert.assertEquals((long)10L, (long)store.getStorefilesCount());
        Path tableDir = CommonFSUtils.getTableDir((Path)this.rootDir, (TableName)this.region.getRegionInfo().getTable());
        FileSystem fs = store.getFileSystem();
        String storePath = tableDir + "/" + this.region.getRegionInfo().getEncodedName() + "/" + Bytes.toString((byte[])HBaseTestingUtil.fam1);
        FileStatus[] regionDirFiles = fs.listStatus(new Path(storePath));
        Assert.assertEquals((long)10L, (long)regionDirFiles.length);
        String defaultFS = this.testUtil.getMiniHBaseCluster().getConfiguration().get("fs.defaultFS");
        Configuration config = HBaseConfiguration.create();
        config.set("fs.defaultFS", defaultFS);
        int result = ToolRunner.run((Configuration)config, (Tool)new CompactionTool(), (String[])new String[]{"-compactOnce", "-major", storePath});
        Assert.assertEquals((long)0L, (long)result);
        regionDirFiles = fs.listStatus(new Path(storePath));
        Assert.assertEquals((long)1L, (long)regionDirFiles.length);
    }

    private void putAndFlush(int key) throws Exception {
        Put put = new Put(Bytes.toBytes((int)key));
        put.addColumn(HBaseTestingUtil.fam1, qualifier, Bytes.toBytes((String)("val" + key)));
        this.region.put(put);
        this.region.flush(true);
    }
}

