/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.Closeable;
import java.io.File;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtil;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.mapreduce.Import;
import org.apache.hadoop.hbase.mapreduce.TableInputFormat;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.WALInputFormat;
import org.apache.hadoop.hbase.security.HBaseKerberosUtils;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.access.PermissionStorage;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.security.provider.SaslClientAuthenticationProviders;
import org.apache.hadoop.hbase.security.token.AuthenticationTokenIdentifier;
import org.apache.hadoop.hbase.security.token.TokenProvider;
import org.apache.hadoop.hbase.security.visibility.VisibilityTestUtil;
import org.apache.hadoop.hbase.testclassification.MapReduceTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKClusterId;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.junit.After;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MapReduceTests.class, MediumTests.class})
public class TestTableMapReduceUtil {
    private static final String HTTP_PRINCIPAL = "HTTP/localhost";
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestTableMapReduceUtil.class);

    @After
    public void after() {
        SaslClientAuthenticationProviders.reset();
    }

    @Test
    public void testInitTableMapperJob1() throws Exception {
        Configuration configuration = new Configuration();
        Job job = Job.getInstance((Configuration)configuration, (String)"tableName");
        TableMapReduceUtil.initTableMapperJob((String)"Table", (Scan)new Scan(), Import.Importer.class, Text.class, Text.class, (Job)job, (boolean)false, WALInputFormat.class);
        Assert.assertEquals(WALInputFormat.class, (Object)job.getInputFormatClass());
        Assert.assertEquals(Import.Importer.class, (Object)job.getMapperClass());
        Assert.assertEquals(LongWritable.class, (Object)job.getOutputKeyClass());
        Assert.assertEquals(Text.class, (Object)job.getOutputValueClass());
        Assert.assertNull((Object)job.getCombinerClass());
        Assert.assertEquals((Object)"Table", (Object)job.getConfiguration().get("hbase.mapreduce.inputtable"));
    }

    @Test
    public void testInitTableMapperJob2() throws Exception {
        Configuration configuration = new Configuration();
        Job job = Job.getInstance((Configuration)configuration, (String)"tableName");
        TableMapReduceUtil.initTableMapperJob((byte[])Bytes.toBytes((String)"Table"), (Scan)new Scan(), Import.Importer.class, Text.class, Text.class, (Job)job, (boolean)false, WALInputFormat.class);
        Assert.assertEquals(WALInputFormat.class, (Object)job.getInputFormatClass());
        Assert.assertEquals(Import.Importer.class, (Object)job.getMapperClass());
        Assert.assertEquals(LongWritable.class, (Object)job.getOutputKeyClass());
        Assert.assertEquals(Text.class, (Object)job.getOutputValueClass());
        Assert.assertNull((Object)job.getCombinerClass());
        Assert.assertEquals((Object)"Table", (Object)job.getConfiguration().get("hbase.mapreduce.inputtable"));
    }

    @Test
    public void testInitTableMapperJob3() throws Exception {
        Configuration configuration = new Configuration();
        Job job = Job.getInstance((Configuration)configuration, (String)"tableName");
        TableMapReduceUtil.initTableMapperJob((byte[])Bytes.toBytes((String)"Table"), (Scan)new Scan(), Import.Importer.class, Text.class, Text.class, (Job)job);
        Assert.assertEquals(TableInputFormat.class, (Object)job.getInputFormatClass());
        Assert.assertEquals(Import.Importer.class, (Object)job.getMapperClass());
        Assert.assertEquals(LongWritable.class, (Object)job.getOutputKeyClass());
        Assert.assertEquals(Text.class, (Object)job.getOutputValueClass());
        Assert.assertNull((Object)job.getCombinerClass());
        Assert.assertEquals((Object)"Table", (Object)job.getConfiguration().get("hbase.mapreduce.inputtable"));
    }

    @Test
    public void testInitTableMapperJob4() throws Exception {
        Configuration configuration = new Configuration();
        Job job = Job.getInstance((Configuration)configuration, (String)"tableName");
        TableMapReduceUtil.initTableMapperJob((byte[])Bytes.toBytes((String)"Table"), (Scan)new Scan(), Import.Importer.class, Text.class, Text.class, (Job)job, (boolean)false);
        Assert.assertEquals(TableInputFormat.class, (Object)job.getInputFormatClass());
        Assert.assertEquals(Import.Importer.class, (Object)job.getMapperClass());
        Assert.assertEquals(LongWritable.class, (Object)job.getOutputKeyClass());
        Assert.assertEquals(Text.class, (Object)job.getOutputValueClass());
        Assert.assertNull((Object)job.getCombinerClass());
        Assert.assertEquals((Object)"Table", (Object)job.getConfiguration().get("hbase.mapreduce.inputtable"));
    }

    private static Closeable startSecureMiniCluster(HBaseTestingUtil util, MiniKdc kdc, String principal) throws Exception {
        Configuration conf = util.getConfiguration();
        SecureTestUtil.enableSecurity((Configuration)conf);
        VisibilityTestUtil.enableVisiblityLabels((Configuration)conf);
        SecureTestUtil.verifyConfiguration((Configuration)conf);
        conf.set("hbase.coprocessor.region.classes", AccessController.class.getName() + ',' + TokenProvider.class.getName());
        HBaseKerberosUtils.setSecuredConfiguration((Configuration)conf, (String)(principal + '@' + kdc.getRealm()), (String)("HTTP/localhost@" + kdc.getRealm()));
        util.startMiniCluster();
        try {
            util.waitUntilAllRegionsAssigned(PermissionStorage.ACL_TABLE_NAME);
        }
        catch (Exception e) {
            util.shutdownMiniCluster();
            throw e;
        }
        return () -> ((HBaseTestingUtil)util).shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInitCredentialsForCluster1() throws Exception {
        HBaseTestingUtil util1 = new HBaseTestingUtil();
        HBaseTestingUtil util2 = new HBaseTestingUtil();
        util1.startMiniCluster();
        try {
            util2.startMiniCluster();
            try {
                Configuration conf1 = util1.getConfiguration();
                Job job = Job.getInstance((Configuration)conf1);
                TableMapReduceUtil.initCredentialsForCluster((Job)job, (Configuration)util2.getConfiguration());
                Credentials credentials = job.getCredentials();
                Collection tokens = credentials.getAllTokens();
                Assert.assertTrue((boolean)tokens.isEmpty());
            }
            finally {
                util2.shutdownMiniCluster();
            }
        }
        finally {
            util1.shutdownMiniCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInitCredentialsForCluster2() throws Exception {
        HBaseTestingUtil util1 = new HBaseTestingUtil();
        HBaseTestingUtil util2 = new HBaseTestingUtil();
        File keytab = new File(util1.getDataTestDir("keytab").toUri().getPath());
        MiniKdc kdc = util1.setupMiniKdc(keytab);
        try {
            String username = UserGroupInformation.getLoginUser().getShortUserName();
            String userPrincipal = username + "/localhost";
            kdc.createPrincipal(keytab, new String[]{userPrincipal, HTTP_PRINCIPAL});
            UserGroupInformation.loginUserFromKeytab((String)(userPrincipal + '@' + kdc.getRealm()), (String)keytab.getAbsolutePath());
            try (Closeable util1Closeable = TestTableMapReduceUtil.startSecureMiniCluster(util1, kdc, userPrincipal);
                 Closeable util2Closeable = TestTableMapReduceUtil.startSecureMiniCluster(util2, kdc, userPrincipal);){
                Configuration conf1 = util1.getConfiguration();
                Job job = Job.getInstance((Configuration)conf1);
                TableMapReduceUtil.initCredentialsForCluster((Job)job, (Configuration)util2.getConfiguration());
                Credentials credentials = job.getCredentials();
                Collection tokens = credentials.getAllTokens();
                Assert.assertEquals((long)1L, (long)tokens.size());
                String clusterId = ZKClusterId.readClusterIdZNode((ZKWatcher)util2.getZooKeeperWatcher());
                Token tokenForCluster = credentials.getToken(new Text(clusterId));
                Assert.assertEquals((Object)(userPrincipal + '@' + kdc.getRealm()), (Object)((AuthenticationTokenIdentifier)tokenForCluster.decodeIdentifier()).getUsername());
            }
        }
        finally {
            kdc.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInitCredentialsForCluster3() throws Exception {
        HBaseTestingUtil util1 = new HBaseTestingUtil();
        File keytab = new File(util1.getDataTestDir("keytab").toUri().getPath());
        MiniKdc kdc = util1.setupMiniKdc(keytab);
        try {
            String username = UserGroupInformation.getLoginUser().getShortUserName();
            String userPrincipal = username + "/localhost";
            kdc.createPrincipal(keytab, new String[]{userPrincipal, HTTP_PRINCIPAL});
            UserGroupInformation.loginUserFromKeytab((String)(userPrincipal + '@' + kdc.getRealm()), (String)keytab.getAbsolutePath());
            try (Closeable util1Closeable = TestTableMapReduceUtil.startSecureMiniCluster(util1, kdc, userPrincipal);){
                HBaseTestingUtil util2 = new HBaseTestingUtil();
                Configuration conf1 = util1.getConfiguration();
                Job job = Job.getInstance((Configuration)conf1);
                TableMapReduceUtil.initCredentialsForCluster((Job)job, (Configuration)util2.getConfiguration());
                Credentials credentials = job.getCredentials();
                Collection tokens = credentials.getAllTokens();
                Assert.assertTrue((boolean)tokens.isEmpty());
            }
        }
        finally {
            kdc.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInitCredentialsForCluster4() throws Exception {
        HBaseTestingUtil util1 = new HBaseTestingUtil();
        HBaseTestingUtil util2 = new HBaseTestingUtil();
        File keytab = new File(util2.getDataTestDir("keytab").toUri().getPath());
        MiniKdc kdc = util2.setupMiniKdc(keytab);
        try {
            String username = UserGroupInformation.getLoginUser().getShortUserName();
            String userPrincipal = username + "/localhost";
            kdc.createPrincipal(keytab, new String[]{userPrincipal, HTTP_PRINCIPAL});
            UserGroupInformation.loginUserFromKeytab((String)(userPrincipal + '@' + kdc.getRealm()), (String)keytab.getAbsolutePath());
            try (Closeable util2Closeable = TestTableMapReduceUtil.startSecureMiniCluster(util2, kdc, userPrincipal);){
                Configuration conf1 = util1.getConfiguration();
                Job job = Job.getInstance((Configuration)conf1);
                TableMapReduceUtil.initCredentialsForCluster((Job)job, (Configuration)util2.getConfiguration());
                Credentials credentials = job.getCredentials();
                Collection tokens = credentials.getAllTokens();
                Assert.assertEquals((long)1L, (long)tokens.size());
                String clusterId = ZKClusterId.readClusterIdZNode((ZKWatcher)util2.getZooKeeperWatcher());
                Token tokenForCluster = credentials.getToken(new Text(clusterId));
                Assert.assertEquals((Object)(userPrincipal + '@' + kdc.getRealm()), (Object)((AuthenticationTokenIdentifier)tokenForCluster.decodeIdentifier()).getUsername());
            }
        }
        finally {
            kdc.stop();
        }
    }
}

