/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fi;

import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fi.FiConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProbabilityModel {
    private static Random generator = new Random();
    private static final Logger LOG = LoggerFactory.getLogger(ProbabilityModel.class);
    static final String FPROB_NAME = "fi.";
    private static final String ALL_PROBABILITIES = "fi.*";
    private static final float DEFAULT_PROB = 0.0f;
    private static final float MAX_PROB = 1.0f;
    private static Configuration conf = FiConfig.getConfig();

    public static boolean injectCriteria(String klassName) {
        boolean trigger = false;
        if (generator.nextFloat() < ProbabilityModel.getProbability(klassName)) {
            trigger = true;
        }
        return trigger;
    }

    protected static float getProbability(String klass) {
        String newProbName = FPROB_NAME + klass;
        String newValue = System.getProperty(newProbName, conf.get(ALL_PROBABILITIES));
        if (newValue != null && !newValue.equals(conf.get(newProbName))) {
            conf.set(newProbName, newValue);
        }
        float ret = conf.getFloat(newProbName, conf.getFloat(ALL_PROBABILITIES, 0.0f));
        LOG.debug("Request for " + newProbName + " returns=" + ret);
        if (ret < 0.0f || ret > 1.0f) {
            ret = conf.getFloat(ALL_PROBABILITIES, 0.0f);
        }
        return ret;
    }

    static {
        conf.set(ALL_PROBABILITIES, System.getProperty(ALL_PROBABILITIES, conf.get(ALL_PROBABILITIES, Float.toString(0.0f))));
        LOG.info("fi.*=" + conf.get(ALL_PROBABILITIES));
    }
}

