/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.ResourcePlugin;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.fpga.FpgaResourcePlugin;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.gpu.GpuDiscoverer;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.gpu.GpuNodeResourceUpdateHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.gpu.GpuResourcePlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcePluginManager {
    private static final Logger LOG = LoggerFactory.getLogger(ResourcePluginManager.class);
    private static final Set<String> SUPPORTED_RESOURCE_PLUGINS = ImmutableSet.of((Object)"yarn.io/gpu", (Object)"yarn.io/fpga");
    private Map<String, ResourcePlugin> configuredPlugins = Collections.emptyMap();

    public void initialize(Context context) throws YarnException {
        Configuration conf = context.getConf();
        String[] plugins = this.getPluginsFromConfig(conf);
        Map<Object, Object> pluginMap = Maps.newHashMap();
        if (plugins != null) {
            pluginMap = this.initializePlugins(conf, context, plugins);
        }
        this.configuredPlugins = Collections.unmodifiableMap(pluginMap);
    }

    private String[] getPluginsFromConfig(Configuration conf) {
        Object[] plugins = conf.getStrings("yarn.nodemanager.resource-plugins");
        if (plugins == null || plugins.length == 0) {
            LOG.info("No Resource plugins found from configuration!");
        }
        LOG.info("Found Resource plugins from configuration: " + Arrays.toString(plugins));
        return plugins;
    }

    private Map<String, ResourcePlugin> initializePlugins(Configuration conf, Context context, String[] plugins) throws YarnException {
        HashMap pluginMap = Maps.newHashMap();
        for (String resourceName : plugins) {
            resourceName = resourceName.trim();
            this.ensurePluginIsSupported(resourceName);
            if (this.isPluginDuplicate(pluginMap, resourceName)) continue;
            ResourcePlugin plugin = null;
            if (resourceName.equals("yarn.io/gpu")) {
                GpuDiscoverer gpuDiscoverer = new GpuDiscoverer();
                GpuNodeResourceUpdateHandler updateHandler = new GpuNodeResourceUpdateHandler(gpuDiscoverer, conf);
                plugin = new GpuResourcePlugin(updateHandler, gpuDiscoverer);
            } else if (resourceName.equals("yarn.io/fpga")) {
                plugin = new FpgaResourcePlugin();
            }
            if (plugin == null) {
                throw new YarnException("This shouldn't happen, plugin=" + resourceName + " should be loaded and initialized");
            }
            plugin.initialize(context);
            LOG.info("Initialized plugin {}", (Object)plugin);
            pluginMap.put(resourceName, plugin);
        }
        return pluginMap;
    }

    private void ensurePluginIsSupported(String resourceName) throws YarnException {
        if (!SUPPORTED_RESOURCE_PLUGINS.contains(resourceName)) {
            String msg = "Trying to initialize resource plugin with name=" + resourceName + ", it is not supported, list of supported plugins:" + StringUtils.join((Object[])new Object[]{",", SUPPORTED_RESOURCE_PLUGINS});
            LOG.error(msg);
            throw new YarnException(msg);
        }
    }

    private boolean isPluginDuplicate(Map<String, ResourcePlugin> pluginMap, String resourceName) {
        if (pluginMap.containsKey(resourceName)) {
            LOG.warn("Ignoring duplicate Resource plugin definition: " + resourceName);
            return true;
        }
        return false;
    }

    public void cleanup() throws YarnException {
        for (ResourcePlugin plugin : this.configuredPlugins.values()) {
            plugin.cleanup();
        }
    }

    public synchronized Map<String, ResourcePlugin> getNameToPlugins() {
        return this.configuredPlugins;
    }
}

