/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import com.google.errorprone.annotations.RestrictedApi;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.balancer.ClusterInfoProvider;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hbase.thirdparty.com.google.common.cache.CacheBuilder;
import org.apache.hbase.thirdparty.com.google.common.cache.CacheLoader;
import org.apache.hbase.thirdparty.com.google.common.cache.LoadingCache;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.Futures;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class RegionHDFSBlockLocationFinder
extends Configured {
    private static final Logger LOG = LoggerFactory.getLogger(RegionHDFSBlockLocationFinder.class);
    private static final long CACHE_TIME = 14400000L;
    private static final float EPSILON = 1.0E-4f;
    private static final HDFSBlocksDistribution EMPTY_BLOCK_DISTRIBUTION = new HDFSBlocksDistribution();
    private volatile ClusterMetrics status;
    private volatile ClusterInfoProvider provider;
    private final ListeningExecutorService executor;
    private long lastFullRefresh = EnvironmentEdgeManager.currentTime();
    private CacheLoader<RegionInfo, HDFSBlocksDistribution> loader = new CacheLoader<RegionInfo, HDFSBlocksDistribution>(){

        public ListenableFuture<HDFSBlocksDistribution> reload(final RegionInfo hri, HDFSBlocksDistribution oldValue) throws Exception {
            return RegionHDFSBlockLocationFinder.this.executor.submit((Callable)new Callable<HDFSBlocksDistribution>(){

                @Override
                public HDFSBlocksDistribution call() throws Exception {
                    return RegionHDFSBlockLocationFinder.this.internalGetTopBlockLocation(hri);
                }
            });
        }

        public HDFSBlocksDistribution load(RegionInfo key) throws Exception {
            return RegionHDFSBlockLocationFinder.this.internalGetTopBlockLocation(key);
        }
    };
    private LoadingCache<RegionInfo, HDFSBlocksDistribution> cache = this.createCache();

    RegionHDFSBlockLocationFinder() {
        this.executor = MoreExecutors.listeningDecorator((ScheduledExecutorService)Executors.newScheduledThreadPool(5, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("region-location-%d").build()));
    }

    private LoadingCache<RegionInfo, HDFSBlocksDistribution> createCache() {
        return CacheBuilder.newBuilder().expireAfterWrite(14400000L, TimeUnit.MILLISECONDS).build(this.loader);
    }

    void setClusterInfoProvider(ClusterInfoProvider provider) {
        this.provider = provider;
    }

    void setClusterMetrics(ClusterMetrics status) {
        long currentTime = EnvironmentEdgeManager.currentTime();
        if (currentTime > this.lastFullRefresh + 0x6DDD00L) {
            this.status = status;
            this.lastFullRefresh = this.scheduleFullRefresh() ? currentTime : this.lastFullRefresh;
        } else {
            this.refreshLocalityChangedRegions(this.status, status);
            this.status = status;
        }
    }

    private void refreshLocalityChangedRegions(ClusterMetrics oldStatus, ClusterMetrics newStatus) {
        if (oldStatus == null || newStatus == null) {
            LOG.debug("Skipping locality-based refresh due to oldStatus={}, newStatus={}", (Object)oldStatus, (Object)newStatus);
            return;
        }
        Map oldServers = oldStatus.getLiveServerMetrics();
        Map newServers = newStatus.getLiveServerMetrics();
        HashMap<String, RegionInfo> regionsByName = new HashMap<String, RegionInfo>(this.cache.asMap().size());
        for (RegionInfo regionInfo : this.cache.asMap().keySet()) {
            regionsByName.put(regionInfo.getEncodedName(), regionInfo);
        }
        for (Map.Entry entry : newServers.entrySet()) {
            Map newRegions = ((ServerMetrics)entry.getValue()).getRegionMetrics();
            for (Map.Entry regionEntry : newRegions.entrySet()) {
                float oldLocality;
                float newLocality;
                String encodedName = RegionInfo.encodeRegionName((byte[])((byte[])regionEntry.getKey()));
                RegionInfo region = (RegionInfo)regionsByName.get(encodedName);
                if (region == null || !(Math.abs((newLocality = ((RegionMetrics)regionEntry.getValue()).getDataLocality()) - (oldLocality = this.getOldLocality((ServerName)entry.getKey(), (byte[])regionEntry.getKey(), oldServers))) > 1.0E-4f)) continue;
                LOG.debug("Locality for region {} changed from {} to {}, refreshing cache", new Object[]{region.getEncodedName(), Float.valueOf(oldLocality), Float.valueOf(newLocality)});
                this.cache.refresh((Object)region);
            }
        }
    }

    private float getOldLocality(ServerName newServer, byte[] regionName, Map<ServerName, ServerMetrics> oldServers) {
        ServerMetrics serverMetrics = oldServers.get(newServer);
        if (serverMetrics == null) {
            return -1.0f;
        }
        RegionMetrics regionMetrics = (RegionMetrics)serverMetrics.getRegionMetrics().get(regionName);
        if (regionMetrics == null) {
            return -1.0f;
        }
        return regionMetrics.getDataLocality();
    }

    private boolean scheduleFullRefresh() {
        ClusterInfoProvider service = this.provider;
        if (service == null) {
            return false;
        }
        boolean includesUserTables = false;
        for (RegionInfo hri : service.getAssignedRegions()) {
            this.cache.refresh((Object)hri);
            includesUserTables |= !hri.getTable().isSystemTable();
        }
        return includesUserTables;
    }

    List<ServerName> getTopBlockLocations(RegionInfo region) {
        List topHosts = this.getBlockDistribution(region).getTopHosts();
        return this.mapHostNameToServerName(topHosts);
    }

    private HDFSBlocksDistribution internalGetTopBlockLocation(RegionInfo region) {
        try {
            TableDescriptor tableDescriptor = this.getDescriptor(region.getTable());
            if (tableDescriptor != null) {
                HDFSBlocksDistribution blocksDistribution = this.provider.computeHDFSBlocksDistribution(this.getConf(), tableDescriptor, region);
                return blocksDistribution;
            }
        }
        catch (IOException ioe) {
            LOG.warn("IOException during HDFSBlocksDistribution computation for region = {}", (Object)region.getEncodedName(), (Object)ioe);
        }
        return EMPTY_BLOCK_DISTRIBUTION;
    }

    private TableDescriptor getDescriptor(TableName tableName) throws IOException {
        ClusterInfoProvider service = this.provider;
        if (service == null) {
            return null;
        }
        return service.getTableDescriptor(tableName);
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*/src/test/.*|.*/RegionHDFSBlockLocationFinder.java")
    List<ServerName> mapHostNameToServerName(List<String> hosts) {
        if (hosts == null || this.status == null) {
            if (hosts == null) {
                LOG.warn("RegionLocationFinder top hosts is null");
            }
            return Collections.emptyList();
        }
        ArrayList<ServerName> topServerNames = new ArrayList<ServerName>();
        Set regionServers = this.status.getLiveServerMetrics().keySet();
        HashMap hostToServerName = new HashMap();
        for (ServerName sn : regionServers) {
            String host = sn.getHostname();
            if (!hostToServerName.containsKey(host)) {
                hostToServerName.put(host, new ArrayList());
            }
            ((List)hostToServerName.get(host)).add(sn);
        }
        for (String host : hosts) {
            if (!hostToServerName.containsKey(host)) continue;
            for (ServerName sn : (List)hostToServerName.get(host)) {
                if (sn == null) continue;
                topServerNames.add(sn);
            }
        }
        return topServerNames;
    }

    HDFSBlocksDistribution getBlockDistribution(RegionInfo hri) {
        HDFSBlocksDistribution blockDistbn = null;
        try {
            if (this.cache.asMap().containsKey(hri)) {
                blockDistbn = (HDFSBlocksDistribution)this.cache.get((Object)hri);
                return blockDistbn;
            }
            LOG.trace("HDFSBlocksDistribution not found in cache for {}", (Object)hri.getRegionNameAsString());
            blockDistbn = this.internalGetTopBlockLocation(hri);
            this.cache.put((Object)hri, (Object)blockDistbn);
            return blockDistbn;
        }
        catch (ExecutionException e) {
            LOG.warn("Error while fetching cache entry ", (Throwable)e);
            blockDistbn = this.internalGetTopBlockLocation(hri);
            this.cache.put((Object)hri, (Object)blockDistbn);
            return blockDistbn;
        }
    }

    private ListenableFuture<HDFSBlocksDistribution> asyncGetBlockDistribution(RegionInfo hri) {
        try {
            return this.loader.reload((Object)hri, (Object)EMPTY_BLOCK_DISTRIBUTION);
        }
        catch (Exception e) {
            return Futures.immediateFuture((Object)EMPTY_BLOCK_DISTRIBUTION);
        }
    }

    void refreshAndWait(Collection<RegionInfo> hris) {
        ArrayList<ListenableFuture<HDFSBlocksDistribution>> regionLocationFutures = new ArrayList<ListenableFuture<HDFSBlocksDistribution>>(hris.size());
        for (RegionInfo hregionInfo : hris) {
            regionLocationFutures.add(this.asyncGetBlockDistribution(hregionInfo));
        }
        int index = 0;
        for (RegionInfo hregionInfo : hris) {
            ListenableFuture future = (ListenableFuture)regionLocationFutures.get(index);
            try {
                this.cache.put((Object)hregionInfo, future.get());
            }
            catch (InterruptedException ite) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException ee) {
                LOG.debug("ExecutionException during HDFSBlocksDistribution computation for region = {}", (Object)hregionInfo.getEncodedName(), (Object)ee);
            }
            ++index;
        }
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*/src/test/.*")
    LoadingCache<RegionInfo, HDFSBlocksDistribution> getCache() {
        return this.cache;
    }
}

