/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.hbase.client.replication.ReplicationPeerConfigUtil;
import org.apache.hadoop.hbase.protobuf.ProtobufMagic;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ReplicationProtos;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hbase.thirdparty.com.google.common.io.ByteStreams;
import org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public enum SyncReplicationState {
    NONE(0),
    ACTIVE(1),
    DOWNGRADE_ACTIVE(2),
    STANDBY(3);

    private final byte value;

    private SyncReplicationState(int value) {
        this.value = (byte)value;
    }

    public static SyncReplicationState valueOf(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return ACTIVE;
            }
            case 2: {
                return DOWNGRADE_ACTIVE;
            }
            case 3: {
                return STANDBY;
            }
        }
        throw new IllegalArgumentException("Unknown synchronous replication state " + value);
    }

    public int value() {
        return this.value & 0xFF;
    }

    public static byte[] toByteArray(SyncReplicationState state) {
        return ProtobufUtil.prependPBMagic(ReplicationPeerConfigUtil.toSyncReplicationState(state).toByteArray());
    }

    public static SyncReplicationState parseFrom(byte[] bytes) throws InvalidProtocolBufferException {
        return ReplicationPeerConfigUtil.toSyncReplicationState(ReplicationProtos.SyncReplicationState.parseFrom(Arrays.copyOfRange(bytes, ProtobufUtil.lengthOfPBMagic(), bytes.length)));
    }

    public static byte[] toByteArray(SyncReplicationState state, SyncReplicationState newState) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(ProtobufMagic.PB_MAGIC);
            ReplicationPeerConfigUtil.toSyncReplicationState(state).writeDelimitedTo(out);
            ReplicationPeerConfigUtil.toSyncReplicationState(newState).writeDelimitedTo(out);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return out.toByteArray();
    }

    public static Pair<SyncReplicationState, SyncReplicationState> parseStateAndNewStateFrom(byte[] bytes) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        ByteStreams.skipFully(in, ProtobufMagic.lengthOfPBMagic());
        SyncReplicationState state = ReplicationPeerConfigUtil.toSyncReplicationState(ReplicationProtos.SyncReplicationState.parseDelimitedFrom(in));
        SyncReplicationState newState = ReplicationPeerConfigUtil.toSyncReplicationState(ReplicationProtos.SyncReplicationState.parseDelimitedFrom(in));
        return Pair.newPair(state, newState);
    }
}

