/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.util.ArrayList;
import org.apache.hadoop.hbase.ByteBufferExtendedCell;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.FilterProtos;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class PrefixFilter
extends FilterBase {
    protected byte[] prefix = null;
    protected boolean passedPrefix = false;
    protected boolean filterRow = true;

    public PrefixFilter(byte[] prefix) {
        this.prefix = prefix;
    }

    public byte[] getPrefix() {
        return this.prefix;
    }

    @Override
    public boolean filterRowKey(Cell firstRowCell) {
        if (firstRowCell == null || this.prefix == null) {
            return true;
        }
        if (this.filterAllRemaining()) {
            return true;
        }
        short length = firstRowCell.getRowLength();
        if (length < this.prefix.length) {
            return true;
        }
        int cmp = firstRowCell instanceof ByteBufferExtendedCell ? ByteBufferUtils.compareTo(((ByteBufferExtendedCell)firstRowCell).getRowByteBuffer(), ((ByteBufferExtendedCell)firstRowCell).getRowPosition(), this.prefix.length, this.prefix, 0, this.prefix.length) : Bytes.compareTo(firstRowCell.getRowArray(), firstRowCell.getRowOffset(), this.prefix.length, this.prefix, 0, this.prefix.length);
        if (!this.isReversed() && cmp > 0 || this.isReversed() && cmp < 0) {
            this.passedPrefix = true;
        }
        this.filterRow = cmp != 0;
        return this.filterRow;
    }

    @Override
    public Filter.ReturnCode filterCell(Cell c) {
        if (this.filterRow) {
            return Filter.ReturnCode.NEXT_ROW;
        }
        return Filter.ReturnCode.INCLUDE;
    }

    @Override
    public boolean filterRow() {
        return this.filterRow;
    }

    @Override
    public void reset() {
        this.filterRow = true;
    }

    @Override
    public boolean filterAllRemaining() {
        return this.passedPrefix;
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        Preconditions.checkArgument(filterArguments.size() == 1, "Expected 1 but got: %s", filterArguments.size());
        byte[] prefix = ParseFilter.removeQuotesFromByteArray(filterArguments.get(0));
        return new PrefixFilter(prefix);
    }

    @Override
    public byte[] toByteArray() {
        FilterProtos.PrefixFilter.Builder builder = FilterProtos.PrefixFilter.newBuilder();
        if (this.prefix != null) {
            builder.setPrefix(UnsafeByteOperations.unsafeWrap(this.prefix));
        }
        return builder.build().toByteArray();
    }

    public static PrefixFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.PrefixFilter proto;
        try {
            proto = FilterProtos.PrefixFilter.parseFrom(pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        return new PrefixFilter(proto.hasPrefix() ? proto.getPrefix().toByteArray() : null);
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrefixFilter)) {
            return false;
        }
        PrefixFilter other = (PrefixFilter)o;
        return Bytes.equals(this.getPrefix(), other.getPrefix());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " " + Bytes.toStringBinary(this.prefix);
    }

    public boolean equals(Object obj) {
        return obj instanceof Filter && this.areSerializedFieldsEqual((Filter)obj);
    }

    public int hashCode() {
        return Bytes.hashCode(this.getPrefix());
    }
}

