/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.trace;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.trace.HBaseSemanticAttributes;
import org.apache.hadoop.hbase.trace.TraceUtil;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ConnectionSpanBuilder
implements Supplier<Span> {
    private String name;
    private final Map<AttributeKey<?>, Object> attributes = new HashMap();

    public ConnectionSpanBuilder(AsyncConnectionImpl conn) {
        ConnectionSpanBuilder.populateConnectionAttributes(this.attributes, conn);
    }

    @Override
    public Span get() {
        return this.build();
    }

    public ConnectionSpanBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public <T> ConnectionSpanBuilder addAttribute(AttributeKey<T> key, T value) {
        this.attributes.put(key, value);
        return this;
    }

    public Span build() {
        SpanBuilder builder = TraceUtil.getGlobalTracer().spanBuilder(this.name).setSpanKind(SpanKind.INTERNAL);
        this.attributes.forEach((k, v) -> builder.setAttribute(k, v));
        return builder.startSpan();
    }

    static void populateConnectionAttributes(Map<AttributeKey<?>, Object> attributes, AsyncConnectionImpl conn) {
        Supplier<String> connStringSupplier = () -> conn.getConnectionRegistry().getConnectionString();
        ConnectionSpanBuilder.populateConnectionAttributes(attributes, connStringSupplier, conn::getUser);
    }

    static void populateConnectionAttributes(Map<AttributeKey<?>, Object> attributes, Supplier<String> connectionStringSupplier, Supplier<User> userSupplier) {
        attributes.put(HBaseSemanticAttributes.DB_SYSTEM, "hbase");
        attributes.put(HBaseSemanticAttributes.DB_CONNECTION_STRING, connectionStringSupplier.get());
        attributes.put(HBaseSemanticAttributes.DB_USER, Optional.ofNullable(userSupplier.get()).map(Object::toString).orElse(null));
    }
}

