/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.MultiRowRangeFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.AbstractHBaseTool;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hbase.thirdparty.com.google.common.base.Splitter;
import org.apache.hbase.thirdparty.org.apache.commons.cli.BasicParser;
import org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLineParser;
import org.apache.hbase.thirdparty.org.apache.commons.cli.HelpFormatter;
import org.apache.hbase.thirdparty.org.apache.commons.cli.MissingOptionException;
import org.apache.hbase.thirdparty.org.apache.commons.cli.Option;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class RowCounter
extends AbstractHBaseTool {
    private static final Logger LOG = LoggerFactory.getLogger(RowCounter.class);
    static final String NAME = "rowcounter";
    private static final String JOB_NAME_CONF_KEY = "mapreduce.job.name";
    private static final String EXPECTED_COUNT_KEY = RowCounter.class.getName() + ".expected_count";
    private static final String OPT_START_TIME = "starttime";
    private static final String OPT_END_TIME = "endtime";
    private static final String OPT_RANGE = "range";
    private static final String OPT_EXPECTED_COUNT = "expectedCount";
    private String tableName;
    private List<MultiRowRangeFilter.RowRange> rowRangeList;
    private long startTime;
    private long endTime;
    private long expectedCount;
    private List<String> columns = new ArrayList<String>();

    public Job createSubmittableJob(Configuration conf) throws IOException {
        Job job = Job.getInstance((Configuration)conf, (String)conf.get(JOB_NAME_CONF_KEY, "rowcounter_" + this.tableName));
        job.setJarByClass(RowCounter.class);
        Scan scan = new Scan();
        scan.setCacheBlocks(false);
        RowCounter.setScanFilter(scan, this.rowRangeList);
        for (String columnName : this.columns) {
            String family = StringUtils.substringBefore((String)columnName, (String)":");
            String qualifier = StringUtils.substringAfter((String)columnName, (String)":");
            if (StringUtils.isBlank((CharSequence)qualifier)) {
                scan.addFamily(Bytes.toBytes((String)family));
                continue;
            }
            scan.addColumn(Bytes.toBytes((String)family), Bytes.toBytes((String)qualifier));
        }
        if (this.expectedCount >= 0L) {
            conf.setLong(EXPECTED_COUNT_KEY, this.expectedCount);
        }
        scan.setTimeRange(this.startTime, this.endTime);
        job.setOutputFormatClass(NullOutputFormat.class);
        TableMapReduceUtil.initTableMapperJob(this.tableName, scan, RowCounterMapper.class, ImmutableBytesWritable.class, Result.class, job);
        job.setNumReduceTasks(0);
        return job;
    }

    @Deprecated
    public static Job createSubmittableJob(Configuration conf, String[] args) throws IOException {
        String tableName = args[0];
        List<MultiRowRangeFilter.RowRange> rowRangeList = null;
        long startTime = 0L;
        long endTime = 0L;
        StringBuilder sb = new StringBuilder();
        String rangeSwitch = "--range=";
        String startTimeArgKey = "--starttime=";
        String endTimeArgKey = "--endtime=";
        String expectedCountArg = "--expected-count=";
        for (int i = 1; i < args.length; ++i) {
            if (args[i].startsWith("--range=")) {
                try {
                    rowRangeList = RowCounter.parseRowRangeParameter(args[i].substring(args[1].indexOf("--range=") + "--range=".length()));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }
            if (args[i].startsWith("--starttime=")) {
                startTime = Long.parseLong(args[i].substring("--starttime=".length()));
                continue;
            }
            if (args[i].startsWith("--endtime=")) {
                endTime = Long.parseLong(args[i].substring("--endtime=".length()));
                continue;
            }
            if (args[i].startsWith("--expected-count=")) {
                conf.setLong(EXPECTED_COUNT_KEY, Long.parseLong(args[i].substring("--expected-count=".length())));
                continue;
            }
            sb.append(args[i]);
            sb.append(" ");
        }
        if (endTime < startTime) {
            RowCounter.printUsage("--endtime=" + endTime + " needs to be greater than --starttime=" + startTime);
            return null;
        }
        Job job = Job.getInstance((Configuration)conf, (String)conf.get(JOB_NAME_CONF_KEY, "rowcounter_" + tableName));
        job.setJarByClass(RowCounter.class);
        Scan scan = new Scan();
        scan.setCacheBlocks(false);
        RowCounter.setScanFilter(scan, rowRangeList);
        if (sb.length() > 0) {
            for (String columnName : sb.toString().trim().split(" ")) {
                String family = StringUtils.substringBefore((String)columnName, (String)":");
                String qualifier = StringUtils.substringAfter((String)columnName, (String)":");
                if (StringUtils.isBlank((CharSequence)qualifier)) {
                    scan.addFamily(Bytes.toBytes((String)family));
                    continue;
                }
                scan.addColumn(Bytes.toBytes((String)family), Bytes.toBytes((String)qualifier));
            }
        }
        scan.setTimeRange(startTime, endTime == 0L ? Long.MAX_VALUE : endTime);
        job.setOutputFormatClass(NullOutputFormat.class);
        TableMapReduceUtil.initTableMapperJob(tableName, scan, RowCounterMapper.class, ImmutableBytesWritable.class, Result.class, job);
        job.setNumReduceTasks(0);
        return job;
    }

    private static void printUsage(String errorMessage) {
        System.err.println("ERROR: " + errorMessage);
        System.err.println("Usage: hbase rowcounter [options] <tablename> [--starttime=<start> --endtime=<end>] [--range=[startKey],[endKey][;[startKey],[endKey]...]] [<column1> <column2>...]");
        System.err.println("For performance consider the following options:\n-Dhbase.client.scanner.caching=100\n-Dmapreduce.map.speculative=false");
    }

    private static List<MultiRowRangeFilter.RowRange> parseRowRangeParameter(String arg) {
        List rangesSplit = Splitter.on((String)";").splitToList((CharSequence)arg);
        ArrayList<MultiRowRangeFilter.RowRange> rangeList = new ArrayList<MultiRowRangeFilter.RowRange>();
        for (String range : rangesSplit) {
            if (range == null || range.isEmpty()) continue;
            List startEnd = Splitter.on((String)",").splitToList((CharSequence)range);
            if (startEnd.size() != 2 || ((String)startEnd.get(1)).contains(",")) {
                throw new IllegalArgumentException("Wrong range specification: " + range);
            }
            String startKey = (String)startEnd.get(0);
            String endKey = (String)startEnd.get(1);
            rangeList.add(new MultiRowRangeFilter.RowRange(Bytes.toBytesBinary((String)startKey), true, Bytes.toBytesBinary((String)endKey), false));
        }
        return rangeList;
    }

    private static void setScanFilter(Scan scan, List<MultiRowRangeFilter.RowRange> rowRangeList) {
        int size;
        int n = size = rowRangeList == null ? 0 : rowRangeList.size();
        if (size <= 1) {
            scan.setFilter((Filter)new FirstKeyOnlyFilter());
        }
        if (size == 1) {
            MultiRowRangeFilter.RowRange range = rowRangeList.get(0);
            scan.withStartRow(range.getStartRow());
            scan.withStopRow(range.getStopRow());
        } else if (size > 1) {
            scan.setFilter((Filter)new MultiRowRangeFilter(rowRangeList));
        }
    }

    protected void printUsage() {
        StringBuilder footerBuilder = new StringBuilder();
        footerBuilder.append("For performance, consider the following configuration properties:\n");
        footerBuilder.append("-Dhbase.client.scanner.caching=100\n");
        footerBuilder.append("-Dmapreduce.map.speculative=false\n");
        this.printUsage("hbase rowcounter <tablename> [options] [<column1> <column2>...]", "Options:", footerBuilder.toString());
    }

    protected void printUsage(String usageStr, String usageHeader, String usageFooter) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.setWidth(120);
        helpFormatter.setOptionComparator((Comparator)new AbstractHBaseTool.OptionsOrderComparator((AbstractHBaseTool)this));
        helpFormatter.setLongOptSeparator("=");
        helpFormatter.printHelp(usageStr, usageHeader, this.options, usageFooter);
    }

    protected void addOptions() {
        Option startTimeOption = Option.builder(null).valueSeparator('=').hasArg(true).desc("starting time filter to start counting rows from.").longOpt(OPT_START_TIME).build();
        Option endTimeOption = Option.builder(null).valueSeparator('=').hasArg(true).desc("end time filter limit, to only count rows up to this timestamp.").longOpt(OPT_END_TIME).build();
        Option rangeOption = Option.builder(null).valueSeparator('=').hasArg(true).desc("[startKey],[endKey][;[startKey],[endKey]...]]").longOpt(OPT_RANGE).build();
        Option expectedOption = Option.builder(null).valueSeparator('=').hasArg(true).desc("expected number of rows to be count.").longOpt(OPT_EXPECTED_COUNT).build();
        this.addOption(startTimeOption);
        this.addOption(endTimeOption);
        this.addOption(rangeOption);
        this.addOption(expectedOption);
    }

    protected void processOptions(CommandLine cmd) throws IllegalArgumentException {
        this.tableName = (String)cmd.getArgList().get(0);
        if (cmd.getOptionValue(OPT_RANGE) != null) {
            this.rowRangeList = RowCounter.parseRowRangeParameter(cmd.getOptionValue(OPT_RANGE));
        }
        this.endTime = cmd.getOptionValue(OPT_END_TIME) == null ? Long.MAX_VALUE : Long.parseLong(cmd.getOptionValue(OPT_END_TIME));
        this.expectedCount = cmd.getOptionValue(OPT_EXPECTED_COUNT) == null ? Long.MIN_VALUE : Long.parseLong(cmd.getOptionValue(OPT_EXPECTED_COUNT));
        this.startTime = cmd.getOptionValue(OPT_START_TIME) == null ? 0L : Long.parseLong(cmd.getOptionValue(OPT_START_TIME));
        for (int i = 1; i < cmd.getArgList().size(); ++i) {
            String argument = (String)cmd.getArgList().get(i);
            if (argument.startsWith("-")) continue;
            this.columns.add(argument);
        }
        if (this.endTime < this.startTime) {
            throw new IllegalArgumentException("--endtime=" + this.endTime + " needs to be greater than --starttime=" + this.startTime);
        }
    }

    protected void processOldArgs(List<String> args) {
        ArrayList<String> copiedArgs = new ArrayList<String>(args);
        args.removeAll(copiedArgs);
        for (String arg : copiedArgs) {
            if (arg.startsWith("-") && arg.contains("=")) {
                String[] kv = arg.split("=");
                args.add(kv[0]);
                args.add(kv[1]);
                continue;
            }
            args.add(arg);
        }
    }

    protected int doWork() throws Exception {
        Job job = this.createSubmittableJob(this.getConf());
        if (job == null) {
            return -1;
        }
        boolean success = job.waitForCompletion(true);
        long expectedCount = this.getConf().getLong(EXPECTED_COUNT_KEY, -1L);
        if (success && expectedCount != -1L) {
            Counter counter = job.getCounters().findCounter((Enum)RowCounterMapper.Counters.ROWS);
            boolean bl = success = expectedCount == counter.getValue();
            if (!success) {
                LOG.error("Failing job because count of '" + counter.getValue() + "' does not match expected count of '" + expectedCount + "'");
            }
        }
        return success ? 0 : 1;
    }

    public static void main(String[] args) throws Exception {
        new RowCounter().doStaticMain(args);
    }

    protected CommandLineParser newParser() {
        return new RowCounterCommandLineParser();
    }

    static class RowCounterCommandLineParser
    extends BasicParser {
        RowCounterCommandLineParser() {
        }

        protected void checkRequiredOptions() throws MissingOptionException {
            if (this.cmd.getArgList().size() < 1 || ((String)this.cmd.getArgList().get(0)).startsWith("-")) {
                throw new MissingOptionException("First argument must be a valid table name.");
            }
        }
    }

    static class RowCounterMapper
    extends TableMapper<ImmutableBytesWritable, Result> {
        RowCounterMapper() {
        }

        public void map(ImmutableBytesWritable row, Result values, Mapper.Context context) throws IOException {
            context.getCounter((Enum)Counters.ROWS).increment(1L);
        }

        public static enum Counters {
            ROWS;

        }
    }
}

