/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapred;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapred.HRegionPartitioner;
import org.apache.hadoop.hbase.mapred.MultiTableSnapshotInputFormat;
import org.apache.hadoop.hbase.mapred.TableInputFormat;
import org.apache.hadoop.hbase.mapred.TableMap;
import org.apache.hadoop.hbase.mapred.TableOutputFormat;
import org.apache.hadoop.hbase.mapred.TableReduce;
import org.apache.hadoop.hbase.mapred.TableSnapshotInputFormat;
import org.apache.hadoop.hbase.mapreduce.MutationSerialization;
import org.apache.hadoop.hbase.mapreduce.ResultSerialization;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.security.token.TokenUtil;
import org.apache.hadoop.hbase.util.RegionSplitter;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class TableMapReduceUtil {
    private static final Logger LOG = LoggerFactory.getLogger(TableMapReduceUtil.class);

    public static void initTableMapJob(String table, String columns, Class<? extends TableMap> mapper, Class<?> outputKeyClass, Class<?> outputValueClass, JobConf job) {
        TableMapReduceUtil.initTableMapJob(table, columns, mapper, outputKeyClass, outputValueClass, job, true, TableInputFormat.class);
    }

    public static void initTableMapJob(String table, String columns, Class<? extends TableMap> mapper, Class<?> outputKeyClass, Class<?> outputValueClass, JobConf job, boolean addDependencyJars) {
        TableMapReduceUtil.initTableMapJob(table, columns, mapper, outputKeyClass, outputValueClass, job, addDependencyJars, TableInputFormat.class);
    }

    public static void initTableMapJob(String table, String columns, Class<? extends TableMap> mapper, Class<?> outputKeyClass, Class<?> outputValueClass, JobConf job, boolean addDependencyJars, Class<? extends InputFormat> inputFormat) {
        job.setInputFormat(inputFormat);
        job.setMapOutputValueClass(outputValueClass);
        job.setMapOutputKeyClass(outputKeyClass);
        job.setMapperClass(mapper);
        job.setStrings("io.serializations", new String[]{job.get("io.serializations"), MutationSerialization.class.getName(), ResultSerialization.class.getName()});
        FileInputFormat.addInputPaths((JobConf)job, (String)table);
        job.set("hbase.mapred.tablecolumns", columns);
        if (addDependencyJars) {
            try {
                TableMapReduceUtil.addDependencyJars(job);
            }
            catch (IOException e) {
                LOG.error("IOException encountered while adding dependency jars", (Throwable)e);
            }
        }
        try {
            TableMapReduceUtil.initCredentials(job);
        }
        catch (IOException ioe) {
            LOG.error("IOException encountered while initializing credentials", (Throwable)ioe);
        }
    }

    public static void initMultiTableSnapshotMapperJob(Map<String, Collection<Scan>> snapshotScans, Class<? extends TableMap> mapper, Class<?> outputKeyClass, Class<?> outputValueClass, JobConf job, boolean addDependencyJars, Path tmpRestoreDir) throws IOException {
        MultiTableSnapshotInputFormat.setInput((Configuration)job, snapshotScans, tmpRestoreDir);
        job.setInputFormat(MultiTableSnapshotInputFormat.class);
        if (outputValueClass != null) {
            job.setMapOutputValueClass(outputValueClass);
        }
        if (outputKeyClass != null) {
            job.setMapOutputKeyClass(outputKeyClass);
        }
        job.setMapperClass(mapper);
        if (addDependencyJars) {
            TableMapReduceUtil.addDependencyJars(job);
        }
        org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil.resetCacheConfig((Configuration)job);
    }

    public static void initTableSnapshotMapJob(String snapshotName, String columns, Class<? extends TableMap> mapper, Class<?> outputKeyClass, Class<?> outputValueClass, JobConf job, boolean addDependencyJars, Path tmpRestoreDir) throws IOException {
        TableSnapshotInputFormat.setInput(job, snapshotName, tmpRestoreDir);
        TableMapReduceUtil.initTableMapJob(snapshotName, columns, mapper, outputKeyClass, outputValueClass, job, addDependencyJars, TableSnapshotInputFormat.class);
        org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil.resetCacheConfig((Configuration)job);
    }

    public static void initTableSnapshotMapJob(String snapshotName, String columns, Class<? extends TableMap> mapper, Class<?> outputKeyClass, Class<?> outputValueClass, JobConf jobConf, boolean addDependencyJars, Path tmpRestoreDir, RegionSplitter.SplitAlgorithm splitAlgo, int numSplitsPerRegion) throws IOException {
        TableSnapshotInputFormat.setInput(jobConf, snapshotName, tmpRestoreDir, splitAlgo, numSplitsPerRegion);
        TableMapReduceUtil.initTableMapJob(snapshotName, columns, mapper, outputKeyClass, outputValueClass, jobConf, addDependencyJars, TableSnapshotInputFormat.class);
        org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil.resetCacheConfig((Configuration)jobConf);
    }

    public static void initTableReduceJob(String table, Class<? extends TableReduce> reducer, JobConf job) throws IOException {
        TableMapReduceUtil.initTableReduceJob(table, reducer, job, null);
    }

    public static void initTableReduceJob(String table, Class<? extends TableReduce> reducer, JobConf job, Class partitioner) throws IOException {
        TableMapReduceUtil.initTableReduceJob(table, reducer, job, partitioner, true);
    }

    public static void initTableReduceJob(String table, Class<? extends TableReduce> reducer, JobConf job, Class partitioner, boolean addDependencyJars) throws IOException {
        job.setOutputFormat(TableOutputFormat.class);
        job.setReducerClass(reducer);
        job.set("hbase.mapred.outputtable", table);
        job.setOutputKeyClass(ImmutableBytesWritable.class);
        job.setOutputValueClass(Put.class);
        job.setStrings("io.serializations", new String[]{job.get("io.serializations"), MutationSerialization.class.getName(), ResultSerialization.class.getName()});
        if (partitioner == HRegionPartitioner.class) {
            job.setPartitionerClass(HRegionPartitioner.class);
            int regions = TableMapReduceUtil.getRegionCount(HBaseConfiguration.create((Configuration)job), TableName.valueOf((String)table));
            if (job.getNumReduceTasks() > regions) {
                job.setNumReduceTasks(regions);
            }
        } else if (partitioner != null) {
            job.setPartitionerClass(partitioner);
        }
        if (addDependencyJars) {
            TableMapReduceUtil.addDependencyJars(job);
        }
        TableMapReduceUtil.initCredentials(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initCredentials(JobConf job) throws IOException {
        UserProvider userProvider = UserProvider.instantiate((Configuration)job);
        if (userProvider.isHadoopSecurityEnabled() && System.getenv("HADOOP_TOKEN_FILE_LOCATION") != null) {
            job.set("mapreduce.job.credentials.binary", System.getenv("HADOOP_TOKEN_FILE_LOCATION"));
        }
        if (userProvider.isHBaseSecurityEnabled()) {
            try (Connection conn = ConnectionFactory.createConnection((Configuration)job);){
                User user = userProvider.getCurrent();
                TokenUtil.addTokenForJob((Connection)conn, (JobConf)job, (User)user);
            }
        }
    }

    public static void limitNumReduceTasks(String table, JobConf job) throws IOException {
        int regions = TableMapReduceUtil.getRegionCount(HBaseConfiguration.create((Configuration)job), TableName.valueOf((String)table));
        if (job.getNumReduceTasks() > regions) {
            job.setNumReduceTasks(regions);
        }
    }

    public static void limitNumMapTasks(String table, JobConf job) throws IOException {
        int regions = TableMapReduceUtil.getRegionCount(HBaseConfiguration.create((Configuration)job), TableName.valueOf((String)table));
        if (job.getNumMapTasks() > regions) {
            job.setNumMapTasks(regions);
        }
    }

    public static void setNumReduceTasks(String table, JobConf job) throws IOException {
        job.setNumReduceTasks(TableMapReduceUtil.getRegionCount(HBaseConfiguration.create((Configuration)job), TableName.valueOf((String)table)));
    }

    public static void setNumMapTasks(String table, JobConf job) throws IOException {
        job.setNumMapTasks(TableMapReduceUtil.getRegionCount(HBaseConfiguration.create((Configuration)job), TableName.valueOf((String)table)));
    }

    public static void setScannerCaching(JobConf job, int batchSize) {
        job.setInt("hbase.client.scanner.caching", batchSize);
    }

    public static void addDependencyJars(JobConf job) throws IOException {
        org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil.addHBaseDependencyJars((Configuration)job);
        org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil.addDependencyJarsForClasses((Configuration)job, job.getMapOutputKeyClass(), job.getMapOutputValueClass(), job.getOutputKeyClass(), job.getOutputValueClass(), job.getPartitionerClass(), job.getClass("mapred.input.format.class", TextInputFormat.class, InputFormat.class), job.getClass("mapred.output.format.class", TextOutputFormat.class, OutputFormat.class), job.getCombinerClass());
    }

    /*
     * Exception decompiling
     */
    private static int getRegionCount(Configuration conf, TableName tableName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

