/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.protocol.OpenFileEntry;
import org.apache.hadoop.hdfs.protocol.OpenFilesIterator;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestListOpenFiles {
    private static final int NUM_DATA_NODES = 3;
    private static final int BATCH_SIZE = 5;
    private static MiniDFSCluster cluster = null;
    private static DistributedFileSystem fs = null;
    private static NamenodeProtocols nnRpc = null;
    private static final Logger LOG = LoggerFactory.getLogger(TestListOpenFiles.class);

    @Before
    public void setUp() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.heartbeat.interval", 1L);
        conf.setLong("dfs.namenode.list.openfiles.num.responses", 5L);
        cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        cluster.waitActive();
        fs = cluster.getFileSystem();
        nnRpc = cluster.getNameNodeRpc();
    }

    @After
    public void tearDown() throws IOException {
        if (fs != null) {
            fs.close();
        }
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Test(timeout=120000L)
    public void testListOpenFilesViaNameNodeRPC() throws Exception {
        HashMap<Path, FSDataOutputStream> openFiles = new HashMap<Path, FSDataOutputStream>();
        this.createFiles((FileSystem)fs, "closed", 10);
        this.verifyOpenFiles(openFiles);
        BatchedRemoteIterator.BatchedEntries openFileEntryBatchedEntries = nnRpc.listOpenFiles(0L, EnumSet.of(OpenFilesIterator.OpenFilesType.ALL_OPEN_FILES), "/");
        Assert.assertTrue((String)"Open files list should be empty!", (openFileEntryBatchedEntries.size() == 0 ? 1 : 0) != 0);
        BatchedRemoteIterator.BatchedEntries openFilesBlockingDecomEntries = nnRpc.listOpenFiles(0L, EnumSet.of(OpenFilesIterator.OpenFilesType.BLOCKING_DECOMMISSION), "/");
        Assert.assertTrue((String)"Open files list blocking decommission should be empty!", (openFilesBlockingDecomEntries.size() == 0 ? 1 : 0) != 0);
        openFiles.putAll(DFSTestUtil.createOpenFiles((FileSystem)fs, "open-1", 1));
        this.verifyOpenFiles(openFiles);
        openFiles.putAll(DFSTestUtil.createOpenFiles((FileSystem)fs, "open-2", 12));
        this.verifyOpenFiles(openFiles);
        DFSTestUtil.closeOpenFiles(openFiles, openFiles.size() / 2);
        this.verifyOpenFiles(openFiles);
        openFiles.putAll(DFSTestUtil.createOpenFiles((FileSystem)fs, "open-3", 25));
        this.verifyOpenFiles(openFiles);
        while (openFiles.size() > 0) {
            DFSTestUtil.closeOpenFiles(openFiles, 1);
            this.verifyOpenFiles(openFiles);
        }
    }

    private void verifyOpenFiles(Map<Path, FSDataOutputStream> openFiles, EnumSet<OpenFilesIterator.OpenFilesType> openFilesTypes, String path) throws IOException {
        BatchedRemoteIterator.BatchedEntries batchedEntries;
        HashSet<Path> remainingFiles = new HashSet<Path>(openFiles.keySet());
        OpenFileEntry lastEntry = null;
        do {
            batchedEntries = lastEntry == null ? nnRpc.listOpenFiles(0L, openFilesTypes, path) : nnRpc.listOpenFiles(lastEntry.getId(), openFilesTypes, path);
            Assert.assertTrue((String)"Incorrect open files list size!", (batchedEntries.size() <= 5 ? 1 : 0) != 0);
            for (int i = 0; i < batchedEntries.size(); ++i) {
                lastEntry = (OpenFileEntry)batchedEntries.get(i);
                String filePath = lastEntry.getFilePath();
                LOG.info("OpenFile: " + filePath);
                Assert.assertTrue((String)("Unexpected open file: " + filePath), (boolean)remainingFiles.remove(new Path(filePath)));
            }
        } while (batchedEntries.hasMore());
        Assert.assertTrue((String)(remainingFiles.size() + " open files not listed!"), (remainingFiles.size() == 0 ? 1 : 0) != 0);
    }

    private void verifyOpenFiles(Map<Path, FSDataOutputStream> openFiles) throws IOException {
        this.verifyOpenFiles(openFiles, EnumSet.of(OpenFilesIterator.OpenFilesType.ALL_OPEN_FILES), "/");
        this.verifyOpenFiles(new HashMap<Path, FSDataOutputStream>(), EnumSet.of(OpenFilesIterator.OpenFilesType.BLOCKING_DECOMMISSION), "/");
    }

    private Set<Path> createFiles(FileSystem fileSystem, String fileNamePrefix, int numFilesToCreate) throws IOException {
        HashSet<Path> files = new HashSet<Path>();
        for (int i = 0; i < numFilesToCreate; ++i) {
            Path filePath = new Path(fileNamePrefix + "-" + i);
            DFSTestUtil.createFile(fileSystem, filePath, 1024L, (short)3, 1L);
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testListOpenFilesInHA() throws Exception {
        fs.close();
        cluster.shutdown();
        HdfsConfiguration haConf = new HdfsConfiguration();
        haConf.setLong("dfs.namenode.list.openfiles.num.responses", 5L);
        MiniDFSCluster haCluster = new MiniDFSCluster.Builder((Configuration)haConf).nnTopology(MiniDFSNNTopology.simpleHATopology()).numDataNodes(0).build();
        try {
            HATestUtil.setFailoverConfigurations(haCluster, (Configuration)haConf);
            DistributedFileSystem fileSystem = HATestUtil.configureFailoverFs(haCluster, (Configuration)haConf);
            List namenodes = HAUtil.getProxiesForAllNameNodesInNameservice((Configuration)haConf, (String)HATestUtil.getLogicalHostname(haCluster));
            haCluster.transitionToActive(0);
            Assert.assertTrue((boolean)HAUtil.isAtLeastOneActive((List)namenodes));
            byte[] data = new byte[1024];
            ThreadLocalRandom.current().nextBytes(data);
            DFSTestUtil.createOpenFiles((FileSystem)fileSystem, "ha-open-file", 22);
            final DFSAdmin dfsAdmin = new DFSAdmin((Configuration)haConf);
            final AtomicBoolean failoverCompleted = new AtomicBoolean(false);
            final AtomicBoolean listOpenFilesError = new AtomicBoolean(false);
            int listingIntervalMsec = 250;
            Thread clientThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (!failoverCompleted.get()) {
                        try {
                            Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-listOpenFiles"}));
                            Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-listOpenFiles", "-blockingDecommission"}));
                            Thread.sleep(250L);
                        }
                        catch (Exception e) {
                            listOpenFilesError.set(true);
                            LOG.info("Error listing open files: ", (Throwable)e);
                            break;
                        }
                    }
                }
            });
            clientThread.start();
            Thread.sleep(500L);
            LOG.info("Shutting down Active NN0!");
            haCluster.shutdownNameNode(0);
            LOG.info("Transitioning NN1 to Active!");
            haCluster.transitionToActive(1);
            failoverCompleted.set(true);
            Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-listOpenFiles"}));
            Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)dfsAdmin, (String[])new String[]{"-listOpenFiles", "-blockingDecommission"}));
            Assert.assertFalse((String)"Client Error!", (boolean)listOpenFilesError.get());
            clientThread.join();
        }
        finally {
            if (haCluster != null) {
                haCluster.shutdown();
            }
        }
    }
}

