/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.hdfs.server.datanode.BPServiceActor;
import org.apache.hadoop.util.Time;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestBpServiceActorScheduler {
    protected static final Logger LOG = LoggerFactory.getLogger(TestBpServiceActorScheduler.class);
    @Rule
    public Timeout timeout = new Timeout(300000);
    private static final long HEARTBEAT_INTERVAL_MS = 5000L;
    private static final long LIFELINE_INTERVAL_MS = 15000L;
    private static final long BLOCK_REPORT_INTERVAL_MS = 10000L;
    private static final long OUTLIER_REPORT_INTERVAL_MS = 10000L;
    private final Random random = new Random(System.nanoTime());

    @Test
    public void testInit() {
        for (long now : this.getTimestamps()) {
            BPServiceActor.Scheduler scheduler = this.makeMockScheduler(now);
            Assert.assertTrue((boolean)scheduler.isHeartbeatDue(now));
            Assert.assertTrue((boolean)scheduler.isBlockReportDue(scheduler.monotonicNow()));
        }
    }

    @Test
    public void testScheduleBlockReportImmediate() {
        for (long now : this.getTimestamps()) {
            BPServiceActor.Scheduler scheduler = this.makeMockScheduler(now);
            scheduler.scheduleBlockReport(0L);
            Assert.assertTrue((boolean)scheduler.resetBlockReportTime);
            Assert.assertThat((Object)scheduler.nextBlockReportTime, (Matcher)Is.is((Object)now));
        }
    }

    @Test
    public void testScheduleBlockReportDelayed() {
        for (long now : this.getTimestamps()) {
            BPServiceActor.Scheduler scheduler = this.makeMockScheduler(now);
            long delayMs = 10L;
            scheduler.scheduleBlockReport(10L);
            Assert.assertTrue((boolean)scheduler.resetBlockReportTime);
            Assert.assertTrue((scheduler.nextBlockReportTime - now >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((scheduler.nextBlockReportTime - (now + 10L) < 0L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testScheduleNextBlockReport() {
        for (long now : this.getTimestamps()) {
            BPServiceActor.Scheduler scheduler = this.makeMockScheduler(now);
            Assert.assertTrue((boolean)scheduler.resetBlockReportTime);
            scheduler.scheduleNextBlockReport();
            Assert.assertTrue((scheduler.nextBlockReportTime - (now + 10000L) < 0L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testScheduleNextBlockReport2() {
        for (long now : this.getTimestamps()) {
            BPServiceActor.Scheduler scheduler = this.makeMockScheduler(now);
            scheduler.resetBlockReportTime = false;
            scheduler.scheduleNextBlockReport();
            Assert.assertThat((Object)scheduler.nextBlockReportTime, (Matcher)Is.is((Object)(now + 10000L)));
        }
    }

    @Test
    public void testScheduleNextBlockReport3() {
        for (long now : this.getTimestamps()) {
            long origBlockReportTime;
            BPServiceActor.Scheduler scheduler = this.makeMockScheduler(now);
            scheduler.resetBlockReportTime = false;
            long blockReportDelay = 10000L + (long)this.random.nextInt(20000);
            scheduler.nextBlockReportTime = origBlockReportTime = now - blockReportDelay;
            scheduler.scheduleNextBlockReport();
            Assert.assertTrue((scheduler.nextBlockReportTime - now < 10000L ? 1 : 0) != 0);
            Assert.assertTrue(((scheduler.nextBlockReportTime - origBlockReportTime) % 10000L == 0L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testScheduleHeartbeat() {
        for (long now : this.getTimestamps()) {
            BPServiceActor.Scheduler scheduler = this.makeMockScheduler(now);
            scheduler.scheduleNextHeartbeat();
            Assert.assertFalse((boolean)scheduler.isHeartbeatDue(now));
            scheduler.scheduleHeartbeat();
            Assert.assertTrue((boolean)scheduler.isHeartbeatDue(now));
        }
    }

    @Test
    public void testScheduleDelayedHeartbeat() {
        for (long now : this.getTimestamps()) {
            BPServiceActor.Scheduler scheduler = this.makeMockScheduler(now);
            scheduler.scheduleNextHeartbeat();
            Assert.assertFalse((boolean)scheduler.isHeartbeatDue(now));
            scheduler.nextHeartbeatTime = now - 50000L;
            scheduler.scheduleNextHeartbeat();
            Assert.assertFalse((boolean)scheduler.isHeartbeatDue(now));
        }
    }

    @Test
    public void testScheduleLifeline() {
        for (long now : this.getTimestamps()) {
            BPServiceActor.Scheduler scheduler = this.makeMockScheduler(now);
            scheduler.scheduleNextLifeline(now);
            Assert.assertFalse((boolean)scheduler.isLifelineDue(now));
            Assert.assertThat((Object)scheduler.getLifelineWaitTime(), (Matcher)Is.is((Object)15000L));
            scheduler.scheduleNextLifeline(now - 15000L);
            Assert.assertTrue((boolean)scheduler.isLifelineDue(now));
            Assert.assertThat((Object)scheduler.getLifelineWaitTime(), (Matcher)Is.is((Object)0L));
        }
    }

    @Test
    public void testScheduleLifelineScheduleTime() {
        BPServiceActor.Scheduler mockScheduler = (BPServiceActor.Scheduler)Mockito.spy((Object)new BPServiceActor.Scheduler(5000L, 15000L, 10000L, 10000L));
        long now = Time.monotonicNow();
        mockScheduler.scheduleNextLifeline(now);
        long mockMonotonicNow = now + 30000L;
        ((BPServiceActor.Scheduler)Mockito.doReturn((Object)mockMonotonicNow).when((Object)mockScheduler)).monotonicNow();
        Assert.assertTrue((mockScheduler.getLifelineWaitTime() >= 0L ? 1 : 0) != 0);
    }

    @Test
    public void testOutlierReportScheduling() {
        for (long now : this.getTimestamps()) {
            BPServiceActor.Scheduler scheduler = this.makeMockScheduler(now);
            Assert.assertTrue((boolean)scheduler.isOutliersReportDue(now));
            scheduler.scheduleNextOutlierReport();
            Assert.assertFalse((boolean)scheduler.isOutliersReportDue(now));
            Assert.assertFalse((boolean)scheduler.isOutliersReportDue(now + 1L));
            Assert.assertTrue((boolean)scheduler.isOutliersReportDue(now + 10000L));
        }
    }

    private BPServiceActor.Scheduler makeMockScheduler(long now) {
        LOG.info("Using now = " + now);
        BPServiceActor.Scheduler mockScheduler = (BPServiceActor.Scheduler)Mockito.spy((Object)new BPServiceActor.Scheduler(5000L, 15000L, 10000L, 10000L));
        ((BPServiceActor.Scheduler)Mockito.doReturn((Object)now).when((Object)mockScheduler)).monotonicNow();
        mockScheduler.nextBlockReportTime = now;
        mockScheduler.nextHeartbeatTime = now;
        mockScheduler.nextOutliersReportTime = now;
        return mockScheduler;
    }

    List<Long> getTimestamps() {
        return Arrays.asList(0L, Long.MIN_VALUE, Long.MAX_VALUE, 0x7FFFFFFFFFFFFFFEL, Math.abs(this.random.nextLong()), -Math.abs(this.random.nextLong()));
    }
}

