/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.AddBlockFlag;
import org.apache.hadoop.hdfs.DFSConfigKeys;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.LogVerificationAppender;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.TestBlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BaseReplicationPolicyTest;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockCollection;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyDefault;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyWithUpgradeDomain;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.FSClusterStats;
import org.apache.hadoop.hdfs.server.blockmanagement.LowRedundancyBlocks;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.Namesystem;
import org.apache.hadoop.hdfs.server.namenode.TestINodeFile;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Matchers;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class TestReplicationPolicy
extends BaseReplicationPolicyTest {
    private static final String filename = "/dummyfile.txt";
    private static final long staleInterval = 30000L;
    private static AtomicLong mockINodeId = new AtomicLong(0L);
    @Rule
    public ExpectedException exception = ExpectedException.none();

    public TestReplicationPolicy(String blockPlacementPolicyClassName) {
        this.blockPlacementPolicy = blockPlacementPolicyClassName;
    }

    @Parameterized.Parameters
    public static Iterable<Object[]> data() {
        return Arrays.asList({BlockPlacementPolicyDefault.class.getName()}, {BlockPlacementPolicyWithUpgradeDomain.class.getName()});
    }

    private void updateHeartbeatForExtraStorage(long capacity, long dfsUsed, long remaining, long blockPoolUsed) {
        DatanodeDescriptor dn = this.dataNodes[5];
        dn.getStorageInfos()[1].setUtilizationForTesting(capacity, dfsUsed, remaining, blockPoolUsed);
        dn.updateHeartbeat(BlockManagerTestUtil.getStorageReportsForDatanode(dn), 0L, 0L, 0, 0, null);
    }

    private void resetHeartbeatForStorages() {
        for (int i = 0; i < this.dataNodes.length; ++i) {
            TestReplicationPolicy.updateHeartbeatWithUsage(this.dataNodes[i], 2048L, 0L, 2048L, 0L, 0L, 0L, 0, 0);
        }
        this.updateHeartbeatForExtraStorage(0L, 0L, 0L, 0L);
    }

    @Override
    DatanodeDescriptor[] getDatanodeDescriptors(Configuration conf) {
        String[] racks = new String[]{"/d1/r1", "/d1/r1", "/d1/r2", "/d1/r2", "/d2/r3", "/d2/r3"};
        this.storages = DFSTestUtil.createDatanodeStorageInfos(racks);
        DatanodeStorage extraStorage = new DatanodeStorage(this.storages[5].getStorageID() + "-extra", DatanodeStorage.State.NORMAL, StorageType.DEFAULT);
        BlockManagerTestUtil.updateStorage(this.storages[5].getDatanodeDescriptor(), extraStorage);
        return DFSTestUtil.toDatanodeDescriptor(this.storages);
    }

    @Test
    public void testChooseNodeWithMultipleStorages1() throws Exception {
        TestReplicationPolicy.updateHeartbeatWithUsage(this.dataNodes[5], 2048L, 0L, 682L, 0L, 0L, 0L, 0, 0);
        this.updateHeartbeatForExtraStorage(2048L, 0L, 682L, 0L);
        DatanodeStorageInfo[] targets = this.chooseTarget(1, this.dataNodes[5], new ArrayList<DatanodeStorageInfo>(), null);
        Assert.assertEquals((long)1L, (long)targets.length);
        Assert.assertEquals((Object)this.storages[4], (Object)targets[0]);
        this.resetHeartbeatForStorages();
    }

    @Test
    public void testChooseNodeWithMultipleStorages2() throws Exception {
        TestReplicationPolicy.updateHeartbeatWithUsage(this.dataNodes[5], 2048L, 0L, 682L, 0L, 0L, 0L, 0, 0);
        this.updateHeartbeatForExtraStorage(2048L, 0L, 1024L, 0L);
        DatanodeStorageInfo[] targets = this.chooseTarget(1, this.dataNodes[5], new ArrayList<DatanodeStorageInfo>(), null);
        Assert.assertEquals((long)1L, (long)targets.length);
        Assert.assertEquals((Object)this.dataNodes[5], (Object)targets[0].getDatanodeDescriptor());
        this.resetHeartbeatForStorages();
    }

    @Test
    public void testChooseTarget1() throws Exception {
        TestReplicationPolicy.updateHeartbeatWithUsage(this.dataNodes[0], 2048L, 0L, 1024L, 0L, 0L, 0L, 4, 0);
        DatanodeStorageInfo[] targets = this.chooseTarget(0);
        Assert.assertEquals((long)targets.length, (long)0L);
        targets = this.chooseTarget(1);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertEquals((Object)this.storages[0], (Object)targets[0]);
        targets = this.chooseTarget(2);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertEquals((Object)this.storages[0], (Object)targets[0]);
        Assert.assertFalse((boolean)this.isOnSameRack(targets[0], targets[1]));
        targets = this.chooseTarget(3);
        Assert.assertEquals((long)targets.length, (long)3L);
        Assert.assertEquals((Object)this.storages[0], (Object)targets[0]);
        Assert.assertFalse((boolean)this.isOnSameRack(targets[0], targets[1]));
        Assert.assertTrue((boolean)this.isOnSameRack(targets[1], targets[2]));
        targets = this.chooseTarget(4);
        Assert.assertEquals((long)targets.length, (long)4L);
        Assert.assertEquals((Object)this.storages[0], (Object)targets[0]);
        Assert.assertTrue((this.isOnSameRack(targets[1], targets[2]) || this.isOnSameRack(targets[2], targets[3]) ? 1 : 0) != 0);
        Assert.assertFalse((boolean)this.isOnSameRack(targets[0], targets[2]));
        this.resetHeartbeatForStorages();
    }

    @Test
    public void testChooseTarget2() throws Exception {
        int i;
        ArrayList<DatanodeStorageInfo> chosenNodes = new ArrayList<DatanodeStorageInfo>();
        HashSet<Node> excludedNodes = new HashSet<Node>();
        excludedNodes.add((Node)this.dataNodes[1]);
        DatanodeStorageInfo[] targets = this.chooseTarget(0, chosenNodes, excludedNodes);
        Assert.assertEquals((long)targets.length, (long)0L);
        excludedNodes.clear();
        chosenNodes.clear();
        excludedNodes.add((Node)this.dataNodes[1]);
        targets = this.chooseTarget(1, chosenNodes, excludedNodes);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertEquals((Object)this.storages[0], (Object)targets[0]);
        excludedNodes.clear();
        chosenNodes.clear();
        excludedNodes.add((Node)this.dataNodes[1]);
        targets = this.chooseTarget(2, chosenNodes, excludedNodes);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertEquals((Object)this.storages[0], (Object)targets[0]);
        Assert.assertFalse((boolean)this.isOnSameRack(targets[0], targets[1]));
        excludedNodes.clear();
        chosenNodes.clear();
        excludedNodes.add((Node)this.dataNodes[1]);
        targets = this.chooseTarget(3, chosenNodes, excludedNodes);
        Assert.assertEquals((long)targets.length, (long)3L);
        Assert.assertEquals((Object)this.storages[0], (Object)targets[0]);
        Assert.assertFalse((boolean)this.isOnSameRack(targets[0], targets[1]));
        Assert.assertTrue((boolean)this.isOnSameRack(targets[1], targets[2]));
        excludedNodes.clear();
        chosenNodes.clear();
        excludedNodes.add((Node)this.dataNodes[1]);
        targets = this.chooseTarget(4, chosenNodes, excludedNodes);
        Assert.assertEquals((long)targets.length, (long)4L);
        Assert.assertEquals((Object)this.storages[0], (Object)targets[0]);
        for (i = 1; i < 4; ++i) {
            Assert.assertFalse((boolean)this.isOnSameRack(targets[0], targets[i]));
        }
        Assert.assertTrue((this.isOnSameRack(targets[1], targets[2]) || this.isOnSameRack(targets[2], targets[3]) ? 1 : 0) != 0);
        Assert.assertFalse((boolean)this.isOnSameRack(targets[1], targets[3]));
        excludedNodes.clear();
        chosenNodes.clear();
        excludedNodes.add((Node)this.dataNodes[1]);
        chosenNodes.add(this.storages[2]);
        targets = this.replicator.chooseTarget(filename, 1, (Node)this.dataNodes[0], chosenNodes, true, excludedNodes, 1024L, TestBlockStoragePolicy.DEFAULT_STORAGE_POLICY, null);
        System.out.println("targets=" + Arrays.asList(targets));
        Assert.assertEquals((long)2L, (long)targets.length);
        for (i = 0; i < targets.length && !this.storages[2].equals((Object)targets[i]); ++i) {
        }
        Assert.assertTrue((i < targets.length ? 1 : 0) != 0);
    }

    @Test
    public void testChooseTarget3() throws Exception {
        TestReplicationPolicy.updateHeartbeatWithUsage(this.dataNodes[0], 2048L, 0L, 0L, 0L, 0L, 0L, 0, 0);
        DatanodeStorageInfo[] targets = this.chooseTarget(0);
        Assert.assertEquals((long)targets.length, (long)0L);
        targets = this.chooseTarget(1);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertEquals((Object)this.storages[1], (Object)targets[0]);
        targets = this.chooseTarget(2);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertEquals((Object)this.storages[1], (Object)targets[0]);
        Assert.assertFalse((boolean)this.isOnSameRack(targets[0], targets[1]));
        targets = this.chooseTarget(3);
        Assert.assertEquals((long)targets.length, (long)3L);
        Assert.assertEquals((Object)this.storages[1], (Object)targets[0]);
        Assert.assertTrue((boolean)this.isOnSameRack(targets[1], targets[2]));
        Assert.assertFalse((boolean)this.isOnSameRack(targets[0], targets[1]));
        targets = this.chooseTarget(4);
        Assert.assertEquals((long)targets.length, (long)4L);
        Assert.assertEquals((Object)this.storages[1], (Object)targets[0]);
        for (int i = 1; i < 4; ++i) {
            Assert.assertFalse((boolean)this.isOnSameRack(targets[0], targets[i]));
        }
        Assert.assertTrue((this.isOnSameRack(targets[1], targets[2]) || this.isOnSameRack(targets[2], targets[3]) ? 1 : 0) != 0);
        Assert.assertFalse((boolean)this.isOnSameRack(targets[1], targets[3]));
        this.resetHeartbeatForStorages();
    }

    @Test
    public void testChoooseTarget4() throws Exception {
        for (int i = 0; i < 2; ++i) {
            TestReplicationPolicy.updateHeartbeatWithUsage(this.dataNodes[i], 2048L, 0L, 0L, 0L, 0L, 0L, 0, 0);
        }
        DatanodeStorageInfo[] targets = this.chooseTarget(0);
        Assert.assertEquals((long)targets.length, (long)0L);
        targets = this.chooseTarget(1);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertFalse((boolean)this.isOnSameRack(targets[0], this.dataNodes[0]));
        targets = this.chooseTarget(2);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertFalse((boolean)this.isOnSameRack(targets[0], this.dataNodes[0]));
        Assert.assertFalse((boolean)this.isOnSameRack(targets[0], targets[1]));
        targets = this.chooseTarget(3);
        Assert.assertEquals((long)targets.length, (long)3L);
        for (int i = 0; i < 3; ++i) {
            Assert.assertFalse((boolean)this.isOnSameRack(targets[i], this.dataNodes[0]));
        }
        Assert.assertTrue((this.isOnSameRack(targets[0], targets[1]) || this.isOnSameRack(targets[1], targets[2]) ? 1 : 0) != 0);
        Assert.assertFalse((boolean)this.isOnSameRack(targets[0], targets[2]));
        this.resetHeartbeatForStorages();
    }

    @Test
    public void testChooseTarget5() throws Exception {
        DatanodeDescriptor writerDesc = DFSTestUtil.getDatanodeDescriptor("7.7.7.7", "/d2/r4");
        DatanodeStorageInfo[] targets = this.chooseTarget(0, writerDesc);
        Assert.assertEquals((long)targets.length, (long)0L);
        targets = this.chooseTarget(1, writerDesc);
        Assert.assertEquals((long)targets.length, (long)1L);
        targets = this.chooseTarget(2, writerDesc);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertFalse((boolean)this.isOnSameRack(targets[0], targets[1]));
        targets = this.chooseTarget(3, writerDesc);
        Assert.assertEquals((long)targets.length, (long)3L);
        Assert.assertTrue((boolean)this.isOnSameRack(targets[1], targets[2]));
        Assert.assertFalse((boolean)this.isOnSameRack(targets[0], targets[1]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChooseTarget6() throws Exception {
        DatanodeStorageInfo storage = DFSTestUtil.createDatanodeStorageInfo("DS-xxxx", "7.7.7.7", "/d2/r3", "host7");
        DatanodeDescriptor newDn = storage.getDatanodeDescriptor();
        ArrayList<DatanodeStorageInfo> chosenNodes = new ArrayList<DatanodeStorageInfo>();
        HashSet<Node> excludedNodes = new HashSet<Node>();
        excludedNodes.add((Node)this.dataNodes[0]);
        excludedNodes.add((Node)this.dataNodes[1]);
        excludedNodes.add((Node)this.dataNodes[2]);
        excludedNodes.add((Node)this.dataNodes[3]);
        DatanodeStorageInfo[] targets = this.chooseTarget(2, chosenNodes, excludedNodes);
        Assert.assertEquals((long)1L, (long)targets.length);
        BlockManager bm = this.namenode.getNamesystem().getBlockManager();
        bm.getDatanodeManager().getNetworkTopology().add((Node)newDn);
        bm.getDatanodeManager().getHeartbeatManager().addDatanode(newDn);
        TestReplicationPolicy.updateHeartbeatWithUsage(newDn, 2048L, 0L, 2048L, 0L, 0L, 0L, 0, 0);
        excludedNodes.clear();
        excludedNodes.add((Node)this.dataNodes[0]);
        excludedNodes.add((Node)this.dataNodes[1]);
        excludedNodes.add((Node)this.dataNodes[2]);
        excludedNodes.add((Node)this.dataNodes[3]);
        chosenNodes.clear();
        try {
            targets = this.chooseTarget(3, chosenNodes, excludedNodes);
            Assert.assertEquals((long)2L, (long)targets.length);
        }
        finally {
            bm.getDatanodeManager().getNetworkTopology().remove((Node)newDn);
        }
        this.resetHeartbeatForStorages();
    }

    @Test
    public void testChooseTargetWithMoreThanAvailableNodesWithStaleness() throws Exception {
        try {
            this.namenode.getNamesystem().getBlockManager().getDatanodeManager().setNumStaleNodes(this.dataNodes.length);
            this.testChooseTargetWithMoreThanAvailableNodes();
        }
        finally {
            this.namenode.getNamesystem().getBlockManager().getDatanodeManager().setNumStaleNodes(0);
        }
    }

    @Test
    public void testChooseTargetWithMoreThanAvailableNodes() throws Exception {
        for (int i = 0; i < 2; ++i) {
            TestReplicationPolicy.updateHeartbeatWithUsage(this.dataNodes[i], 2048L, 0L, 0L, 0L, 0L, 0L, 0, 0);
        }
        LogVerificationAppender appender = new LogVerificationAppender();
        Logger logger = Logger.getRootLogger();
        logger.addAppender((Appender)appender);
        DatanodeStorageInfo[] targets = this.chooseTarget(this.dataNodes.length);
        Assert.assertEquals((long)targets.length, (long)(this.dataNodes.length - 2));
        List<LoggingEvent> log = appender.getLog();
        Assert.assertNotNull(log);
        Assert.assertFalse((log.size() == 0 ? 1 : 0) != 0);
        LoggingEvent lastLogEntry = log.get(log.size() - 1);
        Assert.assertTrue((boolean)Level.WARN.isGreaterOrEqual((Priority)lastLogEntry.getLevel()));
        Assert.assertTrue((boolean)((String)lastLogEntry.getMessage()).contains("in need of 2"));
        this.resetHeartbeatForStorages();
    }

    private boolean containsWithinRange(DatanodeStorageInfo target, DatanodeDescriptor[] nodes, int startIndex, int endIndex) {
        assert (startIndex >= 0 && startIndex < nodes.length);
        assert (endIndex >= startIndex && endIndex < nodes.length);
        for (int i = startIndex; i <= endIndex; ++i) {
            if (!nodes[i].equals((Object)target.getDatanodeDescriptor())) continue;
            return true;
        }
        return false;
    }

    private boolean containsWithinRange(DatanodeDescriptor target, DatanodeStorageInfo[] nodes, int startIndex, int endIndex) {
        assert (startIndex >= 0 && startIndex < nodes.length);
        assert (endIndex >= startIndex && endIndex < nodes.length);
        for (int i = startIndex; i <= endIndex; ++i) {
            if (!nodes[i].getDatanodeDescriptor().equals((Object)target)) continue;
            return true;
        }
        return false;
    }

    @Test
    public void testChooseTargetWithStaleNodes() throws Exception {
        DFSTestUtil.resetLastUpdatesWithOffset((DatanodeInfo)this.dataNodes[0], -30001L);
        this.namenode.getNamesystem().getBlockManager().getDatanodeManager().getHeartbeatManager().heartbeatCheck();
        Assert.assertTrue((boolean)this.namenode.getNamesystem().getBlockManager().getDatanodeManager().shouldAvoidStaleDataNodesForWrite());
        DatanodeStorageInfo[] targets = this.chooseTarget(1);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertEquals((Object)this.storages[1], (Object)targets[0]);
        HashSet<Node> excludedNodes = new HashSet<Node>();
        excludedNodes.add((Node)this.dataNodes[1]);
        ArrayList<DatanodeStorageInfo> chosenNodes = new ArrayList<DatanodeStorageInfo>();
        targets = this.chooseTarget(1, chosenNodes, excludedNodes);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertFalse((boolean)this.isOnSameRack(targets[0], this.dataNodes[0]));
        DFSTestUtil.resetLastUpdatesWithOffset((DatanodeInfo)this.dataNodes[0], 0L);
        this.namenode.getNamesystem().getBlockManager().getDatanodeManager().getHeartbeatManager().heartbeatCheck();
    }

    @Test
    public void testChooseTargetWithHalfStaleNodes() throws Exception {
        for (int i = 0; i < 3; ++i) {
            DFSTestUtil.resetLastUpdatesWithOffset((DatanodeInfo)this.dataNodes[i], -30001L);
        }
        this.namenode.getNamesystem().getBlockManager().getDatanodeManager().getHeartbeatManager().heartbeatCheck();
        DatanodeStorageInfo[] targets = this.chooseTarget(0);
        Assert.assertEquals((long)targets.length, (long)0L);
        targets = this.chooseTarget(1);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertFalse((boolean)this.containsWithinRange(targets[0], this.dataNodes, 0, 2));
        targets = this.chooseTarget(2);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertFalse((boolean)this.containsWithinRange(targets[0], this.dataNodes, 0, 2));
        Assert.assertFalse((boolean)this.containsWithinRange(targets[1], this.dataNodes, 0, 2));
        targets = this.chooseTarget(3);
        Assert.assertEquals((long)targets.length, (long)3L);
        Assert.assertTrue((boolean)this.containsWithinRange(targets[0], this.dataNodes, 3, 5));
        Assert.assertTrue((boolean)this.containsWithinRange(targets[1], this.dataNodes, 3, 5));
        Assert.assertTrue((boolean)this.containsWithinRange(targets[2], this.dataNodes, 3, 5));
        targets = this.chooseTarget(4);
        Assert.assertEquals((long)targets.length, (long)4L);
        Assert.assertTrue((boolean)this.containsWithinRange(this.dataNodes[3], targets, 0, 3));
        Assert.assertTrue((boolean)this.containsWithinRange(this.dataNodes[4], targets, 0, 3));
        Assert.assertTrue((boolean)this.containsWithinRange(this.dataNodes[5], targets, 0, 3));
        for (int i = 0; i < this.dataNodes.length; ++i) {
            DFSTestUtil.resetLastUpdatesWithOffset((DatanodeInfo)this.dataNodes[i], 0L);
        }
        this.namenode.getNamesystem().getBlockManager().getDatanodeManager().getHeartbeatManager().heartbeatCheck();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChooseTargetWithMoreThanHalfStaleNodes() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.namenode.avoid.write.stale.datanode", true);
        String[] hosts = new String[]{"host1", "host2", "host3", "host4", "host5", "host6"};
        String[] racks = new String[]{"/d1/r1", "/d1/r1", "/d1/r2", "/d1/r2", "/d2/r3", "/d2/r3"};
        MiniDFSCluster miniCluster = new MiniDFSCluster.Builder((Configuration)conf).racks(racks).hosts(hosts).numDataNodes(hosts.length).build();
        miniCluster.waitActive();
        try {
            DatanodeDescriptor dnDesc;
            DataNode dn;
            int i;
            for (int i2 = 0; i2 < 2; ++i2) {
                DataNode dn2 = miniCluster.getDataNodes().get(i2);
                DataNodeTestUtils.setHeartbeatsDisabledForTests(dn2, true);
                DatanodeDescriptor dnDes = miniCluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().getDatanode(dn2.getDatanodeId());
                DFSTestUtil.resetLastUpdatesWithOffset((DatanodeInfo)dnDes, -30001L);
            }
            miniCluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().getHeartbeatManager().heartbeatCheck();
            int numStaleNodes = miniCluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().getNumStaleNodes();
            Assert.assertEquals((long)numStaleNodes, (long)2L);
            Assert.assertTrue((boolean)miniCluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().shouldAvoidStaleDataNodesForWrite());
            DatanodeDescriptor staleNodeInfo = miniCluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().getDatanode(miniCluster.getDataNodes().get(0).getDatanodeId());
            BlockPlacementPolicy replicator = miniCluster.getNameNode().getNamesystem().getBlockManager().getBlockPlacementPolicy();
            DatanodeStorageInfo[] targets = replicator.chooseTarget(filename, 3, (Node)staleNodeInfo, new ArrayList(), false, null, 1024L, TestBlockStoragePolicy.DEFAULT_STORAGE_POLICY, null);
            Assert.assertEquals((long)targets.length, (long)3L);
            Assert.assertFalse((boolean)this.isOnSameRack(targets[0], staleNodeInfo));
            for (i = 0; i < 4; ++i) {
                dn = miniCluster.getDataNodes().get(i);
                DataNodeTestUtils.setHeartbeatsDisabledForTests(dn, true);
                dnDesc = miniCluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().getDatanode(dn.getDatanodeId());
                DFSTestUtil.resetLastUpdatesWithOffset((DatanodeInfo)dnDesc, -30001L);
            }
            miniCluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().getHeartbeatManager().heartbeatCheck();
            numStaleNodes = miniCluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().getNumStaleNodes();
            Assert.assertEquals((long)numStaleNodes, (long)4L);
            Assert.assertFalse((boolean)miniCluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().shouldAvoidStaleDataNodesForWrite());
            targets = replicator.chooseTarget(filename, 3, (Node)staleNodeInfo, new ArrayList(), false, null, 1024L, TestBlockStoragePolicy.DEFAULT_STORAGE_POLICY, null);
            Assert.assertEquals((long)targets.length, (long)3L);
            Assert.assertTrue((boolean)this.isOnSameRack(targets[0], staleNodeInfo));
            for (i = 2; i < 4; ++i) {
                dn = miniCluster.getDataNodes().get(i);
                DataNodeTestUtils.setHeartbeatsDisabledForTests(dn, false);
                dnDesc = miniCluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().getDatanode(dn.getDatanodeId());
                DFSTestUtil.resetLastUpdatesWithOffset((DatanodeInfo)dnDesc, 0L);
            }
            miniCluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().getHeartbeatManager().heartbeatCheck();
            numStaleNodes = miniCluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().getNumStaleNodes();
            Assert.assertEquals((long)numStaleNodes, (long)2L);
            Assert.assertTrue((boolean)miniCluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().shouldAvoidStaleDataNodesForWrite());
            targets = this.chooseTarget(3, staleNodeInfo);
            Assert.assertEquals((long)targets.length, (long)3L);
            Assert.assertFalse((boolean)this.isOnSameRack(targets[0], staleNodeInfo));
        }
        finally {
            miniCluster.shutdown();
        }
    }

    @Test
    public void testRereplicate1() throws Exception {
        ArrayList<DatanodeStorageInfo> chosenNodes = new ArrayList<DatanodeStorageInfo>();
        chosenNodes.add(this.storages[0]);
        DatanodeStorageInfo[] targets = this.chooseTarget(0, chosenNodes);
        Assert.assertEquals((long)targets.length, (long)0L);
        targets = this.chooseTarget(1, chosenNodes);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertFalse((boolean)this.isOnSameRack(targets[0], this.dataNodes[0]));
        targets = this.chooseTarget(2, chosenNodes);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertTrue((boolean)this.isOnSameRack(targets[0], this.dataNodes[0]));
        Assert.assertFalse((boolean)this.isOnSameRack(targets[0], targets[1]));
        targets = this.chooseTarget(3, chosenNodes);
        Assert.assertEquals((long)targets.length, (long)3L);
        Assert.assertTrue((boolean)this.isOnSameRack(targets[0], this.dataNodes[0]));
        Assert.assertFalse((boolean)this.isOnSameRack(targets[0], targets[2]));
    }

    @Test
    public void testRereplicate2() throws Exception {
        ArrayList<DatanodeStorageInfo> chosenNodes = new ArrayList<DatanodeStorageInfo>();
        chosenNodes.add(this.storages[0]);
        chosenNodes.add(this.storages[1]);
        DatanodeStorageInfo[] targets = this.chooseTarget(0, chosenNodes);
        Assert.assertEquals((long)targets.length, (long)0L);
        targets = this.chooseTarget(1, chosenNodes);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertFalse((boolean)this.isOnSameRack(targets[0], this.dataNodes[0]));
        targets = this.chooseTarget(2, chosenNodes);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertFalse((boolean)this.isOnSameRack(targets[0], this.dataNodes[0]));
        Assert.assertFalse((boolean)this.isOnSameRack(targets[1], this.dataNodes[0]));
    }

    @Test
    public void testRereplicate3() throws Exception {
        ArrayList<DatanodeStorageInfo> chosenNodes = new ArrayList<DatanodeStorageInfo>();
        chosenNodes.add(this.storages[0]);
        chosenNodes.add(this.storages[2]);
        DatanodeStorageInfo[] targets = this.chooseTarget(0, chosenNodes);
        Assert.assertEquals((long)targets.length, (long)0L);
        targets = this.chooseTarget(1, chosenNodes);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertTrue((boolean)this.isOnSameRack(targets[0], this.dataNodes[0]));
        Assert.assertFalse((boolean)this.isOnSameRack(targets[0], this.dataNodes[2]));
        targets = this.chooseTarget(1, this.dataNodes[2], chosenNodes);
        Assert.assertEquals((long)targets.length, (long)1L);
        Assert.assertTrue((boolean)this.isOnSameRack(targets[0], this.dataNodes[2]));
        Assert.assertFalse((boolean)this.isOnSameRack(targets[0], this.dataNodes[0]));
        targets = this.chooseTarget(2, chosenNodes);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertTrue((boolean)this.isOnSameRack(targets[0], this.dataNodes[0]));
        targets = this.chooseTarget(2, this.dataNodes[2], chosenNodes);
        Assert.assertEquals((long)targets.length, (long)2L);
        Assert.assertTrue((boolean)this.isOnSameRack(targets[0], this.dataNodes[2]));
    }

    private BlockInfo genBlockInfo(long id) {
        return this.genBlockInfo(id, false);
    }

    private BlockInfo genBlockInfo(long id, boolean isBlockCorrupted) {
        BlockInfoContiguous bInfo = new BlockInfoContiguous(new Block(id), 3);
        if (!isBlockCorrupted) {
            bInfo.setBlockCollectionId(mockINodeId.incrementAndGet());
        }
        return bInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testReplicationWithPriority() throws Exception {
        int DFS_NAMENODE_REPLICATION_INTERVAL = 1000;
        int HIGH_PRIORITY = 0;
        Configuration conf = new Configuration();
        conf.setInt("dfs.namenode.redundancy.interval.seconds", 1);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).format(true).build();
        try {
            cluster.waitActive();
            LowRedundancyBlocks neededReconstruction = cluster.getNameNode().getNamesystem().getBlockManager().neededReconstruction;
            for (int i = 0; i < 100; ++i) {
                neededReconstruction.add(this.genBlockInfo(ThreadLocalRandom.current().nextLong(), true), 2, 0, 0, 3);
            }
            Thread.sleep(DFS_NAMENODE_REPLICATION_INTERVAL);
            neededReconstruction.add(this.genBlockInfo(ThreadLocalRandom.current().nextLong(), true), 1, 0, 0, 3);
            Thread.sleep(DFS_NAMENODE_REPLICATION_INTERVAL);
            Assert.assertFalse((String)"Not able to clear the element from high priority list", (boolean)neededReconstruction.iterator(HIGH_PRIORITY).hasNext());
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testChooseLowRedundancyBlocks() throws Exception {
        LowRedundancyBlocks lowRedundancyBlocks = new LowRedundancyBlocks();
        for (int i = 0; i < 5; ++i) {
            lowRedundancyBlocks.add(this.genBlockInfo(ThreadLocalRandom.current().nextLong()), 1, 0, 0, 3);
            lowRedundancyBlocks.add(this.genBlockInfo(ThreadLocalRandom.current().nextLong()), 2, 0, 0, 7);
            lowRedundancyBlocks.add(this.genBlockInfo(ThreadLocalRandom.current().nextLong()), 6, 0, 0, 6);
            lowRedundancyBlocks.add(this.genBlockInfo(ThreadLocalRandom.current().nextLong()), 5, 0, 0, 6);
            lowRedundancyBlocks.add(this.genBlockInfo(ThreadLocalRandom.current().nextLong()), 0, 0, 0, 3);
        }
        List chosenBlocks = lowRedundancyBlocks.chooseLowRedundancyBlocks(6);
        this.assertTheChosenBlocks(chosenBlocks, 5, 1, 0, 0, 0);
        chosenBlocks = lowRedundancyBlocks.chooseLowRedundancyBlocks(10);
        this.assertTheChosenBlocks(chosenBlocks, 0, 4, 5, 1, 0);
        lowRedundancyBlocks.add(this.genBlockInfo(ThreadLocalRandom.current().nextLong()), 0, 1, 0, 3);
        chosenBlocks = lowRedundancyBlocks.chooseLowRedundancyBlocks(10);
        this.assertTheChosenBlocks(chosenBlocks, 1, 0, 0, 4);
        chosenBlocks = lowRedundancyBlocks.chooseLowRedundancyBlocks(7);
        this.assertTheChosenBlocks(chosenBlocks, 6, 1, 0, 0, 0);
    }

    private void assertTheChosenBlocks(List<List<BlockInfo>> chosenBlocks, int ... expectedSizes) {
        int i;
        for (i = 0; i < chosenBlocks.size(); ++i) {
            Assert.assertEquals((String)("Not returned the expected number for i=" + i), (long)expectedSizes[i], (long)chosenBlocks.get(i).size());
        }
        while (i < expectedSizes.length) {
            Assert.assertEquals((String)("Expected size is non-zero for i=" + i), (long)0L, (long)expectedSizes[i]);
            ++i;
        }
    }

    @Test
    public void testChooseReplicaToDelete() throws Exception {
        ArrayList<DatanodeStorageInfo> replicaList = new ArrayList<DatanodeStorageInfo>();
        HashMap rackMap = new HashMap();
        this.storages[0].setRemainingForTests(0x400000);
        this.dataNodes[0].setRemaining(this.calculateRemaining(this.dataNodes[0]));
        replicaList.add(this.storages[0]);
        this.storages[1].setRemainingForTests(0x300000);
        this.dataNodes[1].setRemaining(this.calculateRemaining(this.dataNodes[1]));
        replicaList.add(this.storages[1]);
        this.storages[2].setRemainingForTests(0x200000);
        this.dataNodes[2].setRemaining(this.calculateRemaining(this.dataNodes[2]));
        replicaList.add(this.storages[2]);
        this.storages[4].setRemainingForTests(0x6400000);
        this.storages[5].setRemainingForTests(524288);
        this.dataNodes[5].setRemaining(this.calculateRemaining(this.dataNodes[5]));
        replicaList.add(this.storages[5]);
        for (int i = 0; i < this.dataNodes.length; ++i) {
            DFSTestUtil.resetLastUpdatesWithOffset((DatanodeInfo)this.dataNodes[i], 0L);
        }
        ArrayList first = new ArrayList();
        ArrayList second = new ArrayList();
        this.replicator.splitNodesWithRack(replicaList, replicaList, rackMap, first, second);
        Assert.assertEquals((long)2L, (long)first.size());
        Assert.assertEquals((long)2L, (long)second.size());
        ArrayList<StorageType> excessTypes = new ArrayList<StorageType>();
        excessTypes.add(StorageType.SSD);
        Assert.assertNull((Object)((BlockPlacementPolicyDefault)this.replicator).chooseReplicaToDelete(first, second, excessTypes, rackMap));
        excessTypes.add(StorageType.DEFAULT);
        DatanodeStorageInfo chosen = ((BlockPlacementPolicyDefault)this.replicator).chooseReplicaToDelete(first, second, excessTypes, rackMap);
        Assert.assertEquals((Object)chosen, (Object)this.storages[5]);
        this.replicator.adjustSetsWithChosenReplica(rackMap, first, second, chosen);
        Assert.assertEquals((long)2L, (long)first.size());
        Assert.assertEquals((long)1L, (long)second.size());
        excessTypes.add(StorageType.DEFAULT);
        chosen = ((BlockPlacementPolicyDefault)this.replicator).chooseReplicaToDelete(first, second, excessTypes, rackMap);
        Assert.assertEquals((Object)chosen, (Object)this.storages[1]);
    }

    @Test
    public void testStripedChooseReplicaToDelete() throws Exception {
        ArrayList<DatanodeStorageInfo> replicaList = new ArrayList<DatanodeStorageInfo>();
        ArrayList<DatanodeStorageInfo> candidate = new ArrayList<DatanodeStorageInfo>();
        HashMap rackMap = new HashMap();
        replicaList.add(this.storages[0]);
        replicaList.add(this.storages[1]);
        replicaList.add(this.storages[2]);
        replicaList.add(this.storages[4]);
        candidate.add(this.storages[0]);
        candidate.add(this.storages[2]);
        candidate.add(this.storages[4]);
        for (int i = 0; i < this.dataNodes.length; ++i) {
            DFSTestUtil.resetLastUpdatesWithOffset((DatanodeInfo)this.dataNodes[i], 0L);
        }
        ArrayList first = new ArrayList();
        ArrayList second = new ArrayList();
        BlockPlacementPolicy policy = this.getStriptedPolicy();
        policy.splitNodesWithRack(replicaList, candidate, rackMap, first, second);
        Assert.assertEquals((long)1L, (long)first.size());
        Assert.assertEquals((long)2L, (long)second.size());
        ArrayList<StorageType> excessTypes = new ArrayList<StorageType>();
        excessTypes.add(StorageType.DEFAULT);
        DatanodeStorageInfo chosen = ((BlockPlacementPolicyDefault)policy).chooseReplicaToDelete(first, second, excessTypes, rackMap);
        Assert.assertEquals((Object)chosen, (Object)this.storages[0]);
        policy.adjustSetsWithChosenReplica(rackMap, first, second, chosen);
        Assert.assertEquals((long)0L, (long)first.size());
        Assert.assertEquals((long)2L, (long)second.size());
        excessTypes.add(StorageType.DEFAULT);
        chosen = ((BlockPlacementPolicyDefault)policy).chooseReplicaToDelete(first, second, excessTypes, rackMap);
        Assert.assertEquals((Object)chosen, (Object)this.storages[2]);
        policy.adjustSetsWithChosenReplica(rackMap, first, second, chosen);
        Assert.assertEquals((long)0L, (long)first.size());
        Assert.assertEquals((long)1L, (long)second.size());
        chosen = ((BlockPlacementPolicyDefault)policy).chooseReplicaToDelete(first, second, excessTypes, rackMap);
        Assert.assertEquals((Object)chosen, null);
    }

    private long calculateRemaining(DatanodeDescriptor dataNode) {
        long sum = 0L;
        for (DatanodeStorageInfo storageInfo : dataNode.getStorageInfos()) {
            sum += storageInfo.getRemaining();
        }
        return sum;
    }

    @Test
    public void testChooseReplicasToDelete() throws Exception {
        ArrayList<DatanodeStorageInfo> nonExcess = new ArrayList<DatanodeStorageInfo>();
        nonExcess.add(this.storages[0]);
        nonExcess.add(this.storages[1]);
        nonExcess.add(this.storages[2]);
        nonExcess.add(this.storages[3]);
        BlockStoragePolicySuite POLICY_SUITE = BlockStoragePolicySuite.createDefaultSuite();
        BlockStoragePolicy storagePolicy = POLICY_SUITE.getDefaultPolicy();
        DatanodeStorageInfo excessSSD = DFSTestUtil.createDatanodeStorageInfo("Storage-excess-SSD-ID", "localhost", this.storages[0].getDatanodeDescriptor().getNetworkLocation(), "foo.com", StorageType.SSD, null);
        TestReplicationPolicy.updateHeartbeatWithUsage(excessSSD.getDatanodeDescriptor(), 2048L, 0L, 2048L, 0L, 0L, 0L, 0, 0);
        DatanodeDescriptor delHintNode = this.storages[0].getDatanodeDescriptor();
        List excessTypes = storagePolicy.chooseExcess((short)3, DatanodeStorageInfo.toStorageTypes(nonExcess));
        List excessReplicas = this.replicator.chooseReplicasToDelete(nonExcess, nonExcess, 3, excessTypes, this.storages[3].getDatanodeDescriptor(), delHintNode);
        Assert.assertTrue((excessReplicas.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)excessReplicas.contains(this.storages[0]));
        DatanodeStorageInfo excessStorage = DFSTestUtil.createDatanodeStorageInfo("Storage-excess-ID", "localhost", delHintNode.getNetworkLocation(), "foo.com", StorageType.ARCHIVE, null);
        nonExcess.add(excessStorage);
        excessTypes = storagePolicy.chooseExcess((short)3, DatanodeStorageInfo.toStorageTypes(nonExcess));
        excessReplicas = this.replicator.chooseReplicasToDelete(nonExcess, nonExcess, 3, excessTypes, this.storages[3].getDatanodeDescriptor(), null);
        Assert.assertTrue((boolean)excessReplicas.contains(excessStorage));
        nonExcess.clear();
        nonExcess.add(excessSSD);
        nonExcess.add(this.storages[3]);
        nonExcess.add(this.storages[4]);
        nonExcess.add(this.storages[5]);
        excessTypes = storagePolicy.chooseExcess((short)3, DatanodeStorageInfo.toStorageTypes(nonExcess));
        excessReplicas = this.replicator.chooseReplicasToDelete(nonExcess, nonExcess, 3, excessTypes, this.storages[3].getDatanodeDescriptor(), this.storages[5].getDatanodeDescriptor());
        Assert.assertEquals((long)1L, (long)excessReplicas.size());
        Assert.assertTrue((boolean)excessReplicas.contains(excessSSD));
        nonExcess.clear();
        nonExcess.add(excessSSD);
        nonExcess.add(this.storages[1]);
        nonExcess.add(this.storages[2]);
        nonExcess.add(this.storages[3]);
        excessTypes = storagePolicy.chooseExcess((short)3, DatanodeStorageInfo.toStorageTypes(nonExcess));
        excessReplicas = this.replicator.chooseReplicasToDelete(nonExcess, nonExcess, 3, excessTypes, this.storages[1].getDatanodeDescriptor(), this.storages[3].getDatanodeDescriptor());
        Assert.assertEquals((long)1L, (long)excessReplicas.size());
        Assert.assertTrue((boolean)excessReplicas.contains(excessSSD));
        nonExcess.clear();
        nonExcess.add(excessSSD);
        nonExcess.add(this.storages[2]);
        excessTypes = storagePolicy.chooseExcess((short)1, DatanodeStorageInfo.toStorageTypes(nonExcess));
        excessReplicas = this.replicator.chooseReplicasToDelete(nonExcess, nonExcess, 1, excessTypes, this.storages[2].getDatanodeDescriptor(), null);
        Assert.assertEquals((long)1L, (long)excessReplicas.size());
        Assert.assertTrue((boolean)excessReplicas.contains(excessSSD));
        nonExcess.clear();
        nonExcess.add(excessSSD);
        nonExcess.add(this.storages[4]);
        nonExcess.add(this.storages[5]);
        excessTypes = storagePolicy.chooseExcess((short)2, DatanodeStorageInfo.toStorageTypes(nonExcess));
        excessReplicas = this.replicator.chooseReplicasToDelete(nonExcess, nonExcess, 2, excessTypes, null, null);
        Assert.assertEquals((long)0L, (long)excessReplicas.size());
    }

    @Test
    public void testUseDelHint() throws Exception {
        ArrayList<StorageType> excessTypes = new ArrayList<StorageType>();
        excessTypes.add(StorageType.ARCHIVE);
        BlockPlacementPolicyDefault policyDefault = (BlockPlacementPolicyDefault)this.replicator;
        Assert.assertFalse((boolean)policyDefault.useDelHint(null, null, null, null, null));
        Assert.assertFalse((boolean)policyDefault.useDelHint(this.storages[0], null, null, null, excessTypes));
        ArrayList<DatanodeStorageInfo> moreThanOne = new ArrayList<DatanodeStorageInfo>();
        moreThanOne.add(this.storages[0]);
        moreThanOne.add(this.storages[1]);
        ArrayList<DatanodeStorageInfo> exactlyOne = new ArrayList<DatanodeStorageInfo>();
        exactlyOne.add(this.storages[3]);
        exactlyOne.add(this.storages[5]);
        excessTypes.add(StorageType.DEFAULT);
        Assert.assertTrue((boolean)policyDefault.useDelHint(this.storages[0], null, moreThanOne, exactlyOne, excessTypes));
        Assert.assertTrue((boolean)policyDefault.useDelHint(this.storages[3], this.storages[5], moreThanOne, exactlyOne, excessTypes));
        Assert.assertFalse((boolean)policyDefault.useDelHint(this.storages[3], this.storages[0], moreThanOne, exactlyOne, excessTypes));
        Assert.assertFalse((boolean)policyDefault.useDelHint(this.storages[3], null, moreThanOne, exactlyOne, excessTypes));
    }

    @Test
    public void testIsMovable() throws Exception {
        ArrayList<DatanodeDescriptor> candidates = new ArrayList<DatanodeDescriptor>();
        candidates.add(this.dataNodes[0]);
        candidates.add(this.dataNodes[1]);
        candidates.add(this.dataNodes[2]);
        candidates.add(this.dataNodes[3]);
        Assert.assertTrue((boolean)this.replicator.isMovable(candidates, (DatanodeInfo)this.dataNodes[0], (DatanodeInfo)this.dataNodes[3]));
        candidates.clear();
        candidates.add(this.dataNodes[0]);
        candidates.add(this.dataNodes[1]);
        candidates.add(this.dataNodes[2]);
        candidates.add(this.dataNodes[4]);
        Assert.assertTrue((boolean)this.replicator.isMovable(candidates, (DatanodeInfo)this.dataNodes[0], (DatanodeInfo)this.dataNodes[1]));
        candidates.clear();
        candidates.add(this.dataNodes[0]);
        candidates.add(this.dataNodes[1]);
        candidates.add(this.dataNodes[2]);
        candidates.add(this.dataNodes[4]);
        Assert.assertTrue((boolean)this.replicator.isMovable(candidates, (DatanodeInfo)this.dataNodes[0], (DatanodeInfo)this.dataNodes[4]));
        candidates.clear();
        candidates.add(this.dataNodes[0]);
        candidates.add(this.dataNodes[2]);
        candidates.add(this.dataNodes[3]);
        candidates.add(this.dataNodes[4]);
        Assert.assertFalse((boolean)this.replicator.isMovable(candidates, (DatanodeInfo)this.dataNodes[0], (DatanodeInfo)this.dataNodes[3]));
    }

    @Test
    public void testGetInvalidateWorkPctPerIteration() {
        Configuration conf = new Configuration();
        float blocksInvalidateWorkPct = DFSUtil.getInvalidateWorkPctPerIteration((Configuration)conf);
        Assert.assertTrue((blocksInvalidateWorkPct > 0.0f ? 1 : 0) != 0);
        conf.set("dfs.namenode.invalidate.work.pct.per.iteration", "0.5f");
        blocksInvalidateWorkPct = DFSUtil.getInvalidateWorkPctPerIteration((Configuration)conf);
        Assert.assertEquals((double)blocksInvalidateWorkPct, (double)0.5, (double)((double)blocksInvalidateWorkPct * 1.0E-7));
        conf.set("dfs.namenode.invalidate.work.pct.per.iteration", "1.0f");
        blocksInvalidateWorkPct = DFSUtil.getInvalidateWorkPctPerIteration((Configuration)conf);
        Assert.assertEquals((double)blocksInvalidateWorkPct, (double)1.0, (double)((double)blocksInvalidateWorkPct * 1.0E-7));
        conf.set("dfs.namenode.invalidate.work.pct.per.iteration", "0.0f");
        this.exception.expect(IllegalArgumentException.class);
        blocksInvalidateWorkPct = DFSUtil.getInvalidateWorkPctPerIteration((Configuration)conf);
    }

    @Test
    public void testGetInvalidateWorkPctPerIteration_NegativeValue() {
        Configuration conf = new Configuration();
        float blocksInvalidateWorkPct = DFSUtil.getInvalidateWorkPctPerIteration((Configuration)conf);
        Assert.assertTrue((blocksInvalidateWorkPct > 0.0f ? 1 : 0) != 0);
        conf.set("dfs.namenode.invalidate.work.pct.per.iteration", "-0.5f");
        this.exception.expect(IllegalArgumentException.class);
        blocksInvalidateWorkPct = DFSUtil.getInvalidateWorkPctPerIteration((Configuration)conf);
    }

    @Test
    public void testGetInvalidateWorkPctPerIteration_GreaterThanOne() {
        Configuration conf = new Configuration();
        float blocksInvalidateWorkPct = DFSUtil.getInvalidateWorkPctPerIteration((Configuration)conf);
        Assert.assertTrue((blocksInvalidateWorkPct > 0.0f ? 1 : 0) != 0);
        conf.set("dfs.namenode.invalidate.work.pct.per.iteration", "1.5f");
        this.exception.expect(IllegalArgumentException.class);
        blocksInvalidateWorkPct = DFSUtil.getInvalidateWorkPctPerIteration((Configuration)conf);
    }

    @Test
    public void testGetReplWorkMultiplier() {
        Configuration conf = new Configuration();
        int blocksReplWorkMultiplier = DFSUtil.getReplWorkMultiplier((Configuration)conf);
        Assert.assertTrue((blocksReplWorkMultiplier > 0 ? 1 : 0) != 0);
        conf.set("dfs.namenode.replication.work.multiplier.per.iteration", "3");
        blocksReplWorkMultiplier = DFSUtil.getReplWorkMultiplier((Configuration)conf);
        Assert.assertEquals((long)blocksReplWorkMultiplier, (long)3L);
        conf.set("dfs.namenode.replication.work.multiplier.per.iteration", "-1");
        this.exception.expect(IllegalArgumentException.class);
        blocksReplWorkMultiplier = DFSUtil.getReplWorkMultiplier((Configuration)conf);
    }

    @Test(timeout=60000L)
    public void testUpdateDoesNotCauseSkippedReplication() {
        LowRedundancyBlocks lowRedundancyBlocks = new LowRedundancyBlocks();
        BlockInfo block1 = this.genBlockInfo(ThreadLocalRandom.current().nextLong());
        BlockInfo block2 = this.genBlockInfo(ThreadLocalRandom.current().nextLong());
        BlockInfo block3 = this.genBlockInfo(ThreadLocalRandom.current().nextLong());
        int block1CurReplicas = 2;
        int block1ExpectedReplicas = 7;
        lowRedundancyBlocks.add(block1, 2, 0, 0, 7);
        lowRedundancyBlocks.add(block2, 2, 0, 0, 7);
        lowRedundancyBlocks.add(block3, 2, 0, 0, 6);
        List chosenBlocks = lowRedundancyBlocks.chooseLowRedundancyBlocks(1);
        this.assertTheChosenBlocks(chosenBlocks, 0, 1, 0, 0, 0);
        lowRedundancyBlocks.update(block1, 3, 0, 0, 7, 1, 0);
        chosenBlocks = lowRedundancyBlocks.chooseLowRedundancyBlocks(1);
        this.assertTheChosenBlocks(chosenBlocks, 0, 1, 0, 0, 0);
        chosenBlocks = lowRedundancyBlocks.chooseLowRedundancyBlocks(1);
        this.assertTheChosenBlocks(chosenBlocks, 0, 0, 1, 0, 0);
    }

    @Test(timeout=60000L)
    public void testAddStoredBlockDoesNotCauseSkippedReplication() throws IOException {
        FSNamesystem mockNS = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        Mockito.when((Object)mockNS.hasWriteLock()).thenReturn((Object)true);
        Mockito.when((Object)mockNS.hasReadLock()).thenReturn((Object)true);
        BlockManager bm = new BlockManager((Namesystem)mockNS, false, (Configuration)new HdfsConfiguration());
        LowRedundancyBlocks lowRedundancyBlocks = bm.neededReconstruction;
        BlockInfo block1 = this.genBlockInfo(ThreadLocalRandom.current().nextLong());
        BlockInfo block2 = this.genBlockInfo(ThreadLocalRandom.current().nextLong());
        lowRedundancyBlocks.add(block1, 0, 0, 1, 1);
        lowRedundancyBlocks.add(block2, 0, 0, 1, 1);
        List chosenBlocks = lowRedundancyBlocks.chooseLowRedundancyBlocks(1);
        this.assertTheChosenBlocks(chosenBlocks, 1, 0, 0, 0, 0);
        BlockInfoContiguous info = new BlockInfoContiguous((Block)block1, 1);
        info.convertToBlockUnderConstruction(HdfsServerConstants.BlockUCState.UNDER_CONSTRUCTION, null);
        info.setBlockCollectionId(1000L);
        INodeFile file = TestINodeFile.createINodeFile(1000L);
        Mockito.when((Object)mockNS.getBlockCollection(1000L)).thenReturn((Object)file);
        bm.addBlockCollection((BlockInfo)info, (BlockCollection)file);
        bm.addStoredBlockUnderConstruction(new BlockManager.StatefulBlockInfo((BlockInfo)info, (Block)info, HdfsServerConstants.ReplicaState.FINALIZED), this.storages[0]);
        chosenBlocks = lowRedundancyBlocks.chooseLowRedundancyBlocks(1);
        this.assertTheChosenBlocks(chosenBlocks, 1, 0, 0, 0, 0);
    }

    @Test(timeout=60000L)
    public void testConvertLastBlockToUnderConstructionDoesNotCauseSkippedReplication() throws IOException {
        long blkID2;
        Namesystem mockNS = (Namesystem)Mockito.mock(Namesystem.class);
        Mockito.when((Object)mockNS.hasWriteLock()).thenReturn((Object)true);
        BlockManager bm = new BlockManager(mockNS, false, (Configuration)new HdfsConfiguration());
        LowRedundancyBlocks lowRedundancyBlocks = bm.neededReconstruction;
        long blkID1 = ThreadLocalRandom.current().nextLong();
        if (blkID1 < 0L) {
            blkID1 *= -1L;
        }
        if ((blkID2 = ThreadLocalRandom.current().nextLong()) < 0L) {
            blkID2 *= -1L;
        }
        BlockInfo block1 = this.genBlockInfo(blkID1);
        BlockInfo block2 = this.genBlockInfo(blkID2);
        lowRedundancyBlocks.add(block1, 0, 0, 1, 1);
        lowRedundancyBlocks.add(block2, 0, 0, 1, 1);
        List chosenBlocks = lowRedundancyBlocks.chooseLowRedundancyBlocks(1);
        this.assertTheChosenBlocks(chosenBlocks, 1, 0, 0, 0, 0);
        BlockInfoContiguous info = new BlockInfoContiguous((Block)block1, 1);
        BlockCollection mbc = (BlockCollection)Mockito.mock(BlockCollection.class);
        Mockito.when((Object)mbc.getId()).thenReturn((Object)1000L);
        Mockito.when((Object)mbc.getLastBlock()).thenReturn((Object)info);
        Mockito.when((Object)mbc.getPreferredBlockSize()).thenReturn((Object)(block1.getNumBytes() + 1L));
        Mockito.when((Object)mbc.isUnderConstruction()).thenReturn((Object)true);
        ContentSummary cs = (ContentSummary)Mockito.mock(ContentSummary.class);
        Mockito.when((Object)cs.getLength()).thenReturn((Object)1L);
        Mockito.when((Object)mbc.computeContentSummary(bm.getStoragePolicySuite())).thenReturn((Object)cs);
        info.setBlockCollectionId(1000L);
        bm.addBlockCollection((BlockInfo)info, mbc);
        DatanodeStorageInfo[] storageAry = new DatanodeStorageInfo[]{new DatanodeStorageInfo(this.dataNodes[0], new DatanodeStorage("s1"))};
        info.convertToBlockUnderConstruction(HdfsServerConstants.BlockUCState.UNDER_CONSTRUCTION, storageAry);
        DatanodeStorageInfo storage = (DatanodeStorageInfo)Mockito.mock(DatanodeStorageInfo.class);
        DatanodeDescriptor dn = (DatanodeDescriptor)Mockito.mock(DatanodeDescriptor.class);
        Mockito.when((Object)dn.isDecommissioned()).thenReturn((Object)true);
        Mockito.when((Object)storage.getState()).thenReturn((Object)DatanodeStorage.State.NORMAL);
        Mockito.when((Object)storage.getDatanodeDescriptor()).thenReturn((Object)dn);
        Mockito.when((Object)storage.removeBlock((BlockInfo)Matchers.any(BlockInfo.class))).thenReturn((Object)true);
        Mockito.when((Object)storage.addBlock((BlockInfo)Matchers.any(BlockInfo.class))).thenReturn((Object)DatanodeStorageInfo.AddBlockResult.ADDED);
        info.addStorage(storage, (Block)info);
        BlockInfo lastBlk = mbc.getLastBlock();
        Mockito.when((Object)mbc.getLastBlock()).thenReturn((Object)lastBlk, (Object[])new BlockInfo[]{info});
        bm.convertLastBlockToUnderConstruction(mbc, 0L);
        chosenBlocks = lowRedundancyBlocks.chooseLowRedundancyBlocks(1);
        this.assertTheChosenBlocks(chosenBlocks, 1, 0, 0, 0, 0);
    }

    @Test(timeout=60000L)
    public void testupdateNeededReplicationsDoesNotCauseSkippedReplication() throws IOException {
        Namesystem mockNS = (Namesystem)Mockito.mock(Namesystem.class);
        Mockito.when((Object)mockNS.hasReadLock()).thenReturn((Object)true);
        BlockManager bm = new BlockManager(mockNS, false, (Configuration)new HdfsConfiguration());
        LowRedundancyBlocks lowRedundancyBlocks = bm.neededReconstruction;
        BlockInfo block1 = this.genBlockInfo(ThreadLocalRandom.current().nextLong());
        BlockInfo block2 = this.genBlockInfo(ThreadLocalRandom.current().nextLong());
        lowRedundancyBlocks.add(block1, 0, 0, 1, 1);
        lowRedundancyBlocks.add(block2, 0, 0, 1, 1);
        List chosenBlocks = lowRedundancyBlocks.chooseLowRedundancyBlocks(1);
        this.assertTheChosenBlocks(chosenBlocks, 1, 0, 0, 0, 0);
        bm.setReplication((short)0, (short)1, block1);
        chosenBlocks = lowRedundancyBlocks.chooseLowRedundancyBlocks(1);
        this.assertTheChosenBlocks(chosenBlocks, 1, 0, 0, 0, 0);
    }

    @Test
    public void testChooseExcessReplicaApartFromFavoredNodes() throws Exception {
        ArrayList<DatanodeDescriptor> expectedTargets = new ArrayList<DatanodeDescriptor>();
        expectedTargets.add(this.dataNodes[0]);
        expectedTargets.add(this.dataNodes[1]);
        expectedTargets.add(this.dataNodes[2]);
        expectedTargets.add(this.dataNodes[4]);
        expectedTargets.add(this.dataNodes[5]);
        ArrayList<DatanodeDescriptor> favouredNodes = new ArrayList<DatanodeDescriptor>();
        favouredNodes.add(this.dataNodes[0]);
        favouredNodes.add(this.dataNodes[1]);
        DatanodeStorageInfo[] targets = this.chooseTarget(5, this.dataNodes[2], null, favouredNodes);
        Assert.assertEquals((long)targets.length, (long)5L);
        for (int i = 0; i < targets.length; ++i) {
            Assert.assertTrue((String)"Target should be a part of Expected Targets", (boolean)expectedTargets.contains(targets[i].getDatanodeDescriptor()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChooseFromFavoredNodesWhenPreferLocalSetToFalse() {
        ((BlockPlacementPolicyDefault)this.replicator).setPreferLocalNode(false);
        try {
            ArrayList<DatanodeDescriptor> expectedTargets = new ArrayList<DatanodeDescriptor>();
            expectedTargets.add(this.dataNodes[0]);
            expectedTargets.add(this.dataNodes[2]);
            ArrayList<DatanodeDescriptor> favouredNodes = new ArrayList<DatanodeDescriptor>();
            favouredNodes.add(this.dataNodes[0]);
            favouredNodes.add(this.dataNodes[2]);
            DatanodeStorageInfo[] targets = this.chooseTarget(2, this.dataNodes[3], null, favouredNodes);
            Assert.assertEquals((long)targets.length, (long)2L);
            for (int i = 0; i < targets.length; ++i) {
                Assert.assertTrue((String)"Target should be a part of Expected Targets", (boolean)expectedTargets.contains(targets[i].getDatanodeDescriptor()));
            }
        }
        finally {
            ((BlockPlacementPolicyDefault)this.replicator).setPreferLocalNode(true);
        }
    }

    private DatanodeStorageInfo[] chooseTarget(int numOfReplicas, DatanodeDescriptor writer, Set<Node> excludedNodes, List<DatanodeDescriptor> favoredNodes) {
        return this.chooseTarget(numOfReplicas, writer, excludedNodes, favoredNodes, null);
    }

    private DatanodeStorageInfo[] chooseTarget(int numOfReplicas, DatanodeDescriptor writer, Set<Node> excludedNodes, List<DatanodeDescriptor> favoredNodes, EnumSet<AddBlockFlag> flags) {
        return this.replicator.chooseTarget(filename, numOfReplicas, (Node)writer, excludedNodes, 1024L, favoredNodes, TestBlockStoragePolicy.DEFAULT_STORAGE_POLICY, flags);
    }

    @Test
    public void testAvoidLocalWrite() throws IOException {
        DatanodeStorageInfo[] targets;
        DatanodeDescriptor writer = this.dataNodes[2];
        EnumSet<AddBlockFlag> flags = EnumSet.of(AddBlockFlag.NO_LOCAL_WRITE);
        for (DatanodeStorageInfo info : targets = this.chooseTarget(5, writer, null, null, flags)) {
            Assert.assertNotEquals((Object)info.getDatanodeDescriptor(), (Object)writer);
        }
    }

    @Test
    public void testAvoidLocalWriteNoEnoughNodes() throws IOException {
        DatanodeDescriptor writer = this.dataNodes[2];
        EnumSet<AddBlockFlag> flags = EnumSet.of(AddBlockFlag.NO_LOCAL_WRITE);
        DatanodeStorageInfo[] targets = this.chooseTarget(6, writer, null, null, flags);
        Assert.assertEquals((long)6L, (long)targets.length);
        boolean found = false;
        for (DatanodeStorageInfo info : targets) {
            if (!info.getDatanodeDescriptor().equals((Object)writer)) continue;
            found = true;
        }
        Assert.assertTrue((boolean)found);
    }

    @Test
    public void testMaxLoad() {
        FSClusterStats statistics = (FSClusterStats)Mockito.mock(FSClusterStats.class);
        DatanodeDescriptor node = (DatanodeDescriptor)Mockito.mock(DatanodeDescriptor.class);
        Mockito.when((Object)statistics.getInServiceXceiverAverage()).thenReturn((Object)0.0);
        Mockito.when((Object)node.getXceiverCount()).thenReturn((Object)1);
        Configuration conf = new Configuration();
        Class replicatorClass = conf.getClass("dfs.block.replicator.classname", DFSConfigKeys.DFS_BLOCK_REPLICATOR_CLASSNAME_DEFAULT, BlockPlacementPolicy.class);
        BlockPlacementPolicy bpp = (BlockPlacementPolicy)ReflectionUtils.newInstance((Class)replicatorClass, (Configuration)conf);
        Assert.assertTrue((boolean)(bpp instanceof BlockPlacementPolicyDefault));
        BlockPlacementPolicyDefault bppd = (BlockPlacementPolicyDefault)bpp;
        bppd.initialize(conf, statistics, null, null);
        Assert.assertFalse((boolean)bppd.excludeNodeByLoad(node));
        Mockito.when((Object)statistics.getInServiceXceiverAverage()).thenReturn((Object)1.0);
        Mockito.when((Object)node.getXceiverCount()).thenReturn((Object)10);
        Assert.assertTrue((boolean)bppd.excludeNodeByLoad(node));
    }

    @Test
    public void testChosenFailureForStorageType() {
        LogVerificationAppender appender = new LogVerificationAppender();
        Logger logger = Logger.getRootLogger();
        logger.addAppender((Appender)appender);
        DatanodeStorageInfo[] targets = this.replicator.chooseTarget(filename, 1, (Node)this.dataNodes[0], new ArrayList(), false, null, 1024L, TestBlockStoragePolicy.POLICY_SUITE.getPolicy((byte)2), null);
        Assert.assertEquals((long)0L, (long)targets.length);
        Assert.assertNotEquals((long)0L, (long)appender.countLinesWithMessage("NO_REQUIRED_STORAGE_TYPE"));
    }
}

