/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.qjournal.server;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeInfo;
import org.apache.hadoop.hdfs.qjournal.MiniJournalCluster;
import org.apache.hadoop.hdfs.qjournal.MiniQJMHACluster;
import org.apache.hadoop.hdfs.qjournal.server.Journal;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FileJournalManager;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class TestJournalNodeSync {
    private Configuration conf;
    private MiniQJMHACluster qjmhaCluster;
    private MiniDFSCluster dfsCluster;
    private MiniJournalCluster jCluster;
    private FSNamesystem namesystem;
    private int editsPerformed = 0;
    private final String jid = "ns1";
    private int activeNNindex = 0;
    private static final int DFS_HA_TAILEDITS_PERIOD_SECONDS = 1;
    @Rule
    public TestName testName = new TestName();

    @Before
    public void setUpMiniCluster() throws IOException {
        this.conf = new HdfsConfiguration();
        this.conf.setBoolean("dfs.journalnode.enable.sync", true);
        this.conf.setLong("dfs.journalnode.sync.interval", 1000L);
        if (this.testName.getMethodName().equals("testSyncAfterJNdowntimeWithoutQJournalQueue")) {
            this.conf.setInt("dfs.qjournal.queued-edits.limit.mb", 0);
        }
        if (this.testName.getMethodName().equals("testSyncDuringRollingUpgrade")) {
            this.conf.setInt("dfs.ha.tail-edits.period", 1);
        }
        this.qjmhaCluster = new MiniQJMHACluster.Builder(this.conf).setNumNameNodes(2).build();
        this.dfsCluster = this.qjmhaCluster.getDfsCluster();
        this.jCluster = this.qjmhaCluster.getJournalCluster();
        this.dfsCluster.transitionToActive(0);
        this.namesystem = this.dfsCluster.getNamesystem(0);
    }

    @After
    public void shutDownMiniCluster() throws IOException {
        if (this.qjmhaCluster != null) {
            this.qjmhaCluster.shutdown();
        }
    }

    @Test(timeout=30000L)
    public void testJournalNodeSync() throws Exception {
        for (int i = 0; i < 3; ++i) {
            Assert.assertEquals((Object)true, (Object)this.jCluster.getJournalNode(i).getJournalSyncerStatus("ns1"));
        }
        File firstJournalDir = this.jCluster.getJournalDir(0, "ns1");
        File firstJournalCurrentDir = new Storage.StorageDirectory(firstJournalDir).getCurrentDir();
        long firstTxId = this.generateEditLog();
        this.generateEditLog();
        File missingLog = this.deleteEditLog(firstJournalCurrentDir, firstTxId);
        GenericTestUtils.waitFor(this.editLogExists(Lists.newArrayList((Object[])new File[]{missingLog})), (long)500L, (long)10000L);
    }

    @Test(timeout=30000L)
    public void testSyncForMultipleMissingLogs() throws Exception {
        File firstJournalDir = this.jCluster.getJournalDir(0, "ns1");
        File firstJournalCurrentDir = new Storage.StorageDirectory(firstJournalDir).getCurrentDir();
        long firstTxId = this.generateEditLog();
        long nextTxId = this.generateEditLog();
        ArrayList missingLogs = Lists.newArrayList();
        missingLogs.add(this.deleteEditLog(firstJournalCurrentDir, firstTxId));
        missingLogs.add(this.deleteEditLog(firstJournalCurrentDir, nextTxId));
        GenericTestUtils.waitFor(this.editLogExists(missingLogs), (long)500L, (long)10000L);
    }

    @Test(timeout=30000L)
    public void testSyncForDiscontinuousMissingLogs() throws Exception {
        File firstJournalDir = this.jCluster.getJournalDir(0, "ns1");
        File firstJournalCurrentDir = new Storage.StorageDirectory(firstJournalDir).getCurrentDir();
        long firstTxId = this.generateEditLog();
        this.generateEditLog();
        long nextTxId = this.generateEditLog();
        ArrayList missingLogs = Lists.newArrayList();
        missingLogs.add(this.deleteEditLog(firstJournalCurrentDir, firstTxId));
        missingLogs.add(this.deleteEditLog(firstJournalCurrentDir, nextTxId));
        GenericTestUtils.waitFor(this.editLogExists(missingLogs), (long)500L, (long)10000L);
    }

    @Test(timeout=30000L)
    public void testMultipleJournalsMissingLogs() throws Exception {
        File firstJournalDir = this.jCluster.getJournalDir(0, "ns1");
        File firstJournalCurrentDir = new Storage.StorageDirectory(firstJournalDir).getCurrentDir();
        File secondJournalDir = this.jCluster.getJournalDir(1, "ns1");
        Storage.StorageDirectory sd = new Storage.StorageDirectory(secondJournalDir);
        File secondJournalCurrentDir = sd.getCurrentDir();
        long firstTxId = this.generateEditLog();
        this.generateEditLog();
        ArrayList missingLogs = Lists.newArrayList();
        missingLogs.add(this.deleteEditLog(firstJournalCurrentDir, firstTxId));
        missingLogs.add(this.deleteEditLog(secondJournalCurrentDir, firstTxId));
        GenericTestUtils.waitFor(this.editLogExists(missingLogs), (long)500L, (long)10000L);
    }

    @Test(timeout=60000L)
    public void testMultipleJournalsMultipleMissingLogs() throws Exception {
        File firstJournalDir = this.jCluster.getJournalDir(0, "ns1");
        File firstJournalCurrentDir = new Storage.StorageDirectory(firstJournalDir).getCurrentDir();
        File secondJournalDir = this.jCluster.getJournalDir(1, "ns1");
        File secondJournalCurrentDir = new Storage.StorageDirectory(secondJournalDir).getCurrentDir();
        File thirdJournalDir = this.jCluster.getJournalDir(2, "ns1");
        File thirdJournalCurrentDir = new Storage.StorageDirectory(thirdJournalDir).getCurrentDir();
        long firstTxId = this.generateEditLog();
        long secondTxId = this.generateEditLog();
        long thirdTxId = this.generateEditLog();
        ArrayList missingLogs = Lists.newArrayList();
        missingLogs.add(this.deleteEditLog(firstJournalCurrentDir, firstTxId));
        missingLogs.add(this.deleteEditLog(secondJournalCurrentDir, firstTxId));
        missingLogs.add(this.deleteEditLog(secondJournalCurrentDir, secondTxId));
        missingLogs.add(this.deleteEditLog(thirdJournalCurrentDir, thirdTxId));
        GenericTestUtils.waitFor(this.editLogExists(missingLogs), (long)500L, (long)30000L);
    }

    @Test(timeout=60000L)
    public void testRandomJournalMissingLogs() throws Exception {
        List<File> missingLogs = this.deleteEditLogsFromRandomJN();
        GenericTestUtils.waitFor(this.editLogExists(missingLogs), (long)500L, (long)30000L);
    }

    @Test(timeout=300000L)
    public void testSyncAfterJNdowntime() throws Exception {
        File firstJournalDir = this.jCluster.getJournalDir(0, "ns1");
        File firstJournalCurrentDir = new Storage.StorageDirectory(firstJournalDir).getCurrentDir();
        File secondJournalDir = this.jCluster.getJournalDir(1, "ns1");
        File secondJournalCurrentDir = new Storage.StorageDirectory(secondJournalDir).getCurrentDir();
        long[] startTxIds = new long[10];
        startTxIds[0] = this.generateEditLog();
        startTxIds[1] = this.generateEditLog();
        this.jCluster.getJournalNode(0).stop(0);
        for (int i = 2; i < 10; ++i) {
            startTxIds[i] = this.generateEditLog(5);
        }
        this.jCluster.restartJournalNode(0);
        this.generateEditLog();
        ArrayList missingLogs = Lists.newArrayList();
        for (int i = 2; i < 10; ++i) {
            FileJournalManager.EditLogFile logFile = FileJournalManager.getLogFile((File)secondJournalCurrentDir, (long)startTxIds[i], (boolean)false);
            missingLogs.add(new File(firstJournalCurrentDir, logFile.getFile().getName()));
        }
        GenericTestUtils.waitFor(this.editLogExists(missingLogs), (long)500L, (long)30000L);
    }

    @Test(timeout=300000L)
    public void testSyncAfterJNdowntimeWithoutQJournalQueue() throws Exception {
        File firstJournalDir = this.jCluster.getJournalDir(0, "ns1");
        File firstJournalCurrentDir = new Storage.StorageDirectory(firstJournalDir).getCurrentDir();
        File secondJournalDir = this.jCluster.getJournalDir(1, "ns1");
        File secondJournalCurrentDir = new Storage.StorageDirectory(secondJournalDir).getCurrentDir();
        long[] startTxIds = new long[10];
        startTxIds[0] = this.generateEditLog();
        startTxIds[1] = this.generateEditLog(2);
        this.jCluster.getJournalNode(0).stop(0);
        for (int i = 2; i < 10; ++i) {
            startTxIds[i] = this.generateEditLog(5);
        }
        this.jCluster.restartJournalNode(0);
        this.generateEditLog(2);
        ArrayList missingLogs = Lists.newArrayList();
        for (int i = 2; i < 10; ++i) {
            FileJournalManager.EditLogFile logFile = FileJournalManager.getLogFile((File)secondJournalCurrentDir, (long)startTxIds[i], (boolean)false);
            missingLogs.add(new File(firstJournalCurrentDir, logFile.getFile().getName()));
        }
        GenericTestUtils.waitFor(this.editLogExists(missingLogs), (long)500L, (long)30000L);
        long numEditLogsSynced = this.jCluster.getJournalNode(0).getOrCreateJournal("ns1").getMetrics().getNumEditLogsSynced().value();
        Assert.assertTrue((String)("Edit logs downloaded outside syncer. Expected 8 or more downloads, got " + numEditLogsSynced + " downloads instead"), (numEditLogsSynced >= 8L ? 1 : 0) != 0);
    }

    @Test(timeout=300000L)
    public void testSyncAfterJNformat() throws Exception {
        File firstJournalDir = this.jCluster.getJournalDir(0, "ns1");
        File firstJournalCurrentDir = new Storage.StorageDirectory(firstJournalDir).getCurrentDir();
        File secondJournalDir = this.jCluster.getJournalDir(1, "ns1");
        File secondJournalCurrentDir = new Storage.StorageDirectory(secondJournalDir).getCurrentDir();
        long[] startTxIds = new long[10];
        startTxIds[0] = this.generateEditLog(1);
        startTxIds[1] = this.generateEditLog(2);
        startTxIds[2] = this.generateEditLog(4);
        startTxIds[3] = this.generateEditLog(6);
        Journal journal1 = this.jCluster.getJournalNode(0).getOrCreateJournal("ns1");
        NamespaceInfo nsInfo = journal1.getStorage().getNamespaceInfo();
        for (File file : firstJournalCurrentDir.listFiles()) {
            file.delete();
        }
        journal1.format(nsInfo, false);
        for (int i = 4; i < 10; ++i) {
            startTxIds[i] = this.generateEditLog(5);
        }
        ArrayList missingLogs = Lists.newArrayList();
        for (int i = 0; i < 10; ++i) {
            FileJournalManager.EditLogFile logFile = FileJournalManager.getLogFile((File)secondJournalCurrentDir, (long)startTxIds[i], (boolean)false);
            missingLogs.add(new File(firstJournalCurrentDir, logFile.getFile().getName()));
        }
        GenericTestUtils.waitFor(this.editLogExists(missingLogs), (long)500L, (long)30000L);
    }

    @Test(timeout=300000L)
    public void testSyncDuringRollingUpgrade() throws Exception {
        int standbyNNindex;
        if (this.dfsCluster.getNameNode(0).isActiveState()) {
            this.activeNNindex = 0;
            standbyNNindex = 1;
        } else {
            this.activeNNindex = 1;
            standbyNNindex = 0;
        }
        DistributedFileSystem dfsActive = this.dfsCluster.getFileSystem(this.activeNNindex);
        RollingUpgradeInfo info = dfsActive.rollingUpgrade(HdfsConstants.RollingUpgradeAction.PREPARE);
        Assert.assertEquals((Object)info, (Object)dfsActive.rollingUpgrade(HdfsConstants.RollingUpgradeAction.QUERY));
        this.dfsCluster.restartNameNode(standbyNNindex, true, "-rollingUpgrade", "started");
        Assert.assertEquals((Object)info, (Object)dfsActive.rollingUpgrade(HdfsConstants.RollingUpgradeAction.QUERY));
        List<File> missingLogs = this.deleteEditLogsFromRandomJN();
        GenericTestUtils.waitFor(this.editLogExists(missingLogs), (long)500L, (long)30000L);
        this.dfsCluster.transitionToStandby(this.activeNNindex);
        Thread.sleep(30000L);
        this.dfsCluster.transitionToActive(standbyNNindex);
        this.dfsCluster.waitActive();
        this.activeNNindex = standbyNNindex;
        standbyNNindex = (this.activeNNindex + 1) % 2;
        dfsActive = this.dfsCluster.getFileSystem(this.activeNNindex);
        Assert.assertTrue((boolean)this.dfsCluster.getNameNode(this.activeNNindex).isActiveState());
        Assert.assertFalse((boolean)this.dfsCluster.getNameNode(standbyNNindex).isActiveState());
        this.dfsCluster.restartNameNode(standbyNNindex, true, "-rollingUpgrade", "started");
        Assert.assertEquals((Object)info, (Object)dfsActive.rollingUpgrade(HdfsConstants.RollingUpgradeAction.QUERY));
        this.dfsCluster.waitActive();
        missingLogs.addAll(this.deleteEditLogsFromRandomJN());
        GenericTestUtils.waitFor(this.editLogExists(missingLogs), (long)500L, (long)30000L);
        RollingUpgradeInfo finalize = dfsActive.rollingUpgrade(HdfsConstants.RollingUpgradeAction.FINALIZE);
        Assert.assertTrue((boolean)finalize.isFinalized());
        for (File editLog : missingLogs) {
            Assert.assertTrue((String)"Edit log missing after finalizing rolling upgrade", (boolean)editLog.exists());
        }
    }

    private File deleteEditLog(File currentDir, long startTxId) throws IOException {
        FileJournalManager.EditLogFile logFile = FileJournalManager.getLogFile((File)currentDir, (long)startTxId);
        while (logFile.isInProgress()) {
            this.dfsCluster.getNameNode(this.activeNNindex).getRpcServer().rollEditLog();
            logFile = FileJournalManager.getLogFile((File)currentDir, (long)startTxId);
        }
        File deleteFile = logFile.getFile();
        Assert.assertTrue((String)"Couldn't delete edit log file", (boolean)deleteFile.delete());
        return deleteFile;
    }

    private List<File> deleteEditLogsFromRandomJN() throws IOException {
        Random random = new Random();
        ArrayList journalCurrentDirs = Lists.newArrayList();
        for (int i = 0; i < 3; ++i) {
            journalCurrentDirs.add(new Storage.StorageDirectory(this.jCluster.getJournalDir(i, "ns1")).getCurrentDir());
        }
        long[] startTxIds = new long[20];
        for (int i = 0; i < 20; ++i) {
            startTxIds[i] = this.generateEditLog();
        }
        ArrayList missingLogs = Lists.newArrayList();
        ArrayList deletedStartTxIds = Lists.newArrayList();
        for (int count = 0; count < 5; ++count) {
            int startTxIdIndex = random.nextInt(20);
            while (deletedStartTxIds.contains(startTxIdIndex)) {
                startTxIdIndex = random.nextInt(20);
            }
            long startTxId = startTxIds[startTxIdIndex];
            deletedStartTxIds.add(startTxIdIndex);
            int journalIndex = random.nextInt(3);
            missingLogs.add(this.deleteEditLog((File)journalCurrentDirs.get(journalIndex), startTxId));
        }
        return missingLogs;
    }

    private boolean doAnEdit() throws IOException {
        return this.dfsCluster.getFileSystem(this.activeNNindex).mkdirs(new Path("/tmp", Integer.toString(this.editsPerformed++)));
    }

    private long generateEditLog() throws IOException {
        return this.generateEditLog(1);
    }

    private long generateEditLog(int numEdits) throws IOException {
        long lastWrittenTxId = this.dfsCluster.getNameNode(this.activeNNindex).getFSImage().getEditLog().getLastWrittenTxId();
        for (int i = 1; i <= numEdits; ++i) {
            Assert.assertTrue((String)"Failed to do an edit", (boolean)this.doAnEdit());
        }
        this.dfsCluster.getNameNode(this.activeNNindex).getRpcServer().rollEditLog();
        return lastWrittenTxId;
    }

    private Supplier<Boolean> editLogExists(final List<File> editLogs) {
        Supplier<Boolean> supplier = new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                for (File editLog : editLogs) {
                    if (editLog.exists()) continue;
                    return false;
                }
                return true;
            }
        };
        return supplier;
    }
}

